/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.function.result;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cas.business.service.AccountAmountService;

public class JournalDateResult {
    private static Log logger = LogFactory.getLog(JournalDateResult.class);
    private Map<String, Object> resultMap = new HashMap<String, Object>();

    public Map<String, Object> query(Map<String, Object> paramListMap) throws ParseException {
        for (Map.Entry<String, Object> map : paramListMap.entrySet()) {
            List params = (List)map.getValue();
            if (params == null) continue;
            Map<String, Object> init = this.init(params);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("v", this.getRptListDataSet(init));
            map2.put("type", "2");
            this.resultMap.put(map.getKey(), map2);
        }
        return this.resultMap;
    }

    private Map<String, Object> init(List<String> params) throws ParseException {
        DynamicObject accountObject;
        logger.info("\u53d6\u6570\u51fd\u6570\u65e5\u8bb0\u8d26\u53c2\u6570{}", (Object)SerializationUtils.toJsonString(params));
        HashMap<String, Object> map = new HashMap<String, Object>();
        String accountType = params.get(0);
        String accountEntity = StringUtils.isNotEmpty((String)accountType) ? ("cash".equals(accountType) ? "cas_accountcash" : ("bank".equals(accountType) ? "bd_accountbanks" : null)) : null;
        Long org = null;
        Long currency = null;
        Long bankaccountnumber = null;
        if (StringUtils.isNotEmpty((String)params.get(1))) {
            DynamicObject orgObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])this.getOrgQFilter(params.get(1)));
            org = (Long)orgObject.get("id");
        }
        if (StringUtils.isNotEmpty((String)params.get(2))) {
            DynamicObject curreryObject = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])this.getCurrencyQFilter(params.get(2)));
            currency = (Long)curreryObject.get("id");
        }
        if ((accountObject = QueryServiceHelper.queryOne((String)accountEntity, (String)"id,openorg.id,defaultcurrency.id", (QFilter[])this.getAccountQFilter(params.get(3)))) != null) {
            bankaccountnumber = (Long)accountObject.get("id");
            currency = StringUtils.isEmpty((String)params.get(2)) ? (Long)accountObject.get("defaultcurrency.id") : currency;
            org = StringUtils.isEmpty((String)params.get(1)) ? (Long)accountObject.get("openorg.id") : org;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(params.get(4));
        map.put("accountType", accountType);
        map.put("accountEntity", accountEntity);
        map.put("org", org);
        map.put("currency", currency);
        map.put("bankaccountnumber", bankaccountnumber);
        map.put("date", date);
        return map;
    }

    private BigDecimal getRptListDataSet(Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(this.addMap(map));
        Map<Object, Object> account = new HashMap();
        if ("bank".equals(map.get("accountType"))) {
            account = new AccountAmountService().getBankAccountAmount(maps);
        }
        if ("cash".equals(map.get("accountType"))) {
            account = new AccountAmountService().getCashAccountAmount(maps);
        }
        return account.get(map.get("org") + "" + map.get("bankaccountnumber") + "" + map.get("currency")) == null ? new BigDecimal("0") : (BigDecimal)account.get(map.get("org") + "" + map.get("bankaccountnumber") + "" + map.get("currency"));
    }

    private QFilter[] getOrgQFilter(String orgNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(new QFilter("number", "=", (Object)orgNumber));
        return filters.toArray(new QFilter[1]);
    }

    private QFilter[] getCurrencyQFilter(String curreryNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(new QFilter("number", "=", (Object)curreryNumber));
        return filters.toArray(new QFilter[1]);
    }

    private QFilter[] getAccountQFilter(String accountNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(new QFilter("number", "=", (Object)accountNumber));
        return filters.toArray(new QFilter[1]);
    }

    private Map<String, Object> addMap(Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgid", params.get("org"));
        map.put("accountid", params.get("bankaccountnumber"));
        map.put("currencyid", params.get("currency"));
        map.put("bizdate", params.get("date"));
        return map;
    }
}

