/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.StringUtils;

public class AgentFillPropHelper {
    private static Log logger = LogFactory.getLog(AgentFillPropHelper.class);

    public static void fillProp(DynamicObject agentBill) {
        DynamicObject org;
        agentBill.set("payeetypelist", agentBill.get("payeetype"));
        AgentFillPropHelper.supplePayeeInfo(agentBill);
        DynamicObject payerAcctBank = agentBill.getDynamicObject("payeracctbank");
        if (payerAcctBank != null && CasHelper.isNotEmpty((Object)(payerAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAcctBank.getPkValue(), (String)"bd_accountbanks")))) {
            AgentFillPropHelper.setValueIfAbsent(agentBill, "payerbank", payerAcctBank.getDynamicObject("bank"));
            AgentFillPropHelper.setValueIfAbsent(agentBill, "openorg", payerAcctBank.getDynamicObject("openorg"));
        }
        if ((org = agentBill.getDynamicObject("org")) != null) {
            DynamicObject dpCurrency;
            DynamicObject currency;
            long orgId = org.getLong("id");
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (baseCurrency != null) {
                agentBill.set("basecurrency", (Object)baseCurrency);
            }
            if ((currency = agentBill.getDynamicObject("currency")) != null && CasHelper.isNotEmpty((Object)(currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency")))) {
                agentBill.set("currency", (Object)currency);
            }
            if ((dpCurrency = agentBill.getDynamicObject("dpcurrency")) != null && CasHelper.isNotEmpty((Object)(dpCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)dpCurrency.getPkValue(), (String)"bd_currency")))) {
                agentBill.set("dpcurrency", (Object)dpCurrency);
            }
            AgentFillPropHelper.setPayCountryValue(agentBill);
            if (CasHelper.isEmpty((Object)agentBill.getDynamicObject("exratetable"))) {
                AgentFillPropHelper.setDefaultExratetable(agentBill, orgId);
            }
            AgentFillPropHelper.setValueIfAbsent(agentBill, "exratedate", DateUtils.getCurrentDate());
            BigDecimal exchangeRate = agentBill.getBigDecimal("exchangerate");
            if (CasHelper.isEmpty((Object)exchangeRate) || exchangeRate.compareTo(BigDecimal.ONE) == 0) {
                exchangeRate = BigDecimal.ONE;
                if (currency != null && baseCurrency != null) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = agentBill.getDate("exratedate");
                        DynamicObject exrateTable = agentBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            exchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                agentBill.set("exchangerate", (Object)exchangeRate);
            }
            if (CasHelper.isEmpty((Object)agentBill.getString("paymentchannel"))) {
                AgentFillPropHelper.setPaymentChannelValue(agentBill, payerAcctBank);
            }
            AgentFillPropHelper.setDiffPayInfo(agentBill, orgId);
            AgentFillPropHelper.calculateAmt(agentBill);
            AgentFillPropHelper.setEncodeAmount(agentBill);
            DynamicObject paymentType = agentBill.getDynamicObject("paymenttype");
            if (paymentType != null) {
                paymentType = BusinessDataServiceHelper.loadSingleFromCache((Object)paymentType.getPkValue(), (String)"cas_paymentbilltype", (String)"id,fundflowitem");
                AgentFillPropHelper.fillFundflowItem(agentBill, paymentType.getDynamicObject("fundflowitem"));
            }
        }
    }

    private static void setPaymentChannelValue(DynamicObject targetBill, DynamicObject payerAcctBank) {
        String defChannel = "";
        DynamicObject settletype = targetBill.getDynamicObject("settletype");
        if (settletype != null) {
            settletype = BusinessDataServiceHelper.loadSingleFromCache((Object)settletype.getPkValue(), (String)"bd_settlementtype", (String)"settlementtype");
        }
        defChannel = payerAcctBank == null || settletype != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settletype.getString("settlementtype")) ? PaymentChannelEnum.COUNTER.getValue() : (payerAcctBank.getBoolean("isopenbank") ? PaymentChannelEnum.ONLINEBANK.getValue() : (payerAcctBank.getBoolean("issetbankinterface") ? PaymentChannelEnum.BEI.getValue() : PaymentChannelEnum.COUNTER.getValue()));
        targetBill.set("paymentchannel", (Object)defChannel);
    }

    private static void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }

    private static void setDiffPayInfo(DynamicObject targetBill, Long orgId) {
        DynamicObject dpCurrency = targetBill.getDynamicObject("dpcurrency");
        if (targetBill.getBoolean("isdiffcur") && CasHelper.isNotEmpty((Object)dpCurrency)) {
            BigDecimal agreedRate;
            BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
            if (CasHelper.isEmpty((Object)dpExchangeRate) || dpExchangeRate.compareTo(BigDecimal.ONE) == 0) {
                dpExchangeRate = BigDecimal.ONE;
                DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
                if (CasHelper.isNotEmpty((Object)baseCurrency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = dpCurrency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            dpExchangeRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                targetBill.set("dpexchangerate", (Object)dpExchangeRate);
            }
            if (CasHelper.isEmpty((Object)(agreedRate = targetBill.getBigDecimal("agreedrate"))) || agreedRate.compareTo(BigDecimal.ONE) == 0) {
                agreedRate = BigDecimal.ONE;
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (CasHelper.isNotEmpty((Object)currency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = dpCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty((Object)exrateTable)) {
                            agreedRate = BaseDataHelper.getExchangeRateByTable((Long)srcCurrencyId, (Long)destCurrencyId, (Long)orgId, (Date)exrateDate, (Long)exrateTable.getLong("id"));
                        }
                    }
                }
                targetBill.set("agreedrate", (Object)agreedRate);
            }
        } else {
            targetBill.set("dpcurrency", targetBill.get("currency"));
            targetBill.set("dpexchangerate", targetBill.get("exchangerate"));
            targetBill.set("agreedrate", (Object)BigDecimal.ONE);
        }
    }

    public static void calculateAmt(DynamicObject targetBill) {
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        String quotation = targetBill.getString("payquotation");
        if (null == quotation) {
            quotation = AgentFillPropHelper.quoteType(targetBill);
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (DynamicObject rowInfo : entry) {
            if (rowInfo.get("e_amount") == null) continue;
            BigDecimal amount = rowInfo.getBigDecimal("e_amount");
            sumAmt = sumAmt.add(amount);
            BigDecimal localamt = QuotationHelper.callToCurrency((BigDecimal)amount, (BigDecimal)exchangeRate, (String)quotation, (int)round);
            if (BigDecimal.ZERO.compareTo(rowInfo.getBigDecimal("e_localamt")) == 0) {
                rowInfo.set("e_localamt", (Object)localamt);
            }
            sumLocalAmt = sumLocalAmt.add(localamt);
        }
        targetBill.set("payamount", (Object)sumAmt);
        if (BigDecimal.ZERO.compareTo(targetBill.getBigDecimal("localamt")) == 0) {
            targetBill.set("localamt", (Object)sumLocalAmt);
        }
        AgentFillPropHelper.calculateDpAmt(targetBill);
    }

    private static void calculateDpAmt(DynamicObject targetBill) {
        BigDecimal lossAmt;
        BigDecimal srcDplocalAmt;
        String agreedquotation;
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        BigDecimal payamount = targetBill.getBigDecimal("payamount");
        if (currency != null) {
            payamount = payamount.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        BigDecimal agreedRate = targetBill.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        String dppayquotation = targetBill.getString("dppayquotation");
        if (null == dppayquotation) {
            dppayquotation = AgentFillPropHelper.quoteType(targetBill);
        }
        if (null == (agreedquotation = targetBill.getString("agreedquotation"))) {
            agreedquotation = AgentFillPropHelper.quoteType(targetBill);
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal dpAmt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        if (BigDecimal.ZERO.compareTo(targetBill.getBigDecimal("dpamt")) == 0) {
            targetBill.set("dpamt", (Object)dpAmt);
        }
        if (BigDecimal.ZERO.compareTo(srcDplocalAmt = targetBill.getBigDecimal("dplocalamt")) == 0) {
            targetBill.set("dplocalamt", (Object)dpLocalAmt);
            lossAmt = localAmt.subtract(dpLocalAmt);
        } else {
            lossAmt = localAmt.subtract(srcDplocalAmt);
        }
        targetBill.set("lossamt", (Object)lossAmt);
        AgentFillPropHelper.calculateEntryDpAmt(targetBill);
    }

    private static void calculateEntryDpAmt(DynamicObject targetBill) {
        String agreedquotation;
        Boolean isDiffCur = targetBill.getBoolean("isdiffcur");
        if (!isDiffCur.booleanValue()) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (DynamicObject row : entry) {
            int rowIdx = row.getInt("seq") - 1;
            BigDecimal amount = row.getBigDecimal("e_amount");
            if (amount == null || amount.compareTo(new BigDecimal(0)) <= 0) continue;
            rowIndexs.add(rowIdx);
        }
        int size = rowIndexs.size();
        if (size <= 0) {
            return;
        }
        BigDecimal dpamt = targetBill.getBigDecimal("dpamt");
        BigDecimal dplocalamt = targetBill.getBigDecimal("dplocalamt");
        BigDecimal dpexchangerate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal agreedrate = targetBill.getBigDecimal("agreedrate");
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        String dppayquotation = targetBill.getString("dppayquotation");
        if (null == dppayquotation) {
            dppayquotation = AgentFillPropHelper.quoteType(targetBill);
        }
        if (null == (agreedquotation = targetBill.getString("agreedquotation"))) {
            agreedquotation = AgentFillPropHelper.quoteType(targetBill);
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal sumDpamt = BigDecimal.ZERO;
        BigDecimal sumDpLocalamt = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            int rowIdx = (Integer)rowIndexs.get(i);
            DynamicObject row = (DynamicObject)entry.get(rowIdx);
            BigDecimal edpamt = BigDecimal.ZERO;
            BigDecimal edplocalamt = BigDecimal.ZERO;
            if (i == size - 1) {
                edpamt = dpamt.subtract(sumDpamt);
                edplocalamt = dplocalamt.subtract(sumDpLocalamt);
            } else {
                BigDecimal eamount = row.getBigDecimal("e_amount");
                edpamt = QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)dppayround);
                sumDpamt = sumDpamt.add(edpamt);
                edplocalamt = QuotationHelper.callToCurrency((BigDecimal)edpamt, (BigDecimal)dpexchangerate, (String)dppayquotation, (int)round);
                sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
            }
            if (BigDecimal.ZERO.compareTo(row.getBigDecimal("e_dpamt")) == 0) {
                row.set("e_dpamt", (Object)edpamt);
            }
            if (BigDecimal.ZERO.compareTo(row.getBigDecimal("e_dplocalamt")) != 0) continue;
            row.set("e_dplocalamt", (Object)edplocalamt);
        }
    }

    private static void setPayCountryValue(DynamicObject targetBill) {
        DynamicObject payerBank = targetBill.getDynamicObject("payerbank");
        if (payerBank != null && CasHelper.isEmpty((Object)targetBill.getDynamicObject("paycountry")) && CasHelper.isNotEmpty((Object)(payerBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerBank.getPkValue(), (String)"bd_finorginfo", (String)"id,country")))) {
            targetBill.set("paycountry", (Object)payerBank.getDynamicObject("country"));
        }
    }

    private static void supplePayeeInfo(DynamicObject targetBill) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject rowInfo : entry) {
            DynamicObject payee;
            String payeeType;
            DynamicObject bebank;
            DynamicObject payeebank = rowInfo.getDynamicObject("payeebank");
            if (CasHelper.isNotEmpty((Object)payeebank) && CasHelper.isNotEmpty((Object)(bebank = BusinessDataServiceHelper.loadSingleFromCache((Object)payeebank.getPkValue(), (String)"bd_bebank")))) {
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "payeebanknumber", bebank.getString("union_number"));
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "reccountry", bebank.getDynamicObject("country") == null ? null : bebank.getDynamicObject("country").getPkValue());
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "recprovince", bebank.getDynamicObject("province") == null ? "" : bebank.getDynamicObject("province").getString("name"));
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "reccity", bebank.getDynamicObject("city") == null ? "" : bebank.getDynamicObject("city").getString("name"));
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "recswiftcode", bebank.getString("swift_code"));
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "recroutingnum", bebank.getString("routingnum"));
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "recothercode", bebank.getString("other_code"));
                AgentFillPropHelper.setValueIfAbsent(rowInfo, "recbankaddress", bebank.getString("address_eng"));
            }
            if (!"other".equals(payeeType = AgentFillPropHelper.getPayeeType(targetBill))) {
                rowInfo.set("importpayeetype", (Object)payeeType);
            }
            if (!CasHelper.isNotEmpty((Object)(payee = rowInfo.getDynamicObject("payee"))) || !AgentFillPropHelper.isPayeeCustomer(targetBill) && !AgentFillPropHelper.isPayeeSupplier(targetBill)) continue;
            Map<String, Object> resultMap = AgentFillPropHelper.getPayeeInfo(payee.getPkValue(), payeeType);
            AgentFillPropHelper.setValueIfAbsent(rowInfo, "recemail", resultMap.get("payeeemail"));
            AgentFillPropHelper.setValueIfAbsent(rowInfo, "recaddress", resultMap.get("payeeaddress"));
        }
    }

    private static Map<String, Object> getPayeeInfo(Object payeeOrPayer, String payeeType) {
        DynamicObjectCollection addressls;
        DynamicObject supplierCustDO;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        String addressPropName = "";
        if ("bd_supplier".equals(payeeType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        } else if ("bd_customer".equals(payeeType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        } else {
            return resultMap;
        }
        if (!(CasHelper.isEmpty((Object)entityNameTemp) || CasHelper.isEmpty((Object)payeeOrPayer) || CasHelper.isEmpty((Object)(supplierCustDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeOrPayer, (String)entityNameTemp, (String)("entry_address." + addressPropName)))) || (addressls = supplierCustDO.getDynamicObjectCollection("entry_address")) == null || addressls.size() <= 0)) {
            HashSet<Object> addressIds = new HashSet<Object>();
            for (DynamicObject a : addressls) {
                addressIds.add(a.get(addressPropName + "_id"));
            }
            DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
            if (addresses != null) {
                for (DynamicObject address : addresses) {
                    if (!address.getBoolean("default")) continue;
                    resultMap.put("payeeemail", address.getString("addemail"));
                    resultMap.put("payeeaddress", address.getString("detailaddress"));
                    break;
                }
            }
        }
        return resultMap;
    }

    private static void setEncodeAmount(DynamicObject targetBill) {
        if (targetBill.getBoolean("isencryption") && "BOTP".equals(targetBill.getString("source"))) {
            DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
            if (entry == null || entry.size() <= 0) {
                return;
            }
            for (DynamicObject action : entry) {
                BigDecimal loaclAmount;
                BigDecimal amount = action.getBigDecimal("e_amount");
                if (amount != null) {
                    String encrptyAmountStr = AgentPayBillHelper.encodeAmount((BigDecimal)amount);
                    action.set("e_encryptamount", (Object)encrptyAmountStr);
                }
                if ((loaclAmount = action.getBigDecimal("e_localamt")) == null) continue;
                String encrptyLocalAmountStr = AgentPayBillHelper.encodeAmount((BigDecimal)loaclAmount);
                action.set("e_encryptlocalamt", (Object)encrptyLocalAmountStr);
            }
        }
    }

    private static boolean isPayeeCustomer(DynamicObject targetBill) {
        return "bd_customer".equals(AgentFillPropHelper.getPayeeType(targetBill));
    }

    private static boolean isPayeeSupplier(DynamicObject targetBill) {
        return "bd_supplier".equals(AgentFillPropHelper.getPayeeType(targetBill));
    }

    private static String getPayeeType(DynamicObject targetBill) {
        return targetBill.getString("payeetypelist");
    }

    public static void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty((Object)targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    public static void setDefaultProviceCity(DynamicObject[] agentBills) {
        for (DynamicObject agentBill : agentBills) {
            if (agentBill.getBoolean("iscrosspay")) continue;
            DynamicObjectCollection entryList = agentBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                QFilter filter;
                DynamicObject bank;
                DynamicObject payeeBank;
                if (StringUtils.isNotEmpty((String)entry.getString("recprovince")) || StringUtils.isNotEmpty((String)entry.getString("reccity")) || (payeeBank = entry.getDynamicObject("payeebank")) == null || (bank = QueryServiceHelper.queryOne((String)"bd_bebank", (String)"id,provincetxt,citytxt", (QFilter[])(filter = new QFilter("id", "=", (Object)payeeBank.getLong("id"))).toArray())) == null) continue;
                entry.set("recprovince", bank.get("provincetxt"));
                entry.set("reccity", bank.get("citytxt"));
            }
        }
    }

    private static void fillFundflowItem(DynamicObject targetBill, DynamicObject defaultFundsItem) {
        if (defaultFundsItem == null) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject row : entry) {
            AgentFillPropHelper.setValueIfAbsent(row, "e_fundflowitem", defaultFundsItem);
        }
    }

    private static String quoteType(DynamicObject targetBill) {
        Map exchangeRateByRules;
        DynamicObject currency = targetBill.getDynamicObject("currency");
        DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject exRateTable = targetBill.getDynamicObject("exratetable");
        Date exRateDate = (Date)targetBill.get("exratedate");
        String quoteType = "0";
        if (currency != null && baseCurrency != null && exRateTable != null && exRateDate != null && (exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exRateDate)).get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
            quoteType = "1";
        }
        return quoteType;
    }
}

