/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.helper.RecPayerIdServieHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.MutexServiceHelper;

public class CasUpdateHistoryServiceHelper {
    private static final Log logger = LogFactory.getLog(RecPayerIdServieHelper.class);

    public static void updateHistoryDate() {
        boolean locked = MutexServiceHelper.request((String)"casupdatehistorydate", (String)"cas_updatehistorydate", (String)"updatecashistorydate");
        if (!locked) {
            logger.error("\u51fa\u7eb3\u5386\u53f2\u6570\u636e\u5347\u7ea7\u83b7\u53d6\u7f51\u7edc\u4e92\u65a5\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\u3002 \u9501\uff1a{}", (Object)"casupdatehistorydate");
        }
        try {
            CasUpdateHistoryServiceHelper.updatePaymentDate();
            CasUpdateHistoryServiceHelper.updateReceDate();
            CasUpdateHistoryServiceHelper.updateClaimRecDate();
            CasUpdateHistoryServiceHelper.updateClaimPayDate();
            CasUpdateHistoryServiceHelper.updateNoticeRecDate();
            CasUpdateHistoryServiceHelper.updateNoticePayDate();
            CasUpdateHistoryServiceHelper.updateChangeRecAfterDate();
            CasUpdateHistoryServiceHelper.updateChangeRecBeforeDate();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            boolean releaseLock = MutexServiceHelper.release((String)"casupdatehistorydate", (String)"cas_updatehistorydate", (String)"updatecashistorydate");
            if (!releaseLock) {
                logger.error("\u51fa\u7eb3\u5386\u53f2\u6570\u636e\u5347\u7ea7\u91ca\u653e\u7f51\u7edc\u4e92\u65a5\u5931\u8d25\uff0c\u91ca\u653e\u9501\u5931\u8d25\u3002 \u9501\uff1a{}", (Object)"casupdatehistorydate");
            }
        }
    }

    private static void updateReceDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'receivingtype_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updatereceiving", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "receivingtype_update", 2, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updatereceiving", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Row next = updateinfo.next();
        Long maxId = 0L;
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                DataSet rows = CasUpdateHistoryServiceHelper.queryReceivingDataSet(maxId);
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long freceivingtypeid = row.getLong("FReceivingTypeID");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{freceivingtypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchReceivingEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "receivingtype_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "receivingtype_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update receEntry freceivingtypeid end");
    }

    private static void updatePaymentDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'paymenttype_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updatepaymenttype", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "paymenttype_update", 1, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updatepaymenttype", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryPaymentDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("fpaymenttypeid");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchPaymentEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "paymenttype_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "paymenttype_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update pamentEntry fpaymenttypeid end");
    }

    private static void updateClaimRecDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'claimRec_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updateClaimRec", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "claimRec_update", 3, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updateClaimRec", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryClaimRecDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("frecpaytype");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchClaimRecEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "claimRec_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "claimRec_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update claimRecEntry freceivingtypeid end");
    }

    private static void updateClaimPayDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'claimPay_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updateClaimPay", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "claimPay_update", 4, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updateClaimPay", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryClaimPayDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("fpaytype");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchClaimPayEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "claimPay_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "claimPay_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update claimPayEntry fpaymenttypeid end");
    }

    private static void updateNoticeRecDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'noticeRec_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updateNoticeRec", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "noticeRec_update", 5, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updateNoticeRec", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryNoticeRecDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("frecpaytype");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchNoticeRecEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "noticeRec_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "noticeRec_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update noticeRecEntry freceivingtypeid end");
    }

    private static void updateNoticePayDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'noticePay_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updateNoticePay", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "noticePay_update", 6, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updateNoticePay", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryNoticePayDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("fpaytype");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchNoticePayEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "noticePay_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "noticePay_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update noticePayEntry fpaymenttypeid end");
    }

    private static void updateChangeRecAfterDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'changeRec_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updateChangeRec", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "changeRec_update", 7, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updateChangeRec", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryChangeRecDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("FReceivingTypeID");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchRecChangeRecEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "changeRec_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "changeRec_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update changeRecEntry FReceivingTypeID end");
    }

    private static void updateChangeRecBeforeDate() {
        String sql = "select fid,fnowid,fnowstatus from t_cas_updatehistorydate where fupdatetype = 'changeRecBefore_update' ";
        DataSet updateinfo = DB.queryDataSet((String)"updateChangeRecBefore", (DBRoute)DBRouteConst.cas, (String)sql);
        if (!updateinfo.hasNext()) {
            Long id = DBServiceHelper.genGlobalLongId();
            String insertSQL = "insert into t_cas_updatehistorydate(fid,fupdatetype,fnowstep,fnowid,fnowstatus) values(?, ?, ?, ?, ?)";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.cas, (String)insertSQL, (Object[])new Object[]{id, "changeRecBefore_update", 8, 0L, "upgrading"});
            }
            updateinfo = DB.queryDataSet((String)"updateChangeRecBefore", (DBRoute)DBRouteConst.cas, (String)sql);
        }
        Long maxId = 0L;
        Row next = updateinfo.next();
        Long nowid = next.getLong("fnowid");
        maxId = Math.max(maxId, nowid);
        Long lastId = nowid;
        String fnowstatus = next.getString("fnowstatus");
        Long updateInfoId = next.getLong("fid");
        if ("success".equals(fnowstatus)) {
            return;
        }
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                ArrayList<Object[]> batchParam = new ArrayList<Object[]>(4);
                DataSet rows = CasUpdateHistoryServiceHelper.queryChangeRecBeforeDataSet(maxId);
                if (!rows.hasNext()) break;
                try {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long fpaymenttypeid = row.getLong("fbreceivingtype");
                        Long fentryid = row.getLong("fentryid");
                        maxId = Math.max(maxId, fentryid);
                        batchParam.add(new Object[]{fpaymenttypeid, fentryid});
                    }
                    if (batchParam != null && batchParam.size() > 0) {
                        CasUpdateHistoryServiceHelper.executeBatchRecChangeRecBeforeEntryInfo(batchParam);
                        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "upgrading", "changeRecBefore_update", updateInfoId, lastId);
                        lastId = maxId;
                    }
                    rows.close();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("update cashistorydate has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
        CasUpdateHistoryServiceHelper.executeBatchHistory(maxId, "success", "changeRecBefore_update", updateInfoId, lastId);
        updateinfo.close();
        logger.info("update ecBillChangBEntry FbreceivingType end");
    }

    private static DataSet queryPaymentDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.fpaymenttypeid,b.fentryid from  T_CAS_PaymentBill a inner join  T_CAS_PaymentBillEntry b on a.fid = b.fid where b.FPaymentTypeID =0 and a.fpaymenttypeid != 0 and  a.fpaymenttypeid != 1503663013709008896 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryPaymetBillInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryReceivingDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.FReceivingTypeID,b.fentryid from  T_CAS_ReceivingBill a inner join  T_CAS_ReceivingBillEntry b on a.fid = b.fid where b.freceivingtypeid =0 and a.FReceivingTypeID != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryReceivingBillInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryClaimRecDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.frecpaytype,b.fentryid from  t_cas_claimbill a inner join  t_cas_claimdetailentry b on a.fid = b.fid where b.freceivingtypeid =0 and a.frecpaytype != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryClaimRecInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryClaimPayDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.fpaytype,b.fentryid from  t_cas_claimbill a inner join  t_cas_claimpayentry b on a.fid = b.fid where b.fpaymenttypeid =0 and a.fpaytype != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryClaimPayInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryNoticeRecDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.frecpaytype,b.fentryid from  t_cas_claimnoticebill a inner join  t_cas_claimnoticebill_e b on a.fid = b.fid where b.freceivingtypeid =0 and a.frecpaytype != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryNoticeRecInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryNoticePayDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.fpaytype,b.fentryid from  t_cas_claimnoticebill a inner join  t_cas_claimnoticebillp_e b on a.fid = b.fid where b.fpaymenttypeid =0 and a.fpaytype != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryNoticePayInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryChangeRecDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.FReceivingTypeID,b.fentryid from  t_cas_recbillchang a inner join  t_cas_recbillchangentry b on a.fid = b.fid where b.freceivingtypeid =0 and a.FReceivingTypeID != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryChangeAfterInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static DataSet queryChangeRecBeforeDataSet(Long maxId) {
        String queryDateSql = "select top 2000 a.fbreceivingtype,b.fentryid from  t_cas_recbillchang_e a inner join  t_cas_recbillchangbentry b on a.fid = b.fid where b.fbreceivingtype =0 and a.fbreceivingtype != 0 and b.fentryid > ? order by b.fentryid ";
        return DB.queryDataSet((String)"queryChangeBeforeInfo", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{maxId});
    }

    private static void executeBatchPaymentEntryInfo(List<Object[]> batchParam) {
        String sql = "update T_CAS_PaymentBillEntry SET fpaymenttypeid = ? where  fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchReceivingEntryInfo(List<Object[]> batchParam) {
        String sql = "update T_CAS_ReceivingBillEntry SET freceivingtypeid = ? where  fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchClaimRecEntryInfo(List<Object[]> batchParam) {
        String sql = "update t_cas_claimdetailentry SET freceivingtypeid = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchClaimPayEntryInfo(List<Object[]> batchParam) {
        String sql = "update t_cas_claimpayentry SET fpaymenttypeid = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchNoticeRecEntryInfo(List<Object[]> batchParam) {
        String sql = "update t_cas_claimnoticebill_e SET freceivingtypeid = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchNoticePayEntryInfo(List<Object[]> batchParam) {
        String sql = "update t_cas_claimnoticebillp_e SET fpaymenttypeid = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchRecChangeRecEntryInfo(List<Object[]> batchParam) {
        String sql = "update t_cas_recbillchangentry SET freceivingtypeid = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchRecChangeRecBeforeEntryInfo(List<Object[]> batchParam) {
        String sql = "update t_cas_recbillchangbentry SET fbreceivingtype = ? where fentryid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private static void executeBatchHistory(Long maxId, String nowStatus, String updatetype, Long updateInfoId, Long lastid) {
        String sql = "update T_CAS_UPDATEHISTORYDATE SET FNOWID = ? ,FNOWSTATUS = ?  where FUPDATETYPE=? and fid = ? and fnowid = ?";
        int result = DB.update((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{maxId, nowStatus, updatetype, updateInfoId, lastid});
        if (result < 1) {
            logger.error("update t_cas_updatehistorydate sql fail,billId:" + updateInfoId + "");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u5386\u53f2\u6570\u636e\u5347\u7ea7\u66f4\u65b0\u8868t_cas_updatehistorydate\u51fa\u73b0\u95ee\u9898\uff01\u5bf9\u5e94\u7684\u5347\u7ea7\u8868id\u4e3a\uff1a[%s]", (String)"CasUpdateHistoryServiceHelper_1", (String)"fi-cas-business", (Object[])new Object[]{updateInfoId}), new Object[0]));
        }
    }
}

