/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.fi.cas.business.closeperiod.abstracts.AbstractPreClosePeriodCheck;
import kd.fi.cas.business.closeperiod.abstracts.ClosePeriodCheckItemFactory;
import kd.fi.cas.business.pojo.CasCheckContext;
import kd.fi.cas.util.ClosePeriodUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.fcm.extpoint.checkitem.CheckResult;

public class ClosePeriodHelper {
    private static final Log LOGGER = LogFactory.getLog(ClosePeriodHelper.class);
    private static final String APPID = BizAppServiceHelp.getAppIdByAppNumber((String)"cas");

    public static CheckExecutionResult closeCheck(long orgId, long curPeriod, String operateId) {
        List checkItemList = ClosePeriodUtils.getCheckItemList((Long)orgId, (Boolean)true);
        ClosePeriodHelper.preCloseCheck(checkItemList, orgId, curPeriod);
        List checkItems = checkItemList.stream().map(CheckItemDetail::getId).collect(Collectors.toList());
        CheckExecutionResult executeResult = null;
        if (EmptyUtil.isNoEmpty(checkItems)) {
            CheckItemExecutionParam checkItemExecutionParam = new CheckItemExecutionParam(APPID, "", Long.valueOf(orgId), Long.valueOf(curPeriod), checkItems, operateId);
            executeResult = ClosePeriodCheckExecutor.instance.execute(checkItemExecutionParam);
        }
        return executeResult;
    }

    public static boolean closeCheck(DynamicObjectCollection entries, long orgId, long curPeriod) {
        List checkItemList = ClosePeriodUtils.getCheckItemList((Long)orgId, (Boolean)true);
        ClosePeriodHelper.preCloseCheck(checkItemList, orgId, curPeriod);
        List checkItems = checkItemList.stream().map(CheckItemDetail::getId).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(checkItems)) {
            CheckItemExecutionParam checkItemExecutionParam = new CheckItemExecutionParam(APPID, "", Long.valueOf(orgId), Long.valueOf(curPeriod), checkItems, "");
            CheckExecutionResult executeResult = ClosePeriodCheckExecutor.instance.execute(checkItemExecutionParam);
            List itemCheckResultList = executeResult.getItemCheckResultList();
            LOGGER.info("[closeCheck]org\uff1a{}\uff0ccurPeriod\uff1a{}\uff0citemSize\uff1a{}", new Object[]{orgId, curPeriod, EmptyUtil.isNoEmpty(checkItems) ? checkItems.size() : 0});
            StringBuilder logSb = new StringBuilder();
            for (CheckExecutionResult.CheckResultWrapper checkResultWrapper : itemCheckResultList) {
                logSb.append(checkResultWrapper.getCheckItem().getName());
                logSb.append("-");
                logSb.append(checkResultWrapper.getExecuteStatus().getCode());
                logSb.append(";");
                ClosePeriodUtils.setCheckInfo((DynamicObjectCollection)entries, (CheckExecutionResult.CheckResultWrapper)checkResultWrapper);
            }
            LOGGER.info("[closeCheck]checkResult\uff1a{}", (Object)logSb.toString());
            return executeResult.isFinalApproval();
        }
        return true;
    }

    public static void preCloseCheck(List<CheckItemDetail> checkItemList, long orgId, long curPeriod) {
        for (CheckItemDetail item : checkItemList) {
            AbstractPreClosePeriodCheck checkItemDto = ClosePeriodCheckItemFactory.getCheckItem(item.getNumber());
            if (checkItemDto == null) continue;
            CasCheckContext casCheckContext = new CasCheckContext();
            casCheckContext.setOrgId(orgId);
            casCheckContext.setPeriodId(curPeriod);
            CheckResult checkResult = checkItemDto.check(casCheckContext);
            checkItemDto.cacheCheckResult(casCheckContext, checkResult, 300);
        }
    }
}

