/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cas.dao.MatchRangeInfo;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class ManualMatchHelper {
    public static final String callBackId = "CONFIRM_MANUALMATCH";
    private static final String REC = "rec";
    private static final String PAY = "pay";
    private static final String[] staticMatchField = new String[]{"id", "number", "name", "direction", "bizcondition", "range_bizcondition_real_TAG", "bizdateprop", "entrybizdateprop", "enabledate", "org_entry.u_org"};

    public static MatchRangeInfo getBizBillQFilter(Long orgId, String entryName, Boolean headMatch) {
        MatchRangeInfo result = null;
        switch (entryName) {
            case "cas_paybill": 
            case "cas_recbill": {
                AutoMatchBillTypeEnum BillType = AutoMatchBillTypeEnum.getByBillEntity((String)entryName);
                MatchRangeInfo payRange = ManualMatchHelper.getMatchRangeQFilter(entryName, BillType, orgId, PAY, true);
                QFilter payQFilter = new QFilter("unmatchamountpay", "!=", (Object)0);
                if ("cas_recbill".equals(entryName)) {
                    payQFilter.and("relateotherflow", "=", (Object)true);
                }
                if (payRange.getRangeQFilter() != null) {
                    payQFilter.and(payRange.getRangeQFilter());
                }
                MatchRangeInfo recRange = ManualMatchHelper.getMatchRangeQFilter(entryName, BillType, orgId, REC, true);
                QFilter recQFilter = new QFilter("unmatchamountrec", "!=", (Object)0);
                if ("cas_paybill".equals(entryName)) {
                    recQFilter.and("relateotherflow", "=", (Object)true);
                }
                if (recRange.getRangeQFilter() != null) {
                    recQFilter.and(recRange.getRangeQFilter());
                }
                result = ManualMatchHelper.getDateFieldAndValue("cas_recbill".equals(entryName), payRange, recRange);
                result.setRangeQFilter(payQFilter.or(recQFilter));
                break;
            }
            case "cas_agentpaybill": {
                AutoMatchBillTypeEnum BillType = AutoMatchBillTypeEnum.getByBillEntity((String)entryName);
                result = ManualMatchHelper.getMatchRangeQFilter(entryName, BillType, orgId, PAY, headMatch);
                break;
            }
            case "fca_transupbill": {
                AutoMatchBillTypeEnum BillType = AutoMatchBillTypeEnum.getByBillEntity((String)entryName);
                result = ManualMatchHelper.getMatchRangeQFilter(entryName, BillType, orgId, REC, true);
                break;
            }
            case "fca_transdownbill": 
            case "ifm_transhandlebill": {
                AutoMatchBillTypeEnum BillType = AutoMatchBillTypeEnum.getByBillEntity((String)entryName);
                result = ManualMatchHelper.getMatchRangeQFilter(entryName, BillType, orgId, PAY, true);
                break;
            }
            case "cas_exchangebill": {
                QFilter payAmount = new QFilter("sellunmatchamount", "!=", (Object)0);
                MatchRangeInfo exchangePay = ManualMatchHelper.getMatchRangeQFilter(entryName, AutoMatchBillTypeEnum.EXCHANGEBILL, orgId, PAY, true);
                if (exchangePay.getRangeQFilter() != null) {
                    payAmount.and(exchangePay.getRangeQFilter());
                }
                QFilter recAmount = new QFilter("buyunmatchamount", "!=", (Object)0);
                MatchRangeInfo exchangeRec = ManualMatchHelper.getMatchRangeQFilter(entryName, AutoMatchBillTypeEnum.EXCHANGEBILL, orgId, REC, true);
                if (exchangeRec.getRangeQFilter() != null) {
                    recAmount.and(exchangeRec.getRangeQFilter());
                }
                result = ManualMatchHelper.getDateFieldAndValue(true, exchangePay, exchangeRec);
                result.setRangeQFilter(recAmount.or(payAmount));
                break;
            }
        }
        return result;
    }

    private static MatchRangeInfo getDateFieldAndValue(Boolean recFlag, MatchRangeInfo payRange, MatchRangeInfo recRange) {
        Date dateValue;
        MatchRangeInfo rangeInfo = new MatchRangeInfo();
        String dateFieldPay = payRange.getDateField();
        Date dateValuePay = payRange.getEnableDate();
        String dateFieldRec = recRange.getDateField();
        Date dateValueRec = recRange.getEnableDate();
        String dateField = recFlag != false ? dateFieldRec : dateFieldPay;
        Date date = dateValue = recFlag != false ? dateValueRec : dateValuePay;
        if (dateValue == null) {
            dateValue = recFlag != false ? dateValuePay : dateValueRec;
        }
        rangeInfo.setEnableDate(dateValue);
        rangeInfo.setDateField(dateField);
        return rangeInfo;
    }

    public static MatchRangeInfo getMatchRangeQFilter(String entryName, AutoMatchBillTypeEnum biztype, Long orgId, String direction, boolean headMatch) {
        MatchRangeInfo result = new MatchRangeInfo();
        QFilter filter = new QFilter("biztype", "=", (Object)biztype.getBizType()).and(new QFilter("enable", "=", (Object)"1"));
        if (EmptyUtil.isNoEmpty((String)direction)) {
            filter.and(new QFilter("direction", "=", (Object)direction));
        }
        QFilter orgFilter = QFilter.isNull((String)"org_entry.u_org").or(new QFilter("org_entry.u_org", "=", (Object)orgId));
        filter.and(orgFilter);
        DynamicObjectCollection matchRangeInfo = QueryServiceHelper.query((String)"cas_smartmatch", (String)String.join((CharSequence)",", staticMatchField), (QFilter[])new QFilter[]{filter}, (String)"id desc");
        Map<Long, List<DynamicObject>> smartMatchDOCMap = matchRangeInfo.stream().collect(Collectors.groupingBy(smartMatchDOC -> smartMatchDOC.getLong("org_entry.u_org")));
        List<DynamicObject> smartMatchInfoList = smartMatchDOCMap.get(orgId);
        if (CollectionUtils.isEmpty(smartMatchInfoList)) {
            smartMatchInfoList = smartMatchDOCMap.get(0L);
        }
        if (smartMatchInfoList == null) {
            return result;
        }
        DynamicObject smartMatchInfo = smartMatchInfoList.get(0);
        String dateProp = headMatch ? smartMatchInfo.getString("bizdateprop") : smartMatchInfo.getString("entrybizdateprop");
        result.setDateField(dateProp);
        Date enableDate = smartMatchInfo.getDate("enabledate");
        QFilter dateFilter = null;
        if (enableDate != null) {
            dateFilter = new QFilter(dateProp, ">=", (Object)enableDate);
            result.setEnableDate(enableDate);
        }
        QFilter resultFilter = null;
        String bizConditionTag = smartMatchInfo.getString("range_bizcondition_real_TAG");
        QFilter rangeFilter = null;
        if (StringUtils.isNotEmpty((String)bizConditionTag)) {
            rangeFilter = CasHelper.getFilterFromTag((String)entryName, (String)bizConditionTag);
        }
        if (dateFilter != null && rangeFilter != null) {
            resultFilter = dateFilter.and(rangeFilter);
        } else if (dateFilter != null && rangeFilter == null) {
            resultFilter = dateFilter;
        } else if (dateFilter == null && rangeFilter != null) {
            resultFilter = rangeFilter;
        }
        result.setRangeQFilter(resultFilter);
        return result;
    }

    public static void verifySameOrg(ListSelectedRowCollection selectedRows, String entityName, IFormView view, BeforeDoOperationEventArgs args) {
        DynamicObjectCollection bills;
        Set orgIds;
        Object[] selectedRowPks = selectedRows.getPrimaryKeyValues();
        if (selectedRowPks.length > 1 && (orgIds = (bills = QueryServiceHelper.query((String)entityName, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRowPks)})).stream().map(r -> r.getLong("org")).collect(Collectors.toSet())).size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u7ec4\u7ec7\u5355\u636e\u53d1\u8d77\u5339\u914d\u3002", (String)"ManualMatchHelper_0", (String)"fi-cas-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        args.getListSelectedData().addAll((Collection)selectedRows);
    }

    public static void bizBillMatchDetail(IFormView view, AfterDoOperationEventArgs e, ListSelectedRowCollection selectedRows, IFormPlugin listener, String entityName, String fields) {
        boolean selectedPass;
        LinkedHashMap noMatchBillMap;
        AbstractOperate op = (AbstractOperate)e.getSource();
        String noMatchBillNoStr = op.getOption().containsVariable("noMatchBillNo") ? op.getOption().getVariableValue("noMatchBillNo") : null;
        LinkedHashMap linkedHashMap = noMatchBillMap = StringUtils.isNotEmpty((String)noMatchBillNoStr) ? (LinkedHashMap)JSON.parseObject((String)noMatchBillNoStr, LinkedHashMap.class) : new LinkedHashMap();
        if (!selectedRows.isEmpty() && noMatchBillMap.size() == selectedRows.getPrimaryKeyValues().length) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u65e0\u9700\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u3002", (String)"ManualMatchHelper_1", (String)"fi-cas-business", (Object[])new Object[0]));
            return;
        }
        boolean isSuccess = e.getOperationResult() == null ? false : e.getOperationResult().isSuccess();
        boolean bl = selectedPass = isSuccess && noMatchBillMap.isEmpty();
        if (selectedRows.isEmpty() || selectedPass) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("cas_manualmatch");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setCustomParam("ismergerows", (Object)false);
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (selectedPass && pks.length > 0) {
                ManualMatchHelper.setFspCustomParams(fsp, entityName, fields, pks);
            }
            view.showForm(fsp);
        } else if (!noMatchBillMap.isEmpty()) {
            Set selectedIdSet = Stream.of(selectedRows.getPrimaryKeyValues()).collect(Collectors.toSet());
            Set noMatchIdSet = noMatchBillMap.keySet();
            selectedIdSet.removeAll(noMatchIdSet);
            view.getPageCache().put("manualmatchid", JSON.toJSONString(selectedIdSet));
            ArrayList<String> noMatchBillNoMsg = new ArrayList<String>(noMatchBillMap.size());
            for (String value : noMatchBillMap.values()) {
                String tip = String.format(ResManager.loadKDString((String)"%s \u65e0\u9700\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u3002", (String)"ManualMatchHelper_2", (String)"fi-cas-business", (Object[])new Object[0]), value);
                noMatchBillNoMsg.add(tip);
            }
            String detail = String.join((CharSequence)"\r\n", noMatchBillNoMsg);
            String title = ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e2d\u5b58\u5728\u65e0\u9700\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u70b9\u51fb\u662f\uff0c\u53ef\u9488\u5bf9\u9700\u8981\u5339\u914d\u7684\u4e1a\u52a1\u5355\u636e\u53d1\u8d77\u5339\u914d\uff1b\u70b9\u51fb\u5426\uff0c\u8fd4\u56de\u5217\u8868\u754c\u9762\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u53d1\u8d77\u5339\u914d\u3002", (String)"ManualMatchHelper_3", (String)"fi-cas-business", (Object[])new Object[0]);
            view.showConfirm(title, detail, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(callBackId, listener));
        }
    }

    public static void confirmBizBillMatchDetail(IFormView view, String fields) {
        String billFormId = ((ListView)view).getEntityTypeId();
        String manualMatchIdStr = view.getPageCache().get("manualmatchid");
        Set manualMatchIdSet = (Set)JSON.parseObject((String)manualMatchIdStr, Set.class);
        Object[] pks = manualMatchIdSet.toArray();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cas_manualmatch");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setCustomParam("ismergerows", (Object)false);
        if (pks.length > 0) {
            ManualMatchHelper.setFspCustomParams(fsp, billFormId, fields, pks);
        }
        view.showForm(fsp);
    }

    public static Map<String, BigDecimal> getUnMatchAmtMap(DynamicObjectCollection bizBills, String bizBillListKey, boolean isRec, String unMatchAmtField, boolean entrySelected) {
        HashMap<String, BigDecimal> idToAmtMap = new HashMap<String, BigDecimal>(bizBills.size());
        for (DynamicObject bill : bizBills) {
            String filedProp;
            String id = bill.getString("id");
            if ("list_cas_paybill".equals(bizBillListKey)) {
                filedProp = isRec ? unMatchAmtField.split("#")[0] : unMatchAmtField.split("#")[1];
                boolean relateOtherFlow = bill.getBoolean("relateotherflow");
                if (relateOtherFlow) {
                    idToAmtMap.put(id, bill.getBigDecimal(filedProp));
                    continue;
                }
                idToAmtMap.put(id, isRec ? BigDecimal.ZERO : bill.getBigDecimal(filedProp));
                continue;
            }
            if ("list_cas_recbill".equals(bizBillListKey)) {
                filedProp = isRec ? unMatchAmtField.split("#")[0] : unMatchAmtField.split("#")[1];
                boolean relateOtherFlow = bill.getBoolean("relateotherflow");
                if (relateOtherFlow) {
                    idToAmtMap.put(id, bill.getBigDecimal(filedProp));
                    continue;
                }
                idToAmtMap.put(id, isRec ? bill.getBigDecimal(filedProp) : BigDecimal.ZERO);
                continue;
            }
            if ("list_cas_agentpaybill".equals(bizBillListKey)) {
                filedProp = entrySelected ? unMatchAmtField.split("#")[0] : unMatchAmtField.split("#")[1];
                idToAmtMap.put(id, isRec ? BigDecimal.ZERO : bill.getBigDecimal(filedProp));
                continue;
            }
            if ("list_fca_transupbill".equals(bizBillListKey) || "list_fca_transdownbill".equals(bizBillListKey)) {
                filedProp = unMatchAmtField.split("#")[0];
                String entryId = bill.getString("entrys.id");
                id = id + "," + entryId;
                if ("list_fca_transupbill".equals(bizBillListKey)) {
                    idToAmtMap.put(id, isRec ? bill.getBigDecimal(filedProp) : BigDecimal.ZERO);
                    continue;
                }
                idToAmtMap.put(id, isRec ? BigDecimal.ZERO : bill.getBigDecimal(filedProp));
                continue;
            }
            if ("list_cas_exchangebill".equals(bizBillListKey)) {
                filedProp = isRec ? unMatchAmtField.split("#")[0] : unMatchAmtField.split("#")[1];
                idToAmtMap.put(id, bill.getBigDecimal(filedProp));
                continue;
            }
            idToAmtMap.put(id, bill.getBigDecimal(unMatchAmtField));
        }
        return idToAmtMap;
    }

    private static void setFspCustomParams(FormShowParameter fsp, String entityName, String fields, Object[] pks) {
        Set currencyId;
        Set acctBankId;
        DynamicObjectCollection bill = QueryServiceHelper.query((String)entityName, (String)("id," + fields), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        String[] fieldArr = fields.split(",");
        Set orgId = bill.stream().map(b -> b.get(fieldArr[0])).collect(Collectors.toSet());
        if (fieldArr.length == 5) {
            acctBankId = bill.stream().filter(b -> (Long)b.get(fieldArr[1]) != 0L).map(b -> (Long)b.get(fieldArr[1])).collect(Collectors.toSet());
            Set acctBankIdSell = bill.stream().filter(b -> (Long)b.get(fieldArr[2]) != 0L).map(b -> (Long)b.get(fieldArr[2])).collect(Collectors.toSet());
            acctBankId.addAll(acctBankIdSell);
            currencyId = bill.stream().filter(b -> (Long)b.get(fieldArr[3]) != 0L).map(b -> (Long)b.get(fieldArr[3])).collect(Collectors.toSet());
            Set currencyIdSell = bill.stream().filter(b -> (Long)b.get(fieldArr[4]) != 0L).map(b -> (Long)b.get(fieldArr[4])).collect(Collectors.toSet());
            currencyId.addAll(currencyIdSell);
        } else {
            acctBankId = bill.stream().map(b -> (Long)b.get(fieldArr[1])).collect(Collectors.toSet());
            currencyId = bill.stream().map(b -> (Long)b.get(fieldArr[2])).collect(Collectors.toSet());
        }
        fsp.setCustomParam("filter_org", orgId.toArray()[0]);
        fsp.setCustomParam("filter_accountbank", acctBankId);
        fsp.setCustomParam("filter_currency", currencyId);
        fsp.setCustomParam("bizbillname", (Object)entityName);
        fsp.setCustomParam("bizbillid", Arrays.asList(pks));
    }
}

