/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.result.PayApplyStatusResult;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.FiCacheHelper;

public class PayApplyBillHelper {
    public static PayApplyStatusResult getHeadStatus(DynamicObjectCollection payInfoColl) {
        PayApplyStatusResult result = new PayApplyStatusResult();
        Map<Boolean, List<DynamicObject>> payInfoInvalidGroup = payInfoColl.stream().collect(Collectors.groupingBy(e -> e.getBoolean("entry_invalid")));
        ArrayList payInfoList = new ArrayList(0);
        if (payInfoInvalidGroup.containsKey(Boolean.FALSE)) {
            boolean allInInvalid = payInfoInvalidGroup.get(Boolean.FALSE).stream().allMatch(o -> PayStatusEnum.CLANCEL.getValue().equals(o.getString("entry_paystatus")));
            if (allInInvalid) {
                payInfoList.addAll(payInfoInvalidGroup.get(Boolean.TRUE));
            } else {
                payInfoList.addAll(payInfoInvalidGroup.get(Boolean.FALSE));
            }
        } else {
            payInfoList.addAll(payInfoInvalidGroup.get(Boolean.TRUE));
        }
        Map<Object, List<DynamicObject>> payInfoGroup = payInfoList.stream().collect(Collectors.groupingBy(e -> e.getString("entry_paystatus")));
        PayApplyPayStatusEnum headStatus = null;
        Boolean backBillFlag = Boolean.FALSE;
        Boolean partPaySchFlag = Boolean.FALSE;
        Boolean partPayFlag = Boolean.FALSE;
        List<DynamicObject> notPayDataList = payInfoGroup.get(PayStatusEnum.NOTPAYING.getValue());
        List<DynamicObject> paySchFundDataList = payInfoGroup.get(PayStatusEnum.PAYSCHEFUND.getValue());
        List<DynamicObject> payingDataList = payInfoGroup.get(PayStatusEnum.PAYING.getValue());
        List<DynamicObject> payedDataList = payInfoGroup.get(PayStatusEnum.PAYMENTSUCCESS.getValue());
        boolean payInfoAllPaid = PayApplyBillHelper.isPayInfoAllPaid(payInfoColl);
        if (payInfoAllPaid) {
            headStatus = PayApplyPayStatusEnum.SUCCESS;
        } else if (!CollectionUtils.isEmpty(notPayDataList)) {
            headStatus = PayApplyPayStatusEnum.NOTPAYING;
        } else if (!CollectionUtils.isEmpty(paySchFundDataList)) {
            headStatus = PayApplyPayStatusEnum.PAYSCHE;
        } else if (!CollectionUtils.isEmpty(payingDataList)) {
            headStatus = PayApplyPayStatusEnum.PAYING;
        } else if (!CollectionUtils.isEmpty(payedDataList)) {
            headStatus = PayApplyPayStatusEnum.SUCCESS;
        }
        List<DynamicObject> cancelDataList = payInfoGroup.get(PayStatusEnum.CLANCEL.getValue());
        if (!(CollectionUtils.isEmpty(notPayDataList) || CollectionUtils.isEmpty(paySchFundDataList) && CollectionUtils.isEmpty(payingDataList) && CollectionUtils.isEmpty(payedDataList))) {
            partPaySchFlag = Boolean.TRUE;
        }
        if (!CollectionUtils.isEmpty(cancelDataList)) {
            backBillFlag = Boolean.TRUE;
        }
        if (!(CollectionUtils.isEmpty(payedDataList) || CollectionUtils.isEmpty(notPayDataList) && CollectionUtils.isEmpty(payingDataList) && CollectionUtils.isEmpty(paySchFundDataList))) {
            partPayFlag = Boolean.TRUE;
        }
        result.setPayStatus(headStatus);
        result.setBackBillFlag(backBillFlag);
        result.setPartPayFlag(partPayFlag);
        result.setPartPaySchFlag(partPaySchFlag);
        return result;
    }

    public static boolean isPayInfoAllPaid(DynamicObjectCollection payInfoColl) {
        String payApplyId = ((DynamicObject)payInfoColl.getParent()).getString("id");
        String lockKey = PayApplyBillHelper.getLockKey(payApplyId);
        String successStatusCache = (String)FiCacheHelper.getSessionlessCacheInstance().get(lockKey);
        int successCount = payInfoColl.stream().filter(payInfo -> PayStatusEnum.PAYMENTSUCCESS.getValue().equals(payInfo.getString("entry_paystatus"))).map(payInfo -> 1).collect(Collectors.summingInt(Integer::intValue));
        if (EmptyUtil.isEmpty((String)successStatusCache)) {
            return successCount == payInfoColl.size();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)successStatusCache);
        return jsonObject.size() == payInfoColl.size() || successCount == payInfoColl.size();
    }

    public static DynamicObject updateHeaderInfo(DynamicObjectCollection payDetailEntry, DynamicObject payApplyBill) {
        PayApplyStatusResult result = PayApplyBillHelper.getHeadStatus(payDetailEntry);
        payApplyBill.set("paidstatus", (Object)result.getPayStatus().getValue());
        payApplyBill.set("backbillflag", (Object)result.getBackBillFlag());
        payApplyBill.set("partpaysche", (Object)result.getPartPaySchFlag());
        payApplyBill.set("partpay", (Object)result.getPartPayFlag());
        return payApplyBill;
    }

    public static List<Long> getDraftBillList(DynamicObjectCollection payinfoCollection, boolean isClancel) {
        return payinfoCollection.stream().filter(item -> {
            DynamicObjectCollection draftbillColls = item.getDynamicObjectCollection("entry_draftbill");
            if (draftbillColls == null || draftbillColls.size() < 1) {
                return false;
            }
            if (PayStatusEnum.CLANCEL.getValue().equals(item.getString("entry_paystatus"))) {
                return isClancel;
            }
            if (item.getBoolean("entry_invalid")) {
                return isClancel;
            }
            return true;
        }).map(item -> item.getDynamicObjectCollection("entry_draftbill")).flatMap(item -> item.stream().filter(e -> null != e.getDynamicObject("fbasedataid")).map(coll -> coll.getDynamicObject("fbasedataid").getLong("id"))).collect(Collectors.toList());
    }

    public static String getLockKey(String sourcePayApplyPk) {
        return "CAS-PaySynPayApply-" + sourcePayApplyPk;
    }
}

