/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.PaymentBillBookJournalBuilder;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.service.LetterCreditService;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.EmptyUtil;

public class PayBillHepler {
    private static JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private static final Log logger = LogFactory.getLog(PayBillHepler.class);
    public static final String KEY_CALLBACK_SELECTCREDIT = "CALLBACK_SELECTCREDIT";
    private static final List<WriteBackOperateEnum> LC_ARRIVAL_WB_OPS = Arrays.asList(WriteBackOperateEnum.DELETE, WriteBackOperateEnum.PAY, WriteBackOperateEnum.CANCELPAY, WriteBackOperateEnum.CHARGEBACK);

    public static DynamicObject dealReverse(DynamicObject payBill) {
        payBill.set("hotaccount", (Object)HotAccountEnum.HOTEDBILL.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        DynamicObject newPayBill = (DynamicObject)OrmUtils.clone((Object)payBill, (IDataEntityType)payBill.getDataEntityType(), (boolean)true, (boolean)true);
        newPayBill.set("actpayamt", (Object)newPayBill.getBigDecimal("actpayamt").negate());
        newPayBill.set("fee", (Object)newPayBill.getBigDecimal("fee").negate());
        newPayBill.set("localamt", (Object)newPayBill.getBigDecimal("localamt").negate());
        newPayBill.set("dpamt", (Object)newPayBill.getBigDecimal("dpamt").negate());
        newPayBill.set("dplocalamt", (Object)newPayBill.getBigDecimal("dplocalamt").negate());
        newPayBill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
        String generateNumber = CodeRuleHelper.generateNumber((String)"cas_paybill", (DynamicObject)newPayBill, null, null);
        if (StringUtils.isEmpty((CharSequence)generateNumber)) {
            generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        }
        newPayBill.set("billno", (Object)generateNumber);
        newPayBill.set("hotaccount", (Object)HotAccountEnum.HOTBILL.getValue());
        newPayBill.set("isvoucher", null);
        DynamicObjectCollection entrys = newPayBill.getDynamicObjectCollection("entry");
        entrys.forEach(entry -> {
            entry.set("e_payableamt", (Object)entry.getBigDecimal("e_payableamt").negate());
            entry.set("e_payablelocamt", (Object)entry.getBigDecimal("e_payablelocamt").negate());
            entry.set("e_discountamt", (Object)entry.getBigDecimal("e_discountamt").negate());
            entry.set("e_discountlocamt", (Object)entry.getBigDecimal("e_discountlocamt").negate());
            entry.set("e_actamt", (Object)entry.getBigDecimal("e_actamt").negate());
            entry.set("e_localamt", (Object)entry.getBigDecimal("e_localamt").negate());
            entry.set("e_lockamt", (Object)entry.getBigDecimal("e_lockamt").negate());
            entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_unlockamt").negate());
            entry.set("e_settledamt", (Object)BigDecimal.ZERO);
            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableamt"));
        });
        newPayBill.set("sourcebilltype", (Object)"cas_recbill");
        newPayBill.set("sourcebillid", (Object)String.valueOf(payBill.getPkValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPayBill});
        Boolean isBillBook = true;
        DynamicObject org = newPayBill.getDynamicObject("org");
        if (org != null) {
            isBillBook = SystemParameterHelper.isBillBookJournal((long)org.getLong("id"));
        }
        if (!isBillBook.booleanValue()) {
            return newPayBill;
        }
        QFilter filter = new QFilter("sourcebilltype", "=", (Object)"cas_paybill").and("sourcebillid", "=", (Object)Long.parseLong(payBill.getString("id")));
        boolean exists = QueryServiceHelper.exists((String)"cas_bankjournal", (QFilter[])new QFilter[]{filter});
        if (exists) {
            journalServiceAdapter.validateBook((IBookJournalBuilder)new PaymentBillBookJournalBuilder(), newPayBill);
            journalServiceAdapter.book(newPayBill);
        }
        return newPayBill;
    }

    public static boolean isCreditSettlement(DynamicObject settleType) {
        return PayBillHepler.isLCSettlement(settleType, SettleMentTypeEnum.CREDIT);
    }

    public static boolean isLCSettlement(DynamicObject settleType, SettleMentTypeEnum typeEnum) {
        try {
            return EmptyUtil.isNoEmpty((DynamicObject)settleType) && typeEnum.getValue().equals(settleType.getString("settlementtype"));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    public static boolean isLCSettlement(DynamicObject payBill) {
        if (!payBill.containsProperty("settletype")) {
            return false;
        }
        DynamicObject settleType = payBill.getDynamicObject("settletype");
        String settleNumber = payBill.getString("settletnumber");
        String sourceBillType = payBill.getString("sourcebilltype");
        if ("lc_arrival".equals(sourceBillType)) {
            return false;
        }
        return PayBillHepler.isCreditSettlement(settleType) && StringUtils.isNotEmpty((CharSequence)settleNumber);
    }

    private static boolean isArrivalSettlement(DynamicObject settleType, String settletnumber) {
        try {
            if (PayBillHepler.isCreditSettlement(settleType) && StringUtils.isNotEmpty((CharSequence)settletnumber) && QueryServiceHelper.exists((String)"lc_arrival", (QFilter[])new QFilter[]{new QFilter("arrivalno", "=", (Object)settletnumber)})) {
                return true;
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return false;
    }

    private static boolean isArrivalSettlement(DynamicObject settleType, String settletnumber, Set<String> existArrivalNos) {
        try {
            if (PayBillHepler.isCreditSettlement(settleType) && existArrivalNos.contains(settletnumber)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return false;
    }

    public static <T extends WriteBackTaskConsumer> void payApplyBillWriteBackArrival(DynamicObject paymentBill, WriteBackOperateEnum writebackoperate, Class<T> writebackconsumer) {
        String sourcebilltype = paymentBill.getString("sourcebilltype");
        if (("cas_payapplybill".equals(sourcebilltype) || "lc_arrival".equals(sourcebilltype) || PayBillHepler.isLCSettlement(paymentBill)) && PayBillHepler.isArrivalSettlement(paymentBill.getDynamicObject("settletype"), paymentBill.getString("settletnumber"))) {
            try {
                if (LC_ARRIVAL_WB_OPS.contains((Object)writebackoperate)) {
                    WriteBackTaskHelper.addRealtimeTask(paymentBill, "lc_arrival", writebackoperate, writebackconsumer);
                } else {
                    HashMap<String, Object> param = new HashMap<String, Object>(1);
                    param.put("info", paymentBill);
                    WriteBackTaskHelper.addRealtimeTask(paymentBill, "lc_arrival", writebackoperate, writebackconsumer, param);
                }
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static <T extends WriteBackTaskConsumer> void payApplyBillWriteBackArrival(List<DynamicObject> paymentBills, WriteBackOperateEnum writebackoperate, Class<T> writebackconsumer) {
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(paymentBills.size());
        for (DynamicObject paymentBill : paymentBills) {
            String sourcebilltype = paymentBill.getString("sourcebilltype");
            if (!"cas_payapplybill".equals(sourcebilltype) && !"lc_arrival".equals(sourcebilltype) && !PayBillHepler.isLCSettlement(paymentBill) || !PayBillHepler.isArrivalSettlement(paymentBill.getDynamicObject("settletype"), paymentBill.getString("settletnumber"))) continue;
            try {
                if (LC_ARRIVAL_WB_OPS.contains((Object)writebackoperate)) {
                    WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                    taskInfo.setBillId((Long)paymentBill.getPkValue());
                    taskInfo.setDataEntity(paymentBill.getDataEntityType().getName());
                    taskInfo.setSourceEntity("lc_arrival");
                    taskInfos.add(taskInfo);
                    continue;
                }
                WriteBackTaskInfo taskInfo2 = new WriteBackTaskInfo();
                taskInfo2.setBillId((Long)paymentBill.getPkValue());
                taskInfo2.setDataEntity(paymentBill.getDataEntityType().getName());
                taskInfo2.setSourceEntity("lc_arrival");
                HashMap<String, DynamicObject> param = new HashMap<String, DynamicObject>(1);
                param.put("info", paymentBill);
                taskInfo2.setParam(param);
                taskInfos.add(taskInfo2);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, writebackoperate, writebackconsumer);
    }

    public static <T extends WriteBackTaskConsumer> void batchPayApplyBillWriteBackArrival(DynamicObject[] payBills, WriteBackOperateEnum writebackoperate, Class<T> writebackconsumer) {
        Object[] list;
        HashSet<String> settleNumbers = new HashSet<String>(payBills.length);
        for (DynamicObject payBill : payBills) {
            String settleNumber = payBill.getString("settletnumber");
            settleNumbers.add(settleNumber);
        }
        HashSet<String> existArrivalNos = new HashSet<String>(16);
        if (settleNumbers.size() > 0) {
            DynamicObject[] arrBills;
            for (DynamicObject arrBill : arrBills = BusinessDataServiceHelper.load((String)"lc_arrival", (String)"id, arrivalno", (QFilter[])new QFilter[]{new QFilter("arrivalno", "in", settleNumbers)})) {
                String billNo = arrBill.getString("arrivalno");
                existArrivalNos.add(billNo);
            }
        }
        if (EmptyUtil.isEmpty((Object[])(list = (DynamicObject[])((Stream)Arrays.stream(payBills).parallel()).filter(d -> ("cas_payapplybill".equals(d.getString("sourcebilltype")) || "lc_arrival".equals(d.getString("sourcebilltype")) || PayBillHepler.isLCSettlement(d)) && PayBillHepler.isArrivalSettlement(d.getDynamicObject("settletype"), d.getString("settletnumber"), existArrivalNos)).toArray(DynamicObject[]::new)))) {
            return;
        }
        try {
            if (LC_ARRIVAL_WB_OPS.contains((Object)writebackoperate)) {
                WriteBackTaskHelper.batchAddRealtimeTask((DynamicObject[])list, "lc_arrival", writebackoperate, writebackconsumer, new HashMap<String, Object>());
            } else {
                ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(list.length);
                for (Object info : list) {
                    WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                    taskInfo.setBillId((Long)info.getPkValue());
                    taskInfo.setDataEntity(info.getDataEntityType().getName());
                    taskInfo.setSourceEntity("lc_arrival");
                    HashMap<String, Object> param = new HashMap<String, Object>(1);
                    param.put("info", info);
                    taskInfo.setParam(param);
                    taskInfos.add(taskInfo);
                }
                WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, writebackoperate, writebackconsumer);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static Set<Long> getViewSettle(Object billId, String billType) {
        Set<Long> settleRecordIds = new HashSet<Long>(0);
        if (billId == null) {
            return settleRecordIds;
        }
        if (billId instanceof Long && (Long)billId != 0L) {
            settleRecordIds = PayBillHepler.getViewSettle(Collections.singletonList((Long)billId), billType);
        }
        return settleRecordIds;
    }

    public static Set<Long> getViewSettle(DynamicObject bill) {
        HashSet<Long> settleRecordIds = new HashSet<Long>(0);
        if (bill == null || (Long)bill.getPkValue() == 0L) {
            return settleRecordIds;
        }
        return PayBillHepler.getViewSettle((Long)bill.getPkValue(), bill.getDataEntityType().getName());
    }

    public static Set<Long> getViewSettle(List<Long> billIds, String billType) {
        return PayBillHepler.getViewSettle(billIds, billType, "id", "id");
    }

    public static Set<Long> getViewSettle(List<Long> billIds, String billType, String appointField, String appointField2) {
        HashSet<Long> settleRecordIds = new HashSet<Long>(0);
        if (billIds == null || billIds.size() == 0) {
            return settleRecordIds;
        }
        QFilter otherFilter1 = new QFilter("iswrittenoff", "=", (Object)"0");
        otherFilter1.and("entry.e_hadwrittenoff", "=", (Object)"0");
        QFilter otherFilter2 = new QFilter("iswrittenoff", "=", (Object)"1");
        otherFilter2.and("entry.e_hadwrittenoff", "=", (Object)"1");
        if ("cas_paybill".equals(billType)) {
            Set nomainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain((String)"ap_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter1, (String)appointField);
            Set noasstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst((String)"ap_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter1, (String)appointField2);
            settleRecordIds.addAll(nomainSettleIds);
            settleRecordIds.addAll(noasstSettleIds);
            Set yemainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain((String)"ap_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter2, (String)appointField);
            Set yeasstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst((String)"ap_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter2, (String)appointField2);
            settleRecordIds.addAll(yemainSettleIds);
            settleRecordIds.addAll(yeasstSettleIds);
        } else if ("cas_recbill".equals(billType)) {
            Set nomainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain((String)"ar_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter1, (String)appointField);
            Set noasstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst((String)"ar_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter1, (String)appointField2);
            settleRecordIds.addAll(nomainSettleIds);
            settleRecordIds.addAll(noasstSettleIds);
            Set yemainSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByMain((String)"ar_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter2, (String)appointField);
            Set yeasstSettleIds = SettleRecordQueryHelperForCas.getSettleIdsByAsst((String)"ar_settlerecord", (String)billType, (Object[])billIds.toArray(), (QFilter)otherFilter2, (String)appointField2);
            settleRecordIds.addAll(yemainSettleIds);
            settleRecordIds.addAll(yeasstSettleIds);
        }
        return settleRecordIds;
    }

    public static boolean checkDraftAllInPayApplyBill(DynamicObject payBill, List<Long> draftLockBillIdList) {
        if (payBill == null || draftLockBillIdList == null || draftLockBillIdList.size() < 1) {
            return false;
        }
        Set payBillIds = payBill.getDynamicObjectCollection("entry").stream().map(entry -> entry.getLong("e_sourcebillid")).collect(Collectors.toSet());
        payBillIds.add(payBill.getLong("sourcebillid"));
        DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((Object[])payBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_payapplybill"));
        if (payApplyBills == null || payApplyBills.length < 1) {
            return false;
        }
        ArrayList<Long> tDraftBillList = new ArrayList<Long>(0);
        for (DynamicObject payApplyBill : payApplyBills) {
            tDraftBillList.addAll(PayApplyBillHelper.getDraftBillList(payApplyBill.getDynamicObjectCollection("cas_payinfo"), false));
        }
        return tDraftBillList.containsAll(draftLockBillIdList);
    }

    public static void callCancleDraw(Set<Long> draftTradeBillIdSet, boolean isDeleteByPsd) {
        if (null == draftTradeBillIdSet || draftTradeBillIdSet.size() == 0) {
            return;
        }
        logger.info("callCancleDraw is start:" + SerializationUtils.toJsonString(draftTradeBillIdSet));
        QFilter id_qFilter = new QFilter("id", "in", draftTradeBillIdSet);
        QFilter billStatuas_qFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter draftStatus_qFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        DynamicObject[] draftTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{id_qFilter, billStatuas_qFilter, draftStatus_qFilter});
        if (null != draftTradeBills && draftTradeBills.length > 0) {
            List idList = Arrays.stream(draftTradeBills).map(e -> e.getLong("id")).collect(Collectors.toList());
            OperateOption create = OperateOption.create();
            create.setVariableValue("cancelbycas", "y");
            if (isDeleteByPsd) {
                create.setVariableValue("dealbypsd", "y");
            }
            logger.info("will canceldrawbill is start:" + SerializationUtils.toJsonString(idList));
            OperateServiceHelper.execOperate((String)"canceldrawbill", (String)"cdm_drafttradebill", (Object[])idList.toArray(), (OperateOption)create, (boolean)true);
        }
    }

    public static boolean isNeedBookJournal(DynamicObject paymentBill) {
        Map<Long, Boolean> results = PayBillHepler.isNeedBookJournal(Collections.singletonList(paymentBill));
        return results.size() != 0 && results.values().iterator().next() != false;
    }

    public static Map<Long, Boolean> isNeedBookJournal(List<DynamicObject> paymentBills) {
        if (paymentBills == null || paymentBills.size() == 0) {
            return new HashMap<Long, Boolean>();
        }
        HashMap<Long, Boolean> returns = new HashMap<Long, Boolean>(paymentBills.size());
        for (DynamicObject paymentBill : paymentBills) {
            DynamicObject settle;
            Long payBillId = paymentBill.getLong("id");
            long orgId = DynamicObjectHelper.getPk((DynamicObject)paymentBill, (String)"org");
            if (CasBankJournalHelper.considerBillBookJournal((long)orgId) && (settle = (DynamicObject)paymentBill.get("settletype")) != null) {
                String settleType = settle.getString("settlementtype");
                boolean book = ExtendConfigHelper.bookBySettleType((String)settleType);
                returns.put(payBillId, book);
                continue;
            }
            DynamicObject bankAcct = paymentBill.getDynamicObject("payeracctbank");
            long payeeAcctBankId = paymentBill.getLong("payeeacctbank");
            if (CasHelper.isNotEmpty((Object)bankAcct)) {
                boolean isVirtual;
                DynamicObject payeeAcctBank = null;
                if (CasHelper.isNotEmpty((Object)payeeAcctBankId)) {
                    payeeAcctBank = AccountBankHelper.getAccountBankById((long)payeeAcctBankId);
                }
                if ((isVirtual = bankAcct.getBoolean("isvirtual")) && payeeAcctBank != null && payeeAcctBank.getBoolean("isvirtual")) {
                    returns.put(payBillId, false);
                    continue;
                }
                DynamicObject bank = bankAcct.getDynamicObject("bank");
                if (CasHelper.isEmpty((Object)bank) && payeeAcctBank != null && CasHelper.isEmpty((Object)payeeAcctBank.getDynamicObject("bank"))) {
                    returns.put(payBillId, false);
                    continue;
                }
            }
            returns.put(payBillId, (!CasHelper.isEmpty((Object)paymentBill.getDynamicObject("payeracctbank")) || !CasHelper.isEmpty((Object)paymentBill.getDynamicObject("payeracctcash")) || !CasHelper.isEmpty((Object)paymentBill.getLong("payeeacctbank"))) && !DraftHelper.isSettlePromise((Object)paymentBill.get("settletype")));
        }
        return returns;
    }

    public static void lockEntryAmtForApBill(List<DynamicObject> bills) {
        for (DynamicObject info : bills) {
            DynamicObjectCollection entryColl = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entry.set("e_lockAmt", (Object)entry.getBigDecimal("e_payableAmt"));
                entry.set("e_unlockAmt", (Object)BigDecimal.ZERO);
                entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableAmt").subtract(entry.getBigDecimal("e_settledamt")));
            }
        }
    }

    public static void lockEntryAmt(String sourceBillType, List<DynamicObject> bills) {
        if (!"ap_payapply".equals(sourceBillType)) {
            return;
        }
        Set<Long> allSourceIds = bills.stream().flatMap(b -> b.getDynamicObjectCollection("entry").stream()).map(e -> e.getLong("e_sourcebillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        Set<Long> needLockAmtSourceIds = PaymentServiceHelper.getNeedLockAmtSourceIds(sourceBillType, allSourceIds);
        if (needLockAmtSourceIds.isEmpty()) {
            return;
        }
        for (DynamicObject payBill : bills) {
            DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                if (!needLockAmtSourceIds.contains(entry.getLong("e_sourcebillid"))) continue;
                entry.set("e_lockamt", (Object)entry.getBigDecimal("e_payableamt"));
                entry.set("e_unlockamt", (Object)BigDecimal.ZERO);
                entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableamt").subtract(entry.getBigDecimal("e_settledamt")));
            }
        }
    }

    public static void writeBackLetterCredit(String lcOperate, boolean bizCondition, OperateOption option, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0 || !bizCondition) {
            return;
        }
        List<DynamicObject> lcOpenPayBillList = Arrays.stream(dataEntities).filter(data -> {
            DynamicObject settleType = data.getDynamicObject("settletype");
            String settletNumber = data.getString("settletnumber");
            return StringUtils.isNotBlank((CharSequence)settletNumber) && settleType != null && SettleMentTypeEnum.CREDITOPEN.getValue().equals(settleType.getString("settlementtype"));
        }).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(lcOpenPayBillList)) {
            LetterCreditService.writeBackLetterCredit(lcOperate, lcOpenPayBillList);
            String clearSettletNumber = option.getVariableValue("clearSettletNumber", "");
            if ("delete".equals(lcOperate) && "true".equals(clearSettletNumber)) {
                lcOpenPayBillList.forEach(d -> d.set("settletnumber", (Object)""));
                SaveServiceHelper.update((DynamicObject[])lcOpenPayBillList.toArray(new DynamicObject[0]));
            }
        }
        String oldSettletNumber = option.getVariableValue("srcLcNoHaveValueClear", "");
        if (Arrays.asList("save", "submit").contains(lcOperate) && EmptyUtil.isNotBlank((CharSequence)oldSettletNumber)) {
            List<DynamicObject> payBillList = Arrays.stream(dataEntities).collect(Collectors.toList());
            payBillList.forEach(d -> d.set("settletnumber", (Object)oldSettletNumber));
            LetterCreditService.writeBackLetterCredit("delete", payBillList);
            Arrays.stream(dataEntities).forEach(d -> d.set("settletnumber", (Object)""));
        }
    }

    public static void writeBackArrival(OperateOption option, DynamicObject[] dataEntities) {
        String isClearCreditSettletNumber;
        if (dataEntities == null || dataEntities.length != 1) {
            return;
        }
        DynamicObject info = dataEntities[0];
        if (info.getDataEntityState().getFromDatabase() && "true".equals(isClearCreditSettletNumber = option.getVariableValue("isClearCreditSettletNumber", ""))) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            DynamicObject backInfo = BusinessDataServiceHelper.loadSingle((Object)info.get("id"), (String)info.getDynamicObjectType().getName());
            WriteBackTaskHelper.addRealtimeTask(backInfo, "lc_arrival", WriteBackOperateEnum.DELETE, PaymentDisposeConsumer.class, paramMap);
        }
    }

    public static void payBillOpDelRela(OperateOption option, DynamicObject[] dataEntities) {
        option.setVariableValue("clearSettletNumber", "true");
        PayBillHepler.writeBackLetterCredit("delete", true, option, dataEntities);
    }

    public static void closedCallBack(String actionId, IFormView view, Object returnData) {
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_CALLBACK_SELECTCREDIT) && returnData != null) {
            Map data = (Map)returnData;
            Object payBillId = data.get("paybillid");
            String lcBillNo = (String)data.get("lcBillNo");
            DynamicObject dbData = BusinessDataServiceHelper.loadSingle(payBillId, (String)"cas_paybill", (String)"id,billno,bizdate,settletype,settletnumber,org,payerbank,dpcurrency,actpayamt,payeetype,payeename");
            if (dbData != null) {
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        dbData.set("settletnumber", (Object)lcBillNo);
                        SaveServiceHelper.update((DynamicObject)dbData);
                        PayBillHepler.writeBackLetterCredit("saveValidate", true, OperateOption.create(), new DynamicObject[]{dbData});
                        PayBillHepler.writeBackLetterCredit("save", true, OperateOption.create(), new DynamicObject[]{dbData});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        logger.error("pay select lettercredit error:", (Throwable)e);
                        throw new KDBizException(e.getMessage());
                    }
                }
            }
            if (view != null) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("lcBillNo", lcBillNo);
                view.invokeOperation("pay", option);
            }
        }
    }
}

