/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class VoucherCheckHepler {
    private static final String VCHECKED = "c";
    private static final String VOUCHERCHECKSTATUS_TOBE = "b";

    public static void doVoucherCheck(DynamicObject info) {
        boolean result = VoucherCheckHepler.vouCherCheck(info);
        if (!result) {
            throw new KDBizException(new CasErrorCode().VOUCHER_NOT_CHECK(), new Object[0]);
        }
    }

    public static void batchDoVoucherCheck(List<DynamicObject> infos) {
        DynamicObjectCollection daptrackers;
        if (EmptyUtil.isEmpty(infos)) {
            return;
        }
        String entityname = infos.get(0).getDataEntityType().getName();
        Set ids = infos.parallelStream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and("isvoucher", "=", (Object)"1");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityname, (String)"id,org.id", (QFilter[])qFilter.toArray());
        Set orgIds = bills.parallelStream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("org.id"))).map(d -> d.getLong("org.id")).collect(Collectors.toSet());
        Map orgParamMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs105");
        ArrayList dealIds = new ArrayList(10);
        Map<Long, List<DynamicObject>> groupMap = bills.parallelStream().collect(Collectors.groupingBy(s -> s.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            Long key = entry.getKey();
            long orgId = EmptyUtil.isEmpty((Long)key) ? 0L : key;
            boolean isBillBookJournal = "0".equals(orgParamMap.get(String.valueOf(orgId)));
            if (!isBillBookJournal) continue;
            List collect = entry.getValue().stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            dealIds.addAll(collect);
        }
        if (dealIds.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)(daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", dealIds)})))) {
            Map<Long, List<DynamicObject>> daptracerGroup = daptrackers.parallelStream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
            for (Map.Entry<Long, List<DynamicObject>> daptracker : daptracerGroup.entrySet()) {
                String srctype;
                boolean vouchercheck;
                QFilter[] qFilters;
                DynamicObjectCollection voucherList;
                Long sourceId = daptracker.getKey();
                List<DynamicObject> list = daptracker.getValue();
                List voucherIds = list.parallelStream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("voucherid"))).map(d -> d.getLong("voucherid")).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(voucherIds) || EmptyUtil.isEmpty((DynamicObjectCollection)(voucherList = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebilltype.number,entries.account.iscash,entries.account.isbank,entries.account.iscashequivalent", (QFilter[])(qFilters = new QFilter[]{new QFilter("id", "in", voucherIds), new QFilter("ischeck", "=", (Object)VOUCHERCHECKSTATUS_TOBE), new QFilter("isreverse", "=", (Object)"0"), new QFilter("hasreverse", "=", (Object)"0"), new QFilter("billstatus", "!=", (Object)"A")}))))) continue;
                Map<Long, List<DynamicObject>> voucherMap = voucherList.parallelStream().collect(Collectors.groupingBy(d -> d.getLong("id")));
                ArrayList<Long> needVoucherIds = new ArrayList<Long>();
                for (Map.Entry<Long, List<DynamicObject>> voucher : voucherMap.entrySet()) {
                    Long voucherId = voucher.getKey();
                    List<DynamicObject> dyObjList = voucher.getValue();
                    Optional<DynamicObject> isCashBank = dyObjList.parallelStream().filter(d -> d.getBoolean("entries.account.iscash") || d.getBoolean("entries.account.isbank") || d.getBoolean("entries.account.iscashequivalent")).findFirst();
                    if (!isCashBank.isPresent()) continue;
                    needVoucherIds.add(voucherId);
                }
                if (!EmptyUtil.isNoEmpty(needVoucherIds) || (vouchercheck = VoucherCheckHepler.operateCheck(needVoucherIds, srctype = ((DynamicObject)voucherList.get(0)).getString("sourcebilltype.number"), sourceId, "vouchercheck"))) continue;
                throw new KDBizException(new CasErrorCode().VOUCHER_NOT_CHECK(), new Object[0]);
            }
        }
    }

    public static void doCancelCoucherCheck(DynamicObject info) {
        boolean result = VoucherCheckHepler.cancelCoucherCheck(info);
        if (!result) {
            throw new KDBizException(new CasErrorCode().VOUCHER_NOT_CHECKED(), new Object[0]);
        }
    }

    public static void batchoCancelCoucherCheck(List<DynamicObject> infos) {
        DynamicObjectCollection daptrackers;
        if (EmptyUtil.isEmpty(infos)) {
            return;
        }
        String entityname = infos.get(0).getDataEntityType().getName();
        Set ids = infos.parallelStream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and("isvoucher", "=", (Object)"1");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityname, (String)"id,org.id", (QFilter[])qFilter.toArray());
        Set orgIds = bills.parallelStream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("org.id"))).map(d -> d.getLong("org.id")).collect(Collectors.toSet());
        Map orgParamMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs105");
        ArrayList dealIds = new ArrayList(10);
        Map<Long, List<DynamicObject>> groupMap = bills.parallelStream().collect(Collectors.groupingBy(s -> s.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            Long key = entry.getKey();
            long orgId = EmptyUtil.isEmpty((Long)key) ? 0L : key;
            boolean isBillBookJournal = "0".equals(orgParamMap.get(String.valueOf(orgId)));
            if (!isBillBookJournal) continue;
            List collect = entry.getValue().stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            dealIds.addAll(collect);
        }
        if (dealIds.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)(daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", dealIds)})))) {
            Map<Long, List<DynamicObject>> daptracerGroup = daptrackers.parallelStream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
            for (Map.Entry<Long, List<DynamicObject>> daptracker : daptracerGroup.entrySet()) {
                String type;
                boolean voucheruncheck;
                QFilter[] qFilters;
                DynamicObjectCollection vouchers;
                Long sourceId = daptracker.getKey();
                List<DynamicObject> list = daptracker.getValue();
                List<Long> voucherIds = list.parallelStream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("voucherid"))).map(d -> d.getLong("voucherid")).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(voucherIds) || EmptyUtil.isEmpty((DynamicObjectCollection)(vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebilltype", (QFilter[])(qFilters = new QFilter[]{new QFilter("id", "in", voucherIds), new QFilter("ischeck", "=", (Object)VCHECKED), new QFilter("ispost", "=", (Object)"0")})))) || (voucheruncheck = VoucherCheckHepler.operateCheck(voucherIds, type = ((DynamicObject)vouchers.get(0)).getString("sourcebilltype"), sourceId, "voucheruncheck"))) continue;
                throw new KDBizException(new CasErrorCode().VOUCHER_NOT_CHECKED(), new Object[0]);
            }
        }
    }

    private static boolean vouCherCheck(DynamicObject info) {
        boolean result = true;
        Long sourceBillId = info.getLong("id");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)info.getDataEntityType().getName(), (String)"id,isvoucher,org");
        DynamicObject org = bill.getDynamicObject("org");
        if (!bill.getBoolean("isvoucher") || org == null || !SystemParameterHelper.isBillBookJournal((long)org.getLong("id"))) {
            return result;
        }
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        QFilter filter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
        if (vouchersDaps != null && vouchersDaps.size() > 0) {
            DynamicObject[] vouchers;
            vouchersDaps.forEach(v -> voucherIds.add(v.getLong("voucherid")));
            if (voucherIds.size() > 0 && (vouchers = BusinessDataServiceHelper.load((Object[])voucherIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_voucher"))) != null && vouchers.length > 0) {
                voucherIds.clear();
                for (DynamicObject v2 : vouchers) {
                    if (!VoucherCheckHepler.isCheck(v2) || !VoucherCheckHepler.isCashBank(v2)) continue;
                    voucherIds.add(v2.getLong("id"));
                }
                if (voucherIds.size() > 0) {
                    DynamicObject typeObj = vouchers[0].getDynamicObject("sourcebilltype");
                    String type = typeObj.getString("number");
                    result = VoucherCheckHepler.operateCheck(voucherIds, type, sourceBillId, "vouchercheck");
                }
            }
        }
        return result;
    }

    private static boolean isCheck(DynamicObject vouvher) {
        return VOUCHERCHECKSTATUS_TOBE.equals(vouvher.getString("ischeck")) && "0".equals(vouvher.getString("isreverse")) && "0".equals(vouvher.getString("hasreverse")) && !"A".equals(vouvher.getString("billstatus"));
    }

    private static boolean cancelCoucherCheck(DynamicObject info) {
        boolean result = true;
        Long sourceBillId = info.getLong("id");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)info.getDataEntityType().getName(), (String)"id,isvoucher,org");
        DynamicObject org = bill.getDynamicObject("org");
        if (!bill.getBoolean("isvoucher") || org == null || !SystemParameterHelper.isBillBookJournal((long)org.getLong("id"))) {
            return result;
        }
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        QFilter filter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
        if (vouchersDaps != null && vouchersDaps.size() > 0) {
            vouchersDaps.forEach(v -> voucherIds.add(v.getLong("voucherid")));
            if (voucherIds.size() > 0) {
                QFilter covFilter = new QFilter("id", "in", voucherIds);
                covFilter.and(new QFilter("ischeck", "=", (Object)VCHECKED)).and(new QFilter("ispost", "=", (Object)"0"));
                DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{covFilter});
                if (vouchers != null && vouchers.size() > 0) {
                    voucherIds.clear();
                    vouchers.forEach(v -> voucherIds.add(v.getLong("id")));
                    String type = ((DynamicObject)vouchers.get(0)).getString("sourcebilltype");
                    result = VoucherCheckHepler.operateCheck(voucherIds, type, sourceBillId, "voucheruncheck");
                }
            }
        }
        return result;
    }

    private static boolean operateCheck(List<Long> voucherIds, String sourceBillType, Long sourceBillId, String operKey) {
        boolean result = false;
        if (voucherIds.size() == 1) {
            QFilter filter = new QFilter("voucherid", "=", (Object)voucherIds.get(0));
            DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
            if (vouchersDaps != null) {
                if (vouchersDaps.size() == 1) {
                    result = VoucherCheckHepler.getOpResult(voucherIds, operKey);
                } else if (vouchersDaps.size() > 1) {
                    if (!"voucheruncheck".equals(operKey)) {
                        ArrayList sourceIds = new ArrayList();
                        vouchersDaps.forEach(s -> {
                            Long sId = s.getLong("sourcebillid");
                            if (!sourceBillId.equals(sId)) {
                                sourceIds.add(sId);
                            }
                        });
                        if (sourceIds.size() > 0) {
                            QFilter sFilter = new QFilter("id", "in", (Object)sourceIds.toArray());
                            DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,billstatus", (QFilter[])new QFilter[]{sFilter});
                            for (DynamicObject sourceBill : sourceBills) {
                                if (VoucherCheckHepler.getStatus(sourceBillType).equals(sourceBill.getString("billstatus"))) continue;
                                result = true;
                            }
                        }
                    }
                    if (!result) {
                        result = VoucherCheckHepler.getOpResult(voucherIds, operKey);
                    }
                }
            }
        } else {
            QFilter filter = new QFilter("voucherid", "in", voucherIds);
            DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
            if (vouchersDaps != null) {
                ArrayList sourceIds = new ArrayList();
                vouchersDaps.forEach(v -> {
                    if (!sourceBillId.equals(v.getLong("sourcebillid"))) {
                        sourceIds.add(v.getLong("sourcebillid"));
                    }
                });
                if (sourceIds.size() > 0 && !"voucheruncheck".equals(operKey)) {
                    QFilter sFilter = new QFilter("fid", "in", (Object)sourceIds.toArray());
                    DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)sourceBillType, (String)"id,billstatus", (QFilter[])new QFilter[]{sFilter});
                    for (DynamicObject sourceBill : sourceBills) {
                        if (VoucherCheckHepler.getStatus(sourceBillType).equals(sourceBill.getString("billstatus"))) continue;
                        result = true;
                    }
                    if (result) {
                        return result;
                    }
                } else {
                    result = VoucherCheckHepler.getOpResult(voucherIds, operKey);
                }
            }
        }
        return result;
    }

    private static boolean getOpResult(List<Long> voucherIds, String operKey) {
        OperateOption oper = OperateOption.create();
        oper.setVariableValue("invokingApp", "cas");
        OperationResult result = OperateServiceHelper.executeOperate((String)operKey, (String)"gl_voucher", (Object[])voucherIds.toArray(), (OperateOption)oper);
        if (result != null) {
            return result.isSuccess();
        }
        return false;
    }

    private static boolean isCashBank(DynamicObject voucher) {
        DynamicObjectCollection ves = voucher.getDynamicObjectCollection("entries");
        boolean isCashBank = false;
        for (DynamicObject ve : ves) {
            DynamicObject accInfo = ve.getDynamicObject("account");
            if (!VoucherCheckHepler.isCashAcct(accInfo)) continue;
            isCashBank = true;
            break;
        }
        return isCashBank;
    }

    public static boolean isCashAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        return acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent");
    }

    private static String getStatus(String type) {
        if ("cas_exchangebill".equals(type)) {
            return "F";
        }
        return "D";
    }
}

