/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.init;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasResetInitBalanceValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set selector = super.preparePropertys();
        selector.add("resetinitbalperiod");
        return selector;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject org = (DynamicObject)dataEntity.getValue("org");
            DynamicObject cashMgtInit = PeriodHelper.getCashMgtInit((Object)org.getPkValue());
            DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
            DynamicObject startPeriod = cashMgtInit.getDynamicObject("startperiod");
            DynamicObject resetPeriod = (DynamicObject)dataEntity.getValue("resetinitbalperiod");
            if (PeriodHelper.equal((DynamicObject)resetPeriod, (DynamicObject)startPeriod)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u91cd\u7f6e\u671f\u95f4\u4e3a\u51fa\u7eb3\u542f\u7528\u671f\u95f4\uff0c\u5982\u9700\u4fee\u6539\u521d\u59cb\u4f59\u989d\uff0c\u8bf7\u5230\u51fa\u7eb3\u521d\u59cb\u5316\u83dc\u5355\u53cd\u521d\u59cb\u5316\u4fee\u6539\u3002", (String)"CasResetInitBalanceValidator_3", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (!PeriodHelper.equal((DynamicObject)resetPeriod, (DynamicObject)currentPeriod)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u91cd\u7f6e\u671f\u95f4\u662f\u5426\u6b63\u786e\uff0c\u5982\u9700\u7ee7\u7eed\u8bf7\u5148\u53cd\u7ed3\u8d26\u4f7f\u5f97\u5f53\u524d\u671f\u95f4\u4e0e\u91cd\u7f6e\u671f\u95f4\u76f8\u540c\uff0c\u6216\u8005\u9488\u5bf9\u6700\u65b0\u5f53\u524d\u671f\u95f4\u8fdb\u884c\u521d\u59cb\u4f59\u989d\u91cd\u7f6e\u3002", (String)"CasResetInitBalanceValidator_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            QFilter filterRecEdc = new QFilter("org", "=", org.getPkValue());
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod, startperiod", (QFilter[])new QFilter[]{filterRecEdc});
            this.validateInfo(dataEntity, dynamicObject, resetPeriod, org);
        }
    }

    private void validateInfo(ExtendedDataEntity dataEntity, DynamicObject dynamicObject, DynamicObject resetPeriod, DynamicObject org) {
        if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
            return;
        }
        DynamicObject recPeriod = dynamicObject.getDynamicObject("recperiod");
        if (!PeriodHelper.after((DynamicObject)resetPeriod, (DynamicObject)recPeriod) && !PeriodHelper.equal((DynamicObject)resetPeriod, (DynamicObject)recPeriod)) {
            return;
        }
        QFilter qFilterRec = new QFilter("org", "=", org.getPkValue()).and(new QFilter("initperiod", "=", resetPeriod.getPkValue())).and(new QFilter("isfinishinit", "=", (Object)true));
        DynamicObjectCollection recInitDynamic = QueryServiceHelper.query((String)"cas_rec_init", (String)"id", (QFilter[])new QFilter[]{qFilterRec}, null);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recInitDynamic)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91cd\u7f6e\u671f\u95f4\u5df2\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u5e76\u7ed3\u675f\u5bf9\u8d26\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u521d\u59cb\u4f59\u989d\u3002\u5982\u9700\u7ee7\u7eed\u8bf7\u5220\u9664\u5bf9\u8d26\u521d\u59cb\u5316\u8bb0\u5f55\u3002", (String)"CasResetInitBalanceValidator_2", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }
}

