/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.business.journal.BankJournalDownloadBuilder;
import kd.fi.cas.business.journal.IBankJournalDownload;
import kd.fi.cas.business.journal.JournalRelationBuilder;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public abstract class AbstractBankJournalDownload
implements IBankJournalDownload {
    private static final Log logger = LogFactory.getLog(AbstractBankJournalDownload.class);
    private Map<Long, List<DynamicObject>> periodCache = new HashMap<Long, List<DynamicObject>>();

    protected void saveAndWriteBack(DynamicObject[] bankJournals, List<Object> resultIds) throws Exception {
        if (bankJournals.length <= 0) {
            return;
        }
        JournalRelationBuilder journalRelationBuilder = new JournalRelationBuilder();
        try (TXHandle tx = TX.requiresNew();){
            try {
                Object[] result = SaveServiceHelper.save((DynamicObject[])bankJournals);
                BalanceModelLogHelper.doBalanceModelLog(bankJournals, OperateType.ADD);
                try (TXHandle tmcTx = TX.requiresNew();){
                    LinkedList<Object[]> transIds = new LinkedList<Object[]>();
                    for (DynamicObject journal : bankJournals) {
                        transIds.add(new Object[]{journal.getLong("sourcebillid")});
                        journalRelationBuilder.addRelation(journal);
                    }
                    String sql = "update t_bei_transdetail set fisdownbankjournal=1 where fid = ?";
                    DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, transIds);
                    try (TXHandle rTx = TX.requiresNew();){
                        journalRelationBuilder.save();
                    }
                    catch (Exception e1) {
                        tmcTx.markRollback();
                        throw e1;
                    }
                }
                for (int j = 0; j < result.length; ++j) {
                    DynamicObject obj = (DynamicObject)result[j];
                    resultIds.add(obj.getLong("id"));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    protected DynamicObject convert2BankJournal(Row data, MainEntityType entityType, Map<String, DynamicObject> casInitMap, Date beginDate, String batchNoTime) {
        Long orgId = data.getLong("company");
        Date bizDate = data.getDate("bizdate");
        Long account = data.getLong("accountbank");
        Long currency = data.getLong("currency");
        if (orgId == null || bizDate == null) {
            return null;
        }
        if (!this.checkSaveInfo(orgId, account, currency, bizDate)) {
            return null;
        }
        DynamicObject period = this.getPeriod(orgId, bizDate);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"BankStatementDownloadService_0", (String)"fi-cas-business", (Object[])new Object[0]), data.get("bizdate")));
        }
        DynamicObject bankJournal = new BankJournalDownloadBuilder(entityType, data).setOrganizationInfo().setAmount().setDate().setPeriod(period).setAccount().setBillInfo().setBasicInfo(batchNoTime).build();
        return bankJournal;
    }

    private boolean checkSaveInfo(Long orgId, Long account, Long currency, Date bookDate) {
        DynamicObject balanceAdust;
        Date currentPeriodBegin = null;
        if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
            logger.info("The cas_cashmgtinit is no data");
            return false;
        }
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
        DynamicObject currentperiod = systemStatusCtrol.getDynamicObject("currentperiod");
        currentPeriodBegin = currentperiod != null ? currentperiod.getDate("begindate") : systemStatusCtrol.getDate("startperiod.begindate");
        Date balanceDate = null;
        boolean parameterBoolean = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs095");
        if (!parameterBoolean && (balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust((Long)orgId, (Long)account, (Long)currency)) != null && (BillStatusEnum.AUDIT.getValue().equals(balanceAdust.getString("billstatus")) || BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus")))) {
            balanceDate = balanceAdust.getDate("bizdate");
        }
        if (bookDate.compareTo(currentPeriodBegin) < 0) {
            logger.info("Accounting date less than the first data of cashier begin!");
            return false;
        }
        if (balanceDate != null && balanceDate.compareTo(bookDate) > 0) {
            logger.info("Business data more than account date!");
            return false;
        }
        return true;
    }

    private DynamicObject getPeriod(Long orgId, Date bizDate) {
        List<DynamicObject> periodList = this.periodCache.get(orgId);
        if (periodList != null) {
            for (DynamicObject period : periodList) {
                if (period == null) continue;
                Date beginDate = period.getDate("begindate");
                Date endDate = period.getDate("enddate");
                if (bizDate.compareTo(beginDate) < 0 || bizDate.compareTo(endDate) > 0) continue;
                return period;
            }
        }
        DynamicObject period = PeriodHelper.getPeriodByDate((long)orgId, (Date)bizDate);
        if (periodList == null) {
            periodList = new ArrayList<DynamicObject>();
            this.periodCache.put(orgId, new ArrayList());
        }
        if (period != null) {
            periodList.add(period);
        }
        return period;
    }
}

