/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.helper.QuotationHelper;

public class AgentPayBookJournalBuilder
extends AbstractBookJournalBuilder {
    private static final Log logger = LogFactory.getLog(AgentPayBookJournalBuilder.class);

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObject billObject) {
        ArrayList<JournalInfo> journalInfos = new ArrayList<JournalInfo>();
        DynamicObject basecurrency = billObject.getDynamicObject("basecurrency");
        int round = basecurrency.getInt("amtprecision");
        DynamicObjectCollection entrys = billObject.getDynamicObjectCollection("entry");
        ArrayList<JournalEntryInfo> journalEntryInfos = new ArrayList<JournalEntryInfo>();
        for (DynamicObject entry : entrys) {
            logger.info(String.format("=====\u4ee3\u53d1\u5355\u767b\u65e5\u8bb0\u8d26\u72b6\u6001:ISSUCCESS %s", entry.getBoolean("e_issuccess") || entry.getBoolean("e_isrefund")));
            if (!entry.getBoolean("e_issuccess") && !entry.getBoolean("e_isrefund")) continue;
            JournalEntryInfo journalEntry = new JournalEntryInfo();
            journalEntry.setOppUnit(entry.getString("payeename"));
            journalEntry.setAmount(entry.getBigDecimal("e_amount"));
            journalEntry.setLocalAmount(entry.getBigDecimal("e_localamt"));
            if (billObject.getBoolean("isdiffcur")) {
                journalEntry.setAmount(entry.getBigDecimal("e_dpamt"));
                journalEntry.setLocalAmount(entry.getBigDecimal("e_dplocalamt"));
            }
            journalEntry.setFundFlowItem(entry.getDynamicObject("e_fundflowitem"));
            journalEntryInfos.add(journalEntry);
            logger.info("entry_actPayAmount:" + entry.getBigDecimal("e_amount"));
            if (billObject.getBoolean("isagencypersonpay")) continue;
            ArrayList<JournalEntryInfo> entryList = new ArrayList<JournalEntryInfo>();
            entryList.add(journalEntry);
            JournalInfo journal = new JournalInfo();
            this.setBaseValue(journal, billObject);
            journal.setEntry(entryList);
            journal.setLocalAmount(entry.getBigDecimal("e_localamt"));
            journal.setCreditAmount(entry.getBigDecimal("e_amount"));
            journal.setBankCheckFlag(entry.getString("e_bankcheckflag"));
            journal.setBatchNo(entry.getString("e_bankcheckflag"));
            journal.setOppUnit(entry.getString("payeename"));
            journal.setOppBank(entry.getString("payeebankname"));
            journal.setOppAcctNumber(entry.getString("payeeacctbank"));
            journal.setSourceBillEntryId(entry.getLong("id"));
            journal.setIsencryption(billObject.getBoolean("isencryption"));
            if (billObject.getBoolean("isdiffcur")) {
                journal.setExchangeRate(billObject.getBigDecimal("dpexchangerate"));
                journal.setCurrency(billObject.getDynamicObject("dpcurrency"));
                journal.setCreditAmount(entry.getBigDecimal("e_dpamt"));
                journal.setLocalAmount(entry.getBigDecimal("e_dplocalamt"));
            }
            if (journal.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) {
                journalInfos.add(journal);
                continue;
            }
            logger.info("journal.getCreditAmount():" + journal.getCreditAmount());
        }
        logger.info("ISAGENCYPERSONPAY:" + billObject.getBoolean("isagencypersonpay"));
        if (billObject.getBoolean("isagencypersonpay")) {
            JournalInfo journal = new JournalInfo();
            this.setBaseValue(journal, billObject);
            BigDecimal actPayAmount = billObject.getBigDecimal("actpayamount");
            journal.setEntry(journalEntryInfos);
            BigDecimal exchangerate = billObject.getBigDecimal("exchangerate");
            String quotation = billObject.getString("payquotation");
            journal.setLocalAmount(QuotationHelper.callToCurrency((BigDecimal)actPayAmount, (BigDecimal)exchangerate, (String)quotation, (int)round));
            journal.setCreditAmount(actPayAmount);
            journal.setIsencryption(billObject.getBoolean("isencryption"));
            if (billObject.getBoolean("isdiffcur")) {
                actPayAmount = billObject.getBigDecimal("dpamt");
                BigDecimal dpexchangerate = billObject.getBigDecimal("dpexchangerate");
                journal.setExchangeRate(dpexchangerate);
                journal.setCurrency(billObject.getDynamicObject("dpcurrency"));
                journal.setCreditAmount(actPayAmount);
                journal.setLocalAmount(billObject.getBigDecimal("dplocalamt"));
            }
            if (journal.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) {
                journalInfos.add(journal);
            } else {
                logger.info("journal.getCreditAmount():" + journal.getCreditAmount());
            }
        }
        this.getBankJournalFee(journalInfos, billObject);
        return journalInfos;
    }

    private void getBankJournalFee(List<JournalInfo> list, DynamicObject billObject) {
        String feePayer = billObject.getString("feepayer");
        if (billObject == null || billObject.getBigDecimal("fee").compareTo(BigDecimal.ZERO) == 0 || billObject.getDynamicObject("feeactbank") == null || billObject.getDynamicObject("feecurrency") == null || !FeePayerEnum.PAY.getValue().equals(feePayer) && !FeePayerEnum.BOTH.getValue().equals(feePayer)) {
            return;
        }
        JournalInfo journal = new JournalInfo();
        journal.setAccountBank(billObject.getDynamicObject("feeactbank"));
        this.setBaseValue(journal, billObject);
        if (billObject.getBoolean("isdiffcur")) {
            journal.setExchangeRate(billObject.getBigDecimal("dpexchangerate"));
        }
        journal.setCurrency(billObject.getDynamicObject("feecurrency"));
        journal.setLocalAmount(billObject.getBigDecimal("fee").multiply(journal.getExchangeRate()));
        journal.setCreditAmount(billObject.getBigDecimal("fee"));
        journal.setDebitAmount(BigDecimal.ZERO);
        ArrayList<JournalEntryInfo> journalEntryInfos = new ArrayList<JournalEntryInfo>();
        JournalEntryInfo journalEntry = new JournalEntryInfo();
        journalEntry.setAmount(billObject.getBigDecimal("fee"));
        journalEntry.setLocalAmount(billObject.getBigDecimal("fee").multiply(journal.getExchangeRate()));
        journalEntryInfos.add(journalEntry);
        journal.setEntry(journalEntryInfos);
        list.add(journal);
    }

    public void setBaseValue(JournalInfo journal, DynamicObject billObject) {
        Date bizDate = billObject.getDate("bizdate");
        journal.setBizDate(bizDate);
        journal.setOrg(billObject.getDynamicObject("org"));
        journal.setDescription(billObject.getString("description"));
        journal.setCurrency(billObject.getDynamicObject("currency"));
        journal.setAccountBank(billObject.getDynamicObject("payeracctbank"));
        journal.setAccountCash(billObject.getDynamicObject("accountcash"));
        BigDecimal rate = billObject.getBigDecimal("exchangerate");
        if (rate.compareTo(BigDecimal.ZERO) == 0) {
            rate = BigDecimal.ONE;
        }
        journal.setExchangeRate(rate);
        journal.setSourceBillType("cas_agentpaybill");
        journal.setSource(2);
        journal.setDebitAmount(BigDecimal.ZERO);
        journal.setSourceBillNumber(billObject.getString("billno"));
        journal.setBillno(billObject.getString("billno"));
        journal.setSourceBillId(billObject.getLong("id"));
        journal.setSettlementType(billObject.getDynamicObject("settletype"));
        journal.setSettlementNumber(billObject.getString("settletnumber"));
        journal.setDirection(2);
        String userId = RequestContext.get().getUserId();
        DynamicObject user = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_user"), (Object)userId);
        journal.setCashier(user);
        journal.setBankCheckFlag(billObject.getString("bankcheckflag_tag"));
        journal.setBatchNo(billObject.getString("bankcheckflag_tag"));
        journal.setPayDate(billObject.getDate("paytime"));
        journal.setPaychannel(billObject.getString("paymentchannel"));
        journal.setTraceDate(billObject.getDate("acttradedate"));
        journal.setPd(billObject.getDate("paytime"));
        journal.setPreparationdate(billObject.getDate("createtime"));
        journal.setRpBaseType("cas_paymentbilltype");
        journal.setRpType(billObject.getDynamicObject("paymenttype"));
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObjectCollection billColl) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
        if (billColl == null || billColl.size() == 0) {
            return null;
        }
        HashMap<Long, List<JournalInfo>> returns = new HashMap<Long, List<JournalInfo>>(billColl.size());
        billColl.forEach(e -> returns.put(e.getLong("id"), this.getJournalInfoList((DynamicObject)e)));
        return returns;
    }
}

