/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.business.journal.book.jourrnalbook.check.bill.BookCheckCashVerification;

public class CashVerificationBookJournalBuilder
extends AbstractBookJournalBuilder {
    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObjectCollection exchangeBillColl) {
        return null;
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObject exchangeBill) {
        return null;
    }

    @Override
    public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColls, Map<Long, Exception> errorResult) {
        HashMap<Long, List<JournalInfo>> returns = new HashMap<Long, List<JournalInfo>>(billColls.size());
        for (DynamicObject billColl : billColls) {
            ArrayList<JournalInfo> journalInfoList = new ArrayList<JournalInfo>();
            if (BookCheckCashVerification.getInstance().notZeroAmount(billColl.getBigDecimal("inventorysurplus"))) {
                journalInfoList.add(this.bookJournal(billColl, true));
            }
            if (BookCheckCashVerification.getInstance().notZeroAmount(billColl.getBigDecimal("inventorydeficit"))) {
                journalInfoList.add(this.bookJournal(billColl, false));
            }
            returns.put(billColl.getLong("id"), journalInfoList);
        }
        return returns;
    }

    private JournalInfo bookJournal(DynamicObject billColl, boolean isPanyin) {
        JournalInfo journalInfo = this.createBaseJournal(billColl);
        String amountField = isPanyin ? "inventorysurplus" : "inventorydeficit";
        BigDecimal amount = billColl.getBigDecimal(amountField);
        DynamicObject account = billColl.getDynamicObject("cashaccount");
        journalInfo.setCurrency(billColl.getDynamicObject("currency"));
        journalInfo.setAccountCash(account);
        journalInfo.setDebitAmount(isPanyin ? amount : BigDecimal.ZERO);
        journalInfo.setCreditAmount(isPanyin ? BigDecimal.ZERO : amount);
        journalInfo.setDirection(isPanyin ? 1 : 2);
        return journalInfo;
    }

    private JournalInfo createBaseJournal(DynamicObject billColl) {
        JournalInfo journalBaseInfo = new JournalInfo();
        journalBaseInfo.setSource(2);
        journalBaseInfo.setSourceBillId(billColl.getLong("id"));
        journalBaseInfo.setSourceBillNumber(billColl.getString("billno"));
        journalBaseInfo.setBillno(billColl.getString("billno"));
        journalBaseInfo.setSourceBillType(billColl.getDataEntityType().getName());
        journalBaseInfo.setBizDate(billColl.getDate("checkdate"));
        journalBaseInfo.setOrg(billColl.getDynamicObject("org"));
        journalBaseInfo.setCashier(billColl.getDynamicObject("cashier"));
        journalBaseInfo.setPreparationdate(billColl.getDate("createtime"));
        journalBaseInfo.setEntry(new ArrayList<JournalEntryInfo>());
        return journalBaseInfo;
    }
}

