/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.JournalErrorCode;
import kd.fi.cas.business.journal.JournalRelationBuilder;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.errorcode.KDBatchDealDBException;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class JournalBookImpl
extends AbstractOpService {
    private static Log logger = LogFactory.getLog(JournalBookImpl.class);
    private JournalRelationBuilder journalRelationBuilder;

    public JournalBookImpl() {
        this(new JournalRelationBuilder());
    }

    public JournalBookImpl(JournalRelationBuilder journalRelationBuilder) {
        this.journalRelationBuilder = journalRelationBuilder;
    }

    @Override
    public List<String> getSelector() {
        return new ArrayList<String>();
    }

    public void validate(Map<Long, List<DynamicObject>> journalListMap, Map<Long, Exception> result) {
        logger.info("validate perform data start");
        long startTimeTobook = System.currentTimeMillis();
        logger.info("JournalBookImpl\u5f00\u59cbvalidate\u65f6\u95f4" + startTimeTobook);
        ArrayList journalList = new ArrayList();
        for (Map.Entry<Long, List<DynamicObject>> vouvherId : journalListMap.entrySet()) {
            journalList.addAll(vouvherId.getValue());
        }
        Set orgids = journalList.stream().map(e -> DynamicObjectHelper.getPk((DynamicObject)e, (String)"org")).collect(Collectors.toSet());
        long startTime1 = System.currentTimeMillis();
        logger.info("validate getSystemParamsByOrgIds  start:" + startTime1);
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgids));
        logger.info("validate getSystemParamsByOrgIds  end:" + (System.currentTimeMillis() - startTime1));
        HashSet<Long> orgidsOfBalance = new HashSet<Long>();
        HashSet<Long> setOfBankOrgIds = new HashSet<Long>();
        HashSet<Long> setOfBankAccIds = new HashSet<Long>();
        HashSet<Long> setOfBankAccIdsForBala = new HashSet<Long>();
        HashSet<Long> setOfBankCurrIds = new HashSet<Long>();
        HashSet<Long> setOfCashAccIds = new HashSet<Long>();
        HashMap accBankIdAndOrgIdMap = new HashMap();
        for (DynamicObject journal : journalList) {
            String entityName = journal.getDynamicObjectType().getName();
            long orgId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"org");
            if ("cas_bankjournal".equals(entityName)) {
                Object value;
                Boolean parameterBooleans;
                setOfBankOrgIds.add(orgId);
                Long accountBankId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"accountbank");
                Long currencyBankId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"currency");
                if (CasHelper.isEmpty((Object)accountBankId)) continue;
                setOfBankAccIds.add(accountBankId);
                if (!CasHelper.isEmpty((Object)currencyBankId) && null != journal.getDate("bookdate") && !(parameterBooleans = this.getBooleanOfSysPara(value = ((Map)systemParamsMap.get(String.valueOf(orgId))).get("cs095"))).booleanValue()) {
                    orgidsOfBalance.add(orgId);
                    setOfBankCurrIds.add(currencyBankId);
                    setOfBankAccIdsForBala.add(accountBankId);
                }
                if (accBankIdAndOrgIdMap.containsKey(accountBankId)) {
                    ((Set)accBankIdAndOrgIdMap.get(accountBankId)).add(orgId);
                    continue;
                }
                HashSet<Long> longSet = new HashSet<Long>();
                longSet.add(orgId);
                accBankIdAndOrgIdMap.put(accountBankId, longSet);
                continue;
            }
            Long accountCashId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"accountcash");
            setOfCashAccIds.add(accountCashId);
        }
        Map balanceResultMap = BalanceAdjustHelper.getLastBalanceAdjust(orgidsOfBalance, setOfBankAccIdsForBala, setOfBankCurrIds);
        Map bankResultMap = AccountBankHelper.isEntrustCanUseAccounts(setOfBankOrgIds, setOfBankAccIds, accBankIdAndOrgIdMap);
        Set virtualBankIds = AccountBankHelper.getVirtualBankIds(setOfBankAccIds);
        Set<Long> cashResultMap = this.getBankAndCashResult(setOfCashAccIds);
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgids);
        Map<Object, DynamicObject> periodsMap = this.getAdjustperiodData(orgInitMap);
        Map initEnableBatch = SystemStatusCtrolHelper.isInitEnable(orgInitMap.keySet().stream().map(o -> Long.valueOf(o)).collect(Collectors.toSet()));
        long startTime2 = System.currentTimeMillis();
        logger.info("validate perform data end" + (startTime2 - startTimeTobook));
        for (Map.Entry<Long, List<DynamicObject>> voucherId : journalListMap.entrySet()) {
            List<DynamicObject> journalListNew = voucherId.getValue();
            HashSet<String> removeJournals = new HashSet<String>(journalListNew.size());
            try {
                for (DynamicObject journal : journalListNew) {
                    DynamicObject currentPeriod;
                    Date bizDate;
                    int CS104;
                    boolean isFinishInit;
                    long orgId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"org");
                    String orgIdStr = String.valueOf(orgId);
                    DynamicObject orgInit = (DynamicObject)orgInitMap.get(orgIdStr);
                    Boolean initEnable = (Boolean)initEnableBatch.get(orgId);
                    boolean bl = isFinishInit = EmptyUtil.isNoEmpty((DynamicObject)orgInit) && initEnable != null && initEnable != false;
                    if (!isFinishInit) {
                        throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((long)orgId));
                    }
                    String entityName = journal.getDynamicObjectType().getName();
                    if ("cas_bankjournal".equals(entityName)) {
                        Long accountBankId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"accountbank");
                        if (!CasHelper.isEmpty((Object)accountBankId)) {
                            String keyStr = accountBankId + "_" + orgIdStr;
                            boolean isEntrustCanUse = bankResultMap.containsKey(keyStr);
                            if (!isEntrustCanUse) {
                                throw new KDBizException(new CasErrorCode().ORG_NOT_ACCTAUTH(), new Object[0]);
                            }
                            if (virtualBankIds.contains(accountBankId)) {
                                logger.info("\u865a\u62df\u8d26\u6237\u4e0d\u767b\u65e5\u8bb0\u8d26:orgId:{},accountId:{}", (Object)orgId, (Object)accountBankId);
                                removeJournals.add(keyStr);
                            }
                        }
                    } else {
                        Long accountCashId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"accountcash");
                        boolean closestatus = cashResultMap.contains(accountCashId);
                        if (closestatus) {
                            throw new KDBizException(new CasErrorCode().ACCT_IS_CLOSE(), new Object[0]);
                        }
                    }
                    Object dataInt = ((Map)systemParamsMap.get(orgIdStr)).get("cs104");
                    int n = CS104 = null == dataInt ? 0 : Integer.parseInt(dataInt.toString());
                    if (CS104 == 2 && (bizDate = DateUtils.truncateDate((Date)journal.getDate("bizDate"))).compareTo(journal.getDate("bookDate")) > 0) {
                        throw new KDBizException(new JournalErrorCode().BIZDATE_LARGETHAN_SYSDATE(), new Object[0]);
                    }
                    if (journal.get("period") == null) {
                        throw new KDBizException(new JournalErrorCode().BEYONDPERIOD_CANNOT_BOOK(), new Object[0]);
                    }
                    DynamicObject currentPeriod2 = orgInit.getDynamicObject("currentperiod");
                    if (currentPeriod2 == null) {
                        currentPeriod2 = orgInit.getDynamicObject("startperiod");
                    }
                    if ((currentPeriod = periodsMap.get(currentPeriod2.getPkValue())).getBoolean("isadjustperiod")) {
                        throw new KDBizException(new JournalErrorCode().ADJUSTPERIOD_CANNOT_BOOK(), new Object[0]);
                    }
                    Object value = ((Map)systemParamsMap.get(orgIdStr)).get("cs095");
                    Boolean parameterBooleans = this.getBooleanOfSysPara(value);
                    String errorMsg = AccountBankHelper.checkBalanceAdjust((DynamicObject)journal, (boolean)true, (boolean)parameterBooleans, (Map)balanceResultMap);
                    if (CasHelper.isEmpty((Object)errorMsg)) continue;
                    throw new KDBizException(errorMsg);
                }
                if (removeJournals.size() <= 0) continue;
                logger.info("\u5220\u9664\u865a\u62df\u94f6\u884c\u8d26\u6237\u7684\u6570\u636e......");
                journalListNew.removeIf(o -> removeJournals.contains(DynamicObjectHelper.getPk((DynamicObject)o, (String)"accountbank") + "_" + DynamicObjectHelper.getPk((DynamicObject)o, (String)"org")));
            }
            catch (Exception e2) {
                logger.error("Exception:", (Throwable)e2);
                result.put(voucherId.getKey(), e2);
            }
        }
        logger.info("validate process data is end" + (System.currentTimeMillis() - startTime2));
    }

    public void processOfBatch(Map<Long, Exception> errorResult, Map<Long, List<DynamicObject>> journalsMap) throws KDException {
        long startTimeTobook = System.currentTimeMillis();
        logger.info("processOfBatch start" + startTimeTobook);
        if (EmptyUtil.isEmpty(journalsMap)) {
            return;
        }
        JournalErrorCode journalErrorCode = new JournalErrorCode();
        DynamicObject[] journals = this.getJournalArr(journalsMap);
        HashSet<Long> errorVoucherIdSet = new HashSet<Long>();
        try (TXHandle tx = TX.required();){
            try {
                if (journals != null && journals.length > 0) {
                    HashSet<String> sourcebilltypeSet = new HashSet<String>(10);
                    HashSet<Long> sourcebillIdSet = new HashSet<Long>(10);
                    HashSet<Long> sourceBillEntryIds = new HashSet<Long>(10);
                    for (DynamicObject journal : journals) {
                        sourcebilltypeSet.add(journal.getString("sourcebilltype"));
                        sourcebillIdSet.add(journal.getLong("sourcebillid"));
                        sourceBillEntryIds.add(journal.getLong("sourcebillentryid"));
                    }
                    QFilter filter = new QFilter("sourcebilltype", "in", sourcebilltypeSet).and("sourcebillid", "in", sourcebillIdSet).and("sourcebillentryid", "in", sourceBillEntryIds);
                    DynamicObjectCollection existsResults = new DynamicObjectCollection();
                    long startTime1 = System.currentTimeMillis();
                    logger.info(" queryJournal  start:" + startTime1);
                    DynamicObjectCollection existsResultsOfCash = QueryServiceHelper.query((String)"cas_cashjournal", (String)"sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{filter});
                    DynamicObjectCollection existsResultsOfBank = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{filter});
                    logger.info(" queryJournal  end:" + (System.currentTimeMillis() - startTime1));
                    existsResults.addAll((Collection)existsResultsOfCash);
                    existsResults.addAll((Collection)existsResultsOfBank);
                    Map<String, List<DynamicObject>> existMap = existsResults.stream().collect(Collectors.groupingBy(e -> e.getString("sourcebilltype") + "_" + e.getLong("sourcebillid")));
                    logger.info("processOfBatch perform data end");
                    block15: for (Map.Entry<Long, List<DynamicObject>> voucherId : journalsMap.entrySet()) {
                        for (DynamicObject journal : voucherId.getValue()) {
                            String keyStr = journal.getString("sourcebilltype") + "_" + journal.getLong("sourcebillid");
                            if (existMap.containsKey(keyStr)) {
                                errorVoucherIdSet.add(voucherId.getKey());
                                errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(journalErrorCode.JOURNAL_NOT_RE(), new Object[0])));
                                logger.error("====JournalBookImpl:exist journal keyStr: {}, key:{}, info:{}", new Object[]{keyStr, voucherId.getKey(), journalErrorCode.JOURNAL_NOT_RE()});
                                continue block15;
                            }
                            if (journal.getPkValue() != null && !((Long)journal.getPkValue()).equals(0L)) continue;
                            long pk = DBServiceHelper.genGlobalLongId();
                            journal.set("id", (Object)pk);
                        }
                    }
                }
                this.deleteJournalByVoucherId(journalsMap, errorVoucherIdSet);
                long startTimeTobook3 = System.currentTimeMillis();
                logger.info("process judge end");
                this.setPropsByEntityBatch(errorResult, journalsMap, errorVoucherIdSet);
                this.deleteJournalByVoucherId(journalsMap, errorVoucherIdSet);
                long startTimeTobook4 = System.currentTimeMillis();
                logger.info("setPropsByEntityBatch cost:" + (startTimeTobook4 - startTimeTobook3));
                CasBankJournalHelper.updateBillValues(errorResult, journalsMap, errorVoucherIdSet);
                this.deleteJournalByVoucherId(journalsMap, errorVoucherIdSet);
                long startTimeTobook5 = System.currentTimeMillis();
                logger.info("updateBillValues cost:" + (startTimeTobook5 - startTimeTobook4));
                CasBankJournalHelper.updateBalances(errorResult, journalsMap, errorVoucherIdSet);
                this.deleteJournalByVoucherId(journalsMap, errorVoucherIdSet);
                long startTimeTobook6 = System.currentTimeMillis();
                logger.info("updateBalances cost:" + (startTimeTobook6 - startTimeTobook5));
                this.saveJournal(journalsMap);
                long startTimeTobook7 = System.currentTimeMillis();
                logger.info("saveJournal cost:" + (startTimeTobook7 - startTimeTobook6));
                for (Map.Entry<Long, List<DynamicObject>> voucherId : journalsMap.entrySet()) {
                    this.dealRelationData(errorResult, errorVoucherIdSet, voucherId);
                }
                try {
                    this.journalRelationBuilder.save();
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    throw new KDBatchDealDBException(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb\u6570\u636e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CasErrorCode_13", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                this.deleteJournalByVoucherId(journalsMap, errorVoucherIdSet);
                logger.info("addRelation cost:" + (System.currentTimeMillis() - startTimeTobook7));
            }
            catch (KDBatchDealDBException e3) {
                logger.error((Throwable)e3);
                tx.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u767b\u8d26\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7(traceId:%1$s)", (String)"JournalBookImpl_1", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
            }
            catch (Exception e4) {
                logger.error((Throwable)e4);
                tx.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u767b\u8d26\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7(traceId:%1$s)", (String)"JournalBookImpl_1", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
            }
        }
    }

    private void dealRelationData(Map<Long, Exception> errorResult, Set<Long> errorVoucherIdSet, Map.Entry<Long, List<DynamicObject>> voucherId) {
        try {
            for (DynamicObject journal : voucherId.getValue()) {
                this.journalRelationBuilder.addRelation(journal);
            }
        }
        catch (Exception e) {
            errorVoucherIdSet.add(voucherId.getKey());
            errorResult.put(voucherId.getKey(), e);
            logger.error("error:", (Throwable)e);
        }
    }

    @Override
    public void validate(DynamicObject journal) throws KDException {
        Date bizDate;
        int CS104;
        long orgId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"org");
        if (!SystemStatusCtrolHelper.isInitEnable((long)orgId)) {
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((long)orgId));
        }
        String entityName = journal.getDynamicObjectType().getName();
        if ("cas_bankjournal".equals(entityName)) {
            Long accountBankId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"accountbank");
            logger.info("validate ORG_NOT_ACCTAUTH accountBankId \uff1a" + accountBankId);
            if (!CasHelper.isEmpty((Object)accountBankId)) {
                logger.info("validate ORG_NOT_ACCTAUTH orgId \uff1a" + orgId);
                if (!AccountBankHelper.isEntrustCanUseAccount((long)orgId, (long)accountBankId)) {
                    throw new KDBizException(new CasErrorCode().ORG_NOT_ACCTAUTH(), new Object[0]);
                }
            }
        } else {
            Long accountCashId = DynamicObjectHelper.getPk((DynamicObject)journal, (String)"accountcash");
            DynamicObject accountCash = QueryServiceHelper.queryOne((String)"cas_accountcash", (String)"id,closestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountCashId)});
            if (accountCash != null && 0 != accountCash.getInt("closestatus")) {
                throw new KDBizException(new CasErrorCode().ACCT_IS_CLOSE(), new Object[0]);
            }
        }
        if ((CS104 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs104")) == 2 && (bizDate = DateUtils.truncateDate((Date)journal.getDate("bizDate"))).compareTo(journal.getDate("bookDate")) > 0) {
            throw new KDBizException(new JournalErrorCode().BIZDATE_LARGETHAN_SYSDATE(), new Object[0]);
        }
        if (journal.get("period") == null) {
            throw new KDBizException(new JournalErrorCode().BEYONDPERIOD_CANNOT_BOOK(), new Object[0]);
        }
        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)orgId);
        if ((currentPeriod = PeriodHelper.getPeriodById((long)currentPeriod.getLong("id"))).getBoolean("isadjustperiod")) {
            throw new KDBizException(new JournalErrorCode().ADJUSTPERIOD_CANNOT_BOOK(), new Object[0]);
        }
        String errorMsg = AccountBankHelper.checkBalanceAdjust((DynamicObject)journal, (boolean)true);
        if (!CasHelper.isEmpty((Object)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
        Object sourcebillentryid = journal.get("sourcebillentryid");
        QFilter filter = new QFilter("sourcebilltype", "=", journal.get("sourcebilltype"));
        filter.and("sourcebillid", "=", journal.get("sourcebillid"));
        if (EmptyUtil.isNoEmpty((Object)sourcebillentryid)) {
            filter.and("sourcebillentryid", "=", sourcebillentryid);
        }
        boolean exists = QueryServiceHelper.exists((String)journal.getDataEntityType().getName(), (QFilter[])new QFilter[]{filter});
        logger.info("filter\uff1a" + SerializationUtils.toJsonString((Object)filter));
        logger.info("exists\uff1f\uff1a" + exists);
        if (exists) {
            JournalErrorCode journalErrorCode = new JournalErrorCode();
            throw new KDBizException(journalErrorCode.JOURNAL_NOT_RE(), new Object[0]);
        }
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        this.journalRelationBuilder.addRelation(info);
        this.journalRelationBuilder.save();
    }

    @Override
    public void process(DynamicObject[] journals) throws KDException {
        if (EmptyUtil.isEmpty((Object[])journals)) {
            return;
        }
        super.process(journals);
        if (journals.length > 0) {
            for (DynamicObject journal : journals) {
                if (journal.getPkValue() != null && !journal.getPkValue().equals(0L)) continue;
                long pk = DBServiceHelper.genGlobalLongId();
                journal.set("id", (Object)pk);
            }
        }
        this.setPropsByEntity(journals);
        CasBankJournalHelper.updateBillValue((DynamicObject[])journals);
        CasBankJournalHelper.updateBalance((DynamicObject[])journals);
        if (journals != null && journals.length > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            Map<String, List<DynamicObject>> needSaves = Arrays.stream(journals).collect(Collectors.groupingBy(e -> e.getDataEntityType().getName()));
            for (Map.Entry<String, List<DynamicObject>> needSave : needSaves.entrySet()) {
                OperateServiceHelper.execOperate((String)"save", (String)needSave.getKey(), (DynamicObject[])needSave.getValue().toArray(new DynamicObject[0]), (OperateOption)option);
            }
        }
        for (DynamicObject journal : journals) {
            this.journalRelationBuilder.addRelation(journal);
        }
        this.journalRelationBuilder.save();
    }

    public void setPropsByEntity(DynamicObject[] journals) {
        for (DynamicObject journal : journals) {
            DynamicObject[] bills;
            Set props;
            String sourceBillType = journal.getString("sourcebilltype");
            if ("cas_paybill_synonym".equals(sourceBillType) || "cas_paybill_cash".equals(sourceBillType)) {
                sourceBillType = "cas_paybill";
            }
            if ((props = EntityPropertyHelper.getEntryFieldProp((String)journal.getDataEntityType().getName(), (String)sourceBillType)) == null || props.size() == 0 || CasHelper.isEmpty((DynamicObject[])(bills = BusinessDataServiceHelper.load((String)sourceBillType, (String)StringUtils.join((Object[])props.toArray(), (String)","), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)journal.getLong("sourcebillid"))})))) continue;
            DynamicObject bill = bills[0];
            props.forEach(prop -> journal.set(prop, bill.get(prop)));
        }
    }

    private Boolean getBooleanOfSysPara(Object value) {
        Boolean parameterBooleans = false;
        if (null != value) {
            parameterBooleans = value instanceof Boolean ? (Boolean)value : Boolean.valueOf("true".equals(value));
        }
        return parameterBooleans;
    }

    public Set<Long> getBankAndCashResult(Set<Long> setOfCashAccIds) {
        Set<Long> cashResultSet = new HashSet<Long>();
        if (null == setOfCashAccIds || setOfCashAccIds.size() == 0) {
            return cashResultSet;
        }
        QFilter qFilterOfClosestatus = new QFilter("closestatus", "!=", (Object)"0");
        QFilter qFilterOfId = new QFilter("id", "in", setOfCashAccIds);
        QFilter qFilterAll = qFilterOfClosestatus.and(qFilterOfId);
        Long startTime1 = System.currentTimeMillis();
        logger.info(" getBankAndCashResult  start:" + startTime1);
        DynamicObjectCollection accountCashs = QueryServiceHelper.query((String)"cas_accountcash", (String)"id,closestatus", (QFilter[])new QFilter[]{qFilterAll});
        logger.info(" getBankAndCashResult  end:" + (System.currentTimeMillis() - startTime1));
        cashResultSet = accountCashs.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return cashResultSet;
    }

    private Map<Object, DynamicObject> getAdjustperiodData(Map<String, DynamicObject> orgInitMap) {
        Set currentperiods = orgInitMap.values().stream().map(e -> e.getDynamicObject("currentperiod") == null ? e.getDynamicObject("startperiod").getLong("id") : e.getDynamicObject("currentperiod").getLong("id")).collect(Collectors.toSet());
        Long startTime1 = System.currentTimeMillis();
        logger.info(" getPeriodsByIds  start:" + startTime1);
        Map periodsMap = PeriodHelper.getPeriodsByIds(currentperiods, (Boolean)true);
        logger.info(" getPeriodsByIds  end:" + (System.currentTimeMillis() - startTime1));
        return periodsMap;
    }

    private void getBeiPayChannelMap(List<DynamicObject> journalList, Map<String, Set<Object>> sourceBillTypeMap) {
        Map sourceBillIdMap = journalList.stream().collect(Collectors.groupingBy(e -> e.getString("sourceBillType"), Collectors.mapping(o -> o.getLong("sourceBillId"), Collectors.toSet())));
        for (Map.Entry sourceBillType : sourceBillIdMap.entrySet()) {
            if ("cas_recbill".equals(sourceBillType.getKey())) continue;
            QFilter qFilter1 = new QFilter("id", "in", (Object)sourceBillType.getValue().toArray());
            QFilter qFilter2 = new QFilter("paymentchannel", "=", (Object)PaymentChannelEnum.BEI.getValue());
            QFilter qFilterAll = qFilter1.and(qFilter2);
            try {
                Map sourceBill = BusinessDataServiceHelper.loadFromCache((String)sourceBillType.getKey(), (String)"paymentchannel", (QFilter[])new QFilter[]{qFilterAll});
                if (null == sourceBill || sourceBill.size() <= 0) continue;
                sourceBillTypeMap.put(sourceBillType.getKey(), sourceBill.keySet());
            }
            catch (Exception e2) {
                logger.error(sourceBillType.getKey() + "\uff0c\uff1a\u65e0\u652f\u4ed8\u6e20\u9053\u5b57\u6bb5\uff0c\u4e0d\u8fdb\u884c\u5339\u914d\u5224\u65ad");
            }
        }
    }

    private DynamicObject[] getJournalArr(Map<Long, List<DynamicObject>> journalsMap) {
        ArrayList journalsList = new ArrayList(64);
        for (Map.Entry<Long, List<DynamicObject>> voucherId : journalsMap.entrySet()) {
            journalsList.addAll(voucherId.getValue());
        }
        DynamicObject[] journals = journalsList.toArray(new DynamicObject[0]);
        return journals;
    }

    private void deleteJournalByVoucherId(Map<Long, List<DynamicObject>> journalsMap, Set<Long> errorVoucherIdSet) {
        if (errorVoucherIdSet.size() > 0) {
            logger.info("\u5220\u9664\u65e5\u8bb0\u8d26\u524d\u7684\u51ed\u8bc1\u6570\uff1a" + journalsMap.size());
            journalsMap.keySet().removeIf(errorVoucherIdSet::contains);
            logger.info("\u5220\u9664\u5b8c\u65e5\u8bb0\u8d26\u8fd8\u5269\u4e0b\u7684\u51ed\u8bc1\u6570\uff1a" + journalsMap.size());
            errorVoucherIdSet.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPropsByEntityBatch(Map<Long, Exception> errorResult, Map<Long, List<DynamicObject>> journalsMap, Set<Long> errorVoucherIdSet) {
        ArrayList journalsListNew = new ArrayList();
        for (Map.Entry<Long, List<DynamicObject>> voucherId : journalsMap.entrySet()) {
            journalsListNew.addAll(voucherId.getValue());
        }
        HashMap sourceBillIdMap = new HashMap();
        HashMap<String, Set> sourceTypeAndPropsMap = new HashMap<String, Set>();
        HashMap<String, void> sourceTypeAndDataTypeMap = new HashMap<String, void>();
        for (DynamicObject dynamicObject : journalsListNew) {
            Set props;
            void var10_10;
            String string = dynamicObject.getString("sourceBillType");
            if ("cas_paybill_synonym".equals(string) || "cas_paybill_cash".equals(string)) {
                String string2 = "cas_paybill";
            }
            String dataEntityTypeName = dynamicObject.getDataEntityType().getName();
            String sourceTypeAndPropsKey = (String)var10_10 + "_" + dataEntityTypeName;
            if (sourceBillIdMap.containsKey(sourceTypeAndPropsKey)) {
                ((Set)sourceBillIdMap.get(sourceTypeAndPropsKey)).add(dynamicObject.getLong("sourceBillId"));
            } else {
                HashSet<Long> sourceBillIdSet = new HashSet<Long>();
                sourceBillIdSet.add(dynamicObject.getLong("sourceBillId"));
                sourceBillIdMap.put(sourceTypeAndPropsKey, sourceBillIdSet);
            }
            if (!sourceTypeAndDataTypeMap.containsKey(sourceTypeAndPropsKey)) {
                sourceTypeAndDataTypeMap.put(sourceTypeAndPropsKey, var10_10);
            }
            if (sourceTypeAndPropsMap.containsKey(sourceTypeAndPropsKey) || (props = EntityPropertyHelper.getEntryFieldProp((String)dataEntityTypeName, (String)var10_10)) == null || props.size() == 0) continue;
            sourceTypeAndPropsMap.put(sourceTypeAndPropsKey, props);
        }
        HashMap mapOfDataBase = new HashMap(10);
        for (Map.Entry entry : sourceTypeAndPropsMap.entrySet()) {
            String sourceBillType = (String)sourceTypeAndDataTypeMap.get(entry.getKey());
            Set props = (Set)entry.getValue();
            Set ids = (Set)sourceBillIdMap.get(entry.getKey());
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)sourceBillType, (String)StringUtils.join((Object[])props.toArray(), (String)","), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            Map<Long, DynamicObject> mapOfDataBasePart = Arrays.stream(bills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            mapOfDataBase.put(entry.getKey(), mapOfDataBasePart);
        }
        for (Map.Entry<Object, Object> entry : journalsMap.entrySet()) {
            try {
                for (DynamicObject journal : (List)entry.getValue()) {
                    DynamicObject bill;
                    boolean isContain;
                    Long sourcebillid = journal.getLong("sourcebillid");
                    String sourceBillType = journal.getString("sourcebilltype");
                    if ("cas_paybill_synonym".equals(sourceBillType) || "cas_paybill_cash".equals(sourceBillType)) {
                        sourceBillType = "cas_paybill";
                    }
                    String dataTypeName = journal.getDataEntityType().getName();
                    String keyStr = sourceBillType + "_" + dataTypeName;
                    Set props = (Set)sourceTypeAndPropsMap.get(keyStr);
                    if (props == null || props.size() == 0 || !(isContain = mapOfDataBase.containsKey(keyStr)) || null == (bill = (DynamicObject)((Map)mapOfDataBase.get(keyStr)).get(sourcebillid))) continue;
                    props.forEach(prop -> journal.set(prop, bill.get(prop)));
                }
            }
            catch (Exception e2) {
                errorVoucherIdSet.add((Long)entry.getKey());
                errorResult.put((Long)entry.getKey(), e2);
                logger.error("error:", (Throwable)e2);
            }
        }
    }

    private void saveJournal(Map<Long, List<DynamicObject>> journalsMap) {
        ArrayList journals = new ArrayList(64);
        for (Map.Entry<Long, List<DynamicObject>> voucherId : journalsMap.entrySet()) {
            journals.addAll(voucherId.getValue());
        }
        Map<String, List<DynamicObject>> dataTypeMap = journals.stream().collect(Collectors.groupingBy(e -> e.getDataEntityType().getName()));
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            for (Map.Entry<String, List<DynamicObject>> dataType : dataTypeMap.entrySet()) {
                OperationResult op = OperateServiceHelper.execOperate((String)"save", (String)dataType.getKey(), (DynamicObject[])dataType.getValue().toArray(new DynamicObject[0]), (OperateOption)option);
                if (null == op.getAllErrorInfo() || op.getAllErrorInfo().size() <= 0) continue;
                throw new KDBatchDealDBException(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CasErrorCode_12", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e2) {
            logger.error("Exception:", (Throwable)e2);
            throw new KDBatchDealDBException(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CasErrorCode_12", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }
}

