/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.cas.consts.CasBFRow;
import kd.fi.cas.helper.CasBotpHelper;

public class JournalRelationBuilder {
    private Map<String, List<CasBFRow>> relationCache = new HashMap<String, List<CasBFRow>>();
    private Map<String, Long> tableIdCache = new HashMap<String, Long>();

    public void addRelation(DynamicObject journal) {
        String sourceBillType = journal.getString("sourcebilltype");
        if ("cas_paybill_synonym".equals(sourceBillType) || "cas_paybill_cash".equals(sourceBillType)) {
            sourceBillType = "cas_paybill";
        }
        String journalType = journal.getDataEntityType().getName();
        Long sourceTableId = this.getTableId(sourceBillType);
        Long targetTableId = this.getTableId(journalType);
        List<CasBFRow> relationRows = this.relationCache.get(journalType);
        if (relationRows == null) {
            relationRows = new LinkedList<CasBFRow>();
            this.relationCache.put(journalType, relationRows);
        }
        Long sourcePk = journal.getLong("sourcebillid");
        Long journalPk = journal.getLong("id");
        long pk = DBServiceHelper.genGlobalLongId();
        CasBFRow row = new CasBFRow(Long.valueOf(pk), sourcePk, sourceTableId, targetTableId, journalPk);
        relationRows.add(row);
    }

    private Long getTableId(String entityKey) {
        if (!this.tableIdCache.containsKey(entityKey)) {
            this.tableIdCache.put(entityKey, CasBotpHelper.getTableIdByEntityKey((String)entityKey));
        }
        return this.tableIdCache.get(entityKey);
    }

    public void save() {
        this.relationCache.forEach((jouranlType, relationRows) -> CasBotpHelper.saveRelation((List)relationRows, (String)jouranlType));
    }
}

