/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import com.alibaba.fastjson.JSON;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.business.journal.BookJournalLogger;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalAntiBookImpl;
import kd.fi.cas.business.journal.JournalBookImpl;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.pojo.book.BookInfo;
import kd.fi.cas.util.EmptyUtil;

public class JournalServiceAdapter {
    private Map<Object, List<DynamicObject>> journalMap4Book = new HashMap<Object, List<DynamicObject>>();
    private Map<Long, List<DynamicObject>> journalMapBatchBook = new HashMap<Long, List<DynamicObject>>();
    private static final Log logger = LogFactory.getLog(JournalServiceAdapter.class);
    protected boolean isConsistency = false;
    private Map<Long, Collection<Long>> journalMap4CancelBook = new HashMap<Long, Collection<Long>>();
    private String journalEntityName = "";

    public void validateBook(IBookJournalBuilder builder, DynamicObject bizBill) {
        JournalBookImpl journalBookImpl = new JournalBookImpl();
        List<DynamicObject> journalList = builder.getJournalList(bizBill);
        if (journalList == null || journalList.isEmpty()) {
            logger.info("journalList is null");
            return;
        }
        for (DynamicObject journal : journalList) {
            journalBookImpl.validate(journal);
        }
        this.journalMap4Book.put(bizBill, journalList);
    }

    public void validateBook(IBookJournalBuilder builder, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length == 0) {
            return;
        }
        DynamicObjectCollection bizBillsCols = new DynamicObjectCollection();
        bizBillsCols.addAll(Arrays.asList(bizBills));
        List<DynamicObject> journalList = builder.getJournalList(bizBillsCols);
        if (journalList == null || journalList.isEmpty()) {
            logger.info("journalList is null");
            return;
        }
        JournalBookImpl journalBookImpl = new JournalBookImpl();
        Map<Long, String> results = journalBookImpl.validate(journalList.toArray(new DynamicObject[0]));
        if (results != null && results.size() > 0) {
            throw new KDBizException(results.values().toString());
        }
        this.journalMap4Book.put(bizBills[0], journalList);
    }

    public Map<Long, List<DynamicObject>> validateBooks(IBookJournalBuilder builder, List<DynamicObject> bizBills, Map<Long, Exception> result) {
        JournalBookImpl journalBookImpl = new JournalBookImpl();
        long startTimeTobook = System.currentTimeMillis();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        dynamicObjectCollection.addAll(bizBills);
        Map<Long, List<DynamicObject>> journalList = builder.getJournalList(dynamicObjectCollection, result);
        logger.info("getJournalList cost time:" + (System.currentTimeMillis() - startTimeTobook));
        if (journalList == null || journalList.isEmpty()) {
            logger.info("validateBooks journalList is null");
            return journalList;
        }
        journalBookImpl.validate(journalList, result);
        this.journalMapBatchBook = journalList;
        return journalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void book(DynamicObject bizBill) {
        boolean book;
        String entityName = bizBill.getDynamicObjectType().getName();
        if (Arrays.asList("cas_paybill", "cas_recbill", "cas_agentpaybill").contains(entityName) && !(book = CasBankJournalHelper.bookByBizBillSettleType((DynamicObject)bizBill))) {
            return;
        }
        StringJoiner errorMsg = new StringJoiner(";");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        String billType = "booklock" + bizBill.getDynamicObjectType().getName();
        String billno = bizBill.getString("billno");
        String billId = bizBill.getPkValue().toString();
        try {
            logger.info("billno is:" + billno + " and billType is: " + billType + " and id is:" + billId);
            ArrayList<String> billids = new ArrayList<String>();
            billids.add(billId);
            Map lockResultMap = MutexServiceHelper.batchRequest(billids, (String)"fi-cas-business", (String)billType);
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                logger.info("requestFailIds:" + JSON.toJSONString(requestFailIds));
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), billno));
            } else {
                JournalBookImpl journalBookImpl = new JournalBookImpl();
                Collection journals = this.journalMap4Book.get(bizBill);
                if (journals != null) {
                    journalBookImpl.process(journals.toArray(new DynamicObject[0]));
                }
            }
        }
        catch (KDBizException e) {
            logger.error("KDBizException is:", (Throwable)e);
            errorMsg.add(e.getMessage());
        }
        catch (Exception e1) {
            logger.error("Exception is:", (Throwable)e1);
            errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u767b\u8d26\u5931\u8d25\u3002", (String)"ReceivErrorCode_30", (String)"fi-cas-business", (Object[])new Object[0]), billno));
        }
        finally {
            logger.info("release lock\uff1a{},unlock lock\uff1a{}", (Object)JSON.toJSONString(requestIds), (Object)JSON.toJSONString(requestFailIds));
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-business", (String)billType);
        }
        if (errorMsg.length() > 0) {
            logger.info("eror is:" + errorMsg);
            throw new KDBizException(errorMsg.toString());
        }
    }

    public void book(Map<Long, Exception> errorResult, Map<Long, List<DynamicObject>> journalList) {
        if (journalList != null) {
            JournalBookImpl journalBookImpl = new JournalBookImpl();
            journalBookImpl.processOfBatch(errorResult, journalList);
        }
    }

    public void bookBatch(Set<Long> ids) {
        HashMap<Long, Exception> errorResult = new HashMap<Long, Exception>();
        if (this.journalMapBatchBook != null) {
            JournalBookImpl journalBookImpl = new JournalBookImpl();
            HashMap<Long, List<DynamicObject>> tmpMap = new HashMap<Long, List<DynamicObject>>();
            tmpMap.putAll(this.journalMapBatchBook);
            tmpMap.keySet().retainAll(ids);
            journalBookImpl.processOfBatch(errorResult, tmpMap);
        }
    }

    public void validateCancelBooks(Map<Long, DynamicObject> voucherMapNew, Map<Long, Exception> errorResult, Map<Long, Boolean> nullVoucherMap, boolean needCheck) {
        long startTimeBBB = System.currentTimeMillis();
        logger.info("validateCancelBooks perform data start" + startTimeBBB);
        ArrayList<DynamicObject> bizBills = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, DynamicObject> voucherId : voucherMapNew.entrySet()) {
            bizBills.add(voucherId.getValue());
        }
        Map<String, Set<Long>> dataTyprMap = bizBills.stream().collect(Collectors.groupingBy(e -> e.getDataEntityType().getName(), Collectors.mapping(o -> o.getLong("id"), Collectors.toSet())));
        HashSet<Long> bankTargetBills = new HashSet<Long>();
        HashSet<Long> cashTargetBills = new HashSet<Long>();
        this.getBankAndCashBotpData(dataTyprMap, bankTargetBills, cashTargetBills);
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
        Map<String, Map<Long, List<DynamicObject>>> bankCashJournalsByBotpMap = this.getBankCashDataByBotp(bankTargetBills, cashTargetBills, journalSelectors);
        Map<Long, String> voucherAndJouridMap = bizBills.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("billno")));
        HashSet<Object> allOrgIds = new HashSet<Object>();
        HashSet<Long> orgidsOfBalance = new HashSet<Long>();
        Set<Object> setOfBankOrgIds = new HashSet();
        HashSet<Long> setOfBankAccIds = new HashSet<Long>();
        HashSet<Long> setOfBankCurrIds = new HashSet<Long>();
        QFilter qFilter = new QFilter("sourcebillid", "in", voucherAndJouridMap.keySet());
        DynamicObject[] bankJournalArr = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)journalSelectors, (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] cashJournalArr = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)journalSelectors, (QFilter[])new QFilter[]{qFilter});
        Set setOfCashOrgids = Arrays.stream(cashJournalArr).map(e -> e.getLong("org.id")).collect(Collectors.toSet());
        Set<Long> setOfCashAccIds = Arrays.stream(cashJournalArr).map(e -> e.getLong("accountcash.id")).collect(Collectors.toSet());
        allOrgIds.addAll(setOfCashOrgids);
        setOfBankOrgIds = Arrays.stream(bankJournalArr).map(e -> e.getLong("org.id")).collect(Collectors.toSet());
        allOrgIds.addAll(setOfBankOrgIds);
        if (allOrgIds.size() == 0) {
            return;
        }
        Map systemParamsMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(allOrgIds));
        Map<Long, List<DynamicObject>> bankJournalMap = Arrays.stream(bankJournalArr).collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
        Map<Long, List<DynamicObject>> cashJournalMap = Arrays.stream(cashJournalArr).collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
        HashSet<Long> setOfBankAccIdsForBala = new HashSet<Long>();
        HashMap accBankIdAndOrgIdMap = new HashMap();
        for (DynamicObject bankJournal : bankJournalArr) {
            Object value;
            Boolean parameterBooleans;
            long orgId = DynamicObjectHelper.getPk((DynamicObject)bankJournal, (String)"org");
            Long accountBankId = DynamicObjectHelper.getPk((DynamicObject)bankJournal, (String)"accountbank");
            Long currencyBankId = DynamicObjectHelper.getPk((DynamicObject)bankJournal, (String)"currency");
            if (CasHelper.isEmpty((Object)accountBankId)) continue;
            setOfBankAccIds.add(accountBankId);
            if (!CasHelper.isEmpty((Object)currencyBankId) && null != bankJournal.getDate("bookdate") && !(parameterBooleans = this.getBooleanOfSysPara(value = ((Map)systemParamsMap.get(String.valueOf(orgId))).get("cs095"))).booleanValue()) {
                orgidsOfBalance.add(orgId);
                setOfBankCurrIds.add(currencyBankId);
                setOfBankAccIdsForBala.add(accountBankId);
            }
            if (accBankIdAndOrgIdMap.containsKey(accountBankId)) {
                ((Set)accBankIdAndOrgIdMap.get(accountBankId)).add(orgId);
                continue;
            }
            HashSet<Long> longSet = new HashSet<Long>();
            longSet.add(orgId);
            accBankIdAndOrgIdMap.put(accountBankId, longSet);
        }
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(allOrgIds);
        Set currentperiods = orgInitMap.values().stream().map(e -> e.getDynamicObject("currentperiod") == null ? e.getDynamicObject("startperiod").getLong("id") : e.getDynamicObject("currentperiod").getLong("id")).collect(Collectors.toSet());
        Map periodsMap = PeriodHelper.getPeriodsByIds(currentperiods, (Boolean)false);
        Map balanceResultMap = BalanceAdjustHelper.getLastBalanceAdjust(orgidsOfBalance, setOfBankAccIdsForBala, setOfBankCurrIds);
        Map bankResultMap = AccountBankHelper.isEntrustCanUseAccounts(setOfBankOrgIds, setOfBankAccIds, accBankIdAndOrgIdMap);
        Set<Long> cashResultMap = this.getBankAndCashResult(setOfCashAccIds);
        long startTime2 = System.currentTimeMillis();
        logger.info("validateCancelBooks perform data nullVoucherMap" + SerializationUtils.toJsonString(nullVoucherMap));
        for (Map.Entry<Long, DynamicObject> voucherId : voucherMapNew.entrySet()) {
            DynamicObject bizBill = voucherId.getValue();
            try {
                String[] journalEntityKeys;
                Collection<Long> validatedJournals;
                long voucherPkId;
                boolean isNullVoucher = false;
                if (null != nullVoucherMap && nullVoucherMap.size() != 0 && nullVoucherMap.containsKey(voucherPkId = bizBill.getLong("id")) && null != nullVoucherMap.get(voucherPkId)) {
                    isNullVoucher = true;
                }
                logger.info("isNullVoucher is:" + isNullVoucher + ",bizBill id:" + bizBill.getLong("id"));
                if (!isNullVoucher) {
                    Date orgStartPeriodStartdate;
                    Date voucherEnddate;
                    DynamicObject orgInit = (DynamicObject)orgInitMap.get(bizBill.getDynamicObject("org").get("id").toString());
                    if (null == orgInit) {
                        String error = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002%s", (String)"JournalServiceAdapter_0", (String)"fi-cas-business", (Object[])new Object[0]), bizBill.getString("billno"));
                        BookJournalLogger.log(error);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error)));
                        continue;
                    }
                    DynamicObject startPeriod = orgInit.getDynamicObject("startperiod");
                    if (null == startPeriod || null == startPeriod.getDate("begindate")) {
                        String error = String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002%s", (String)"JournalServiceAdapter_0", (String)"fi-cas-business", (Object[])new Object[0]), bizBill.getString("billno"));
                        BookJournalLogger.log(error);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error)));
                        continue;
                    }
                    String formId = bizBill.getDynamicObjectType().getName();
                    if (!("cas_recbill".equals(formId) || "cas_paybill".equals(formId) || "cas_agentpaybill".equals(formId) || "cas_cash_verification".equals(formId) || !(voucherEnddate = bizBill.getDynamicObject("period").getDate("enddate")).before(orgStartPeriodStartdate = startPeriod.getDate("begindate")))) {
                        String error = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5728\u671f\u95f4\u6700\u540e\u4e00\u5929\u4e0d\u80fd\u65e9\u4e8e\u8d44\u91d1\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u7b2c\u4e00\u5929\uff01%s", (String)"JournalServiceAdapter_1", (String)"fi-cas-business", (Object[])new Object[0]), bizBill.getString("billno"));
                        BookJournalLogger.log(error);
                        if (!this.isConsistency) continue;
                        errorResult.put(voucherId.getKey(), (Exception)((Object)new KDBizException(error)));
                        continue;
                    }
                }
                if ((validatedJournals = this.journalMap4CancelBook.get(voucherId.getKey())) == null) {
                    validatedJournals = new HashSet<Long>();
                }
                for (String journalEntity : journalEntityKeys = new String[]{"cas_bankjournal", "cas_cashjournal"}) {
                    Map<Long, List<DynamicObject>> botpMap = bankCashJournalsByBotpMap.get(journalEntity);
                    if (null != botpMap && botpMap.containsKey(voucherId.getKey())) {
                        List<DynamicObject> journalsList = botpMap.get(voucherId.getKey());
                        for (DynamicObject dynamicObject : journalsList) {
                            journalAntiBookImpl.validates(periodsMap, orgInitMap, dynamicObject, bankResultMap, systemParamsMap, balanceResultMap, cashResultMap, needCheck);
                            validatedJournals.add((Long)dynamicObject.getPkValue());
                        }
                        this.journalMap4CancelBook.put((Long)bizBill.getPkValue(), validatedJournals);
                        this.journalEntityName = journalEntity;
                    }
                    List<Object> journalsListOfDatabase = new ArrayList();
                    journalsListOfDatabase = journalEntity.equalsIgnoreCase("cas_bankjournal") ? bankJournalMap.get(bizBill.getLong("id")) : cashJournalMap.get(bizBill.getLong("id"));
                    if (null == journalsListOfDatabase || journalsListOfDatabase.size() <= 0) continue;
                    for (DynamicObject dynamicObject : journalsListOfDatabase) {
                        if (validatedJournals.contains((Long)dynamicObject.getPkValue())) continue;
                        journalAntiBookImpl.validates(periodsMap, orgInitMap, dynamicObject, bankResultMap, systemParamsMap, balanceResultMap, cashResultMap, needCheck);
                        validatedJournals.add((Long)dynamicObject.getPkValue());
                    }
                    this.journalMap4CancelBook.put((Long)bizBill.getPkValue(), validatedJournals);
                    this.journalEntityName = journalEntity;
                }
            }
            catch (Exception e2) {
                logger.error("validateCancelBooks perform data exception:", (Throwable)e2);
                errorResult.put(voucherId.getKey(), e2);
            }
        }
        logger.info("validateCancelBooks process data end" + (System.currentTimeMillis() - startTime2));
    }

    public void validateCancelBook(DynamicObject bizBill) {
        Collection<Long> validatedJournals = this.journalMap4CancelBook.get((Long)bizBill.getPkValue());
        if (validatedJournals == null) {
            validatedJournals = new HashSet<Long>();
        }
        String entityName = bizBill.getDataEntityType().getName();
        String[] journalEntityKeys = new String[]{"cas_bankjournal", "cas_cashjournal"};
        Map targetMaps = CasBotpHelper.getTargetBillIdMap((String)entityName, Collections.singletonList(bizBill.getLong("id")), null, Arrays.stream(journalEntityKeys).collect(Collectors.toSet()), (boolean)true);
        Map targetBills = (Map)targetMaps.get(bizBill.getLong("id"));
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        String journalSelectors = String.join((CharSequence)",", journalAntiBookImpl.getSelector());
        for (String journalEntity : journalEntityKeys) {
            QFilter filter;
            DynamicObject[] journals;
            DynamicObject billType;
            Set journalPks = (Set)targetBills.get(journalEntity);
            if (journalPks != null) {
                DynamicObject[] journals2;
                for (DynamicObject journal : journals2 = BusinessDataServiceHelper.load((String)journalEntity, (String)journalSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)journalPks)})) {
                    journalAntiBookImpl.validate(journal);
                    validatedJournals.add((Long)journal.getPkValue());
                }
                this.journalMap4CancelBook.put((Long)bizBill.getPkValue(), validatedJournals);
                this.journalEntityName = journalEntity;
            }
            if ("cas_paybill".equals(entityName) && (billType = bizBill.getDynamicObject("billtype")) != null) {
                long type = billType.getLong("id");
                if (BillTypeConstants.PAYBILL_SYN.equals(type)) {
                    entityName = "cas_paybill_synonym";
                }
                if (BillTypeConstants.PAYBILL_CASH.equals(type)) {
                    entityName = "cas_paybill_cash";
                }
            }
            if ((journals = BusinessDataServiceHelper.load((String)journalEntity, (String)journalSelectors, (QFilter[])new QFilter[]{filter = new QFilter("sourcebilltype", "=", (Object)entityName).and("sourcebillid", "=", bizBill.getPkValue())})) == null || journals.length <= 0) continue;
            for (DynamicObject journal : journals) {
                if (validatedJournals.contains((Long)journal.getPkValue())) continue;
                journalAntiBookImpl.validate(journal);
                validatedJournals.add((Long)journal.getPkValue());
            }
            this.journalMap4CancelBook.put((Long)bizBill.getPkValue(), validatedJournals);
            this.journalEntityName = journalEntity;
        }
    }

    public void cancelBook(DynamicObject bizBill) {
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        Collection<Long> journalIds = this.journalMap4CancelBook.get((Long)bizBill.getPkValue());
        if (journalIds != null && journalIds.size() > 0) {
            DynamicObject[] journalBills = BusinessDataServiceHelper.load((Object[])journalIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.journalEntityName));
            if ("cas_bankjournal".equals(this.journalEntityName)) {
                journalBills = (DynamicObject[])Arrays.stream(journalBills).filter(s -> !s.getBoolean("ischeck")).toArray(DynamicObject[]::new);
            }
            journalAntiBookImpl.process(journalBills);
            if (journalBills == null || journalIds.size() > journalBills.length) {
                String journalType = "cas_bankjournal".equals(this.journalEntityName) ? "cas_cashjournal" : "cas_bankjournal";
                journalBills = BusinessDataServiceHelper.load((Object[])journalIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)journalType));
                if ("cas_bankjournal".equals(journalType)) {
                    journalBills = (DynamicObject[])Arrays.stream(journalBills).filter(s -> !s.getBoolean("ischeck")).toArray(DynamicObject[]::new);
                }
                journalAntiBookImpl.process(journalBills);
            }
        }
    }

    public boolean hasBooked(DynamicObject bizBill) {
        DynamicObject billType;
        String entityName = bizBill.getDataEntityType().getName();
        if ("cas_paybill".equals(entityName) && (billType = bizBill.getDynamicObject("billtype")) != null) {
            long type = billType.getLong("id");
            if (BillTypeConstants.PAYBILL_SYN.equals(type)) {
                entityName = "cas_paybill_synonym";
            }
            if (BillTypeConstants.PAYBILL_CASH.equals(type)) {
                entityName = "cas_paybill_cash";
            }
        }
        Long[] bizBillPks = new Long[]{(Long)bizBill.getPkValue()};
        return this.hasBooked(entityName, bizBillPks);
    }

    public boolean hasBooked(String entityKey, Long[] bizBillPks) {
        QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)entityKey);
        qFilter.and(new QFilter("sourcebillid", "in", (Object)bizBillPks));
        DynamicObject[] bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (bankJournals != null && bankJournals.length > 0) {
            return true;
        }
        DynamicObject[] cashJournals = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return cashJournals != null && cashJournals.length > 0;
    }

    public static DynamicObject getVoucherBook(Long voucherId, String errorType, String businessType, Exception error) {
        if (EmptyUtil.isEmpty((String)businessType)) {
            return null;
        }
        DynamicObject voucherBook = BusinessDataServiceHelper.newDynamicObject((String)"cas_voucherbook");
        voucherBook.set("sourcebillid", (Object)voucherId);
        voucherBook.set("errortype", (Object)errorType);
        voucherBook.set("businesstype", (Object)businessType);
        voucherBook.set("createtime", (Object)new Date());
        String errorMsg = error.getMessage();
        if (errorMsg != null && errorMsg.length() > 255) {
            errorMsg = errorMsg.substring(0, 255);
        }
        voucherBook.set("errormsg", (Object)errorMsg);
        voucherBook.set("errormsg_tag", (Object)JournalServiceAdapter.getStackTraceMessage(error));
        return voucherBook;
    }

    private static String getStackTraceMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.flush();
        return sw.toString();
    }

    private void getBankAndCashBotpData(Map<String, Set<Long>> dataTyprMap, HashSet<Long> bankTargetBills, HashSet<Long> cashTargetBills) {
        for (Map.Entry<String, Set<Long>> dataType : dataTyprMap.entrySet()) {
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)dataType.getKey(), (Long[])dataType.getValue().toArray(new Long[0]));
            if (targetBills.containsKey("cas_bankjournal")) {
                bankTargetBills.addAll((Collection)targetBills.get("cas_bankjournal"));
            }
            if (!targetBills.containsKey("cas_cashjournal")) continue;
            cashTargetBills.addAll((Collection)targetBills.get("cas_cashjournal"));
        }
    }

    private Map<String, Map<Long, List<DynamicObject>>> getBankCashDataByBotp(HashSet<Long> bankTargetBills, HashSet<Long> cashTargetBills, String journalSelectors) {
        DynamicObject[] bankJournalsByBotp = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)journalSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", bankTargetBills)});
        DynamicObject[] cashJournalsByBotp = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)journalSelectors, (QFilter[])new QFilter[]{new QFilter("id", "in", cashTargetBills)});
        Map<Long, List<DynamicObject>> bankJournalsByBotpMap = Arrays.stream(bankJournalsByBotp).collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
        Map<Long, List<DynamicObject>> cashJournalsByBotpMap = Arrays.stream(cashJournalsByBotp).collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
        HashMap<String, Map<Long, List<DynamicObject>>> bankCashJournalsByBotpMap = new HashMap<String, Map<Long, List<DynamicObject>>>();
        bankCashJournalsByBotpMap.put("cas_bankjournal", bankJournalsByBotpMap);
        bankCashJournalsByBotpMap.put("cas_cashjournal", cashJournalsByBotpMap);
        return bankCashJournalsByBotpMap;
    }

    private Boolean getBooleanOfSysPara(Object value) {
        Boolean parameterBooleans = false;
        if (null != value) {
            parameterBooleans = "true".equals(value);
        }
        return parameterBooleans;
    }

    public Set<Long> getBankAndCashResult(Set<Long> setOfCashAccIds) {
        Set<Long> cashResultSet = new HashSet<Long>();
        if (null == setOfCashAccIds || setOfCashAccIds.size() == 0) {
            return cashResultSet;
        }
        QFilter qFilterOfClosestatus = new QFilter("closestatus", "!=", (Object)"0");
        QFilter qFilterOfId = new QFilter("id", "in", setOfCashAccIds);
        QFilter qFilterAll = qFilterOfClosestatus.and(qFilterOfId);
        DynamicObjectCollection accountCashs = QueryServiceHelper.query((String)"cas_accountcash", (String)"id,closestatus", (QFilter[])new QFilter[]{qFilterAll});
        cashResultSet = accountCashs.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return cashResultSet;
    }

    public void cancelBooks(List<Long> bizBillIds) {
        JournalAntiBookImpl journalAntiBookImpl = new JournalAntiBookImpl();
        ArrayList<Long> journalIds = new ArrayList<Long>();
        for (Long bizBillId : bizBillIds) {
            Collection<Long> journalIdsByBillId = this.journalMap4CancelBook.get(bizBillId);
            if (null == journalIdsByBillId) continue;
            journalIds.addAll(journalIdsByBillId);
        }
        if (journalIds.size() > 0) {
            Object[] journalBills = BusinessDataServiceHelper.load((Object[])journalIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.journalEntityName));
            if ("cas_bankjournal".equals(this.journalEntityName)) {
                journalBills = (DynamicObject[])Arrays.stream(journalBills).filter(s -> !s.getBoolean("ischeck")).toArray(DynamicObject[]::new);
            }
            journalAntiBookImpl.processes((DynamicObject[])journalBills, this.journalEntityName);
            if (journalBills == null || journalIds.size() > journalBills.length) {
                String journalType = "cas_bankjournal".equals(this.journalEntityName) ? "cas_cashjournal" : "cas_bankjournal";
                journalBills = BusinessDataServiceHelper.load((Object[])journalIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)journalType));
                if ("cas_bankjournal".equals(journalType)) {
                    journalBills = (DynamicObject[])Arrays.stream(journalBills).filter(s -> !s.getBoolean("ischeck")).toArray(DynamicObject[]::new);
                }
                if (EmptyUtil.isNoEmpty((Object[])journalBills)) {
                    journalAntiBookImpl.processes((DynamicObject[])journalBills, journalType);
                }
            }
        }
    }

    public void setConsistency(boolean consistency) {
        this.isConsistency = consistency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void book(List<DynamicObject> bizBills, List<BookInfo> okBookInfos) {
        if (bizBills == null || bizBills.size() == 0) {
            return;
        }
        if (okBookInfos == null || okBookInfos.size() == 0) {
            return;
        }
        Set _retainbillIds = bizBills.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        List<BookInfo> _retains = okBookInfos.stream().filter(o -> _retainbillIds.contains(o.getBizId())).collect(Collectors.toList());
        Map<String, String> _retainMaps = bizBills.stream().collect(Collectors.toMap(o -> o.getPkValue().toString(), o -> o.getString("billno")));
        ArrayList journals = new ArrayList();
        _retains.forEach(o -> journals.addAll(o.getBookObjs()));
        if (journals.size() == 0) {
            return;
        }
        StringJoiner errorMsg = new StringJoiner(";");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        ArrayList<String> requestFailNums = new ArrayList<String>();
        String billType = "booklock" + ((BookInfo)_retains.get(0)).getBizBillType();
        try {
            Map lockResultMap = MutexServiceHelper.batchRequest(new ArrayList<String>(_retainMaps.keySet()), (String)"fi-cas-business", (String)billType);
            for (Map.Entry lockResult : lockResultMap.entrySet()) {
                String id = (String)lockResult.getKey();
                Boolean isNotLock = (Boolean)lockResult.getValue();
                if (isNotLock.booleanValue()) {
                    requestIds.add(id);
                    continue;
                }
                requestFailIds.add(id);
                requestFailNums.add(_retainMaps.get(id));
            }
            if (requestFailIds.size() > 0) {
                logger.info("requestFailIds:" + JSON.toJSONString(requestFailIds));
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), ((Object)requestFailNums).toString()));
            } else if (journals != null && journals.size() > 0) {
                new JournalBookImpl().process(journals.toArray(new DynamicObject[0]));
            }
        }
        catch (KDBizException e) {
            logger.error("KDBizException is:", (Throwable)e);
            errorMsg.add(e.getMessage());
        }
        catch (Exception e1) {
            logger.error("Exception is:", (Throwable)e1);
            errorMsg.add(String.format(ResManager.loadKDString((String)"\u767b\u8d26\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3010tranceid\uff1a%s\u3011", (String)"JournalServiceAdapter_2", (String)"fi-cas-business", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
        finally {
            logger.info("release lock\uff1a{},unlock lock\uff1a{}", (Object)JSON.toJSONString(requestIds), (Object)JSON.toJSONString(requestFailIds));
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-business", (String)billType);
        }
        if (errorMsg.length() > 0) {
            logger.info("eror is:" + errorMsg);
            throw new KDBizException(errorMsg.toString());
        }
    }
}

