/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBillBookJournalBuilder
extends AbstractBookJournalBuilder {
    private static Log logger = LogFactory.getLog(PaymentBillBookJournalBuilder.class);
    private OperateOption option;

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObject info) {
        boolean isDraft;
        ArrayList<JournalInfo> journalInfoList = new ArrayList<JournalInfo>();
        DynamicObject settleType = info.getDynamicObject("settletype");
        String settlementType = settleType.getString("settlementtype");
        boolean bl = isDraft = "5".equals(settlementType) || "6".equals(settlementType);
        if (isDraft) {
            return journalInfoList;
        }
        JournalInfo payerJournal = this.bookPayerJournal(info);
        journalInfoList.add(payerJournal);
        String payeeType = info.getString("payeetype");
        if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType) || AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType)) {
            logger.info("CUSTOMER || SUPPLIER:" + payeeType);
            return journalInfoList;
        }
        DynamicObject billType = info.getDynamicObject("billtype");
        if (billType != null && BillTypeConstants.PAYBILL_CASH.equals(billType.getLong("id"))) {
            if (CasHelper.isNotEmpty((Object)info.get("payeeacctbank")) || CasHelper.isNotEmpty((Object)info.get("payeeacctcash"))) {
                JournalInfo oppJournal = this.bookOppJournal(info);
                journalInfoList.add(oppJournal);
            }
        } else {
            boolean cs1047 = SystemParameterHelper.getParameterBoolean((long)info.getDynamicObject("org").getLong("id"), (String)"cs1047");
            logger.info("cs1047 is:" + cs1047);
            if (cs1047) {
                logger.info(String.format("org:[%1$s];payee:[%2$s];org_name:[%3$s];payeename:[%4$s]", info.getDynamicObject("org"), info.getLong("payee"), info.getDynamicObject("org").getLocaleString("name").getLocaleValue(), info.getString("payeename")));
                String orgName = info.getDynamicObject("org").getString("name") == null ? "" : info.getDynamicObject("org").getString("name");
                logger.info("orgName:{}", (Object)orgName);
                if (info.getDynamicObject("org").getPkValue().equals(info.getLong("payee")) || orgName.equals(info.getString("payeename"))) {
                    logger.info(CasHelper.isNotEmpty((Object)info.get("payeeacctbank")) ? "payeeacctbank not null" : "payeeacctbank is null");
                    logger.info(String.format("sourcebilltype:[%1$s]", info.getString("sourcebilltype")));
                    if (CasHelper.isNotEmpty((Object)info.get("payeeacctbank")) && !"fca_transdownbill".equalsIgnoreCase(info.getString("sourcebilltype")) && !"fca_transupbill".equalsIgnoreCase(info.getString("sourcebilltype"))) {
                        DynamicObject accountBank = AccountBankHelper.getAccountBankById((long)info.getLong("payeeacctbank"));
                        logger.info(accountBank != null ? "accountBank != null" : "accountBank == null");
                        if (accountBank != null) {
                            DynamicObject bankLoad;
                            DynamicObject bankCate;
                            logger.info("account id:" + accountBank.getPkValue());
                            DynamicObject bank = accountBank.getDynamicObject("bank");
                            boolean isVirtual = accountBank.getBoolean("isvirtual");
                            logger.info(!isVirtual ? "isVirtual != null" : "isVirtual == null");
                            if (!(isVirtual || !CasHelper.isEmpty((Object)(bankCate = (bankLoad = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"bank_cate")).getDynamicObject("bank_cate"))) && VisibleVirtualAcctHelper.checkVirtualAcct(bankCate.getLong("id")).booleanValue())) {
                                JournalInfo oppJournal = this.bookOppJournal(info);
                                journalInfoList.add(oppJournal);
                            }
                        }
                    }
                }
            }
        }
        return journalInfoList;
    }

    private void getBankJournalInner(List<JournalInfo> list, DynamicObject info) {
        DynamicObject innerAccount = info.getDynamicObject("inneraccount");
        if (innerAccount == null) {
            return;
        }
        JournalInfo journal = this.createBaseJournal(info, true);
        journal.setOrg(info.getDynamicObject("org"));
        journal.setAccountBank(innerAccount);
        journal.setCreditAmount(BigDecimal.ZERO);
        journal.setDebitAmount(info.getBigDecimal("actpayamt"));
        journal.setDirection(1);
        journal.setOppUnit(CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name"));
        DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
        if (payerAcctBank != null) {
            journal.setOppAcctNumber(payerAcctBank.getString("bankaccountnumber"));
        } else {
            DynamicObject payerAcctCash = info.getDynamicObject("payeracctcash");
            if (payerAcctCash != null) {
                journal.setOppAcctNumber(payerAcctCash.getString("number"));
            }
        }
        DynamicObject payerBank = info.getDynamicObject("payerbank");
        if (payerBank != null) {
            journal.setOppBank(CasHelper.getLocalValue((DynamicObject)payerBank, (String)"name"));
        }
        journal.setBatchNo(info.getString("bankcheckflag_tag"));
        list.add(journal);
    }

    private JournalInfo bookOppJournal(DynamicObject info) {
        JournalInfo journalInfo = this.createBaseJournal(info, false);
        journalInfo.setOrg(info.getDynamicObject("org"));
        long payeeAcctBank = info.getLong("payeeacctbank");
        long payeeAcctCash = info.getLong("payeeacctcash");
        if (CasHelper.isNotEmpty((Object)payeeAcctBank)) {
            DynamicObject accountBankById = AccountBankHelper.getAccountBankById((long)payeeAcctBank);
            if (accountBankById != null) {
                logger.info("account id:" + accountBankById.getPkValue());
            }
            journalInfo.setAccountBank(accountBankById);
        } else if (CasHelper.isNotEmpty((Object)payeeAcctCash)) {
            DynamicObject accountCashById = AccountCashHelper.getAccountCashById((long)payeeAcctCash);
            if (accountCashById != null) {
                logger.info("account id:" + accountCashById.getPkValue());
            }
            journalInfo.setAccountCash(accountCashById);
        }
        journalInfo.setCreditAmount(BigDecimal.ZERO);
        journalInfo.setDebitAmount(info.getBigDecimal("actpayamt"));
        journalInfo.setDirection(1);
        journalInfo.setOppUnit(CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name"));
        DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
        if (payerAcctBank != null) {
            journalInfo.setOppAcctNumber(payerAcctBank.getString("bankaccountnumber"));
        } else {
            DynamicObject payerAcctCash = info.getDynamicObject("payeracctcash");
            if (payerAcctCash != null) {
                journalInfo.setOppAcctNumber(payerAcctCash.getString("number"));
            }
        }
        if (info.getDynamicObject("payerbank") != null) {
            journalInfo.setOppBank(info.getDynamicObject("payerbank").getLocaleString("name").getLocaleValue());
        }
        journalInfo.setBatchNo(info.getString("bankcheckflag_tag"));
        journalInfo.setRpBaseType("cas_paymentbilltype");
        journalInfo.setRpType(info.getDynamicObject("paymenttype"));
        return journalInfo;
    }

    private JournalInfo bookPayerJournal(DynamicObject info) {
        boolean isLinkagePayment;
        JournalInfo journalInfo = this.createBaseJournal(info, true);
        journalInfo.setOrg(info.getDynamicObject("org"));
        journalInfo.setAccountBank(info.getDynamicObject("payeracctbank"));
        journalInfo.setAccountCash(info.getDynamicObject("payeracctcash"));
        journalInfo.setOppUnit(info.getString("payeename"));
        journalInfo.setOppAcctNumber(info.getString("payeebanknum"));
        DynamicObject payeeBank = info.getDynamicObject("payeebank");
        if (payeeBank != null) {
            journalInfo.setOppBank(payeeBank.getLocaleString("name").getLocaleValue());
        } else {
            journalInfo.setOppBank(info.getString("payeebankname"));
        }
        journalInfo.setDirection(2);
        journalInfo.setBatchNo(info.getString("bankcheckflag_tag"));
        boolean isBillBookJournal = SystemParameterHelper.isBillBookJournal((long)info.getDynamicObject("org").getLong("id"));
        boolean isVoucherMixBookJournal = SystemParameterHelper.isVoucherMixBookJournal((long)info.getDynamicObject("org").getLong("id"));
        boolean isBookInner = SystemParameterHelper.getParameterBoolean((long)info.getDynamicObject("org").getLong("id"), (String)"is_book_inner");
        DynamicObject paymentIdentify = info.getDynamicObject("paymentidentify");
        if (isBookInner && (isBillBookJournal || isVoucherMixBookJournal) && (isLinkagePayment = LinkagePaymentHelper.isLinkagePayment(info)) && paymentIdentify != null) {
            String type = paymentIdentify.getString("type");
            DynamicObject innerAccount = info.getDynamicObject("inneraccount");
            if ("0".equals(type) && innerAccount != null) {
                journalInfo.setAccountBank(AccountBankHelper.getAccountBankById((long)innerAccount.getLong("id")));
            }
        }
        journalInfo.setRpBaseType("cas_paymentbilltype");
        journalInfo.setRpType(info.getDynamicObject("paymenttype"));
        return journalInfo;
    }

    private JournalInfo createBaseJournal(DynamicObject info, boolean isPay) {
        JournalInfo journalInfo = new JournalInfo();
        this.setBillValue(journalInfo, info);
        DynamicObject billType = info.getDynamicObject("billtype");
        if (billType != null) {
            long type = billType.getLong("id");
            if (BillTypeConstants.PAYBILL_SYN.equals(type)) {
                journalInfo.setSourceBillType("cas_paybill_synonym");
            }
            if (BillTypeConstants.PAYBILL_CASH.equals(type)) {
                journalInfo.setSourceBillType("cas_paybill_cash");
            }
        }
        DynamicObjectCollection entryColl = info.getDynamicObjectCollection("entry");
        ArrayList<JournalEntryInfo> entryList = new ArrayList<JournalEntryInfo>(entryColl.size());
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            JournalEntryInfo entryInfo = new JournalEntryInfo();
            BigDecimal e_actamt = entry.getBigDecimal("e_actamt");
            entryInfo.setAmount(e_actamt);
            entryInfo.setLocalAmount(entry.getBigDecimal("e_localamt"));
            if (info.getBoolean("isdiffcur") && isPay) {
                DynamicObject dpCurrency = info.getDynamicObject("dpcurrency");
                String agreedquotation = info.getString("agreedquotation");
                if (dpCurrency != null) {
                    entryInfo.setAmount(QuotationHelper.callToCurrency((BigDecimal)e_actamt, (BigDecimal)info.getBigDecimal("agreedrate"), (String)agreedquotation, (int)dpCurrency.getInt("amtprecision")));
                } else {
                    entryInfo.setAmount(QuotationHelper.callToCurrency((BigDecimal)e_actamt, (BigDecimal)info.getBigDecimal("agreedrate"), (String)agreedquotation, (int)10));
                }
                DynamicObject baseCurrency = info.getDynamicObject("basecurrency");
                String dppayquotation = info.getString("dppayquotation");
                if (baseCurrency != null) {
                    entryInfo.setLocalAmount(QuotationHelper.callToCurrency((BigDecimal)entryInfo.getAmount(), (BigDecimal)info.getBigDecimal("dpexchangerate"), (String)dppayquotation, (int)baseCurrency.getInt("amtprecision")));
                } else {
                    entryInfo.setLocalAmount(QuotationHelper.callToCurrency((BigDecimal)entryInfo.getAmount(), (BigDecimal)info.getBigDecimal("dpexchangerate"), (String)dppayquotation, (int)10));
                }
            }
            entryInfo.setFundFlowItem(entry.getDynamicObject("e_fundflowitem"));
            entryList.add(entryInfo);
        }
        journalInfo.setEntry(entryList);
        return journalInfo;
    }

    private void setBillValue(JournalInfo journalInfo, DynamicObject info) {
        BigDecimal localAmount;
        BigDecimal totalpayamt;
        String quotation;
        DynamicObject baseCurrency;
        BigDecimal rate = info.getBigDecimal("dpexchangerate");
        if (info.containsProperty("feepay") && info.containsProperty("exchangerate") && info.getBoolean("feepay")) {
            rate = info.getBigDecimal("exchangerate");
        }
        if (rate.compareTo(BigDecimal.ZERO) == 0) {
            rate = BigDecimal.ONE;
        }
        if (!info.getBoolean("singlestream")) {
            baseCurrency = info.getDynamicObject("basecurrency");
            quotation = info.getString("dppayquotation");
            totalpayamt = info.getBigDecimal("totalpayamt");
            journalInfo.setCreditAmount(totalpayamt);
            journalInfo.setFee(info.getBigDecimal("fee"));
            localAmount = BigDecimal.ZERO;
            localAmount = baseCurrency != null ? QuotationHelper.callToCurrency((BigDecimal)totalpayamt, (BigDecimal)rate, (String)quotation, (int)baseCurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency((BigDecimal)totalpayamt, (BigDecimal)rate, (String)quotation, (int)10);
            journalInfo.setLocalAmount(localAmount);
        } else {
            journalInfo.setCreditAmount(info.getBigDecimal("dpamt"));
            journalInfo.setLocalAmount(info.getBigDecimal("dplocalamt"));
        }
        if (info.containsProperty("feepay") && info.containsProperty("basecurrency") && info.containsProperty("payquotation") && info.containsProperty("totalpayamt") && info.getBoolean("feepay")) {
            baseCurrency = info.getDynamicObject("basecurrency");
            quotation = info.getString("payquotation");
            totalpayamt = info.getBigDecimal("totalpayamt");
            localAmount = BigDecimal.ZERO;
            localAmount = baseCurrency != null ? QuotationHelper.callToCurrency((BigDecimal)totalpayamt, (BigDecimal)rate, (String)quotation, (int)baseCurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency((BigDecimal)totalpayamt, (BigDecimal)rate, (String)quotation, (int)10);
            journalInfo.setLocalAmount(localAmount);
        }
        journalInfo.setDebitAmount(BigDecimal.ZERO);
        journalInfo.setCurrency(info.getDynamicObject("dpcurrency"));
        journalInfo.setExchangeRate(rate);
        journalInfo.setBizDate(info.getDate("bizdate"));
        journalInfo.setDescription(info.getString("description"));
        journalInfo.setSource(2);
        journalInfo.setSettlementType(info.getDynamicObject("settletype"));
        journalInfo.setSettlementNumber(info.getString("settletnumber"));
        logger.info("\u51fa\u7eb3\uff1a" + info.get("cashier"));
        journalInfo.setCashier(DynamicObjectHelper.wapDynamic((String)"bos_user", (Object)info.get("cashier")));
        journalInfo.setSourceBillType(info.getDataEntityType().getName());
        journalInfo.setSourceBillNumber(info.getString("billno"));
        journalInfo.setBillno(info.getString("billno"));
        journalInfo.setSourceBillId(info.getLong("id"));
        journalInfo.setBankCheckFlag(info.getString("bankcheckflag_tag"));
        if (info.containsProperty("bankcheckentity")) {
            DynamicObjectCollection bankEntry = info.getDynamicObjectCollection("bankcheckentity");
            if (bankEntry.size() > 0) {
                journalInfo.setBankCheckEntity(info.getDynamicObjectCollection("bankcheckentity"));
            } else {
                journalInfo.setBankCheckEntity(info.getString("bankcheckflag_tag"));
            }
        } else {
            journalInfo.setBankCheckEntity(info.getString("bankcheckflag_tag"));
        }
        journalInfo.setPayDate(info.getDate("paydate"));
        journalInfo.setPaychannel(info.getString("paymentchannel"));
        journalInfo.setTraceDate(info.getDate("acttradedate"));
        journalInfo.setPd(info.getDate("paydate"));
        journalInfo.setAvd(info.getDate("expectdate"));
        journalInfo.setFeepayer(info.getString("feepayer"));
        journalInfo.setPreparationdate(info.getDate("createtime"));
        String payChannel = info.getString("paymentchannel");
        Set cs109 = SystemParameterHelper.getParameterComboxs((long)info.getDynamicObject("org").getLong("id"), (String)"cs109");
        if (EmptyUtil.isEmpty((Object)info.getDate("paydate"))) {
            DynamicObject org = info.getDynamicObject("org");
            HashSet<Long> setOrfIds = new HashSet<Long>(2);
            setOrfIds.add(org.getLong("id"));
            Date payDate = this.getPayDate(info, setOrfIds);
            journalInfo.setPd(payDate);
            if (cs109.contains(payChannel)) {
                journalInfo.setPayDate(payDate);
            }
        }
    }

    private boolean isBeiPay(DynamicObject info) {
        String paymentchannel = info.getString("paymentchannel");
        return PaymentChannelEnum.BEI.getValue().equals(paymentchannel);
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObjectCollection billColl) {
        throw new RuntimeException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u6682\u4e0d\u652f\u6301\u6279\u91cf\u767b\u8d26\u3002", (String)"PaymentBillBookJournalBuilder_0", (String)"fi-cas-business", (Object[])new Object[0]));
    }

    @Override
    public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
        HashMap<Long, List<JournalInfo>> listMap = new HashMap<Long, List<JournalInfo>>();
        Set orgIds = billColl.parallelStream().filter(d -> CasHelper.isNotEmpty((Object)d.getDynamicObject("org"))).map(d -> d.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map cs1047Map = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs1047");
        Set acctIds = billColl.parallelStream().filter(d -> CasHelper.isNotEmpty((Object)d.getLong("payeeacctbank"))).map(d -> d.getLong("payeeacctbank")).collect(Collectors.toSet());
        Map<Object, Object> acctBankMap = new HashMap(acctIds.size());
        if (acctIds.size() > 0) {
            DynamicObjectCollection acctBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,isvirtual", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)});
            acctBankMap = acctBanks.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getBoolean("isvirtual")));
        }
        for (DynamicObject info : billColl) {
            boolean isCashPayBill;
            ArrayList<JournalInfo> list = new ArrayList<JournalInfo>();
            Long id = info.getLong("id");
            JournalInfo payerJournal = this.bookPayerJournal(info);
            list.add(payerJournal);
            String payeeType = info.getString("payeetype");
            if (AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType) || AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType)) {
                listMap.put(id, list);
                logger.info("CUSTOMER || SUPPLIER:" + payeeType);
                continue;
            }
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject billType = info.getDynamicObject("billtype");
            Long payeeacctbank = info.getLong("payeeacctbank");
            String sourcebilltype = info.getString("sourcebilltype");
            Long payee = info.getLong("payee");
            String payeename = info.getString("payeename");
            boolean bl = CasHelper.isEmpty((Object)billType) ? false : (isCashPayBill = BillTypeConstants.PAYBILL_CASH.longValue() == billType.getLong("id"));
            if (isCashPayBill) {
                if (CasHelper.isNotEmpty((Object)info.get("payeeacctbank")) || CasHelper.isNotEmpty((Object)info.get("payeeacctcash"))) {
                    JournalInfo oppJournal = this.bookOppJournal(info);
                    list.add(oppJournal);
                } else {
                    logger.info("payeeacctbank is empty || payeeacctcash is empty");
                }
            } else {
                Long orgId = CasHelper.isEmpty((Object)org) ? 0L : org.getLong("id");
                boolean cs1047 = (Boolean)cs1047Map.get(String.valueOf(orgId));
                logger.info("---> PaymentBillBookJournalBuilder.getJournalInfoLists(): billno=[{}], cs1047=[{}]", (Object)info.getString("billno"), (Object)cs1047);
                if (cs1047) {
                    String orgName = org.getString("name") == null ? "" : org.getString("name");
                    boolean sameName = orgName.equals(payeename);
                    if ((orgId.compareTo(payee) == 0 || sameName) && CasHelper.isNotEmpty((Object)payeeacctbank) && !"fca_transdownbill".equalsIgnoreCase(sourcebilltype) && !"fca_transupbill".equalsIgnoreCase(sourcebilltype)) {
                        boolean isVirtAcct;
                        boolean bl2 = isVirtAcct = acctBankMap.size() > 0 ? (Boolean)acctBankMap.get(payeeacctbank) : true;
                        if (!isVirtAcct) {
                            JournalInfo oppJournal = this.bookOppJournal(info);
                            list.add(oppJournal);
                        }
                    }
                }
            }
            listMap.put(id, list);
        }
        return listMap;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    private Date getPayDate(DynamicObject paybill, Set<Long> setOrg) {
        if (this.option == null) {
            return null;
        }
        Map params = this.option.getVariables();
        String cs1046 = params.get("cs1046") != null ? (String)params.get("cs1046") : "";
        Map paydateMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(setOrg), (String)"selectpaydate");
        return PaymentPayHelper.confirmPayDate((DynamicObject)paybill, (String)cs1046, (Map)params, (Map)paydateMap);
    }
}

