/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class RecBillBookJournalbuilder
extends AbstractBookJournalBuilder {
    private static Log logger = LogFactory.getLog(RecBillBookJournalbuilder.class);

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObject recBill) {
        DynamicObjectCollection recBillCol = new DynamicObjectCollection();
        recBillCol.add((Object)recBill);
        return this.getJournalInfoList(recBillCol);
    }

    private JournalInfo bookOppJournal(DynamicObject recBill, DynamicObject user, DynamicObject payerAcctBank) {
        JournalInfo journalInfo = this.createBaseJournal(recBill, user);
        journalInfo.setOrg(recBill.getDynamicObject("org"));
        journalInfo.setAccountBank(payerAcctBank);
        journalInfo.setAccountCash(null);
        journalInfo.setDebitAmount(BigDecimal.ZERO);
        journalInfo.setLocalAmount(recBill.getBigDecimal("localamt"));
        journalInfo.setCreditAmount(recBill.getBigDecimal("actrecamt"));
        journalInfo.setDirection(2);
        journalInfo.setOppUnit(CasHelper.getLocalValue((DynamicObject)recBill.getDynamicObject("org"), (String)"name"));
        DynamicObject payeeAccountBank = recBill.getDynamicObject("accountbank");
        if (payeeAccountBank != null) {
            journalInfo.setOppAcctNumber(payeeAccountBank.getString("bankaccountnumber"));
        } else {
            DynamicObject payeeAccountCash = recBill.getDynamicObject("accountcash");
            if (payeeAccountCash != null) {
                journalInfo.setOppAcctNumber(payeeAccountCash.getString("number"));
            }
        }
        DynamicObject payeeBank = recBill.getDynamicObject("payeebank");
        if (payeeBank != null) {
            journalInfo.setOppBank(payeeBank.getString("name"));
        }
        return journalInfo;
    }

    private JournalInfo bookReceivJournal(DynamicObject recBill, DynamicObject user) {
        JournalInfo journalInfo = this.createBaseJournal(recBill, user);
        journalInfo.setOrg(recBill.getDynamicObject("org"));
        journalInfo.setAccountBank(recBill.getDynamicObject("accountbank"));
        journalInfo.setAccountCash(recBill.getDynamicObject("accountcash"));
        journalInfo.setDebitAmount(recBill.getBigDecimal("actrecamt"));
        journalInfo.setLocalAmount(recBill.getBigDecimal("localamt"));
        journalInfo.setCreditAmount(BigDecimal.ZERO);
        journalInfo.setDirection(1);
        journalInfo.setOppUnit(recBill.getString("payername"));
        journalInfo.setOppAcctNumber(recBill.getString("payeracctbanknum"));
        DynamicObject payerBank = recBill.getDynamicObject("f7_payerbank");
        if (payerBank != null) {
            journalInfo.setOppBank(payerBank.getString("name"));
        } else {
            journalInfo.setOppBank(recBill.getString("payerbankname"));
        }
        journalInfo.setRpBaseType("cas_receivingbilltype");
        journalInfo.setRpType(recBill.getDynamicObject("receivingtype"));
        return journalInfo;
    }

    private JournalInfo createBaseJournal(DynamicObject billObject, DynamicObject user) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCurrency(billObject.getDynamicObject("currency"));
        journalInfo.setExchangeRate(billObject.getBigDecimal("exchangerate"));
        journalInfo.setCashier(user);
        journalInfo.setBizDate(billObject.getDate("bizdate"));
        journalInfo.setSource(2);
        journalInfo.setSourceBillType("cas_recbill");
        journalInfo.setSourceBillNumber(billObject.getString("billno"));
        journalInfo.setBillno(billObject.getString("billno"));
        journalInfo.setSourceBillId(billObject.getLong("id"));
        journalInfo.setSettlementType(billObject.getDynamicObject("settletype"));
        journalInfo.setSettlementNumber(billObject.getString("settletnumber"));
        journalInfo.setDescription(billObject.getString("txt_description"));
        journalInfo.setBatchNo(billObject.getString("bankcheckflag_tag"));
        journalInfo.setBankCheckFlag(billObject.getString("bankcheckflag_tag"));
        if (billObject.containsProperty("bankcheckentity")) {
            journalInfo.setBankCheckEntity(billObject.getDynamicObjectCollection("bankcheckentity"));
        } else {
            journalInfo.setBankCheckEntity(billObject.getString("bankcheckflag_tag"));
        }
        journalInfo.setTraceDate(billObject.getDate("acttradedate"));
        journalInfo.setPreparationdate(billObject.getDate("createtime"));
        DynamicObjectCollection entry = billObject.getDynamicObjectCollection("entry");
        ArrayList<JournalEntryInfo> entryList = new ArrayList<JournalEntryInfo>(entry.size());
        for (DynamicObject recentryInfo : entry) {
            JournalEntryInfo entryInfo = new JournalEntryInfo();
            entryInfo.setAmount(recentryInfo.getBigDecimal("e_actamt"));
            entryInfo.setLocalAmount(recentryInfo.getBigDecimal("e_localamt"));
            entryInfo.setFundFlowItem(recentryInfo.getDynamicObject("e_fundflowitem"));
            entryList.add(entryInfo);
        }
        journalInfo.setEntry(entryList);
        return journalInfo;
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObjectCollection billColl) {
        if (billColl == null || billColl.size() == 0) {
            return new ArrayList<JournalInfo>();
        }
        ArrayList<JournalInfo> returns = new ArrayList<JournalInfo>(billColl.size());
        Map<Long, List<JournalInfo>> journalInfos = this.getJournalInfoLists(billColl, null);
        journalInfos.forEach((key, value) -> returns.addAll((Collection<JournalInfo>)value));
        return returns;
    }

    @Override
    public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
        HashMap<Long, List<JournalInfo>> JournalInfoMap = new HashMap<Long, List<JournalInfo>>(10);
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
        Set orgIdSet = billColl.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
        Map cs1047Map = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIdSet), (String)"cs1047");
        Set payerAcctBankSet = billColl.stream().map(o -> o.getLong("payeracctbank")).collect(Collectors.toSet());
        Map acctMap = BusinessDataServiceHelper.loadFromCache((Object[])payerAcctBankSet.stream().filter(Objects::nonNull).toArray(), (String)"bd_accountbanks");
        for (DynamicObject recBill : billColl) {
            ArrayList<JournalInfo> journalInfoList = new ArrayList<JournalInfo>();
            if (CasHelper.isEmpty((Object)recBill.getDynamicObject("accountbank")) && CasHelper.isEmpty((Object)recBill.getDynamicObject("accountcash"))) {
                logger.info("recBill_accountbank_:accountcash is null");
                continue;
            }
            JournalInfo journalInfo = this.bookReceivJournal(recBill, user);
            journalInfoList.add(journalInfo);
            Long orgId = recBill.getDynamicObject("org").getLong("id");
            if (null == orgId) {
                logger.info("null ==orgId");
                continue;
            }
            Long id = recBill.getLong("id");
            String payerType = recBill.getString("payertype");
            if (AsstActTypeEnum.CUSTOMER.getValue().equals(payerType) || AsstActTypeEnum.SUPPLIER.getValue().equals(payerType)) {
                JournalInfoMap.put(id, journalInfoList);
                logger.info("CUSTOMER || SUPPLIER" + payerType);
                continue;
            }
            Boolean cs1047 = (Boolean)cs1047Map.get(orgId.toString());
            DynamicObject payerAcctBank = (DynamicObject)acctMap.get(recBill.getLong("payeracctbank"));
            logger.info("cs1047:" + cs1047);
            if (cs1047.booleanValue()) {
                if (recBill.getDynamicObject("org").getPkValue().equals(recBill.getLong("payer"))) {
                    if (!(CasHelper.isEmpty((Object)recBill.get("payeracctbank")) || "fca_transdownbill".equalsIgnoreCase(recBill.getString("sourcebilltype")) || "fca_transupbill".equalsIgnoreCase(recBill.getString("sourcebilltype")))) {
                        JournalInfo oppJournal = this.bookOppJournal(recBill, user, payerAcctBank);
                        journalInfoList.add(oppJournal);
                    }
                } else {
                    ILocaleString orgName;
                    DynamicObject org = recBill.getDynamicObject("org");
                    if (CasHelper.isNotEmpty((Object)org) && null != (orgName = org.getLocaleString("name")) && null != orgName.getLocaleValue() && orgName.getLocaleValue().equals(recBill.getString("payername")) && !CasHelper.isEmpty((Object)recBill.get("payeracctbank")) && !"fca_transdownbill".equalsIgnoreCase(recBill.getString("sourcebilltype")) && !"fca_transupbill".equalsIgnoreCase(recBill.getString("sourcebilltype"))) {
                        JournalInfo oppJournal = this.bookOppJournal(recBill, user, payerAcctBank);
                        journalInfoList.add(oppJournal);
                    }
                }
            }
            JournalInfoMap.put(id, journalInfoList);
        }
        return JournalInfoMap;
    }
}

