/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.factory;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cas.business.opservice.IBankVCCheckService;
import kd.fi.cas.business.opservice.impl.CheckByFlagServiceImpl;
import kd.fi.cas.business.opservice.impl.CheckBySettleNumServiceImpl;
import kd.fi.cas.business.opservice.impl.One2OneServiceImpl;
import kd.fi.cas.business.pojo.BankVCCheckInfo;

public class BankVCCheckServiceContext {
    private List<IBankVCCheckService> serviceList = new ArrayList<IBankVCCheckService>();
    private BankVCCheckInfo checkInfo;

    public BankVCCheckServiceContext(BankVCCheckInfo checkInfo) {
        this.checkInfo = checkInfo;
        DynamicObject checkScheme = checkInfo.getCheckScheme();
        if (checkScheme.getBoolean("ischeckflag")) {
            this.serviceList.add(new CheckByFlagServiceImpl());
        }
        if (checkScheme.getBoolean("issettlenum4schedule") || this.isOnlySettleNum4Auto(checkScheme)) {
            this.serviceList.add(new CheckBySettleNumServiceImpl());
        }
        boolean noSelectedItem = this.noSelectedItem(checkScheme);
        if (!this.isOnlySettleNum4Auto(checkScheme)) {
            this.serviceList.add(new One2OneServiceImpl(noSelectedItem));
        }
    }

    public void doCheck() {
        for (int i = 0; i < this.serviceList.size(); ++i) {
            this.serviceList.get(i).doCheck(this.checkInfo);
        }
    }

    private boolean isOnlySettleNum4Auto(DynamicObject checkScheme) {
        return checkScheme.getBoolean("issettlenum4auto") && !checkScheme.getBoolean("isbizdate") && !checkScheme.getBoolean("isdatediff") && !checkScheme.getBoolean("issettlementtype") && !checkScheme.getBoolean("isdescription") && !checkScheme.getBoolean("isoppunit");
    }

    private boolean noSelectedItem(DynamicObject checkScheme) {
        return !checkScheme.getBoolean("isbizdate") && !checkScheme.getBoolean("isdatediff") && !checkScheme.getBoolean("issettlenum4auto") && !checkScheme.getBoolean("issettlementtype") && !checkScheme.getBoolean("isdescription") && !checkScheme.getBoolean("isoppunit");
    }
}

