/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasDetailInfoExtFieldsHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class DealCasSameTransAndRuleNameHelper {
    private static Log logger = LogFactory.getLog(DealCasSameTransAndRuleNameHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dealSameNameTrans(DynamicObject bizbill, String ruleWay) {
        String entityName = bizbill.getDataEntityType().getName();
        String sourceDetailBilltype = bizbill.getString("sourcebilltype");
        Long sourceBillId = bizbill.getLong("sourcebillid");
        logger.info("\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1--------\u4fdd\u5b58\u5904\u7406,\u4e1a\u52a1\u5355\u636eid:{}\uff0c\u4e1a\u52a1\u5355\u636e\u5b9e\u4f53\u6807\u8bc6entityName:{};\u6e90\u5355\u5b9e\u4f53\u7c7b\u578b(\u4ea4\u6613\u660e\u7ec6)sourceDetailBilltype\uff1a{}\uff0c\u6e90\u5355id(\u4ea4\u6613\u660e\u7ec6)\uff1a{}", new Object[]{bizbill.getPkValue(), entityName, sourceDetailBilltype, sourceBillId});
        logger.info("\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1--------\u627e\u5230\u6e90\u4ea4\u6613\u660e\u7ec6\u5355:{}", (Object)sourceBillId);
        DynamicObject thisDetail = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceDetailBilltype));
        if (!thisDetail.getBoolean("synonym")) {
            return;
        }
        Map detailInfoFieldsMap = CasDetailInfoExtFieldsHelper.getDetailInfoFields((String)entityName);
        Set<DynamicObject> otherDetails = DealCasSameTransAndRuleNameHelper.getOtherDetailByThisDetail(thisDetail, entityName);
        if (EmptyUtil.isEmpty(otherDetails)) {
            return;
        }
        String billFlag = bizbill.getDataEntityType().getName();
        DynamicObject otherDetailDO = otherDetails.stream().findFirst().orElseGet(() -> null);
        if (otherDetailDO == null) {
            return;
        }
        String otherDetailBillType = otherDetailDO.getDataEntityType().getName();
        logger.info("\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1--------\u6e90\u4ea4\u6613\u660e\u7ec6:{},\u5bf9\u5e94\u7684\u53e6\u4e00\u65b9\u4ea4\u6613\u660e\u7ec6id:{},\u53e6\u4e00\u65b9\u4ea4\u6613\u660e\u7ec6\u7c7b\u578b:{}", new Object[]{thisDetail.getPkValue(), otherDetailDO.getPkValue(), otherDetailBillType});
        List<String> otherDetailIds = Collections.singletonList(otherDetailDO.getString("id"));
        if (!TxCheckUtil.getLocked(otherDetailIds).isEmpty()) {
            logger.info("\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1-------\u53e6\u4e00\u65b9\u7684\u4ea4\u6613\u660e\u7ec6\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u91cd\u590d\u5904\u7406\u3002\u53e6\u4e00\u65b9\u4ea4\u6613\u660e\u7ec6id\uff1a{}", otherDetailDO.getPkValue());
            return;
        }
        boolean isLocked = MutexServiceHelper.request((String)otherDetailDO.getString("id"), (String)otherDetailBillType, (String)"batchWork_bench");
        if (!isLocked) {
            logger.info("\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1-------\u53e6\u4e00\u65b9\u7684\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d\uff0c\u4e0d\u91cd\u590d\u5904\u7406\u3002\u53e6\u4e00\u65b9\u4ea4\u6613\u660e\u7ec6id\uff1a{}", otherDetailDO.getPkValue());
            return;
        }
        try {
            otherDetailDO.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
            otherDetailDO.set("recedbillnumber", (Object)bizbill.getString("billno"));
            otherDetailDO.set("isreced", (Object)"1");
            otherDetailDO.set("recedbilltype", (Object)billFlag);
            otherDetailDO.set("smartmatch", (Object)"1");
            BigDecimal matchMoney = BigDecimal.ZERO;
            String direction = "";
            if ("cas_recbill".equals(entityName)) {
                matchMoney = otherDetailDO.getBigDecimal("debitamount");
                direction = "pay";
                bizbill.set("matchamountpay", (Object)bizbill.getBigDecimal("matchamountpay").add(matchMoney));
                bizbill.set("unmatchamountpay", (Object)bizbill.getBigDecimal("unmatchamountpay").subtract(matchMoney));
            } else {
                matchMoney = otherDetailDO.getBigDecimal("creditamount");
                direction = "rec";
                bizbill.set("matchamountrec", (Object)bizbill.getBigDecimal("matchamountrec").add(matchMoney));
                bizbill.set("unmatchamountrec", (Object)bizbill.getBigDecimal("unmatchamountrec").subtract(matchMoney));
            }
            otherDetailDO.set("confirmamount", (Object)matchMoney);
            otherDetailDO.set("unconfirmamount", (Object)BigDecimal.ZERO);
            String opNumber = thisDetail.getDynamicObjectCollection("recedbillentry").stream().map(t -> t.getString("e_opnumber")).findFirst().orElse("");
            AutoMatchHelper.setRecedBillEntry(otherDetailDO, bizbill.getDataEntityType().getName(), bizbill.getString("billno"), bizbill.getLong("id"), 0L, "", matchMoney, direction, opNumber);
            boolean haveBankcheckflag = bizbill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag".equals(o.getName()) || "bankcheckflag_tag".equals(o.getName()));
            if (haveBankcheckflag) {
                String bankcheckflag = otherDetailDO.getString("bankcheckflag");
                haveBankcheckflag = bizbill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag_tag".equals(o.getName()));
                String bussbankcheckflag = haveBankcheckflag ? bizbill.getString("bankcheckflag_tag") : bizbill.getString("bankcheckflag");
                bussbankcheckflag = bussbankcheckflag == null || bussbankcheckflag.trim().length() < 1 ? bankcheckflag : String.join((CharSequence)",", bussbankcheckflag, bankcheckflag);
                bizbill.set("bankcheckflag", (Object)CasHelper.subFlag((String)bussbankcheckflag));
                if (haveBankcheckflag) {
                    bizbill.set("bankcheckflag_tag", (Object)bussbankcheckflag);
                }
                if (bizbill.containsProperty("bankcheckentity") && !EmptyUtil.isEmpty((String)bankcheckflag)) {
                    Object[] split;
                    DynamicObjectCollection bankCheckEntity = bizbill.getDynamicObjectCollection("bankcheckentity");
                    for (String string : split = bankcheckflag.split(",")) {
                        if (EmptyUtil.isEmpty((Object[])split)) continue;
                        DynamicObject dynamicObject = bankCheckEntity.addNew();
                        dynamicObject.set("ebankcheckflag", (Object)string);
                        CasDetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)otherDetailDO, (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                    }
                }
            }
            otherDetailDO.set("receredway", (Object)ReceredWayEnum.AUTOMATCH.getValue());
            CasFlowConfirmLogHelper.updateSameTransMatchLog(opNumber, otherDetailDO, sourceBillId);
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{otherDetailDO});
            }
        }
        finally {
            MutexServiceHelper.release((String)otherDetailDO.getString("id"), (String)otherDetailBillType, (String)"batchWork_bench");
        }
        CasBotpHelper.saveRelation((String)otherDetailDO.getDataEntityType().getName(), (Long)((Long)otherDetailDO.getPkValue()), (String)bizbill.getDataEntityType().getName(), (Long)((Long)bizbill.getPkValue()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizbill});
    }

    @Deprecated
    public static void dealCancleRuleSameNameTrans(List<DynamicObject> thisDetails, String entityName) {
        Set<DynamicObject> filterThisDetails = DealCasSameTransAndRuleNameHelper.filterTheSameNameTrans(thisDetails.toArray(new DynamicObject[0]));
        if (CollectionUtils.isEmpty(filterThisDetails)) {
            return;
        }
        for (DynamicObject thisDetail : filterThisDetails) {
            Map targetBills;
            String detailEntityName = thisDetail.getDataEntityType().getName();
            String otherDetailEntityName = "bei_transdetail_cas";
            if ("bei_intelpay".equalsIgnoreCase(detailEntityName)) {
                otherDetailEntityName = "bei_intelrec";
            }
            if (CollectionUtils.isEmpty((Map)(targetBills = BFTrackerServiceHelper.findTargetBills((String)detailEntityName, (Long[])new Long[]{(Long)thisDetail.getPkValue()})))) {
                return;
            }
            Set bizBillIds = targetBills.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            String targetEntityName = targetBills.keySet().stream().findFirst().orElseGet(() -> null);
            for (Long bizBillId : bizBillIds) {
                Set otherDetailSet;
                Set detailSet = CasBotpHelper.getSrcBillByDestBill((Long)bizBillId, (String)targetEntityName, (String)detailEntityName);
                if (!CollectionUtils.isEmpty((Collection)detailSet)) {
                    DealCasSameTransAndRuleNameHelper.updateDetail(detailSet, detailEntityName);
                }
                if (otherDetailEntityName.equalsIgnoreCase(detailEntityName) || CollectionUtils.isEmpty((Collection)(otherDetailSet = CasBotpHelper.getSrcBillByDestBill((Long)bizBillId, (String)targetEntityName, (String)otherDetailEntityName)))) continue;
                DealCasSameTransAndRuleNameHelper.updateDetail(otherDetailSet, otherDetailEntityName);
            }
        }
    }

    private static void updateDetail(Set<Long> detailSet, String entityName) {
        DynamicObject[] thisSrcDetails;
        for (DynamicObject transDetail : thisSrcDetails = BusinessDataServiceHelper.load((Object[])detailSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
            String matchRuleName = RecPayRuleHelper.getNameByDetailApi(transDetail);
            transDetail.set("rulename", (Object)matchRuleName);
        }
        Arrays.stream(thisSrcDetails).forEach(v -> {
            v.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
            v.set("isreced", (Object)"0");
            v.set("recedbilltype", null);
            v.set("recedbillnumber", null);
            v.set("receredway", null);
            AutoMatchHelper.deleteRecedBillEntry(v);
        });
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])thisSrcDetails);
        }
    }

    private static Set<DynamicObject> filterTheSameNameTrans(DynamicObject[] thisSrcDetail) {
        Set sameNameTransList = Arrays.stream(thisSrcDetail).filter(detail -> DealCasSameTransAndRuleNameHelper.isSynonymDetail(detail, detail.getDynamicObject("accountbank"), detail.getDynamicObject("company"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(sameNameTransList)) {
            return null;
        }
        Set dynamicObjects = sameNameTransList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("oppbanknumber"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        DynamicObjectCollection acctDynamics = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", dynamicObjects.stream().map(a -> a.getString("oppbanknumber")).collect(Collectors.toSet()))});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)acctDynamics)) {
            dynamicObjects = sameNameTransList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("opprelacct"))).collect(Collectors.toSet());
            acctDynamics = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", dynamicObjects.stream().map(a -> a.getString("opprelacct")).collect(Collectors.toSet()))});
        }
        HashMap map = new HashMap(dynamicObjects.size());
        acctDynamics.forEach(e -> map.put(e.getString("bankaccountnumber"), e.getLong("company.id")));
        DynamicObjectCollection thisAccts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("id", "in", dynamicObjects.stream().map(a -> a.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet()))});
        if (CollectionUtils.isEmpty((Collection)thisAccts)) {
            return null;
        }
        HashMap thisMaps = new HashMap(thisAccts.size());
        thisAccts.forEach(e -> thisMaps.put(e.getLong("id"), e.getLong("company.id")));
        return dynamicObjects.stream().filter(e -> (long)(EmptyUtil.isEmpty((Long)((Long)map.get(e.getString("oppbanknumber")))) ? (Long)map.get(e.getString("opprelacct")) : (Long)map.get(e.getString("oppbanknumber"))).compareTo((Long)thisMaps.get(e.getDynamicObject("accountbank").getLong("id"))) == 0L).collect(Collectors.toSet());
    }

    public static boolean isSynonymDetail(DynamicObject transDetail, DynamicObject acctBank, DynamicObject company) {
        String companyName;
        String oppUnit = transDetail.getString("oppunit");
        String oppBankNumber = transDetail.getString("oppbanknumber");
        if (EmptyUtil.isNoEmpty((String)oppUnit)) {
            if (null != acctBank) {
                String openOrgName;
                String acctName = acctBank.getString("acctname");
                if (oppUnit.equals(acctName)) {
                    return true;
                }
                String string = openOrgName = EmptyUtil.isEmpty((DynamicObject)acctBank.getDynamicObject("openorg")) ? "" : acctBank.getDynamicObject("openorg").getString("name");
                if (oppUnit.equals(openOrgName)) {
                    return true;
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)company) && oppUnit.equals(companyName = company.getString("name"))) {
                return true;
            }
        }
        if (EmptyUtil.isNoEmpty((String)oppBankNumber) && EmptyUtil.isNoEmpty((DynamicObject)company)) {
            companyName = company.getString("name");
            QFilter filter = new QFilter("virtualentity.virtualaccount", "=", (Object)oppBankNumber);
            DynamicObject acctBankByVirtual = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company.name", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isNoEmpty((DynamicObject)acctBankByVirtual)) {
                String applyComapny = acctBankByVirtual.getString("company.name");
                return companyName.equals(applyComapny);
            }
            DynamicObject oppAcctBank = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company.name", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)oppBankNumber)});
            if (EmptyUtil.isNoEmpty((DynamicObject)oppAcctBank)) {
                String applyComapny = oppAcctBank.getString("company.name");
                return companyName.equals(applyComapny);
            }
        }
        return false;
    }

    private static Set<DynamicObject> getOtherDetailByThisDetail(DynamicObject thisDetail, String entityName) {
        String detailEntityName = thisDetail.getDataEntityType().getName();
        String otherBotpDetailEntityName = "bei_transdetail_cas";
        if ("bei_intelpay".equalsIgnoreCase(detailEntityName)) {
            otherBotpDetailEntityName = "bei_intelrec";
        } else if ("bei_intelrec".equalsIgnoreCase(detailEntityName)) {
            otherBotpDetailEntityName = "bei_intelpay";
        }
        String thisAmtField = "debitamount";
        String otherAmtField = "creditamount";
        if ("cas_recbill".equals(entityName)) {
            thisAmtField = "creditamount";
            otherAmtField = "debitamount";
        }
        Date bizdate = thisDetail.getDate("bizdate");
        Date thisDateStartDate = DateUtils.getDataFormat((Date)bizdate, (boolean)true);
        Date thisDateEndDate = DateUtils.getDataFormat((Date)bizdate, (boolean)false);
        BigDecimal limitAmt = thisDetail.getBigDecimal(thisAmtField);
        String banknumber = "";
        DynamicObject banknumberObj = thisDetail.getDynamicObject("accountbank");
        if (banknumberObj != null) {
            banknumber = banknumberObj.getString("bankaccountnumber");
        }
        String oppbanknumber = thisDetail.getString("oppbanknumber");
        DynamicObject currency = thisDetail.getDynamicObject("currency");
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)thisDateStartDate).and("bizdate", "<=", (Object)thisDateEndDate);
        QFilter amtFilter = new QFilter(otherAmtField, "=", (Object)limitAmt);
        QFilter oppbankCurrFilter = new QFilter("accountbank.bankaccountnumber", "=", (Object)oppbanknumber);
        String opprelacct = thisDetail.getString("opprelacct");
        if (EmptyUtil.isNoEmpty((String)opprelacct)) {
            oppbankCurrFilter.or("accountbank.bankaccountnumber", "=", (Object)opprelacct);
        }
        if (!EmptyUtil.isEmpty((String)banknumber)) {
            QFilter bankNumberFilter = new QFilter("oppbanknumber", "=", (Object)banknumber);
            bankNumberFilter.or("opprelacct", "=", (Object)banknumber);
            oppbankCurrFilter.and(bankNumberFilter);
        }
        if (!EmptyUtil.isEmpty((DynamicObject)currency)) {
            oppbankCurrFilter.and(new QFilter("currency", "=", currency.getPkValue()));
        }
        QFilter statusFilter = new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue());
        QFilter[] waitRuleFilters = new QFilter[]{dateFilter, amtFilter, statusFilter, oppbankCurrFilter};
        DynamicObject[] otherDetails = BusinessDataServiceHelper.load((String)otherBotpDetailEntityName, (String)("id,billno,company,bizdate,currency,debitamount,creditamount,receredtype,isreced,oppunit,accountbank,recedbillnumber,receredway,recedbilltype,bankcheckflag,oppbanknumber,smartmatch,confirmamount,unconfirmamount," + AutoMatchHelper.getMatchFieldKeys().stream().reduce((s1, s2) -> String.join((CharSequence)",", s1, s2)).orElse("id") + CasDetailInfoExtFieldsHelper.getSrcDetailInfoSelectFields((String)entityName)), (QFilter[])waitRuleFilters);
        return Arrays.stream(otherDetails).filter(detail -> DealCasSameTransAndRuleNameHelper.isSynonymDetail(detail, detail.getDynamicObject("accountbank"), detail.getDynamicObject("company"))).collect(Collectors.toSet());
    }
}

