/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.MatchStatusEnum;
import kd.fi.cas.enums.ReceredtypeEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class HandLinkBillHelper {
    private static final Log logger = LogFactory.getLog(HandLinkBillHelper.class);

    public static void dealHandLink(DynamicObject bizbill) {
        logger.info("dealHandLink is start");
        String entityName = bizbill.getDataEntityType().getName();
        Set detailSrcSet = CasBotpHelper.getSrcBillByDestBill((Long)bizbill.getLong("id"), (String)entityName, (String)"bei_transdetail_cas");
        Set paySet = CasBotpHelper.getSrcBillByDestBill((Long)bizbill.getLong("id"), (String)entityName, (String)"bei_intelpay");
        Set recSet = CasBotpHelper.getSrcBillByDestBill((Long)bizbill.getLong("id"), (String)entityName, (String)"bei_intelrec");
        Set<Long> detailSet = HandLinkBillHelper.mergerSet(detailSrcSet, paySet, recSet);
        if (EmptyUtil.isEmpty(detailSet) || detailSet.size() <= 0) {
            return;
        }
        DynamicObject[] thisSrcDetails = BusinessDataServiceHelper.load((Object[])detailSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        Set<DynamicObject> ishanglinkData = Arrays.stream(thisSrcDetails).filter(o -> o.getBoolean("ishandlink") || "beipay".equals(o.getString("receredway")) && "fromifm".equals(o.getString("datasource"))).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(ishanglinkData) || ishanglinkData.size() <= 0) {
            logger.info("ishanglinkDataSet is null");
            return;
        }
        for (DynamicObject ishanglinkDatum : ishanglinkData) {
            Map rectargetBills;
            Map paytargetBills;
            Map detailtargetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_transdetail_cas", (Long[])new Long[]{(Long)ishanglinkDatum.getPkValue()});
            Map<String, HashSet<Long>> targetBills = HandLinkBillHelper.mergerMap(detailtargetBills, paytargetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_intelpay", (Long[])new Long[]{(Long)ishanglinkDatum.getPkValue()}), rectargetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_intelrec", (Long[])new Long[]{(Long)ishanglinkDatum.getPkValue()}));
            if (targetBills.size() > 1 || targetBills.get(entityName).size() > 1) {
                logger.info("targetBills is not null");
                String recedbillnumber = ishanglinkDatum.getString("recedbillnumber");
                String billno = bizbill.getString("billno");
                recedbillnumber = HandLinkBillHelper.dealBankcheckflag(billno, recedbillnumber);
                ishanglinkDatum.set("recedbillnumber", (Object)recedbillnumber);
            } else {
                logger.info("targetBills is null");
                ishanglinkDatum.set("ishandlink", (Object)"0");
                ishanglinkDatum.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
                ishanglinkDatum.set("receredway", null);
                ishanglinkDatum.set("recedbillnumber", null);
            }
            AutoMatchHelper.deleteRecedBillEntry(ishanglinkDatum, bizbill.getString("billno"));
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])ishanglinkData.toArray(new DynamicObject[ishanglinkData.size()]));
        }
        if ("cas_exchangebill".equals(entityName)) {
            tx = TX.requiresNew();
            var9_9 = null;
            try {
                CasBotpHelper.deleteRation((Object)bizbill.getPkValue(), (String[])new String[0]);
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var9_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    public static void bankStatementWritBankJournal(Set<Long> bankStatement, Set<Long> bankJournal) {
        DynamicObject[] billnos;
        if (bankStatement.size() < 1 || bankJournal.size() < 1) {
            return;
        }
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)"id,bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", bankStatement)});
        Date bizdate = Arrays.stream(ids).map(o -> o.getDate("bizdate")).filter(o -> CasHelper.isNotEmpty((Object)o)).reduce((a, b) -> a.compareTo((Date)b) > 0 ? a : b).orElse(null);
        DynamicObject[] jourals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,tracedate,sourcebillnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", bankJournal), new QFilter("sourcebilltype", "=", (Object)"cas_agentpaybill")});
        ArrayList<String> agentBillNos = new ArrayList<String>();
        for (DynamicObject joural : jourals) {
            if (!CasHelper.isEmpty((Object)joural.getDate("tracedate"))) continue;
            joural.set("tracedate", (Object)bizdate);
            agentBillNos.add(joural.getString("sourcebillnumber"));
        }
        for (DynamicObject billno : billnos = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,isagencypersonpay,paytime,entry,entry.e_paytime,acttradedate", (QFilter[])new QFilter[]{new QFilter("billno", "in", agentBillNos)})) {
            if (!billno.getBoolean("isagencypersonpay")) {
                DynamicObjectCollection entry = billno.getDynamicObjectCollection("entry");
                for (DynamicObject dynamicObject : entry) {
                    dynamicObject.set("e_paytime", (Object)bizdate);
                }
            }
            billno.set("acttradedate", (Object)bizdate);
        }
        SaveServiceHelper.save((DynamicObject[])jourals);
        SaveServiceHelper.save((DynamicObject[])billnos);
    }

    public static void dealHandLinkAndMatchAndAccount(String handlink, String matchlink, String bizType, Object bizId) {
        DynamicObject[] detailDatas;
        ArrayList<Object> detailIds = new ArrayList<Object>();
        Set handlinkSet = null;
        ArrayList<String> bankcheckflagList = new ArrayList<String>();
        Object matchId = null;
        if (CasHelper.isNotEmpty((Object)handlink)) {
            handlinkSet = (Set)JSON.parseObject((String)handlink, Set.class);
            detailIds.addAll(handlinkSet);
        }
        if (CasHelper.isNotEmpty((Object)matchlink)) {
            matchId = JSON.parseObject((String)matchlink, Object.class);
            detailIds.add(matchId);
        }
        DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((Object)bizId, (String)bizType);
        for (DynamicObject detailData : detailDatas = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,ishandlink,bankcheckflag,receredtype,isreced,smartmatch,recedbillnumber,autorecorpay,recedbilltype,accountbank,currency,recedbillnumber,receredway", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)})) {
            Long pkValue = (Long)detailData.getPkValue();
            bankcheckflagList.add(detailData.getString("bankcheckflag"));
            AutoMatchHelper.deleteRecedBillEntry(detailData, bizBill.getString("billno"));
            if (CasHelper.isNotEmpty((Object)handlinkSet) && handlinkSet.contains(pkValue)) {
                Map paytargetBills;
                Map rectargetBills;
                Map detailtargetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_transdetail_cas", (Long[])new Long[]{pkValue});
                Map<String, HashSet<Long>> targetBills = HandLinkBillHelper.mergerMap(detailtargetBills, rectargetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_intelrec", (Long[])new Long[]{pkValue}), paytargetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_intelpay", (Long[])new Long[]{pkValue}));
                if (CasHelper.isNotEmpty(targetBills) && (targetBills.size() > 1 || targetBills.get(bizType).size() > 1)) {
                    String recedbillnumber = detailData.getString("recedbillnumber");
                    String billno = bizBill.getString("billno");
                    recedbillnumber = HandLinkBillHelper.dealBankcheckflag(billno, recedbillnumber);
                    detailData.set("recedbillnumber", (Object)recedbillnumber);
                    continue;
                }
                if (detailData.getDynamicObjectCollection("recedbillentry").size() > 0) continue;
                detailData.set("ishandlink", (Object)"0");
                detailData.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
                detailData.set("receredway", null);
                detailData.set("recedbillnumber", null);
            }
            if ((!CasHelper.isNotEmpty((Object)matchId) || pkValue.compareTo((Long)matchId) != 0) && !detailData.getBoolean("smartmatch")) continue;
            detailData.set("smartmatch", (Object)MatchStatusEnum.UNSMARTMATCH.getValue());
            detailData.set("recedbillnumber", null);
            detailData.set("autorecorpay", (Object)false);
            detailData.set("recedbilltype", null);
            Boolean autorecorpay = detailData.getBoolean("autorecorpay");
            if (!autorecorpay.booleanValue() || !BillStatusEnum.PAY.getValue().equals(bizBill.getString("billstatus")) || !"cas_paybill".equals(bizType) && !"cas_recbill".equals(bizType)) continue;
            OperateServiceHelper.execOperate((String)("cas_paybill".equals(bizType) ? "cancelpay" : "cancelrec"), (String)bizType, (Object[])new Object[]{bizId}, (OperateOption)OperateOption.create(), (boolean)true);
        }
        String bankcheckflag = bizBill.getString("bankcheckflag_tag");
        for (String detailBankcheckflag : bankcheckflagList) {
            bankcheckflag = HandLinkBillHelper.dealBankcheckflag(detailBankcheckflag, bankcheckflag);
        }
        bizBill.set("bankcheckflag", (Object)CasHelper.subFlag((String)bankcheckflag));
        bizBill.set("bankcheckflag_tag", (Object)bankcheckflag);
        DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,creditamount,sourcebillid,tracedate", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", bizId)});
        try (TXHandle tx = TX.requiresNew();){
            if (CasHelper.isNotEmpty((Object)bankjournals) && bankjournals.length > 0) {
                bankjournals[0].set("bankcheckflag", (Object)CasHelper.subFlag((String)bankcheckflag));
                bankjournals[0].set("bankcheckflag_tag", (Object)bankcheckflag);
                bankjournals[0].set("tracedate", null);
                bankjournals[0].set("batchno", (Object)bankcheckflag);
                SaveServiceHelper.save((DynamicObject[])bankjournals);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizBill});
        }
        tx = TX.requiresNew();
        var13_16 = null;
        try {
            SaveServiceHelper.save((DynamicObject[])detailDatas);
        }
        catch (Throwable throwable) {
            var13_16 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var13_16 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var13_16.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = TX.requiresNew();
        var13_16 = null;
        try {
            CasBotpHelper.deleteRation((Object)bizId, (String[])new String[0]);
        }
        catch (Throwable throwable) {
            var13_16 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var13_16 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var13_16.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public static void dealHandLinkExChange(String handlink, String bizType, Object bizId) {
        HashSet handlinkSet = new HashSet(10);
        if (!CasHelper.isNotEmpty((Object)handlink)) {
            return;
        }
        handlinkSet.addAll((Collection)JSON.parseObject((String)handlink, Set.class));
        DynamicObject bussBill = BusinessDataServiceHelper.loadSingle((Object)bizId, (String)bizType);
        DynamicObject[] detailDatas = BusinessDataServiceHelper.load((Object[])handlinkSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,creditamount,sourcebillid,tracedate", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", bizId)});
        String sellingbankcheckflag = bussBill.getString("sellingbankcheckflag");
        String feebankcheckflag = bussBill.getString("feebankcheckflag");
        String buybankcheckflag = bussBill.getString("buybankcheckflag");
        BigDecimal buyAmount = bussBill.getBigDecimal("buyamount");
        BigDecimal sellMount = bussBill.getBigDecimal("sellamount");
        BigDecimal feeMount = bussBill.getBigDecimal("commissionamount");
        for (DynamicObject detailData : detailDatas) {
            Map targetBills;
            Long pkValue = (Long)detailData.getPkValue();
            String bankcheckflag = detailData.getString("bankcheckflag");
            if (buybankcheckflag.contains(bankcheckflag)) {
                buybankcheckflag = HandLinkBillHelper.dealBankcheckflag(bankcheckflag, buybankcheckflag);
                bussBill.set("buybankcheckflag", (Object)sellingbankcheckflag);
            }
            if (sellingbankcheckflag.contains(bankcheckflag)) {
                sellingbankcheckflag = HandLinkBillHelper.dealBankcheckflag(bankcheckflag, sellingbankcheckflag);
                bussBill.set("sellingbankcheckflag", (Object)sellingbankcheckflag);
            }
            if (feebankcheckflag.contains(bankcheckflag)) {
                feebankcheckflag = HandLinkBillHelper.dealBankcheckflag(bankcheckflag, feebankcheckflag);
                bussBill.set("feebankcheckflag", (Object)feebankcheckflag);
            }
            Long accountBankId = (Long)detailData.getDynamicObject("accountbank").getPkValue();
            Long currencyId = (Long)detailData.getDynamicObject("currency").getPkValue();
            if (bankjournals.length > 0) {
                for (DynamicObject bankjournal : bankjournals) {
                    Long sourcebillid = bankjournal.getLong("sourcebillid");
                    if (sourcebillid.compareTo((Long)bussBill.getPkValue()) != 0) continue;
                    Long accountbankjournal = (Long)bankjournal.getDynamicObject("accountbank").getPkValue();
                    Long currencyjournal = (Long)bankjournal.getDynamicObject("currency").getPkValue();
                    if (accountbankjournal.compareTo(accountBankId) != 0 || currencyjournal.compareTo(currencyId) != 0) continue;
                    BigDecimal creditamount = bankjournal.getBigDecimal("creditamount");
                    if (sellMount.compareTo(BigDecimal.ZERO) != 0 && sellMount.compareTo(creditamount) == 0) {
                        bankjournal.set("bankcheckflag", (Object)CasHelper.subFlag((String)sellingbankcheckflag));
                        bankjournal.set("bankcheckflag_tag", (Object)sellingbankcheckflag);
                        bankjournal.set("tracedate", null);
                        continue;
                    }
                    if (feeMount.compareTo(BigDecimal.ZERO) != 0 && feeMount.compareTo(creditamount) == 0) {
                        bankjournal.set("bankcheckflag", (Object)CasHelper.subFlag((String)feebankcheckflag));
                        bankjournal.set("bankcheckflag_tag", (Object)feebankcheckflag);
                        bankjournal.set("tracedate", null);
                        continue;
                    }
                    if (accountbankjournal.compareTo(accountBankId) != 0 || currencyjournal.compareTo(currencyId) != 0 || buyAmount.compareTo(BigDecimal.ZERO) == 0 || buyAmount.compareTo(creditamount) != 0) continue;
                    bankjournal.set("bankcheckflag", (Object)CasHelper.subFlag((String)sellingbankcheckflag));
                    bankjournal.set("bankcheckflag_tag", (Object)sellingbankcheckflag);
                    bankjournal.set("tracedate", null);
                }
            }
            AutoMatchHelper.deleteRecedBillEntry(detailData, bussBill.getString("billno"));
            if (CasHelper.isNotEmpty(handlinkSet) && handlinkSet.contains(pkValue) && CasHelper.isNotEmpty((Object)(targetBills = BFTrackerServiceHelper.findTargetBills((String)"bei_transdetail_cas", (Long[])new Long[]{pkValue}))) && (targetBills.size() > 1 || CasHelper.isNotEmpty(targetBills.get(bizType)) && ((HashSet)targetBills.get(bizType)).size() > 1)) {
                String recedbillnumber = detailData.getString("recedbillnumber");
                String billno = bussBill.getString("billno");
                recedbillnumber = HandLinkBillHelper.dealBankcheckflag(billno, recedbillnumber);
                detailData.set("recedbillnumber", (Object)recedbillnumber);
                continue;
            }
            if (detailData.getDynamicObjectCollection("recedbillentry").size() > 0) continue;
            detailData.set("ishandlink", (Object)"0");
            detailData.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
            detailData.set("recedbillnumber", null);
            detailData.set("receredway", null);
        }
        bussBill.set("acttradedate", null);
        CasBotpHelper.deleteRation((Object)bizId, (String[])new String[0]);
        if (bankjournals.length > 0) {
            SaveServiceHelper.save((DynamicObject[])bankjournals);
        }
        SaveServiceHelper.save((DynamicObject[])detailDatas);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bussBill});
    }

    private static String dealBankcheckflag(String detailFlag, String bussFlag) {
        if (bussFlag != null) {
            if (bussFlag.equals(detailFlag)) {
                return null;
            }
            if (bussFlag.startsWith(detailFlag)) {
                return bussFlag.replace(detailFlag + ",", "");
            }
            if (bussFlag.contains(detailFlag)) {
                return bussFlag.replace("," + detailFlag, "");
            }
        }
        return bussFlag;
    }

    public static Boolean recognitionBillChange(BigDecimal newactpayamt, BigDecimal oldctpayamt) {
        if (CasHelper.isEmpty((Object)newactpayamt) || CasHelper.isEmpty((Object)oldctpayamt) || newactpayamt.compareTo(oldctpayamt) != 0) {
            return true;
        }
        return false;
    }

    public static Boolean recognitionBillChange(DynamicObject newactpayamt, DynamicObject oldctpayamt) {
        return CasHelper.isEmpty((Object)newactpayamt) || CasHelper.isEmpty((Object)oldctpayamt) || !newactpayamt.getPkValue().equals(oldctpayamt.getPkValue());
    }

    public static Map<String, HashSet<Long>> mergerMap(Map<String, HashSet<Long>> targetBills, Map<String, HashSet<Long>> newTargetBills, Map<String, HashSet<Long>> recTargetBills) {
        HashMap<String, HashSet<Long>> returnMap = new HashMap<String, HashSet<Long>>();
        if (CasHelper.isNotEmpty(newTargetBills) && newTargetBills.size() > 0) {
            returnMap.putAll(newTargetBills);
        }
        HandLinkBillHelper.dealBill(returnMap, targetBills);
        HandLinkBillHelper.dealBill(returnMap, recTargetBills);
        return returnMap;
    }

    private static void dealBill(Map<String, HashSet<Long>> returnMap, Map<String, HashSet<Long>> recTargetBills) {
        if (CasHelper.isNotEmpty(recTargetBills) && recTargetBills.size() > 0) {
            for (Map.Entry<String, HashSet<Long>> setEntry : recTargetBills.entrySet()) {
                String key = setEntry.getKey();
                HashSet<Long> set = returnMap.get(key);
                if (CasHelper.isEmpty(set)) {
                    returnMap.put(key, setEntry.getValue());
                    continue;
                }
                set.addAll((Collection<Long>)setEntry.getValue());
                returnMap.put(key, set);
            }
        }
    }

    public static Set<Long> mergerSet(Set<Long> srcBillByDestBill, Set<Long> paysrcBillByDestBill, Set<Long> recsrcBillByDestBill) {
        HashSet<Long> set = new HashSet<Long>();
        if (CasHelper.isNotEmpty(srcBillByDestBill)) {
            set.addAll(srcBillByDestBill);
        }
        if (CasHelper.isNotEmpty(paysrcBillByDestBill)) {
            set.addAll(paysrcBillByDestBill);
        }
        if (CasHelper.isNotEmpty(recsrcBillByDestBill)) {
            set.addAll(recsrcBillByDestBill);
        }
        return set;
    }

    public static Set<Long> showBotpRtansDetails(ListSelectedRowCollection selectedRows, String entityId) {
        HashSet<Long> idsSetAll = new HashSet<Long>(10);
        if (CasHelper.isNotEmpty((Object)selectedRows) && !selectedRows.isEmpty()) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            ArrayList<Long> billIdsBankCheck = new ArrayList<Long>(10);
            for (Object object : primaryKeyValues) {
                Long pkId = (Long)object;
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (!idsSet.isEmpty()) {
                    idsSetAll.addAll(idsSet);
                    continue;
                }
                billIdsBankCheck.add((Long)object);
            }
            QFilter idQf = new QFilter("id", "in", billIdsBankCheck);
            if ("cas_paybill".equals(entityId)) {
                DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{idQf});
                Set<Long> detailIds = HandLinkBillHelper.getDetailIds(entityId, bizBills);
                if (detailIds != null && detailIds.size() > 0) {
                    idsSetAll.addAll(detailIds);
                }
            } else if ("cas_agentpaybill".equals(entityId)) {
                DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,entry,entry.e_bankcheckflag", (QFilter[])new QFilter[]{idQf});
                Set<Long> detailIds = HandLinkBillHelper.getDetailIds(entityId, bizBills);
                if (detailIds != null && detailIds.size() > 0) {
                    idsSetAll.addAll(detailIds);
                }
            } else if ("cas_exchangebill".equals(entityId)) {
                QFilter qFilter;
                DynamicObject[] ids;
                Set collect;
                DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,buybankcheckflag,sellingbankcheckflag,feebankcheckflag", (QFilter[])new QFilter[]{idQf});
                List<String> list = new ArrayList<String>();
                for (DynamicObject bizBill : bizBills) {
                    String buybankcheckflag = bizBill.getString("buybankcheckflag");
                    String sellingbankcheckflag = bizBill.getString("sellingbankcheckflag");
                    String feebankcheckflag = bizBill.getString("feebankcheckflag");
                    list = HandLinkBillHelper.getbankcheckflagList(list, buybankcheckflag);
                    list = HandLinkBillHelper.getbankcheckflagList(list, sellingbankcheckflag);
                    list = HandLinkBillHelper.getbankcheckflagList(list, feebankcheckflag);
                }
                if (list.size() > 0 && CasHelper.isNotEmpty(collect = Arrays.stream(ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("bankcheckflag", "in", list)})).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())) && collect.size() > 0) {
                    idsSetAll.addAll(collect);
                }
            }
        }
        return idsSetAll;
    }

    public static String getBankCheckFlagNoDetail(ListSelectedRowCollection selectedRows, String entityId) {
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)selectedRows) && selectedRows.size() > 0) {
            DynamicObject[] entityDyObjs;
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            for (DynamicObject dyObj : entityDyObjs = BusinessDataServiceHelper.load((String)entityId, (String)"id,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                Long pkId = dyObj.getLong("id");
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (!idsSet.isEmpty()) continue;
                DynamicObjectCollection entryEntity = dyObj.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject entry : entryEntity) {
                    bankCheckFlags.add(entry.getString("ebankcheckflag"));
                }
            }
        }
        if (bankCheckFlags.isEmpty()) {
            return "";
        }
        return StringUtils.join(bankCheckFlags, (String)",");
    }

    public static String getBankCheckFlagNoDetail1(ListSelectedRowCollection selectedRows, String entityId) {
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)selectedRows) && selectedRows.size() > 0) {
            DynamicObject[] entityDyObjs;
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            for (DynamicObject dyObj : entityDyObjs = BusinessDataServiceHelper.load((String)entityId, (String)"id,buybankcheckflag,sellingbankcheckflag,feebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                Long pkId = dyObj.getLong("id");
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() != 0) continue;
                String buybankcheckflag = dyObj.getString("buybankcheckflag");
                String sellingbankcheckflag = dyObj.getString("sellingbankcheckflag");
                String feebankcheckflag = dyObj.getString("feebankcheckflag");
                if (StringUtils.isNotEmpty((String)buybankcheckflag)) {
                    bankCheckFlags.add(buybankcheckflag);
                }
                if (StringUtils.isNotEmpty((String)sellingbankcheckflag)) {
                    bankCheckFlags.add(sellingbankcheckflag);
                }
                if (!StringUtils.isNotEmpty((String)feebankcheckflag)) continue;
                bankCheckFlags.add(feebankcheckflag);
            }
        }
        String bankCheckFlag = StringUtils.join(bankCheckFlags, (String)",");
        return bankCheckFlag;
    }

    public static Set<Long> getBotpRtansDetails(Long pkId, String entityId) {
        DynamicObjectCollection transDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,receredway,debitamount,creditamount,recedbillentry.e_recedbillid", (QFilter[])new QFilter("recedbillentry.e_recedbillid", "=", (Object)pkId).and(new QFilter("recedbillentry.e_recedbilltype", "=", (Object)entityId)).toArray());
        if (CasHelper.isNotEmpty((Object)transDetails)) {
            return transDetails.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    public static List<String> getReceiptNoByDetails(ListSelectedRowCollection selectedRows, String entityId) {
        List<String> receiptNos = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)selectedRows) && !selectedRows.isEmpty()) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            HashSet<Long> detailIds = new HashSet<Long>(10);
            HashSet<Long> selectdIds = new HashSet<Long>(10);
            for (Object primaryKeyValue : primaryKeyValues) {
                Long pkId = (Long)primaryKeyValue;
                selectdIds.add(pkId);
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.isEmpty()) continue;
                detailIds.addAll(idsSet);
            }
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = details.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
            if (!selectdIds.isEmpty()) {
                if ("cas_recbill".equalsIgnoreCase(entityId)) {
                    DynamicObject[] selectBills = BusinessDataServiceHelper.load((Object[])selectdIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId));
                    receiptNos = HandLinkBillHelper.getBankReceipts(selectBills, receiptNos, "accountbank", Boolean.FALSE);
                } else if ("cas_paybill".equalsIgnoreCase(entityId)) {
                    DynamicObject[] selectBills = BusinessDataServiceHelper.load((Object[])selectdIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId));
                    receiptNos = HandLinkBillHelper.getBankReceipts(selectBills, receiptNos, "payeracctbank", Boolean.TRUE);
                }
            }
        }
        return receiptNos;
    }

    public static List<String> getBankReceipts(DynamicObject[] selectBills, List<String> receiptNos, String bankName, Boolean isPay) {
        Object result;
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject bill : selectBills) {
            DynamicObject accountBankDy = bill.getDynamicObject(bankName);
            if (accountBankDy == null) continue;
            accountBankDy = BusinessDataServiceHelper.loadSingle((Object)accountBankDy.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"));
            String finorgType = accountBankDy.getString("finorgtype");
            Boolean authQuerpt = accountBankDy.getBoolean("authquerpt");
            if (!"1".equalsIgnoreCase(finorgType) || !authQuerpt.booleanValue()) continue;
            long id = (Long)bill.getPkValue();
            ids.add(id);
        }
        if (ids.size() > 0 && (result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"queryBankReceiptService", (String)"getBankReceipts", (Object[])new Object[]{ids, isPay})) != null) {
            Set bankReceipts = (Set)result;
            receiptNos.addAll(bankReceipts);
        }
        return receiptNos;
    }

    public static Set<Long> showBotpRtansDetails(Object[] primaryKeyValues, String entityId) {
        HashSet<Long> idsSetAll = new HashSet<Long>(10);
        ArrayList<Long> billIdsBankCheck = new ArrayList<Long>(10);
        for (Object object : primaryKeyValues) {
            Long pkId = (Long)object;
            Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
            if (idsSet.size() > 0) {
                idsSetAll.addAll(idsSet);
            }
            if (idsSet.size() != 0) continue;
            billIdsBankCheck.add((Long)object);
        }
        QFilter idQf = new QFilter("id", "in", billIdsBankCheck);
        if ("cas_paybill".equals(entityId)) {
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,bankcheckentity.ebankcheckflag,bankcheckflag_tag", (QFilter[])new QFilter[]{idQf});
            Set<Long> detailIds = HandLinkBillHelper.getDetailIds(entityId, bizBills);
            if (detailIds != null && detailIds.size() > 0) {
                idsSetAll.addAll(detailIds);
            }
        } else if ("cas_agentpaybill".equals(entityId)) {
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,entry,entry.e_bankcheckflag", (QFilter[])new QFilter[]{idQf});
            Set<Long> detailIds = HandLinkBillHelper.getDetailIds(entityId, bizBills);
            if (detailIds != null && detailIds.size() > 0) {
                idsSetAll.addAll(detailIds);
            }
        } else if ("cas_exchangebill".equals(entityId)) {
            QFilter qFilter;
            DynamicObject[] ids;
            Set collect;
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,buybankcheckflag,sellingbankcheckflag,feebankcheckflag", (QFilter[])new QFilter[]{idQf});
            List<String> list = new ArrayList<String>();
            for (DynamicObject bizBill : bizBills) {
                String buybankcheckflag = bizBill.getString("buybankcheckflag");
                String sellingbankcheckflag = bizBill.getString("sellingbankcheckflag");
                String feebankcheckflag = bizBill.getString("feebankcheckflag");
                list = HandLinkBillHelper.getbankcheckflagList(list, buybankcheckflag);
                list = HandLinkBillHelper.getbankcheckflagList(list, sellingbankcheckflag);
                list = HandLinkBillHelper.getbankcheckflagList(list, feebankcheckflag);
            }
            if (list.size() > 0 && CasHelper.isNotEmpty(collect = Arrays.stream(ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("bankcheckflag", "in", list)})).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())) && collect.size() > 0) {
                idsSetAll.addAll(collect);
            }
        }
        return idsSetAll;
    }

    public static String getBankCheckFlagNoDetail(Object[] primaryKeyValues, String entityId) {
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)primaryKeyValues) && primaryKeyValues.length > 0) {
            DynamicObject[] entityDyObjs;
            for (DynamicObject dyObj : entityDyObjs = BusinessDataServiceHelper.load((String)entityId, (String)"id,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                Long pkId = dyObj.getLong("id");
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() != 0) continue;
                DynamicObjectCollection entryEntity = dyObj.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject entry : entryEntity) {
                    bankCheckFlags.add(entry.getString("ebankcheckflag"));
                }
            }
        }
        String bankCheckFlag = StringUtils.join(bankCheckFlags, (String)",");
        return bankCheckFlag;
    }

    public static List<String> getReceiptNoByDetails(Object[] primaryKeyValues, String entityId) {
        List<String> receiptNos = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)primaryKeyValues) && primaryKeyValues.length > 0) {
            HashSet<Long> detailIds = new HashSet<Long>(10);
            for (Object primaryKeyValue : primaryKeyValues) {
                Long pkId = (Long)primaryKeyValue;
                Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() <= 0) continue;
                detailIds.addAll(idsSet);
            }
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = details.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        }
        return receiptNos;
    }

    public static Set<Long> showBotpRtansDetails(DynamicObject bizBill, String entityId) {
        HashSet<Long> idsSetAll = new HashSet<Long>(10);
        if (CasHelper.isNotEmpty((Object)bizBill)) {
            Set collect;
            DynamicObject[] ids;
            QFilter bankcheckflagQf;
            Long pkId = (Long)bizBill.getPkValue();
            Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
            if (idsSet.size() > 0) {
                idsSetAll.addAll(idsSet);
                return idsSetAll;
            }
            List<String> list = new ArrayList<String>();
            if ("cas_paybill".equals(entityId) || "cas_agentpaybill".equals(entityId)) {
                String bankcheckflag = bizBill.getString("bankcheckflag_tag");
                list = HandLinkBillHelper.getbankcheckflagList(list, bankcheckflag);
            }
            if (list.size() > 0) {
                bankcheckflagQf = new QFilter("bankcheckflag", "in", list);
                ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{bankcheckflagQf});
                Set detailIds = Arrays.stream(ids).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
                if (CasHelper.isNotEmpty(detailIds) && detailIds.size() > 0) {
                    idsSetAll.addAll(detailIds);
                }
            } else if ("cas_exchangebill".equals(entityId)) {
                String buybankcheckflag = bizBill.getString("buybankcheckflag");
                String sellingbankcheckflag = bizBill.getString("sellingbankcheckflag");
                String feebankcheckflag = bizBill.getString("feebankcheckflag");
                list = HandLinkBillHelper.getbankcheckflagList(list, buybankcheckflag);
                list = HandLinkBillHelper.getbankcheckflagList(list, sellingbankcheckflag);
                list = HandLinkBillHelper.getbankcheckflagList(list, feebankcheckflag);
            }
            if (list.size() > 0 && CasHelper.isNotEmpty(collect = Arrays.stream(ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{bankcheckflagQf = new QFilter("bankcheckflag", "in", list)})).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())) && collect.size() > 0) {
                idsSetAll.addAll(collect);
            }
        }
        return idsSetAll;
    }

    public static String getBankCheckFlagNoDetail(DynamicObject bizBill, String entityId) {
        Set<Long> idsSet;
        DynamicObject entityDyObjs;
        String bankCheckFlag = null;
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)bizBill) && (entityDyObjs = BusinessDataServiceHelper.loadSingle((String)entityId, (String)"id,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "=", bizBill.getPkValue())})) != null && ((idsSet = HandLinkBillHelper.getBotpRtansDetails((Long)entityDyObjs.getPkValue(), entityId)) == null || idsSet.size() == 0)) {
            DynamicObjectCollection entryEntity = entityDyObjs.getDynamicObjectCollection("bankcheckentity");
            for (DynamicObject entry : entryEntity) {
                bankCheckFlags.add(entry.getString("ebankcheckflag"));
            }
        }
        bankCheckFlag = StringUtils.join(bankCheckFlags, (String)",");
        return bankCheckFlag;
    }

    public static String getBankCheckFlagNoDetail1(DynamicObject bizBill, String entityId) {
        Set<Long> idsSet;
        DynamicObject[] entityDyObjs;
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        String bankCheckFlag = null;
        if (CasHelper.isNotEmpty((Object)bizBill) && (entityDyObjs = BusinessDataServiceHelper.load((String)entityId, (String)"id,buybankcheckflag,sellingbankcheckflag,feebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "=", bizBill.getPkValue())})) != null && entityDyObjs.length >= 1 && ((idsSet = HandLinkBillHelper.getBotpRtansDetails((Long)entityDyObjs[0].getPkValue(), entityId)) == null || idsSet.size() == 0)) {
            String buybankcheckflag = entityDyObjs[0].getString("buybankcheckflag");
            String sellingbankcheckflag = entityDyObjs[0].getString("sellingbankcheckflag");
            String feebankcheckflag = entityDyObjs[0].getString("feebankcheckflag");
            if (StringUtils.isNotEmpty((String)buybankcheckflag)) {
                bankCheckFlags.add(buybankcheckflag);
            }
            if (StringUtils.isNotEmpty((String)sellingbankcheckflag)) {
                bankCheckFlags.add(sellingbankcheckflag);
            }
            if (StringUtils.isNotEmpty((String)feebankcheckflag)) {
                bankCheckFlags.add(feebankcheckflag);
            }
        }
        bankCheckFlag = StringUtils.join(bankCheckFlags, (String)",");
        return bankCheckFlag;
    }

    public static List<String> getReceiptNoByDetails(DynamicObject bizBill, String entityId) {
        List<String> receiptNos = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty((Object)bizBill)) {
            HashSet<Long> detailIds = new HashSet<Long>(10);
            Long pkId = (Long)bizBill.getPkValue();
            Set<Long> idsSet = HandLinkBillHelper.getBotpRtansDetails(pkId, entityId);
            if (idsSet.isEmpty()) {
                return receiptNos;
            }
            detailIds.addAll(idsSet);
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = details.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        }
        return receiptNos;
    }

    private static Set<Long> getDetailIds(String entityId, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return null;
        }
        List<String> list = new ArrayList<String>(bizBills.length);
        for (DynamicObject bizBill : bizBills) {
            String e_bankcheckflag;
            DynamicObjectCollection entrys;
            String bankcheckflag = "";
            if ("cas_paybill".equals(entityId)) {
                entrys = bizBill.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject row : entrys) {
                    e_bankcheckflag = row.getString("ebankcheckflag");
                    if (!CasHelper.isNotEmpty((Object)e_bankcheckflag)) continue;
                    list = HandLinkBillHelper.getbankcheckflagList(list, bankcheckflag);
                }
                continue;
            }
            entrys = bizBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entrys) {
                e_bankcheckflag = row.getString("e_bankcheckflag");
                if (!CasHelper.isNotEmpty((Object)e_bankcheckflag)) continue;
                list = HandLinkBillHelper.getbankcheckflagList(list, bankcheckflag);
            }
        }
        if (list.size() > 0) {
            QFilter bankcheckflagQf = new QFilter("bankcheckflag", "in", list);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{bankcheckflagQf});
            Set<Long> collect = Arrays.stream(ids).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
            return collect;
        }
        return null;
    }

    private static List<String> getbankcheckflagList(List<String> list, String bankcheckflag) {
        if (CasHelper.isNotEmpty((Object)bankcheckflag)) {
            if (bankcheckflag.contains(",")) {
                String[] split = bankcheckflag.split(",");
                Collections.addAll(list, split);
            } else {
                list.add(bankcheckflag);
            }
        }
        return list;
    }
}

