/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.fi.cas.business.opservice.helper.RecSaleServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class PaymentSaleServiceHelper {
    public static void convertPur(DynamicObject[] infos, boolean isPay) {
        ECSession dtxSession;
        ArrayList<Map<String, Object>> purMapList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> contractMapList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> scpMapList = new ArrayList<Map<String, Object>>();
        CommonParam purParam = new CommonParam();
        CommonParam conParam = new CommonParam();
        CommonParam scpParam = new CommonParam();
        block10: for (DynamicObject info : infos) {
            String sourceBillType = info.getString("sourcebilltype");
            if (CasHelper.isEmpty((Object)sourceBillType)) continue;
            switch (sourceBillType) {
                case "pm_purorderbill": {
                    PaymentSaleServiceHelper.getPurOrScpMap(isPay, purMapList, info);
                    PaymentSaleServiceHelper.getConMap(isPay, contractMapList, info, sourceBillType);
                    continue block10;
                }
                case "conm_purcontract": {
                    PaymentSaleServiceHelper.getConMap(isPay, contractMapList, info, sourceBillType);
                    continue block10;
                }
                case "sctm_scpo": {
                    PaymentSaleServiceHelper.getPurOrScpMap(isPay, scpMapList, info);
                    continue block10;
                }
            }
        }
        purParam.put((Object)"list", purMapList);
        conParam.put((Object)"method", (Object)"wbPurContAmount");
        conParam.put((Object)"list", contractMapList);
        scpParam.put((Object)"list", scpMapList);
        if (CasHelper.isNotEmpty((Object)purParam) && purMapList.size() > 0) {
            dtxSession = (ECSession)DtxContext.getDtxSession();
            if (null == dtxSession) {
                ECGlobalSession.begin((String)"pay_wbpuramount", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            }
            ECGlobalSession.register((String)"scmc", (String)"pm", (String)"WbPayPlanPayAmountService", (Param)purParam, null, (String)"");
        }
        if (CasHelper.isNotEmpty((Object)conParam) && contractMapList.size() > 0) {
            dtxSession = (ECSession)DtxContext.getDtxSession();
            if (null == dtxSession) {
                ECGlobalSession.begin((String)"pay_wbconamount", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            }
            ECGlobalSession.register((String)"scmc", (String)"conm", (String)"PurConmService", (Param)conParam, null, (String)"");
        }
        if (CasHelper.isNotEmpty((Object)scpParam) && scpMapList.size() > 0) {
            dtxSession = (ECSession)DtxContext.getDtxSession();
            if (null == dtxSession) {
                ECGlobalSession.begin((String)"pay_wbplanamount", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            }
            ECGlobalSession.register((String)"scmc", (String)"sctm", (String)"WbPayPlanPayAmount4SctmService", (Param)scpParam, null, (String)"");
        }
    }

    private static void getConMap(boolean isPay, List<Map<String, Object>> contractMapList, DynamicObject info, String sourceBillType) {
        long payee = info.getLong("payee");
        DynamicObjectCollection collectionEntry = info.getDynamicObjectCollection("entry");
        for (DynamicObject entry : collectionEntry) {
            HashMap<String, Object> contractMap = new HashMap<String, Object>();
            contractMap.put("srcBillEntity", sourceBillType);
            contractMap.put("mainBillEntity", entry.getString("e_corebilltype"));
            contractMap.put("mainBillID", entry.getLong("e_corebillid"));
            contractMap.put("mainBillEntryID", entry.getLong("e_corebillentryid"));
            contractMap.put("contractID", entry.getLong("conbillid"));
            contractMap.put("contractEntryID", entry.getLong("conbillentryid"));
            contractMap.put("asstactID", payee);
            contractMap.put("internalAsst", RecSaleServiceHelper.isExistInternalBusinessUnit(info.getString("payeetype"), payee));
            DynamicObject settleOrg = entry.getDynamicObject("settleorg");
            Long settleOrgID = CasHelper.isNotEmpty((Object)settleOrg) ? settleOrg.getLong("id") : 0L;
            contractMap.put("settleOrgID", settleOrgID);
            contractMap.put("accessType", "PAY");
            long uniquekey = DB.genGlobalLongId();
            contractMap.put("uniquekey", uniquekey);
            BigDecimal payableamt = entry.getBigDecimal("e_payableamt");
            if (isPay) {
                contractMap.put("amount", payableamt);
            } else {
                contractMap.put("amount", payableamt.negate());
            }
            contractMapList.add(contractMap);
        }
    }

    private static void getPurOrScpMap(boolean isPay, List<Map<String, Object>> conOrScpMapList, DynamicObject info) {
        long payee = info.getLong("payee");
        DynamicObjectCollection collectionEntry = info.getDynamicObjectCollection("entry");
        for (DynamicObject entry : collectionEntry) {
            HashMap<String, Object> conOrScp = new HashMap<String, Object>();
            conOrScp.put("mainbillentity", entry.getString("e_corebilltype"));
            conOrScp.put("mainbillid", entry.getLong("e_corebillid"));
            conOrScp.put("mainbillentryid", entry.getLong("e_corebillentryid"));
            conOrScp.put("internal_company", RecSaleServiceHelper.isExistInternalBusinessUnit(info.getString("payeetype"), payee));
            DynamicObject settleOrg = entry.getDynamicObject("settleorg");
            Long settleOrgID = CasHelper.isNotEmpty((Object)settleOrg) ? settleOrg.getLong("id") : 0L;
            conOrScp.put("settleorgid", settleOrgID);
            conOrScp.put("supplierid", payee);
            long uniquekey = DB.genGlobalLongId();
            conOrScp.put("uniquekey", uniquekey);
            BigDecimal payableamt = entry.getBigDecimal("e_payableamt");
            if (isPay) {
                conOrScp.put("amount", payableamt);
            } else {
                conOrScp.put("amount", payableamt.negate());
            }
            conOrScpMapList.add(conOrScp);
        }
    }
}

