/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class RecBillSupDivideHelper {
    private static Log logger = LogFactory.getLog(RecBillSupDivideHelper.class);

    public static void recBillRecOpDoDivideOp(DynamicObject recBill) {
        if (RecBillSupDivideHelper.isOpenSysPush2VirRecParam(recBill)) {
            RecBillSupDivideHelper.genVirtualRecBill(recBill);
        }
    }

    public static void recBillSaveOrgsDivideOp(DynamicObject recBill) {
        if (RecBillSupDivideHelper.isOpenSysPush2VirRecParam(recBill)) {
            logger.info("\u751f\u6210\u865a\u62df\u6536\u6b3e\u5355\u524d2" + recBill);
            RecBillSupDivideHelper.genVirtualRecBill(recBill);
            logger.info("\u751f\u6210\u865a\u62df\u6536\u6b3e\u5355\u540e3" + recBill);
        }
        RecBillSupDivideHelper.push2OtherAppaybill(recBill);
    }

    public static void recBillSaveOpDoCancelDivideOp(DynamicObject recBill, List<Long> entryCancelIds) {
        List<String> validErrors = RecBillSupDivideHelper.validCancelOrgDivideIsOk(recBill, entryCancelIds);
        if (validErrors.size() != 0) {
            throw new KDBizException(String.join((CharSequence)",", validErrors));
        }
        Map<String, List<DynamicObject>> targetBillMap = RecBillSupDivideHelper.getEntryPushTargetBillMap(recBill, entryCancelIds);
        for (Map.Entry<String, List<DynamicObject>> tagbillsListMap : targetBillMap.entrySet()) {
            String tagEntityName = tagbillsListMap.getKey();
            if (!"cas_recbill".equals(tagEntityName) && !"ap_finapbill".equals(tagEntityName)) continue;
            List<DynamicObject> tagbillList = tagbillsListMap.getValue();
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)tagEntityName), (Object[])tagbillsListMap.getValue().stream().map(DataEntityBase::getPkValue).toArray());
            for (DynamicObject tagbill : tagbillList) {
                CasBotpHelper.deleteRation((Object)tagbill.getPkValue(), (String[])new String[]{tagEntityName});
            }
        }
    }

    private static void push2OtherAppaybill(DynamicObject info) {
        long id = (Long)info.getDynamicObject("org").getPkValue();
        boolean isCS089 = SystemParameterHelper.getParameterBoolean((long)id, (String)"cs089");
        if (isCS089) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("app", "cas");
            DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
            boolean isPush = false;
            for (DynamicObject entry : coll) {
                String settleId = entry.getString("e_settleorg.id");
                String orgId = info.getString("org.id");
                logger.info(String.format("===\u7ed3\u7b97id\uff1a%s  \u7ec4\u7ec7id:%s===", settleId, orgId));
                if (!RecBillSupDivideHelper.isSettleType(info) || !StringUtils.isNotEmpty((String)settleId) || !StringUtils.isNotEmpty((String)orgId) || orgId.equals(settleId)) continue;
                String settleName = entry.getString("e_settleorg.name");
                if (RecBillHepler.matchByName(id, settleName) == null) continue;
                isPush = true;
                break;
            }
            if (isPush) {
                logger.info("===\u751f\u6210\u5176\u4ed6\u5e94\u4ed8\u5355===");
                OperationResult opResult = OperateServiceHelper.execOperateWithoutThrow((String)"genapbill", (String)"cas_recbill", (Object[])new Long[]{info.getLong("id")}, (OperateOption)option);
                String result = OperateServiceHelper.decodeErrorMsg((OperationResult)opResult);
                logger.info(result);
            }
        }
    }

    private static boolean isSettleType(DynamicObject info) {
        DynamicObject receivingtype = info.getDynamicObject("receivingtype");
        receivingtype = BusinessDataServiceHelper.loadSingle((Object)receivingtype.getPkValue(), (String)"cas_receivingbilltype", (String)"ispartreceivable");
        return receivingtype.getBoolean("ispartreceivable");
    }

    private static List<String> validCancelOrgDivideIsOk(DynamicObject recBill, List<Long> entryCancelIds) {
        List<String> errorList = new ArrayList<String>(10);
        Map<String, List<DynamicObject>> targetBillMap = RecBillSupDivideHelper.getEntryPushTargetBillMap(recBill, entryCancelIds);
        for (Map.Entry<String, List<DynamicObject>> tagbillsListMap : targetBillMap.entrySet()) {
            String entityName = tagbillsListMap.getKey();
            List<DynamicObject> tagbillDoList = tagbillsListMap.getValue();
            if ("cas_recbill".equals(entityName) && !EmptyUtil.isEmpty(tagbillDoList) && tagbillDoList.size() > 0) {
                errorList = RecBillSupDivideHelper.getPushErrorInfo(errorList, tagbillDoList);
            }
            if (!"ap_finapbill".equals(entityName) || EmptyUtil.isEmpty(tagbillDoList) || tagbillDoList.size() <= 0) continue;
            errorList = RecBillSupDivideHelper.getPushErrorInfo(errorList, tagbillDoList);
        }
        return errorList;
    }

    private static List<String> getPushErrorInfo(List<String> errorList, List<DynamicObject> tagbillDoList) {
        for (DynamicObject targbill : tagbillDoList) {
            if (BillStatusEnum.SAVE.getValue().equals(targbill.getString("billstatus"))) continue;
            errorList.add(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38%1$s\u5355\u636e\uff08\u7f16\u7801:%2$s\uff09\u4e0d\u662f\u6682\u5b58\u72b6\u6001,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"RecBillSupDivideHelper_0", (String)"fi-cas-business", (Object[])new Object[0]), targbill.getDynamicObjectType().getDisplayName(), targbill.getString("billno")));
        }
        return errorList;
    }

    private static Map<String, List<DynamicObject>> getEntryPushTargetBillMap(DynamicObject recBill, List<Long> entryCancelIds) {
        HashMap<String, List<DynamicObject>> targetDOBills = new HashMap<String, List<DynamicObject>>(16);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)recBill.getDataEntityType().getName(), (Long[])new Long[]{(Long)recBill.getPkValue()});
        if (!CollectionUtils.isEmpty((Map)targetBills) && targetBills.size() > 0) {
            for (Map.Entry tagbillsListMap : targetBills.entrySet()) {
                String entityName = (String)tagbillsListMap.getKey();
                HashSet pushTargIdSet = (HashSet)tagbillsListMap.getValue();
                DynamicObject[] tagbills = null;
                if ("cas_recbill".equals(entityName) && !EmptyUtil.isEmpty((Collection)pushTargIdSet) && pushTargIdSet.size() > 0) {
                    QFilter filter = new QFilter("id", "in", (Object)pushTargIdSet).and("entry.e_sourcebillentryid", "in", entryCancelIds);
                    tagbills = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                } else if ("ap_finapbill".equals(entityName) && !EmptyUtil.isEmpty((Collection)pushTargIdSet) && pushTargIdSet.size() > 0) {
                    List entryCancelIdStrs = entryCancelIds.stream().map(o -> o.toString()).collect(Collectors.toList());
                    QFilter filter = new QFilter("id", "in", (Object)pushTargIdSet).and("detailentry.e_sourcebillentryid", "in", entryCancelIdStrs);
                    tagbills = BusinessDataServiceHelper.load((String)entityName, (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                }
                if (EmptyUtil.isEmpty(tagbills) || tagbills.length <= 0) continue;
                targetDOBills.put(entityName, Arrays.stream(tagbills).collect(Collectors.toList()));
            }
        }
        return targetDOBills;
    }

    private static void genVirtualRecBill(DynamicObject recBill) {
        Object openorg = recBill.getDynamicObject("openorg").getPkValue();
        DynamicObjectCollection recEntrys = recBill.getDynamicObjectCollection("entry");
        Set settleOrgs = recEntrys.stream().filter(s -> EmptyUtil.isNoEmpty((DynamicObject)s.getDynamicObject("e_settleorg"))).map(s -> s.getDynamicObject("e_settleorg")).collect(Collectors.toSet());
        logger.info("\u5f53\u524d\u5355\u636e\u5934\u7684\u6838\u7b97\u7ec4\u7ec7openorg:" + openorg + ";");
        boolean isCanPush = settleOrgs.stream().anyMatch(settleOrg -> !settleOrg.getPkValue().equals(openorg));
        if (isCanPush) {
            logger.info("\u8c03\u7528\u4e0b\u63a8\u865a\u62df\u6536\u6b3e\u5355===============\u5f00\u59cb");
            OperateServiceHelper.execOperate((String)"push2virtualrec", (String)"cas_recbill", (Object[])new Object[]{recBill.getLong("id")}, (OperateOption)OperateOption.create());
            logger.info("\u8c03\u7528\u4e0b\u63a8\u865a\u62df\u6536\u6b3e\u5355===============\u7ed3\u675f");
        }
    }

    private static boolean isOpenSysPush2VirRecParam(DynamicObject recBill) {
        Long orgId = recBill.getDynamicObject("org").getLong("id");
        return SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs118");
    }
}

