/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.journal.AgentPayBookJournalBuilder;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.business.opservice.impl.CasRecManualBookImpl;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.MutexServiceHelper;

public class CasAgentManualBookImpl
extends AbstractOpService {
    private static final Log logger = LogFactory.getLog(CasRecManualBookImpl.class);
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    @Override
    public List<String> getSelector() {
        return AgentPayServiceHelper.getSelectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DynamicObject[] infos) throws KDException {
        StringJoiner errorMsg = new StringJoiner(";\r\n");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        try {
            List billnos = Arrays.stream(infos).map(e -> e.get("billno").toString()).collect(Collectors.toList());
            Map lockResultMap = MutexServiceHelper.batchRequest(billnos, (String)"fi-cas-business", (String)"casAgentmanualBook");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
            }
            this.dealBook(infos, errorMsg);
        }
        catch (Exception e2) {
            logger.error("e is:", (Throwable)e2);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-business", (String)"casAgentmanualBook");
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private void dealBook(DynamicObject[] infos, StringJoiner errorMsg) {
        for (DynamicObject agentPayBill : infos) {
            String billId = agentPayBill.get("billno").toString();
            try {
                if (BillStatusEnum.PAY.getValue().equals(agentPayBill.getString("billstatus"))) {
                    if (!CasAgentManualBookImpl.isNeedBookJournal(agentPayBill, errorMsg, billId)) continue;
                    if (this.journalServiceAdapter.hasBooked(agentPayBill)) {
                        logger.info(String.format("bill %s has book,start to cancelBook", billId));
                        this.journalServiceAdapter.validateCancelBook(agentPayBill);
                        this.journalServiceAdapter.cancelBook(agentPayBill);
                        logger.info(String.format("bill %s has book,cancelBook end", billId));
                    }
                    logger.info(String.format("bill %s start to book", billId));
                    this.journalServiceAdapter.validateBook((IBookJournalBuilder)new AgentPayBookJournalBuilder(), agentPayBill);
                    this.journalServiceAdapter.book(agentPayBill);
                    logger.info(String.format("bill %s book end", billId));
                    continue;
                }
                errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u4ed8\u6b3e\u72b6\u6001\u7684\u5355\u636e\u53ef\u4ee5\u624b\u52a8\u767b\u8d26\u3002", (String)"ReceivErrorCode_20", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            }
            catch (Exception e) {
                logger.error("CasAgentManualBookImpl error is:", (Throwable)e);
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u624b\u52a8\u767b\u8d26\u5931\u8d25\u3002", (String)"ReceivErrorCode_26", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            }
        }
    }

    private static boolean isNeedBookJournal(DynamicObject agentPayBill, StringJoiner errorMsg, String billId) {
        DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            if (!row.getBoolean("e_issuccess") && !row.getBoolean("e_isrefund")) continue;
            return true;
        }
        errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u5206\u5f55\u4e2d\u4e0d\u5b58\u5728\u6210\u529f\u6216\u8005\u9000\u7968\u7684\u5206\u5f55\uff0c\u4e0d\u9700\u8981\u767b\u8d26\u3002", (String)"ReceivErrorCode_28", (String)"fi-cas-business", (Object[])new Object[0]), billId));
        return false;
    }
}

