/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.journal.ExchangeBillBookJournalBuilder;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.impl.CasRecManualBookImpl;
import kd.fi.cas.helper.MutexServiceHelper;

public class CasExchangeManualBookImpl
extends AbstractOpService {
    private static final Log logger = LogFactory.getLog(CasRecManualBookImpl.class);
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    @Override
    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(22);
        list.add("billno");
        list.add("biztype");
        list.add("billstatus");
        list.add("bizdate");
        list.add("org");
        list.add("remark");
        list.add("accounttype");
        list.add("buyingcurrency");
        list.add("buyingaccount");
        list.add("buyamount");
        list.add("buyingexchangerate");
        list.add("buyinglocalamount");
        list.add("sellingcurrency");
        list.add("sellingaccount");
        list.add("sellamount");
        list.add("sellingexchangerate");
        list.add("sellinglocalamount");
        list.add("commissioncurrency");
        list.add("paycommissionaccount");
        list.add("commissionamount");
        list.add("commissionexchangerate");
        list.add("commissionlocalamount");
        list.add("exchangedate");
        list.add("buybankcheckflag");
        list.add("sellingbankcheckflag");
        list.add("feebankcheckflag");
        list.add("acttradedate");
        list.add("createtime");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DynamicObject[] infos) throws KDException {
        super.process(infos);
        StringJoiner errorMsg = new StringJoiner(";\r\n");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        try {
            List billnos = Arrays.stream(infos).map(e -> e.get("billno").toString()).collect(Collectors.toList());
            Map lockResultMap = MutexServiceHelper.batchRequest(billnos, (String)"fi-cas-business", (String)"casExchmanualBook");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
            }
            this.dealBook(infos, errorMsg);
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-business", (String)"casExchmanualBook");
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private void dealBook(DynamicObject[] infos, StringJoiner errorMsg) {
        for (DynamicObject info : infos) {
            String billStatus = info.getString("billstatus");
            String billId = info.get("billno").toString();
            if (!"F".equalsIgnoreCase(billStatus)) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u5df2\u5151\u6362\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u624b\u52a8\u767b\u8d26\u3002", (String)"ReceivErrorCode_27", (String)"fi-cas-business", (Object[])new Object[0]), billId));
                continue;
            }
            try {
                if (this.journalServiceAdapter.hasBooked(info)) {
                    logger.info(String.format("bill %s has book,start to cancelBook", billId));
                    this.journalServiceAdapter.validateCancelBook(info);
                    this.journalServiceAdapter.cancelBook(info);
                    logger.info(String.format("bill %s has book,cancelBook end", billId));
                }
                logger.info(String.format("bill %s start to book", billId));
                this.journalServiceAdapter.validateBook((IBookJournalBuilder)new ExchangeBillBookJournalBuilder(), info);
                this.journalServiceAdapter.book(info);
                info.set("exchangedate", (Object)new Date());
                logger.info(String.format("bill %s book end", billId));
            }
            catch (Exception e) {
                logger.error("rec manualbook has exception:", (Throwable)e);
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u624b\u52a8\u767b\u8d26\u5931\u8d25\u3002", (String)"ReceivErrorCode_26", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            }
        }
    }
}

