/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.PaymentBillBookJournalBuilder;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.MutexServiceHelper;

public class CasPaymentManualBookImpl
extends AbstractOpService {
    private static final Log logger = LogFactory.getLog(CasPaymentManualBookImpl.class);
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(60);
        lst.add("org");
        lst.add("id");
        lst.add("billtype");
        lst.add("dpamt");
        lst.add("dplocalamt");
        lst.add("exchangerate");
        lst.add("basecurrency");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("hotaccount");
        lst.add("billstatus");
        lst.add("isvoucher");
        lst.add("paymenttype");
        lst.add("basecurrency.amtprecision");
        lst.add("payquotation");
        lst.add("totalpayamt");
        lst.add("fee");
        lst.add("actpayamt");
        lst.add("localamt");
        lst.add("currency");
        lst.add("bizdate");
        lst.add("description");
        lst.add("settletype");
        lst.add("bankcheckflag");
        lst.add("paydate");
        lst.add("paymentchannel");
        lst.add("expectdate");
        lst.add("feepayer");
        lst.add("createtime");
        lst.add("dpexchangerate");
        lst.add("feecurrency");
        lst.add("dpcurrency");
        lst.add("agreedquotation");
        lst.add("agreedrate");
        lst.add("dppayquotation");
        lst.add("billno");
        lst.add("payeetype");
        lst.add("dpcurrency.amtprecision");
        lst.add("acttradedate");
        lst.add("settletnumber");
        lst.add("cashier");
        lst.add("billtype.id");
        lst.add("org");
        lst.add("org.name");
        lst.add("payee");
        lst.add("payeename");
        lst.add("payeeacctcash");
        lst.add("payeeacctbank");
        lst.add("isdiffcur");
        lst.add("payeracctbank");
        lst.add("payeracctcash");
        lst.add("payeebanknum");
        lst.add("payeebank");
        lst.add("payeebank.name");
        lst.add("payeebankname");
        lst.add("bankcheckflag_tag");
        lst.add("singlestream");
        lst.add("entry.e_actamt");
        lst.add("entry.e_localamt");
        lst.add("entry.e_fundflowitem");
        lst.add("entry.e_payableamt");
        lst.add("entry.e_payablelocamt");
        lst.add("entry.e_discountamt");
        lst.add("entry.e_discountlocamt");
        lst.add("entry.e_lockamt");
        lst.add("entry.e_unlockamt");
        lst.add("entry.e_unsettledamt");
        lst.add("entry.e_settledamt");
        lst.add("payerbank");
        lst.add("payerbank.name");
        lst.add("paymentidentify");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_paybill", (String)"entry"));
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DynamicObject[] infos) throws KDException {
        super.process(infos);
        StringJoiner errorMsg = new StringJoiner(";\r\n");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        try {
            List billnos = Arrays.stream(infos).map(e -> e.get("billno").toString()).collect(Collectors.toList());
            Map lockResultMap = MutexServiceHelper.batchRequest(billnos, (String)"fi-cas-business", (String)"casPaymanualBook");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
            }
            this.dealRecManualBook(infos, errorMsg);
        }
        catch (Exception e2) {
            logger.error("e is that:", (Throwable)e2);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-business", (String)"casPaymanualBook");
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private void dealRecManualBook(DynamicObject[] infos, StringJoiner errorMsg) {
        for (DynamicObject info : infos) {
            String billId = info.get("billno").toString();
            String billStatus = info.getString("billstatus");
            if (!"D".equalsIgnoreCase(billStatus)) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u4ed8\u6b3e\u72b6\u6001\u7684\u5355\u636e\u53ef\u4ee5\u624b\u52a8\u767b\u8d26\u3002", (String)"ReceivErrorCode_20", (String)"fi-cas-business", (Object[])new Object[0]), billId));
                continue;
            }
            try {
                if (this.journalServiceAdapter.hasBooked(info)) {
                    logger.info(String.format("bill %s has book,start to cancelBook", billId));
                    this.journalServiceAdapter.validateCancelBook(info);
                    this.journalServiceAdapter.cancelBook(info);
                    logger.info(String.format("bill %s has book,cancelBook end", billId));
                }
                logger.info(String.format("bill %s is start to book", billId));
                this.journalServiceAdapter.validateBook((IBookJournalBuilder)new PaymentBillBookJournalBuilder(), info);
                this.journalServiceAdapter.book(info);
                logger.info(String.format("bill %s book end", billId));
            }
            catch (Exception e) {
                logger.error("payment manualbook has exception is that:", (Throwable)e);
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u624b\u52a8\u767b\u8d26\u5931\u8d25\u3002", (String)"ReceivErrorCode_26", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            }
        }
    }
}

