/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.enums.BillStatusEnum;

public class PaymentUnSubmitImpl
extends AbstractOpService {
    private static Log logger = LogFactory.getLog(PaymentUnSubmitImpl.class);

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(50);
        lst.add("billstatus");
        lst.add("bizdate");
        lst.add("paymenttype");
        lst.add("payeetype");
        lst.add("description");
        lst.add("issingle");
        lst.add("org");
        lst.add("payeracctbank");
        lst.add("payerbank");
        lst.add("payee");
        lst.add("payeeformid");
        lst.add("payeename");
        lst.add("payeeaccformid");
        lst.add("payeeacctbank");
        lst.add("payeebanknum");
        lst.add("payeebank");
        lst.add("actpayamt");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("fundflowitem");
        lst.add("usage");
        lst.add("expectdate");
        lst.add("reccountry");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("recaccbankname");
        lst.add("recbanknumber");
        lst.add("sourcetype");
        lst.add("entrance");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("e_payableAmt");
        lst.add("e_lockAmt");
        lst.add("e_unlockAmt");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
        String billStatus = info.getString("billstatus");
        if (!BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            throw new KDBizException(new AgentPayErrorCode().STATUS_CANNOT_UNSUBMIT(), new Object[0]);
        }
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        super.process(info);
        logger.info("process() begin...");
    }
}

