/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecClaimBillHelper;
import kd.fi.cas.business.helper.StringHelper;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.helper.ValidAndSetMatchInfoHelper;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.DataTypeEnum;
import kd.fi.cas.enums.RecTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;

public class RecBillSaveImpl
extends AbstractOpService {
    private static final Log logger = LogFactory.getLog(RecBillSaveImpl.class);
    private ParamMap param = new ParamMap();

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(20);
        lst.add("currency.amtprecision");
        lst.add("sourcetype");
        lst.add("billno");
        lst.add("sourcebillnumber");
        lst.add("sourcebillid");
        lst.add("payer");
        lst.add("payername");
        lst.add("payertype");
        lst.add("itempayer");
        lst.add("itempayertype");
        lst.add("payeracctbanknum");
        lst.add("txt_description");
        lst.add("e_unlockAmt");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("settletype");
        lst.add("payeracctbank");
        lst.add("openorg");
        lst.add("e_settleorg");
        lst.add("e_dividestatus");
        lst.add("recorg");
        lst.add("e_orgsdividebatch");
        lst.add("e_lockAmt");
        lst.add("basecurrency");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("exratedate");
        lst.add("exratetable");
        lst.add("e_receivableamt");
        lst.add("e_receivablelocamt");
        lst.add("e_discountamt");
        lst.add("e_discountlocamt");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("actrecamt");
        lst.add("localamt");
        lst.add("e_unsettledlocalamt");
        lst.add("inneraccount");
        lst.add("exchangerate");
        lst.add("paymentterm");
        lst.add("payernumber");
        lst.add("settlestatus");
        lst.add("unsettleamount");
        lst.add("unsettleamountbase");
        lst.add("settleamount");
        lst.add("settleamountbase");
        lst.add("e_settledlocalamt");
        lst.add("relateotherflow");
        lst.add("org");
        lst.add("matchamountpay");
        lst.add("unmatchamountpay");
        lst.add("actrecamt");
        lst.add("matchamountrec");
        lst.add("unmatchamountrec");
        lst.add("matchflag");
        lst.add("bankcheckentity.ebankcheckflag");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
    }

    @Override
    public void prepare(DynamicObject[] dataEntities, ParamMap param) {
        super.prepare(dataEntities, param);
        this.param = param;
    }

    @Override
    public void process(DynamicObject recBill) throws KDException {
        String sourcebillnumber;
        String sourceBillType = recBill.getString("sourcebilltype");
        DynamicObject basecurrency = recBill.getDynamicObject("basecurrency");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        DynamicObjectCollection entryColl = recBill.getDynamicObjectCollection("entry");
        logger.info("\u53c2\u6570\u4e2d\u662f\u5426\u6ca1\u6709thisRecOptype\uff1a{}", (Object)(!"thisRecOptype".equals(this.param.get("thisRecOptype")) ? 1 : 0));
        if (!"thisRecOptype".equals(this.param.get("thisRecOptype"))) {
            for (DynamicObject entry : entryColl) {
                BigDecimal e_receivableamt = entry.getBigDecimal("e_receivableamt");
                BigDecimal e_lockamt = entry.getBigDecimal("e_lockamt");
                BigDecimal e_settledamt = entry.getBigDecimal("e_settledamt");
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unlockAmt", (Object)e_receivableamt.subtract(e_lockamt));
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledamt", (Object)e_receivableamt.subtract(e_settledamt));
            }
        }
        BigDecimal settledamt = BigDecimal.ZERO;
        BigDecimal settledlocalamt = BigDecimal.ZERO;
        BigDecimal unsettledamt = BigDecimal.ZERO;
        DynamicObjectCollection entryRecColl = recBill.getDynamicObjectCollection("entry");
        for (DynamicObject entryRec : entryRecColl) {
            settledamt = settledamt.add(entryRec.getBigDecimal("e_settledamt"));
            settledlocalamt = settledlocalamt.add(entryRec.getBigDecimal("e_settledlocalamt"));
            unsettledamt = unsettledamt.add(entryRec.getBigDecimal("e_unsettledamt"));
        }
        recBill.set("settleamount", (Object)settledamt);
        recBill.set("settleamountbase", (Object)settledlocalamt);
        recBill.set("unsettleamount", (Object)unsettledamt);
        if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) == 0) {
            recBill.set("settlestatus", (Object)"settled");
        }
        if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
            recBill.set("settlestatus", (Object)"partsettle");
        }
        if (settledamt.compareTo(BigDecimal.ZERO) == 0 && unsettledamt.compareTo(BigDecimal.ZERO) != 0) {
            recBill.set("settlestatus", (Object)"unsettle");
        }
        if (StringUtils.isNotEmpty((CharSequence)(sourcebillnumber = recBill.getString("sourcebillnumber"))) && sourcebillnumber.length() > 255) {
            sourcebillnumber = sourcebillnumber.substring(0, 252) + "...";
            recBill.set("sourcebillnumber", (Object)sourcebillnumber);
        }
        String settleNumber = recBill.getString("settletnumber");
        recBill.set("settletnumber", (Object)StringHelper.subString(settleNumber, 2000));
        if (!CasHelper.isEmpty((Object)sourceBillType)) {
            this.setValueIfPushAndSave(recBill);
        }
        DynamicObjectCollection recEntrys = recBill.getDynamicObjectCollection("entry");
        BigDecimal sumUnSettledLocAmt = BigDecimal.ZERO;
        BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
        String quotation = recBill.getString("quotation");
        for (DynamicObject entry : recEntrys) {
            BigDecimal unSettledAmt = entry.getBigDecimal("e_unsettledamt");
            if (unSettledAmt == null) continue;
            entry.set("e_unsettledlocalamt", (Object)QuotationHelper.callToCurrency((BigDecimal)unSettledAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round));
            sumUnSettledLocAmt = sumUnSettledLocAmt.add(QuotationHelper.callToCurrency((BigDecimal)unSettledAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round));
        }
        recBill.set("unsettleamountbase", (Object)sumUnSettledLocAmt);
        DynamicObject settleType = recBill.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            recBill.set("accountbank", null);
        }
        DynamicObject accountBank = recBill.getDynamicObject("accountbank");
        DynamicObject accountCash = recBill.getDynamicObject("accountcash");
        if (accountBank != null) {
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)recBill, (String)"openorg", (Object)accountBank.get("openorg"));
        } else if (accountCash != null) {
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)recBill, (String)"openorg", (Object)accountCash.get("openorg"));
        }
        for (DynamicObject entry : entryColl) {
            if (!CasHelper.isEmpty((Object)entry.get("e_settleorg"))) continue;
            entry.set("e_settleorg", recBill.get("openorg"));
        }
        if (("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelrec".equals(sourceBillType) || "cas_claimcenterbill".equals(sourceBillType) && this.param.getParams().get("returnDataByOpHand") != null) && !recBill.getDataEntityState().getFromDatabase()) {
            DynamicObject fundflowitem;
            String fundflowitemSeri;
            Object e_fundflowitem;
            DynamicObject receivingtype;
            logger.info("RecBillSaveImpl\u9996\u6b21\u7531\u4ea4\u6613\u660e\u7ec6\u4e0b\u63a8\u6536\u6b3e\u5355,\u4fdd\u5b58\u64cd\u4f5c\u7684\u4e1a\u52a1");
            DynamicObject entry = (DynamicObject)recBill.getDynamicObjectCollection("entry").get(0);
            Map handReturnData = null;
            Map handMergeReturnData = null;
            if (!CasHelper.isEmpty((Object)this.param) && this.param.getParams().size() > 0) {
                String returnDataStr;
                Map params = this.param.getParams();
                Object returnDataByOpHand = params.get("returnDataByOpHand");
                Object returnDataByOpHandMerge = params.get("returnDataByOpHandMerge");
                if (returnDataByOpHand != null) {
                    returnDataStr = String.valueOf(returnDataByOpHand);
                    handReturnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
                }
                if (returnDataByOpHandMerge != null) {
                    returnDataStr = String.valueOf(returnDataByOpHandMerge);
                    handMergeReturnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
                }
            }
            if (!CasHelper.isEmpty(handReturnData) && handReturnData != null && handReturnData.size() > 0) {
                String receivingtypeSeri;
                Object receivingType = handReturnData.get("e_receivingtype");
                if (EmptyUtil.isNoEmpty(receivingType) && !CasHelper.isEmpty((Object)(receivingtypeSeri = String.valueOf(receivingType)))) {
                    receivingtype = SerializeHelper.deserializeDynamicObj((String)"cas_receivingbilltype", (String)receivingtypeSeri);
                    handReturnData.put("e_receivingtype", receivingtype);
                }
                if ((e_fundflowitem = handReturnData.get("e_fundflowitem")) != null) {
                    fundflowitemSeri = String.valueOf(e_fundflowitem);
                    fundflowitem = SerializeHelper.deserializeDynamicObj((String)"cas_fundflowitem", (String)fundflowitemSeri);
                    handReturnData.put("e_fundflowitem", fundflowitem);
                }
                logger.info("\u4ea4\u6613\u660e\u7ec6\u4e0b\u63a8\u5e76\u4fdd\u5b58\u6536\u6b3e\u5355,\u624b\u5de5\u5165\u8d26,\u4e0d\u8d70\u89c4\u5219,\u8fd4\u56de\u4fe1\u606f" + handReturnData);
                this.setRecValueByRule(handReturnData, recBill, entry, sourceBillType);
                if ("cas_claimcenterbill".equals(sourceBillType)) {
                    RecClaimBillHelper.unClaimAccount(new Object[]{recBill.get("sourcebillid")});
                }
            } else if (!CasHelper.isEmpty(handMergeReturnData) && handMergeReturnData != null && handMergeReturnData.size() > 0) {
                int i;
                String receivingtypeSeri = String.valueOf(handMergeReturnData.get("e_receivingtype"));
                if (!CasHelper.isEmpty((Object)receivingtypeSeri)) {
                    DynamicObject receivingtype2 = SerializeHelper.deserializeDynamicObj((String)"cas_receivingbilltype", (String)receivingtypeSeri);
                    handMergeReturnData.put("e_receivingtype", receivingtype2);
                }
                if ((e_fundflowitem = handMergeReturnData.get("e_fundflowitem")) != null) {
                    fundflowitemSeri = String.valueOf(e_fundflowitem);
                    fundflowitem = SerializeHelper.deserializeDynamicObj((String)"cas_fundflowitem", (String)fundflowitemSeri);
                    handMergeReturnData.put("e_fundflowitem", fundflowitem);
                }
                logger.info("\u4ea4\u6613\u660e\u7ec6\u4e0b\u63a8\u5e76\u4fdd\u5b58\u6536\u6b3e\u5355,\u624b\u5de5\u5165\u8d26,\u4e0d\u8d70\u89c4\u5219,\u8fd4\u56de\u4fe1\u606f" + handMergeReturnData);
                receivingtype = (DynamicObject)handMergeReturnData.get("e_receivingtype");
                DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
                if (!CasHelper.isEmpty((Object)receivingtype)) {
                    recBill.set("receivingtype", (Object)receivingtype);
                    QFilter qf = new QFilter("number", "=", receivingtype.get("number"));
                    DynamicObject recType = BusinessDataServiceHelper.loadSingle((String)"cas_receivingbilltype", (String)"id,ispartreceivable,number", (QFilter[])new QFilter[]{qf});
                    logger.info("recType\u662f\u5426\u6709ispartreceivable\uff1a{}", (Object)(recType != null && recType.getBoolean("ispartreceivable") ? 1 : 0));
                    if (recType != null && recType.getBoolean("ispartreceivable")) {
                        for (i = 0; i < entrys.size(); ++i) {
                            ((DynamicObject)entrys.get(i)).set("e_unsettledamt", (Object)((BigDecimal)((DynamicObject)entrys.get(i)).get("e_actamt")).subtract((BigDecimal)((DynamicObject)entrys.get(i)).get("e_settledamt")));
                            ((DynamicObject)entrys.get(i)).set("e_unlockamt", (Object)((BigDecimal)((DynamicObject)entrys.get(i)).get("e_actamt")).subtract((BigDecimal)((DynamicObject)entrys.get(i)).get("e_lockamt")));
                        }
                        recBill.set("biztype", (Object)RecTypeEnum.SalesRec.getValue());
                    }
                }
                DynamicObject ee_fundflowitem = null;
                Object o_fundflowitem = handMergeReturnData.get("e_fundflowitem");
                if (o_fundflowitem != null) {
                    ee_fundflowitem = (DynamicObject)o_fundflowitem;
                }
                if (!CasHelper.isEmpty(ee_fundflowitem)) {
                    for (i = 0; i < entrys.size(); ++i) {
                        ((DynamicObject)entrys.get(i)).set("e_fundflowitem", (Object)ee_fundflowitem);
                    }
                }
                this.setRecValueByRule(handMergeReturnData, recBill, entry, sourceBillType);
            }
        }
        DynamicObjectHelper.setValue((DynamicObject)recBill, (String)"payeracctbanknum", (Object)CheckUtils.bankNumberCheck((String)recBill.getString("payeracctbanknum")));
        new BillPropertyValueHandle(recBill);
        RecBillHepler.dealMatchInfo(recBill);
        DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)recBill, (String)"txt_description");
    }

    private void setRecValueByRule(Map<String, Object> returnRec, DynamicObject recBill, DynamicObject entry, String sourceBillType) {
        DynamicObject[] account;
        DynamicObject[] iaccount;
        Long innerAcct;
        DynamicObject receivingtype = (DynamicObject)returnRec.get("e_receivingtype");
        String payertype = String.valueOf(returnRec.get("e_payertype"));
        Object e_payer = returnRec.get("e_payer");
        if (("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelrec".equals(sourceBillType)) && EmptyUtil.isEmpty((Object)e_payer)) {
            logger.info("RecBillSaveImpl.setRecValueByRule");
            ValidAndSetMatchInfoHelper.validAndSetMatchInfo(recBill, payertype, "rec", false);
        }
        DynamicObject e_fundflowitem = null;
        Object o_fundflowitem = returnRec.get("e_fundflowitem");
        if (o_fundflowitem != null) {
            e_fundflowitem = (DynamicObject)o_fundflowitem;
        }
        String e_remark = "";
        Object o_remark = returnRec.get("e_remark");
        if (o_remark != null) {
            e_remark = String.valueOf(o_remark);
        }
        if (!CasHelper.isEmpty((Object)receivingtype)) {
            recBill.set("receivingtype", (Object)receivingtype);
            QFilter qf = new QFilter("number", "=", receivingtype.get("number"));
            DynamicObject recType = BusinessDataServiceHelper.loadSingle((String)"cas_receivingbilltype", (String)"id,ispartreceivable,number", (QFilter[])new QFilter[]{qf});
            if (recType != null && recType.getBoolean("ispartreceivable")) {
                entry.set("e_unsettledamt", entry.get("e_receivableamt"));
                entry.set("e_unlockamt", entry.get("e_receivableamt"));
                recBill.set("biztype", (Object)RecTypeEnum.SalesRec.getValue());
            }
        }
        if (!CasHelper.isEmpty((Object)payertype)) {
            recBill.set("payertype", (Object)payertype);
            recBill.set("payerformid", (Object)payertype);
            if (!CasHelper.isEmpty((Object)e_payer)) {
                if (!AsstActTypeEnum.OTHER.getValue().equals(payertype)) {
                    DynamicObject e_payerObj = BusinessDataServiceHelper.loadSingle((Object)e_payer, (String)payertype);
                    recBill.set("itempayer", e_payerObj.getPkValue());
                    recBill.set("payer", e_payerObj.getPkValue());
                    recBill.set("payername", (Object)e_payerObj.getString("name"));
                    recBill.set("payernumber", (Object)e_payerObj.getString("number"));
                } else {
                    recBill.set("itempayer", null);
                    recBill.set("payer", null);
                    recBill.set("payername", e_payer);
                    recBill.set("payernumber", (Object)"");
                }
            }
        }
        if (!CasHelper.isEmpty((Object)e_fundflowitem)) {
            entry.set("e_fundflowitem", (Object)e_fundflowitem);
        }
        if (!CasHelper.isEmpty((Object)e_remark)) {
            recBill.set("txt_description", (Object)e_remark);
        }
        if (!CasHelper.isEmpty((Object)(innerAcct = (Long)returnRec.get("inneracct"))) && (iaccount = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[]{new QFilter("id,number", "=", (Object)innerAcct)})) != null && iaccount.length > 0 && (account = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)iaccount[0].getString("number"))})) != null && account.length != 0) {
            recBill.set("inneraccount", (Object)account[0]);
        }
        this.fillExtFieldValues(returnRec, recBill);
    }

    private void setValueIfPushAndSave(DynamicObject recBill) {
        BigDecimal localamt;
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"org");
        Long baseCurrencyId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"basecurrency");
        if (CasHelper.isEmpty((Object)baseCurrencyId)) {
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (baseCurrency == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u5355\u636e\u3002", (String)"RecBillSaveImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            recBill.set("basecurrency", (Object)baseCurrency);
            baseCurrencyId = baseCurrency.getLong("id");
        }
        Long currencyId = DynamicObjectHelper.getPk((DynamicObject)recBill, (String)"currency");
        Date exrateDate = recBill.getDate("exratedate") == null ? Calendar.getInstance().getTime() : recBill.getDate("exratedate");
        DynamicObject exrateTable = recBill.getDynamicObject("exratetable");
        if (exrateTable == null) {
            exrateTable = SystemStatusCtrolHelper.getExrateTable((long)orgId);
            recBill.set("exratetable", (Object)exrateTable);
        }
        BigDecimal exchangeRate = recBill.getBigDecimal("exchangerate");
        String quotation = recBill.getString("quotation");
        if (CasHelper.isEmpty((Object)exchangeRate)) {
            exchangeRate = BigDecimal.ONE.setScale(10);
            quotation = "0";
            if (!baseCurrencyId.equals(currencyId)) {
                long exrateTableId = exrateTable == null ? 0L : exrateTable.getLong("id");
                Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currencyId, (Long)baseCurrencyId, (Long)exrateTableId, (Date)exrateDate);
                if (exchangeRateByRules.get("exchangeRate") != null) {
                    exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                }
                if (exchangeRateByRules.get("quoteType") != null && ((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
                    quotation = "1";
                }
            }
            DynamicObjectHelper.setValue((DynamicObject)recBill, (String)"exchangerate", (Object)exchangeRate);
            DynamicObjectHelper.setValue((DynamicObject)recBill, (String)"quotation", (Object)quotation);
        } else if (CasHelper.isEmpty((Object)quotation)) {
            quotation = "0";
            recBill.set("quotation", (Object)quotation);
        }
        DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
        DynamicObject currency = recBill.getDynamicObject("currency");
        int round = 10;
        DynamicObject basecurrency = recBill.getDynamicObject("basecurrency");
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            BigDecimal receivableAmt = entry.getBigDecimal("e_receivableamt");
            BigDecimal receivableLocAmt = entry.getBigDecimal("e_receivablelocamt");
            if (receivableAmt != null && CasHelper.isEmpty((Object)receivableLocAmt)) {
                BigDecimal recLocAmt = QuotationHelper.callToCurrency((BigDecimal)receivableAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                entry.set("e_receivablelocamt", (Object)recLocAmt);
            }
            BigDecimal discountAmt = entry.getBigDecimal("e_discountamt");
            BigDecimal discountLocAmt = entry.getBigDecimal("e_discountlocamt");
            if (discountAmt != null && CasHelper.isEmpty((Object)discountLocAmt)) {
                BigDecimal disLocAmt = QuotationHelper.callToCurrency((BigDecimal)discountAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                entry.set("e_discountlocamt", (Object)disLocAmt);
            }
            BigDecimal actAmt = entry.getBigDecimal("e_actamt");
            if (receivableAmt != null && discountAmt != null && CasHelper.isEmpty((Object)actAmt)) {
                actAmt = currency != null ? receivableAmt.subtract(discountAmt).subtract(entry.getBigDecimal("e_fee")).setScale(currency.getInt("amtprecision"), 4) : receivableAmt.subtract(discountAmt).subtract(entry.getBigDecimal("e_fee"));
                entry.set("e_actamt", (Object)actAmt);
            }
            actAmt = entry.getBigDecimal("e_actamt");
            sumAmt = sumAmt.add(actAmt);
            BigDecimal actLocalAmt = entry.getBigDecimal("e_localamt");
            if (CasHelper.isNotEmpty((Object)actAmt) && CasHelper.isEmpty((Object)actLocalAmt)) {
                BigDecimal actLocAmt = QuotationHelper.callToCurrency((BigDecimal)actAmt, (BigDecimal)exchangeRate, (String)quotation, (int)round);
                entry.set("e_localamt", (Object)actLocAmt);
            }
            actLocalAmt = CasHelper.isEmpty((Object)(actLocalAmt = entry.getBigDecimal("e_localamt"))) ? BigDecimal.ZERO : actLocalAmt;
            sumLocalAmt = sumLocalAmt.add(actLocalAmt);
        }
        BigDecimal actrecamt = recBill.getBigDecimal("actrecamt");
        if (CasHelper.isEmpty((Object)actrecamt)) {
            recBill.set("actrecamt", (Object)sumAmt);
        }
        if (CasHelper.isEmpty((Object)(localamt = recBill.getBigDecimal("localamt")))) {
            recBill.set("localamt", (Object)sumLocalAmt);
        }
    }

    private void fillExtFieldValues(Map<String, Object> returnRec, DynamicObject recBill) {
        String handleBillType = (String)returnRec.get("handleBill");
        DynamicObjectCollection billConFieldConfigs = QueryServiceHelper.query((String)"cas_billconvertfieldcfg", (String)"billtype, datatype, extendname, tarfieldname", null);
        billConFieldConfigs.stream().filter(billConFieldConfig -> {
            String billtype = billConFieldConfig.getString("billtype");
            if ("recvbill".equals(billtype)) {
                billtype = billtype.replace("v", "");
            }
            return EmptyUtil.isNoEmpty((String)handleBillType) && handleBillType.contains(billtype);
        }).forEach(billConFieldConfig -> {
            String extendName = billConFieldConfig.getString("extendname");
            String tarfieldname = billConFieldConfig.getString("tarfieldname");
            int dataType = billConFieldConfig.getInt("datatype");
            if (recBill.containsProperty(tarfieldname) && EmptyUtil.isNoEmpty(returnRec.get(extendName)) && DataTypeEnum.getDataTypeByOrdinal((int)dataType) != null) {
                Object value = returnRec.get(extendName);
                recBill.set(tarfieldname, DataType.convertValue((DataType)DataTypeEnum.getDataTypeByOrdinal((int)dataType), value));
            }
        });
    }
}

