/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class ValidateReclateOperation {
    private Log logger = LogFactory.getLog(ValidateReclateOperation.class);
    private DynamicObject infoBill;
    private String infoBillName;
    private String infoBillNumber;

    public ValidateReclateOperation(DynamicObject infoBill) {
        this.infoBill = infoBill;
        this.infoBillName = infoBill.getDataEntityType().getDisplayName().getLocaleValue();
        this.infoBillNumber = infoBill.getString("billno");
    }

    public Map<String, HashSet<Long>> srcBillReverseOpValidate(String sourceStrings) {
        return this.billDeleteOpValidate(Collections.singletonList(sourceStrings));
    }

    public Map<String, HashSet<Long>> srcBillReverseOpValidate(List<String> sourceStrings) {
        return this.billDeleteOpValidate(sourceStrings);
    }

    public Map<String, HashSet<Long>> billDeleteOpValidate(List<String> sourceStrings) {
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)this.infoBill.getDataEntityType().getName(), (Long[])new Long[]{(Long)this.infoBill.getPkValue()});
        this.validate(sourceStrings, sourceBills, new IMsgResult(){

            @Override
            public String getResult(DynamicObject bill) {
                return String.format(ResManager.loadKDString((String)"\u7531%1$s%2$s\u751f\u6210\u7684%3$s%4$s\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ValidateReclateOperation_0", (String)"fi-cas-business", (Object[])new Object[0]), bill.getString("billno"), bill.getDataEntityType().getDisplayName(), ValidateReclateOperation.this.infoBillNumber, ValidateReclateOperation.this.infoBillName);
            }
        });
        return sourceBills;
    }

    public Map<String, HashSet<Long>> targetBillReverseOpValidate(String targetStrings) {
        return this.billReverseOpValidate(Collections.singletonList(targetStrings));
    }

    public Map<String, HashSet<Long>> targetBillReverseOpValidate(List<String> targetStrings) {
        return this.billReverseOpValidate(targetStrings);
    }

    public Map<String, HashSet<Long>> billReverseOpValidate(List<String> targetStrings) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)this.infoBill.getDataEntityType().getName(), (Long[])new Long[]{(Long)this.infoBill.getPkValue()});
        this.filterPaymentTargetBills(targetBills);
        this.validate(targetStrings, targetBills, new IMsgResult(){

            @Override
            public String getResult(DynamicObject bill) {
                String billno = bill.getString("billno");
                return String.format(ResManager.loadKDString((String)"%1$s%2$s\u751f\u6210\u4e86%3$s\u516c\u53f8\u7684%4$s%5$s\uff0c\u76ee\u524d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u53cd\u5411\u64cd\u4f5c%6$s%7$s\u3002", (String)"ValidateReclateOperation_1", (String)"fi-cas-business", (Object[])new Object[0]), ValidateReclateOperation.this.infoBillNumber, ValidateReclateOperation.this.infoBillName, bill.getString("org.name"), billno, bill.getDataEntityType().getDisplayName(), billno, bill.getDataEntityType().getDisplayName());
            }
        });
        return targetBills;
    }

    public void filterPaymentTargetBills(Map<String, HashSet<Long>> payTargetBills) {
        DynamicObject[] transBills;
        if (Objects.equals(this.infoBill.getDataEntityType().getName(), "cas_paybill") && (transBills = BusinessDataServiceHelper.load((String)"cdm_draftallocation", (String)"id", (QFilter[])new QFilter("sourcebillid", "=", this.infoBill.getPkValue()).toArray())).length > 0) {
            DynamicObject transBill = transBills[0];
            Map transTargetBills = BFTrackerServiceHelper.findTargetBills((String)transBill.getDataEntityType().getName(), (Long[])new Long[]{(Long)transBill.getPkValue()});
            for (Map.Entry<String, HashSet<Long>> entry : payTargetBills.entrySet()) {
                String entryName = entry.getKey();
                HashSet<Long> payTargetBillIds = entry.getValue();
                HashSet transTargetBillIds = (HashSet)transTargetBills.get(entryName);
                if (!CollectionUtils.isEmpty((Collection)transTargetBillIds)) {
                    payTargetBillIds.removeAll(transTargetBillIds);
                }
                if (!Objects.equals(entryName, "cdm_draftallocation")) continue;
                payTargetBillIds.clear();
            }
        }
    }

    public void validate(List<String> billKP, Map<String, HashSet<Long>> bills, IMsgResult msgResult) {
        boolean isFromCdmDrafttradebill = false;
        if (CasHelper.isNotEmpty(bills)) {
            for (Map.Entry<String, HashSet<Long>> entry : bills.entrySet()) {
                DynamicObject[] destBills;
                String sourceBillType;
                String sourceKey = entry.getKey();
                HashSet<Long> sourcePks = entry.getValue();
                if (!billKP.contains(sourceKey)) continue;
                if ("cas_recbill".equals(this.infoBill.getDataEntityType().getName()) && "cdm_drafttradebill".equals(sourceBillType = this.infoBill.getString("sourcebilltype"))) {
                    isFromCdmDrafttradebill = true;
                }
                for (DynamicObject destBill : destBills = BusinessDataServiceHelper.load((Object[])sourcePks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceKey))) {
                    if ("A".equals(destBill.getString("billstatus")) || isFromCdmDrafttradebill) continue;
                    throw new KDBizException(ResManager.loadKDString((String)msgResult.getResult(destBill), (String)"ValidateReclateOperation_0", (String)"fi-cas-business", (Object[])new Object[0]));
                }
            }
        }
    }

    static interface IMsgResult {
        public String getResult(DynamicObject var1);
    }
}

