/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.bean.PushLinkInfo;
import kd.fi.cas.business.paysche.push.IPushPayBillAction;
import kd.fi.cas.business.paysche.push.PushContext;
import kd.fi.cas.util.StringUtils;

public class LinkScheInfoAction
implements IPushPayBillAction {
    private PushContext context;
    private static final String PREFIX_BILL = "bill_";
    private static final String PREFIX_FUND = "fund_";

    public LinkScheInfoAction(PushContext context) {
        this.context = context;
    }

    @Override
    public void execute() {
        List<PushLinkInfo> linkList;
        HashMap<String, Queue<PaySchePayInfo>> headMap = new HashMap<String, Queue<PaySchePayInfo>>(this.context.getPayInfoList().size());
        HashMap<String, Queue<PaySchePayInfo>> entryMap = new HashMap<String, Queue<PaySchePayInfo>>(this.context.getPayInfoList().size());
        for (PaySchePayInfo payInfo : this.context.getPayInfoList()) {
            if (payInfo.hasFundAmt()) {
                this.mappingPayInfo(payInfo, PREFIX_FUND + payInfo.getSourceBillId(), headMap);
                this.mappingPayInfo(payInfo, PREFIX_FUND + payInfo.getSourceEntryId(), entryMap);
            }
            if (!payInfo.hasBillAmt()) continue;
            this.mappingPayInfo(payInfo, PREFIX_BILL + payInfo.getSourceBillId(), headMap);
            this.mappingPayInfo(payInfo, PREFIX_BILL + payInfo.getSourceEntryId(), entryMap);
        }
        if (this.context.getFundPayBill() != null) {
            linkList = this.generateLinkInfo(this.context.getFundPayBill(), PREFIX_FUND, headMap, entryMap);
            this.context.getLinkInfoList().addAll(linkList);
        }
        if (this.context.getBillPayBill() != null) {
            linkList = this.generateLinkInfo(this.context.getBillPayBill(), PREFIX_BILL, headMap, entryMap);
            this.context.getLinkInfoList().addAll(linkList);
        }
    }

    private void mappingPayInfo(PaySchePayInfo payInfo, String key, Map<String, Queue<PaySchePayInfo>> map) {
        Queue entryQueue = map.computeIfAbsent(key, o -> new LinkedList());
        entryQueue.add(payInfo);
    }

    private List<PushLinkInfo> generateLinkInfo(DynamicObject payBill, String prefix, Map<String, Queue<PaySchePayInfo>> headMap, Map<String, Queue<PaySchePayInfo>> entryMap) {
        ArrayList<PushLinkInfo> linkList = new ArrayList<PushLinkInfo>();
        DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryList) {
            String sourceEntryId = entry.getString("e_sourcebillentryid");
            Long sourceBillId = entry.getLong("e_sourcebillid");
            boolean entryIdIsNull = StringUtils.isEmpty((String)sourceEntryId) || sourceEntryId.equals("0");
            PaySchePayInfo payScheInfo = entryIdIsNull ? headMap.get(prefix + sourceBillId).poll() : entryMap.get(prefix + sourceEntryId).poll();
            if (payScheInfo == null) continue;
            PushLinkInfo linkInfo = new PushLinkInfo();
            linkInfo.setPayBillId((Long)payBill.getPkValue());
            linkInfo.setPayBillEntryId(entry.getLong("id"));
            linkInfo.setPayScheId(payScheInfo.getScheId());
            linkList.add(linkInfo);
        }
        return linkList;
    }
}

