/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.push.IPushPayBillAction;
import kd.fi.cas.business.paysche.push.action.FillSchePayInfoAction;
import kd.fi.cas.business.paysche.push.action.InitPayBillInfoAction;
import kd.fi.cas.business.paysche.push.action.LinkScheInfoAction;
import kd.fi.cas.business.paysche.push.action.ReBuildPayBillAction;
import kd.fi.cas.business.paysche.push.action.SinglePushAction;
import kd.fi.cas.business.paysche.push.action.StatusConvertAction;
import kd.fi.cas.business.paysche.push.executor.AbstractPushPayBillExecutor;

public class SinglePushPayBillExecutor
extends AbstractPushPayBillExecutor {
    private DynamicObject sourceBill;

    public SinglePushPayBillExecutor(DynamicObject sourceBill, PaySchePayInfo payInfo) {
        super(Collections.singletonList(payInfo));
        this.sourceBill = sourceBill;
    }

    @Override
    protected List<IPushPayBillAction> getPushAction() {
        ArrayList<IPushPayBillAction> actionList = new ArrayList<IPushPayBillAction>();
        PaySchePayInfo payScheInfo = this.context.getPayInfoList().get(0);
        if (payScheInfo.isStatusConvert()) {
            actionList.add(new StatusConvertAction(this.context));
        } else {
            actionList.add(new SinglePushAction(this.context, this.sourceBill));
        }
        actionList.add(new InitPayBillInfoAction(this.context));
        actionList.add(new LinkScheInfoAction(this.context));
        actionList.add(new FillSchePayInfoAction(this.context));
        actionList.add(new ReBuildPayBillAction(this.context));
        return actionList;
    }
}

