/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.serive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class DraftLockServiceHelper {
    private static Log logger = LogFactory.getLog(DraftLockServiceHelper.class);
    private List<DraftLockInfo> changeLockInfoList = new ArrayList<DraftLockInfo>();
    private List<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
    private List<LockResult> resultList;
    private boolean strict;
    private String opStr = "";

    public DraftLockServiceHelper() {
        this.strict = true;
    }

    public DraftLockServiceHelper(boolean strictMode) {
        this.strict = strictMode;
    }

    public List<LockResult> changeDraftLock(List<DraftLockInfo> lockInfoList) {
        if (!CollectionUtils.isEmpty(lockInfoList)) {
            logger.info("is changeDraftLock");
            boolean isExistLockBillIdList = false;
            for (DraftLockInfo dli : lockInfoList) {
                List<DraftAmountLockSubInfo> lockBillIdList = dli.getLockSubInfoList();
                if (lockBillIdList.size() <= 0) continue;
                isExistLockBillIdList = true;
                break;
            }
            if (isExistLockBillIdList) {
                this.changeLockInfoList = lockInfoList;
                String resultListStr = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"changeBillLockInfo", (Object[])new Object[]{JSON.toJSONString(lockInfoList), this.strict});
                if (EmptyUtil.isNoEmpty((String)resultListStr)) {
                    this.resultList = (List)JSON.parseObject((String)resultListStr, (TypeReference)new TypeReference<List<LockResult>>(){}, (Feature[])new Feature[0]);
                }
            }
        }
        return this.resultList;
    }

    public List<LockResult> releaseOrLockDraft(List<DraftLockInfo> lockInfoList) {
        if (!CollectionUtils.isEmpty(lockInfoList)) {
            logger.info("is releaseOrLockDraft");
            this.lockOrReleaseInfoList = lockInfoList;
            String resultListStr = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"lockOrReleaseBill", (Object[])new Object[]{JSON.toJSONString(lockInfoList), this.strict});
            if (EmptyUtil.isNoEmpty((String)resultListStr)) {
                this.resultList = (List)JSON.parseObject((String)resultListStr, (TypeReference)new TypeReference<List<LockResult>>(){}, (Feature[])new Feature[0]);
            }
        }
        return this.resultList;
    }

    public void rollback() {
        if (EmptyUtil.isNoEmpty(this.resultList)) {
            logger.info("is rollback");
            List successLockResult = this.resultList.stream().filter(LockResult::isSuccess).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(successLockResult)) {
                Map<Long, LockResult> sourceIdAndDyMap = successLockResult.stream().collect(Collectors.toMap(LockResult::getSourceBillId, e -> e));
                try {
                    if (EmptyUtil.isNoEmpty(this.changeLockInfoList) && this.changeLockInfoList.size() > 0) {
                        ArrayList<DraftLockInfo> newChangeLockList = new ArrayList<DraftLockInfo>(8);
                        this.getChangeLockInfo(sourceIdAndDyMap);
                        this.changeDraftLock(newChangeLockList);
                    }
                    ArrayList<DraftLockInfo> newDraftLockReleaseList = new ArrayList<DraftLockInfo>(8);
                    if (EmptyUtil.isNoEmpty(this.lockOrReleaseInfoList) && this.lockOrReleaseInfoList.size() > 0) {
                        this.getAddAndReleaseLockInfo(sourceIdAndDyMap, newDraftLockReleaseList);
                        this.releaseOrLockDraft(newDraftLockReleaseList);
                    }
                }
                catch (Exception e1) {
                    logger.error("rollback has error:", (Throwable)e1);
                }
            }
        }
    }

    private void getChangeLockInfo(Map<Long, LockResult> sourceIdAndDyMap) {
        for (DraftLockInfo changeLockInfo : this.changeLockInfoList) {
            String sourceBillType = changeLockInfo.getSourceBillType();
            Long sourceBillId = changeLockInfo.getSourceBillId();
            if (!sourceIdAndDyMap.containsKey(sourceBillId)) continue;
            LockResult lockResult = sourceIdAndDyMap.get(sourceBillId);
            Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
            Set<Long> draftIdSet = billIdLogIdMap.keySet();
            DraftLockInfo newChangeDraftInfo = new DraftLockInfo();
            List<DraftAmountLockSubInfo> lockSubInfoList = changeLockInfo.getLockSubInfoList();
            Map<Long, DraftAmountLockSubInfo> draftIdAndSubDyInfoMap = lockSubInfoList.stream().collect(Collectors.toMap(e -> e.getBillId(), e -> e));
            for (Map.Entry<Long, Long> entry : billIdLogIdMap.entrySet()) {
                Long successDraft = entry.getKey();
                Long billLogId = entry.getValue();
                DraftAmountLockSubInfo draftAmountReleaseSubInfo = new DraftAmountLockSubInfo();
                DraftAmountLockSubInfo preLockSubInfo = draftIdAndSubDyInfoMap.get(successDraft);
                draftAmountReleaseSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountReleaseSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                BigDecimal dealAmount = preLockSubInfo.getDealAmount();
                draftAmountReleaseSubInfo.setDealAmount(dealAmount);
                draftAmountReleaseSubInfo.setBillLogId(billLogId);
                draftAmountReleaseSubInfo.setBillId(successDraft);
                newChangeDraftInfo.getLockSubInfoList().add(draftAmountReleaseSubInfo);
            }
            newChangeDraftInfo.setSourceBillType(changeLockInfo.getTargetBillType());
            newChangeDraftInfo.setSourceBillId(changeLockInfo.getTargetBillId());
            newChangeDraftInfo.setTargetBillType(sourceBillType);
            newChangeDraftInfo.setTargetBillId(sourceBillId);
        }
    }

    private void getAddAndReleaseLockInfo(Map<Long, LockResult> sourceIdAndDyMap, List<DraftLockInfo> newDraftLockReleaseList) {
        for (DraftLockInfo lockOrReleaseInfo : this.lockOrReleaseInfoList) {
            Long sourceBillId = lockOrReleaseInfo.getSourceBillId();
            if (!sourceIdAndDyMap.containsKey(sourceBillId)) continue;
            List lockBillIdList = lockOrReleaseInfo.getLockSubInfoList().stream().filter(e -> LogBizStatusEnum.PROCESS.getValue().equals(e.getBillTradeStatus())).map(DraftAmountLockSubInfo::getBillId).collect(Collectors.toList());
            List releaseBillIdList = lockOrReleaseInfo.getLockSubInfoList().stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getOperateType())).map(DraftAmountLockSubInfo::getBillId).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(lockBillIdList) && lockBillIdList.size() > 0) {
                List<DraftAmountLockSubInfo> lockSubInfoList = lockOrReleaseInfo.getLockSubInfoList();
                Map<Long, DraftAmountLockSubInfo> draftIdAndSubDyInfoMap = lockSubInfoList.stream().filter(e -> LogBizStatusEnum.PROCESS.getValue().equals(e.getBillTradeStatus())).collect(Collectors.toMap(e -> e.getBillId(), e -> e));
                DraftLockInfo draftLockInfo = new DraftLockInfo();
                LockResult lockResult = sourceIdAndDyMap.get(sourceBillId);
                Map<Long, BigDecimal> billIdDiffAmountMap = lockResult.getBillIdDiffAmountMap();
                Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                draftLockInfo.setBizBillNo(lockOrReleaseInfo.getBizBillNo());
                draftLockInfo.setSourceBillId(lockOrReleaseInfo.getSourceBillId());
                draftLockInfo.setSourceBillType(lockOrReleaseInfo.getSourceBillType());
                for (Map.Entry<Long, Long> entry : billIdLogIdMap.entrySet()) {
                    Long successDraft = entry.getKey();
                    Long billLogId = entry.getValue();
                    DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                    DraftAmountLockSubInfo preLockSubInfo = draftIdAndSubDyInfoMap.get(successDraft);
                    draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                    if (billIdDiffAmountMap.containsKey(successDraft)) {
                        BigDecimal dealAmount = billIdDiffAmountMap.get(successDraft);
                        if (EmptyUtil.isNoEmpty((BigDecimal)dealAmount) && BigDecimal.ZERO.compareTo(dealAmount) != 0) {
                            draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                            draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                            draftAmountLockSubInfo.setDealAmount(dealAmount);
                            draftAmountLockSubInfo.setBillLogId(billLogId);
                            draftAmountLockSubInfo.setBillId(successDraft);
                            draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
                            continue;
                        }
                        BigDecimal deleteDealAmount = preLockSubInfo.getDealAmount();
                        draftAmountLockSubInfo.setDealAmount(deleteDealAmount);
                        draftAmountLockSubInfo.setBillLogId(billLogId);
                        draftAmountLockSubInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                        draftAmountLockSubInfo.setBillId(successDraft);
                        draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                        draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
                        continue;
                    }
                    draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                    draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    BigDecimal addAmount = preLockSubInfo.getDealAmount();
                    draftAmountLockSubInfo.setDealAmount(addAmount);
                    draftAmountLockSubInfo.setBillLogId(billLogId);
                    draftAmountLockSubInfo.setBillId(successDraft);
                    draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
                }
                newDraftLockReleaseList.add(draftLockInfo);
            }
            if (!EmptyUtil.isNoEmpty(releaseBillIdList) || releaseBillIdList.size() <= 0) continue;
            List<DraftAmountLockSubInfo> releaseSubInfoList = lockOrReleaseInfo.getLockSubInfoList();
            Map<Long, DraftAmountLockSubInfo> deleteDraftIdAndSubDyInfoMap = releaseSubInfoList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getOperateType()) && LogOperateTypeEnum.DELETE.getValue().equals(e.getOperateType())).collect(Collectors.toMap(e -> e.getBillId(), e -> e));
            Map<Long, DraftAmountLockSubInfo> compeleteDraftIdAndSubDyInfoMap = releaseSubInfoList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getOperateType()) && LogOperateTypeEnum.COMPLETE.getValue().equals(e.getOperateType())).collect(Collectors.toMap(e -> e.getBillId(), e -> e));
            Map<Long, DraftAmountLockSubInfo> canCleComDraftIdAndSubDyInfoMap = releaseSubInfoList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getOperateType()) && LogOperateTypeEnum.CANCELCOMPLETE.getValue().equals(e.getOperateType())).collect(Collectors.toMap(e -> e.getBillId(), e -> e));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setBizBillNo(lockOrReleaseInfo.getBizBillNo());
            draftLockInfo.setSourceBillId(lockOrReleaseInfo.getSourceBillId());
            draftLockInfo.setSourceBillType(lockOrReleaseInfo.getSourceBillType());
            LockResult lockResult = sourceIdAndDyMap.get(sourceBillId);
            Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
            if (EmptyUtil.isNoEmpty(deleteDraftIdAndSubDyInfoMap) && deleteDraftIdAndSubDyInfoMap.size() > 0) {
                this.getDraftLockInfo(deleteDraftIdAndSubDyInfoMap, draftLockInfo, billIdLogIdMap, true, LogBizStatusEnum.PROCESS.getValue());
            } else if (EmptyUtil.isNoEmpty(compeleteDraftIdAndSubDyInfoMap) && compeleteDraftIdAndSubDyInfoMap.size() > 0) {
                this.getDraftLockInfo(compeleteDraftIdAndSubDyInfoMap, draftLockInfo, billIdLogIdMap, false, LogOperateTypeEnum.CANCELCOMPLETE.getValue());
            } else if (EmptyUtil.isNoEmpty(canCleComDraftIdAndSubDyInfoMap) && canCleComDraftIdAndSubDyInfoMap.size() > 0) {
                this.getDraftLockInfo(canCleComDraftIdAndSubDyInfoMap, draftLockInfo, billIdLogIdMap, false, LogOperateTypeEnum.COMPLETE.getValue());
            }
            newDraftLockReleaseList.add(draftLockInfo);
        }
    }

    private void getDraftLockInfo(Map<Long, DraftAmountLockSubInfo> deleteDraftIdAndSubDyInfoMap, DraftLockInfo draftLockInfo, Map<Long, Long> billIdLogIdMap, boolean isAdd, String opStr) {
        for (Map.Entry<Long, Long> entry : billIdLogIdMap.entrySet()) {
            Long successDraft = entry.getKey();
            Long billLogId = entry.getValue() == null ? Long.valueOf(0L) : entry.getValue();
            DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
            draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
            if (isAdd) {
                draftAmountLockSubInfo.setBillTradeStatus(opStr);
            } else {
                draftAmountLockSubInfo.setOperateType(opStr);
            }
            DraftAmountLockSubInfo preLockSubInfo = deleteDraftIdAndSubDyInfoMap.get(successDraft);
            BigDecimal dealAmount = preLockSubInfo.getDealAmount() == null ? BigDecimal.ZERO : preLockSubInfo.getDealAmount();
            draftAmountLockSubInfo.setDealAmount(dealAmount);
            draftAmountLockSubInfo.setBillLogId(billLogId);
            draftAmountLockSubInfo.setBillId(successDraft);
            draftLockInfo.getLockSubInfoList().add(draftAmountLockSubInfo);
        }
    }

    public DraftLockInfo getReleaseLockInfo(DynamicObject data, List<Long> lockDraftIds, HashMap<Long, BigDecimal> draftIdDealAmountMap, HashMap<Long, Long> draftIdLogIdMap) {
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setSourceBillType(data.getDataEntityType().getName());
        draftLockInfo.setBizBillNo(data.getString("billno"));
        draftLockInfo.setSourceBillId(data.getLong("id"));
        for (Long lockDraftId : lockDraftIds) {
            DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
            draftAmountLockInfo.setBillId(lockDraftId);
            BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : draftIdDealAmountMap.get(lockDraftId);
            draftAmountLockInfo.setDealAmount(dealAmount);
            Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : draftIdLogIdMap.get(lockDraftId);
            draftAmountLockInfo.setBillLogId(draftLogId);
            draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
            draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
            draftLockInfo.getLockSubInfoList().add(draftAmountLockInfo);
        }
        return draftLockInfo;
    }
}

