/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paywarning;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;

public class RecWarningHelper {
    private static final Log logger = LogFactory.getLog(RecWarningHelper.class);

    public static void submitValidate(DynamicObject dataEntity, AbstractFormPlugin plugin) {
        if (dataEntity == null) {
            return;
        }
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        List<DynamicObject> resultList = null;
        DynamicObject accountBank = dataEntity.getDynamicObject("accountbank");
        DynamicObject accountCash = dataEntity.getDynamicObject("accountcash");
        if (accountBank != null || accountCash != null) {
            ArrayList<Object> orgIdList = new ArrayList<Object>(10);
            orgIdList.add(org.getPkValue());
            DynamicObjectCollection recWarnList = RecWarningHelper.getRecWarnList(orgIdList);
            logger.info("\u5339\u914d\u89c4\u5219\u6570:" + recWarnList.size());
            resultList = RecWarningHelper.getRecWarnResults(dataEntity, recWarnList);
        }
        if (resultList != null && resultList.size() > 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("cas_recwarnmsg");
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "beforeSubmit"));
            plugin.getView().showForm(parameter);
        } else {
            plugin.getView().invokeOperation("submit");
        }
    }

    public static DynamicObjectCollection getRecWarnList(List<Object> recIdList) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"1").and(new QFilter("entry.org", "in", recIdList).or(QFilter.isNull((String)"entry.org")));
        return QueryServiceHelper.query((String)"cas_recwarnset", (String)"id,billno,day,payer,paynum,recnum,recamount,bizdate,entry.org", (QFilter[])new QFilter[]{filter});
    }

    public static List<DynamicObject> getRecWarnResults(DynamicObject dataEntity, DynamicObjectCollection recWarns) {
        if (recWarns == null || recWarns.size() == 0) {
            return null;
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
        HashSet<DynamicObject> allBills = new HashSet<DynamicObject>(16);
        HashSet<String> ids = new HashSet<String>(16);
        for (DynamicObject recWarn : recWarns) {
            DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billno,payertype,payername,billstatus,bizdate,currency,txt_description,payer,payeracctbanknum,actrecamt,accountbank,accountcash,createtime", (QFilter[])new QFilter[]{RecWarningHelper.getRecFilter(dataEntity, recWarn)});
            if (recBills == null || recBills.length <= 0) continue;
            for (DynamicObject recBill : recBills) {
                if (ids.contains(recBill.getString("id"))) continue;
                ids.add(recBill.getString("id"));
                allBills.add(recBill);
            }
        }
        if (allBills != null && allBills.size() > 0) {
            DeleteServiceHelper.delete((String)"cas_recwarnresult", (QFilter[])new QFilter[]{new QFilter("creater", "=", (Object)CasHelper.getCurrentUser())});
            bills.add(RecWarningHelper.getResult(allBills, dataEntity));
        }
        if (bills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
        }
        return bills;
    }

    private static QFilter getRecFilter(DynamicObject dataEntity, DynamicObject recWarn) {
        String payType = dataEntity.getString("payertype");
        Long payer = dataEntity.getLong("payer");
        String payerAcctBankNum = dataEntity.getString("payeracctbanknum");
        DynamicObject accountBank = dataEntity.getDynamicObject("accountbank");
        DynamicObject accountCash = dataEntity.getDynamicObject("accountcash");
        BigDecimal amount = dataEntity.getBigDecimal("actrecamt");
        Date bizDate = dataEntity.getDate("bizdate");
        QFilter filter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        Date date = DateUtils.getLastDay((Date)new Date(), (int)recWarn.getInt("day"));
        if (recWarn.getBoolean("payer")) {
            if ("other".equals(payType)) {
                filter.and("payername", "=", (Object)dataEntity.getString("payername"));
            } else {
                filter.and("payer", "=", (Object)payer);
            }
        }
        if (recWarn.getBoolean("paynum")) {
            filter.and("payeracctbanknum", "=", (Object)payerAcctBankNum);
        }
        if (recWarn.getBoolean("recnum") && (accountBank != null || accountCash != null)) {
            String field = accountBank != null ? "accountbank" : "accountcash";
            filter.and(field, "=", accountBank != null ? accountBank.getPkValue() : accountCash.getPkValue());
        }
        if (recWarn.getBoolean("recamount")) {
            filter.and("actrecamt", "=", (Object)amount);
        }
        if (recWarn.getBoolean("bizdate")) {
            filter.and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)bizDate, (boolean)true)).and(new QFilter("createtime", "<=", (Object)DateUtils.getDataFormat((Date)bizDate, (boolean)false)));
        }
        filter.and("createtime", ">=", (Object)date);
        return filter;
    }

    private static DynamicObject getResult(Set<DynamicObject> bills, DynamicObject data) {
        DynamicObject warnResult = BusinessDataServiceHelper.newDynamicObject((String)"cas_recwarnresult");
        warnResult.set("status", (Object)0);
        warnResult.set("batchno", (Object)DateUtils.formatString((Date)new Date(), (String)"yyyyMMddhhmmss"));
        warnResult.set("createdate", (Object)new Date());
        warnResult.set("creater", (Object)CasHelper.getCurrentUser());
        for (DynamicObject bill : bills) {
            RecWarningHelper.setEntryValue(bill, warnResult, true);
        }
        RecWarningHelper.setEntryValue(data, warnResult, false);
        return warnResult;
    }

    private static void setEntryValue(DynamicObject bill, DynamicObject warnResult, boolean hasSave) {
        DynamicObjectCollection entrys = warnResult.getDynamicObjectCollection("entry");
        DynamicObject entry = entrys.addNew();
        entry.set("note", (Object)(hasSave ? ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u6709\u6536\u6b3e\u5355", (String)"RecWarningHelper_0", (String)"fi-cas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u63d0\u4ea4\u6536\u6b3e\u5355", (String)"RecWarningHelper_1", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        entry.set("billno", bill.get("billno"));
        entry.set("billstatus", bill.get("billstatus"));
        entry.set("bizdate", (Object)DateUtils.formatString((Date)bill.getDate("bizdate"), (String)"yyyy-MM-dd"));
        entry.set("createtime", (Object)DateUtils.formatString((Date)bill.getDate("createtime"), (String)"yyyy-MM-dd HH:mm:ss"));
        entry.set("currency", bill.get("currency"));
        entry.set("description", bill.get("txt_description"));
        entry.set("hassave", (Object)hasSave);
        entry.set("payer", bill.get("payername"));
        entry.set("payernum", bill.get("payeracctbanknum"));
        entry.set("recamount", bill.get("actrecamt"));
        DynamicObject accountBank = bill.getDynamicObject("accountbank");
        DynamicObject accountcash = bill.getDynamicObject("accountcash");
        entry.set("recnum", (Object)(accountBank != null ? accountBank.getString("number") : (accountcash != null ? accountcash.getString("number") : "")));
    }

    public static List<DynamicObject> getResultByPkIds(List<Object> rowIds) {
        DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,org,billno,payertype,payername,billstatus,bizdate,currency,txt_description,payer,payeracctbanknum,actrecamt,accountbank,accountcash,createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", rowIds)});
        if (recBills == null || recBills.length == 0) {
            return null;
        }
        DeleteServiceHelper.delete((String)"cas_recwarnresult", (QFilter[])new QFilter[]{new QFilter("creater", "=", (Object)CasHelper.getCurrentUser())});
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(16);
        List<Object> orgIdList = Arrays.stream(recBills).map(o -> o.getDynamicObject("org")).filter(Objects::nonNull).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObjectCollection recWarnList = RecWarningHelper.getRecWarnList(orgIdList);
        Map<Object, List<DynamicObject>> recWarnListMap = recWarnList.stream().collect(Collectors.groupingBy(o -> o.get("entry.org")));
        for (DynamicObject recBill : recBills) {
            List<DynamicObject> recWarns;
            DynamicObject org;
            if (!BillStatusEnum.SAVE.getValue().equals(recBill.getString("billstatus")) || (org = recBill.getDynamicObject("org")) == null || (recWarns = recWarnListMap.get(org.getPkValue())) == null || recWarns.size() == 0) continue;
            HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(16);
            HashSet<String> ids = new HashSet<String>(16);
            for (DynamicObject recWarn : recWarns) {
                QFilter recFilter = RecWarningHelper.getRecFilter(recBill, recWarn);
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billno,payertype,payername,billstatus,bizdate,currency,txt_description,payer,payeracctbanknum,actrecamt,accountbank,accountcash,createtime", (QFilter[])new QFilter[]{recFilter.or(new QFilter("id", "=", recBill.getPkValue()))}, (String)"billstatus");
                if (bills == null || bills.length <= 0) continue;
                for (DynamicObject bill : bills) {
                    if (ids.contains(bill.getString("id"))) continue;
                    ids.add(bill.getString("id"));
                    billSet.add(bill);
                }
            }
            DynamicObject warnResult = RecWarningHelper.warnResult(billSet, recBill.getPkValue());
            if (warnResult == null) continue;
            resultList.add(warnResult);
        }
        if (resultList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]));
        }
        return resultList;
    }

    private static DynamicObject warnResult(Set<DynamicObject> bills, Object pkId) {
        if (bills == null || bills.size() <= 1) {
            return null;
        }
        DynamicObject warnResult = BusinessDataServiceHelper.newDynamicObject((String)"cas_recwarnresult");
        warnResult.set("status", (Object)0);
        warnResult.set("batchno", (Object)DateUtils.formatString((Date)new Date(), (String)"yyyyMMddhhmmss"));
        warnResult.set("createdate", (Object)new Date());
        warnResult.set("creater", (Object)CasHelper.getCurrentUser());
        for (DynamicObject bill : bills) {
            boolean isHas = !pkId.equals(bill.getPkValue());
            RecWarningHelper.setEntryValue(bill, warnResult, isHas);
        }
        return warnResult;
    }
}

