/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.recpayrule.transfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.recpayrule.bean.MatchBean;
import kd.fi.cas.business.recpayrule.transfer.AbstractMatchDataTransfer;

public class DetailMatchDataTransfer
extends AbstractMatchDataTransfer {
    private boolean noticeClaim;

    public DetailMatchDataTransfer(List<DynamicObject> bills) {
        super("bei_transdetail_cas", null, bills);
    }

    public DetailMatchDataTransfer(Object[] billIds) {
        super("bei_transdetail_cas", null, null);
        String selectString = StringUtils.join((Object[])this.getSelectPropList().toArray(new Object[0]), (String)",");
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)this.getNumber(), (String)selectString, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
        this.setBillList((List<DynamicObject>)detailList);
        this.noticeClaim = false;
    }

    public DetailMatchDataTransfer(Object[] billIds, boolean noticeClaim) {
        super("bei_transdetail_cas", null, null);
        String selectString = StringUtils.join((Object[])this.getSelectPropList().toArray(new Object[0]), (String)",");
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)this.getNumber(), (String)selectString, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
        this.setBillList((List<DynamicObject>)detailList);
        this.noticeClaim = noticeClaim;
    }

    @Override
    public List<MatchBean> buildMatchBean() {
        ArrayList<MatchBean> matchBeanList = new ArrayList<MatchBean>(10);
        List<DynamicObject> bills = this.getBillList();
        if (bills.isEmpty()) {
            return matchBeanList;
        }
        Map<String, List<DynamicObject>> billTypeMap = bills.stream().collect(Collectors.groupingBy(b -> BigDecimal.ZERO.compareTo(b.getBigDecimal("creditamount")) != 0 ? "rec" : "pay"));
        for (Map.Entry<String, List<DynamicObject>> entry0 : billTypeMap.entrySet()) {
            DynamicObject commonRule = this.getCommonRule(entry0.getKey(), this.noticeClaim);
            Map<Object, List<DynamicObject>> billMap = entry0.getValue().stream().collect(Collectors.groupingBy(b -> b.get("company.id")));
            DynamicObject[] matchingRules = this.getMatchingRule(billMap.keySet(), entry0.getKey(), false, this.noticeClaim);
            HashSet<Object> haveRuleCompanyId = new HashSet<Object>(16);
            for (DynamicObject matchingRule : matchingRules) {
                ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
                DynamicObjectCollection orgList = matchingRule.getDynamicObjectCollection("org_entry");
                for (DynamicObject org : orgList) {
                    if (!billMap.containsKey(org.getDynamicObject("u_org").getPkValue())) continue;
                    haveRuleCompanyId.add(org.getDynamicObject("u_org").getPkValue());
                    billList.addAll((Collection<DynamicObject>)billMap.get(org.getDynamicObject("u_org").getPkValue()));
                }
                MatchBean matchBean = new MatchBean();
                matchBean.setBillList(billList);
                matchBean.setMainOrgRule(matchingRule);
                matchBeanList.add(matchBean);
            }
            for (Map.Entry entry : billMap.entrySet()) {
                if (haveRuleCompanyId.contains(entry.getKey())) continue;
                MatchBean matchBean = new MatchBean();
                matchBean.setCommonRule(commonRule);
                matchBean.setBillList((List)entry.getValue());
                matchBeanList.add(matchBean);
            }
        }
        return matchBeanList;
    }
}

