/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.refund;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.ConvertRuleIdEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.log.RefundLogExecutor;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.EmptyUtil;

public class RefundService {
    private static final Log logger = LogFactory.getLog(RefundService.class);
    public static final String[] REV_OPERATES = new String[]{"save", "submit", "audit", "receivingrec"};

    public Long insertMarkLog(DynamicObject transDetailBill, String operate) {
        RefundLogExecutor logExecutor = new RefundLogExecutor(transDetailBill.getDataEntityType().getName(), operate);
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        result.setMessage("running");
        Long[] logIds = logExecutor.saveAutoRenoteLog(result, null, transDetailBill);
        return logIds[0];
    }

    public void updateLogResult(Long logId, OperationResult result) {
        RefundLogExecutor logExecutor = new RefundLogExecutor();
        logExecutor.updateLogResult(logId, result);
    }

    public boolean checkHaveRefundBills(DynamicObject transDetailBill) {
        QFilter payBillFilter = RefundHelper.buildPayBillFilterByTransBill((DynamicObject)transDetailBill);
        boolean payBillExists = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])payBillFilter.toArray());
        if (payBillExists) {
            return true;
        }
        QFilter agentBillFilter = RefundHelper.buildAgentBillFilterByTransBill((DynamicObject)transDetailBill);
        DynamicObjectCollection agentList = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,isencryption,entry.e_amount,entry.e_encryptamount", (QFilter[])agentBillFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)agentList)) {
            return false;
        }
        List filterAgentList = RefundHelper.filterAgentAmtByTransDetail((List)agentList, (DynamicObject)transDetailBill);
        return !filterAgentList.isEmpty();
    }

    public OperationResult autoRenote(Long billId, String billType) {
        return this.autoRenote(billId, billType, null, null);
    }

    public OperationResult autoRenote(Long billId, String billType, Collection<Long> agentRefundEntryIds) {
        return this.autoRenote(billId, billType, agentRefundEntryIds, null);
    }

    public OperationResult autoRenote(Long billId, String billType, Long transDetailId) {
        return this.autoRenote(billId, billType, null, transDetailId);
    }

    public OperationResult autoRenote(Long billId, String billType, Collection<Long> agentRefundEntryIds, Long transDetailId) {
        OperationResult result;
        DynamicObject[] revBills;
        String operate = "cas_paybill".equals(billType) ? "paybillAutoRenote" : "agentbillAutoRenote";
        RefundLogExecutor logExecutor = new RefundLogExecutor(billType, operate);
        DynamicObject payOrAgentBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType, (String)"id,currency,org,refunddetailid,billno,entry.id");
        if (payOrAgentBill.getDynamicObjectCollection("entry").isEmpty()) {
            return RefundService.saveErrLog(payOrAgentBill, (Exception)((Object)new KDBizException("business bill no entry")), logExecutor, null);
        }
        try {
            if ("cas_paybill".equals(billType)) {
                revBills = CasBotpHelper.push((DynamicObject)payOrAgentBill, (String)"cas_recbill", (String)ConvertRuleIdEnum.AUTO_RENOTE_PAY_REV.getRuleId());
            } else {
                if (CollectionUtils.isEmpty(agentRefundEntryIds)) {
                    agentRefundEntryIds = payOrAgentBill.getDynamicObjectCollection("entry").stream().map(en -> en.getLong("id")).collect(Collectors.toSet());
                }
                revBills = CasBotpHelper.push((DynamicObject)payOrAgentBill, (String)"entry", agentRefundEntryIds, (String)"cas_recbill", (String)ConvertRuleIdEnum.AUTO_RENOTE_AGENT_REV.getRuleId());
            }
        }
        catch (Exception e) {
            logger.error("auto refund push error", (Throwable)e);
            return RefundService.saveErrLog(payOrAgentBill, e, logExecutor, null);
        }
        DynamicObject transDetail = null;
        if (transDetailId != null) {
            QFilter filter = new QFilter("id", "=", (Object)transDetailId);
            transDetail = QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)"id,billno,bizdate,debitamount,creditamount,bankcheckflag", (QFilter[])filter.toArray());
        }
        Object[] revIds = (Long[])Arrays.stream(revBills).map(r -> r.getLong("id")).toArray(Long[]::new);
        logger.info("auto renote push rev success,size:" + Arrays.toString(revIds));
        revBills = new DynamicObject[]{revBills[0]};
        this.updateRevBill(transDetail, revBills);
        for (String operateKey : REV_OPERATES) {
            OperationResult operationResult;
            try (TXHandle tx = TX.requiresNew();){
                Object[] ids;
                try {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("WF", "true");
                    option.setVariableValue("AUTO_RENOTE", "true");
                    option.setVariableValue("ignoreValidation", "true");
                    logger.info("auto refund executing " + operateKey);
                    if ("save".equals(operateKey)) {
                        operationResult = OperateServiceHelper.execOperateWithoutThrow((String)operateKey, (String)"cas_recbill", (DynamicObject[])revBills, (OperateOption)option);
                    } else {
                        ids = Arrays.stream(revBills).map(r -> r.get("id")).toArray();
                        operationResult = OperateServiceHelper.execOperateWithoutThrow((String)operateKey, (String)"cas_recbill", (Object[])ids, (OperateOption)option);
                    }
                    logger.info("auto refund execute end " + operateKey);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("auto refund do" + operateKey + " error: ", (Throwable)e);
                    ids = RefundService.saveErrLog(payOrAgentBill, e, logExecutor, revBills);
                    if (tx != null) {
                        if (var17_21 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var17_21.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return ids;
                }
                boolean success = operationResult.isSuccess();
                if (!success) {
                    tx.markRollback();
                    String failResultMsg = CasHelper.getFailResultMsg((OperationResult)operationResult);
                    logger.error("auto refund do" + operateKey + " error: " + failResultMsg);
                    logExecutor.saveAutoRenoteLog(operationResult, revBills, payOrAgentBill);
                    OperationResult operationResult2 = operationResult;
                    return operationResult2;
                }
            }
            if (!"save".equals(operateKey) || !operationResult.isSuccess()) continue;
            this.autoMatchTransDetail(transDetail, revBills[0]);
        }
        if (!this.checkTx(revBills[0])) {
            String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u6b63\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d,\u7a0d\u540e\u8bf7\u624b\u52a8\u64cd\u4f5c\u9000\u7968\u3002", (String)"RefundService_1", (String)"fi-cas-business", (Object[])new Object[0]);
            return RefundService.saveErrLog(payOrAgentBill, (Exception)((Object)new KDBizException(msg)), logExecutor, revBills);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("operateKey", "renote");
        option.setVariableValue("billType", billType);
        option.setVariableValue("billId", String.valueOf(payOrAgentBill.getPkValue()));
        if (CollectionUtils.isNotEmpty((Collection)agentRefundEntryIds)) {
            option.setVariableValue("entryIds", JSONObject.toJSONString((Object)agentRefundEntryIds));
        }
        try {
            result = OperateServiceHelper.execOperateWithoutThrow((String)"refund_backstage", (String)"cas_recbill", (DynamicObject[])revBills, (OperateOption)option);
        }
        catch (Exception e) {
            logger.error("auto refund doRefund error: ", (Throwable)e);
            return RefundService.saveErrLog(payOrAgentBill, e, logExecutor, revBills);
        }
        if (result.isSuccess()) {
            RefundService.updateRefundDetailId(billType, (Long)payOrAgentBill.getPkValue(), transDetailId, agentRefundEntryIds);
        } else {
            String failResultMsg = CasHelper.getFailResultMsg((OperationResult)result);
            logger.error("auto refund doRefund fail: " + failResultMsg);
        }
        logExecutor.saveAutoRenoteLog(result, revBills, payOrAgentBill);
        return result;
    }

    private boolean checkTx(DynamicObject revBill) {
        String revId = String.valueOf(revBill.getLong("id"));
        List<String> revIds = Collections.singletonList(revId);
        List lockedIds = TxCheckUtil.getLocked(revIds);
        if (!lockedIds.contains(revId)) {
            return true;
        }
        for (int i = 0; i < 200; ++i) {
            logger.info("checkTx retry num:" + i + ", revId=" + revId);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.info("checkTx error", (Object)e);
            }
            List locks = TxCheckUtil.getLocked(revIds);
            if (locks.contains(revId)) continue;
            return true;
        }
        return false;
    }

    private void updateRevBill(DynamicObject transDetail, DynamicObject[] revBills) {
        if (transDetail != null) {
            for (DynamicObject revBill : revBills) {
                revBill.set("refunddetailid", transDetail.get("id"));
                revBill.set("bizdate", transDetail.get("bizdate"));
                revBill.set("payeedate", transDetail.get("bizdate"));
            }
        }
    }

    public static void updateRefundDetailId(String billType, Long payOrAgentId, Long transDetailId, Collection<Long> agentEntryIds) {
        if ("cas_paybill".equals(billType)) {
            DynamicObject updatePayBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)billType), (Object)payOrAgentId);
            updatePayBill.set("refunddetailid", (Object)transDetailId);
            SaveServiceHelper.update((DynamicObject)updatePayBill);
        } else if (CollectionUtils.isNotEmpty(agentEntryIds)) {
            List paramsList = agentEntryIds.stream().map(agentEntryId -> new Object[]{transDetailId, agentEntryId}).collect(Collectors.toList());
            String sql = "update T_CAS_AgentPayBillEntry set frefunddetailid = ? where fentryid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, paramsList);
        }
    }

    private static OperationResult saveErrLog(DynamicObject bill, Exception e, RefundLogExecutor logExecutor, DynamicObject[] revBills) {
        OperationResult opResult = new OperationResult();
        opResult.setSuccess(false);
        opResult.setMessage(e.getMessage());
        logExecutor.saveAutoRenoteLog(opResult, revBills, bill);
        return opResult;
    }

    private void autoMatchTransDetail(DynamicObject transDetail, DynamicObject revBill) {
        if (transDetail != null) {
            try {
                ReceredWayEnum receredWayEnum;
                String sourceEntity;
                String direction;
                BigDecimal debitAmount = transDetail.getBigDecimal("debitamount");
                BigDecimal creditAmount = transDetail.getBigDecimal("creditamount");
                boolean debitEmpty = EmptyUtil.isEmpty((BigDecimal)debitAmount);
                boolean creditEmpty = EmptyUtil.isEmpty((BigDecimal)creditAmount);
                if (debitEmpty && creditEmpty || !debitEmpty && !creditEmpty) {
                    return;
                }
                if (!debitEmpty) {
                    direction = debitAmount.compareTo(BigDecimal.ZERO) > 0 ? "pay" : "rec";
                    sourceEntity = "bei_intelpay";
                    receredWayEnum = ReceredWayEnum.REVERSEMATCH;
                } else {
                    direction = debitAmount.compareTo(BigDecimal.ZERO) > 0 ? "rec" : "pay";
                    sourceEntity = "bei_intelrec";
                    receredWayEnum = ReceredWayEnum.AUTOMATCH;
                }
                BigDecimal amt = revBill.getBoolean("relateotherflow") ? ("pay".equals(direction) ? revBill.getBigDecimal("unmatchamountpay") : revBill.getBigDecimal("unmatchamountrec")) : revBill.getBigDecimal("unmatchamountrec");
                ArrayList<AutoMatchInfoParam> autoMatchInfoList = new ArrayList<AutoMatchInfoParam>(1);
                AutoMatchInfoParam autoMatchInfoParam = new AutoMatchInfoParam(sourceEntity, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), "cas_recbill", revBill.getString("billno"), Long.valueOf(revBill.getLong("id")), Long.valueOf(0L), DynamicObjectHelper.getPk((DynamicObject)revBill, (String)"currency"), "", amt, transDetail.getString("bankcheckflag"), transDetail.getDate("bizdate"), String.valueOf(DB.genGlobalLongId()), direction);
                autoMatchInfoList.add(autoMatchInfoParam);
                logger.info("start autoMatchTransDetail");
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{autoMatchInfoList, receredWayEnum.getValue(), null, true, null});
                this.checkTx(revBill);
                CasFlowConfirmLogHelper.saveMatchLog(autoMatchInfoList, receredWayEnum.getValue());
            }
            catch (Exception e) {
                logger.error("auto renote autoMatchTransDetail error: ", (Throwable)e);
            }
        }
    }
}

