/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.schedule;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.opservice.factory.BankVCCheckServiceContext;
import kd.fi.cas.business.pojo.BankVCCheckInfo;
import kd.fi.cas.helper.CasHelper;

public class BankVCCheckSchedule {
    private static final Log logger = LogFactory.getLog(BankVCCheckSchedule.class);

    public void autoCheck(Long accountBankId) {
        DynamicObjectCollection acctColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,name,company,company.name,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname", (QFilter[])new QFilter[]{new QFilter("acctstatus", "=", (Object)"normal"), new QFilter("id", "=", (Object)accountBankId)}, null);
        long orgId = 0L;
        DynamicObject checkScheme = null;
        for (int i = 0; i < acctColl.size(); ++i) {
            DynamicObject acct = (DynamicObject)acctColl.get(i);
            try (TXHandle h = TX.requiresNew((String)"schedule_bankvccheck");){
                try {
                    if (acct.getLong("company") != orgId) {
                        orgId = acct.getLong("company");
                        checkScheme = BusinessDataServiceHelper.loadSingle((String)"cas_checkscheme", (String)"id,org,ischeckflag,issettlenum4schedule,isbizdate,isdatediff,issettlementtype,issettlenum4auto,isdescription,isoppunit,datediffcount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
                        if (checkScheme == null) {
                            checkScheme = BusinessDataServiceHelper.newDynamicObject((String)"cas_checkscheme");
                            checkScheme.set("ischeckflag", (Object)"1");
                            checkScheme.set("issettlenum4schedule", (Object)"1");
                        }
                        checkScheme.set("org", (Object)acct.getLong("company"));
                    }
                    BankVCCheckInfo checkInfo = new BankVCCheckInfo();
                    checkInfo.setOrgId(orgId);
                    checkInfo.setAccountBankId(acct.getLong("id"));
                    checkInfo.setCurrencyId(acct.getLong("currencyid"));
                    checkInfo.setCheckType("byauto");
                    checkInfo.setCheckScheme(checkScheme);
                    logger.info(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5bf9\u8d26\u2014\u2014\u94f6\u884c\u8d26\u6237\uff1a%1$s \u5e01\u79cd\uff1a%2$s \u5f00\u59cb\u6267\u884c\u5bf9\u8d26\u65b9\u6cd5doCheck\uff1a%3$s", (String)"BankVCCheckSchedule_0", (String)"fi-cas-business", (Object[])new Object[0]), acct.getString("name"), acct.getString("currencyname"), checkInfo));
                    BankVCCheckServiceContext checkContext = new BankVCCheckServiceContext(checkInfo);
                    checkContext.doCheck();
                    logger.info(String.format(ResManager.loadKDString((String)"\u667a\u80fd\u5bf9\u8d26\u2014\u2014\u94f6\u884c\u8d26\u6237\uff1a%1$s \u5e01\u79cd\uff1a%2$s docheck\u65b9\u6cd5\u6267\u884c\u5b8c\u6210", (String)"BankVCCheckSchedule_1", (String)"fi-cas-business", (Object[])new Object[0]), acct.getString("name"), acct.getString("currencyname")));
                }
                catch (Exception exception) {
                    h.markRollback();
                    String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u94f6\u884c\u8d26\u6237\u201c%2$s\u201d\u5e01\u79cd\u2018%3$s'\u540e\u53f0\u667a\u80fd\u5bf9\u8d26\u5931\u8d25\uff1a\u5f02\u5e38\u4fe1\u606f\uff1a%4$s\u3002", (String)"BankVCCheckSchedule_2", (String)"fi-cas-business", (Object[])new Object[0]), acct.getString("company.name"), acct.getString("name"), acct.getString("currencyname"), CasHelper.getStackTraceMessage((Exception)exception));
                    logger.error(message);
                }
                continue;
            }
        }
    }
}

