/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.bean.CancelPayResult;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.OperateServiceHelper;

public class AgentPayInfoService {
    private static Log logger = LogFactory.getLog(AgentPayInfoService.class);

    public List<Long> getPayer() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter functionFilter = new QFilter("fisbankroll", "=", (Object)"1");
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        ArrayList<Long> payerIds = new ArrayList<Long>(orgs.size());
        for (DynamicObject org : orgs.values()) {
            payerIds.add(org.getLong("id"));
        }
        logger.info("AgentPayInfoService getPayerIds:" + SerializationUtils.toJsonString(payerIds));
        return payerIds;
    }

    public String cancelPayValidate(List<String> sourceBillIds) {
        CancelPayResult result = new CancelPayResult();
        if (CasHelper.isEmpty(sourceBillIds)) {
            return SerializationUtils.toJsonString((Object)result);
        }
        DynamicObject[] agentBills = this.loadAgentBills(sourceBillIds);
        HashSet<String> failSourceBills = new HashSet<String>(agentBills.length);
        for (DynamicObject agentBill : agentBills) {
            String billstatus = agentBill.getString("billstatus");
            if (!BillStatusEnum.SUBMIT.getValue().equals(billstatus) && !BillStatusEnum.AUDIT.getValue().equals(billstatus) && !BillStatusEnum.PAY.getValue().equals(billstatus) && !BillStatusEnum.BEING.getValue().equals(billstatus)) continue;
            failSourceBills.add(((DynamicObject)agentBill.getDynamicObjectCollection("entry").get(0)).getString("sourcebillid"));
        }
        ArrayList<String> successBills = new ArrayList<String>(sourceBillIds);
        successBills.removeAll(failSourceBills);
        result.setFailBills(new ArrayList<String>(failSourceBills));
        result.setSuccessBills(successBills);
        logger.info("AgentPayInfoService cancelPayValidate result:" + SerializationUtils.toJsonString((Object)result));
        return SerializationUtils.toJsonString((Object)result);
    }

    public String cancelPay(List<String> sourceBillIds) {
        logger.info("AgentPayInfoService cancelPay req:" + SerializationUtils.toJsonString(sourceBillIds));
        CancelPayResult result = new CancelPayResult();
        result.setSuccessBills(sourceBillIds);
        if (CasHelper.isEmpty(sourceBillIds)) {
            return SerializationUtils.toJsonString((Object)result);
        }
        DynamicObject[] agentBills = this.loadAgentBills(sourceBillIds);
        ArrayList<Long> opBillIds = new ArrayList<Long>(agentBills.length);
        for (DynamicObject agentBill : agentBills) {
            String billstatus = agentBill.getString("billstatus");
            if (BillStatusEnum.SUBMIT.getValue().equals(billstatus) || BillStatusEnum.AUDIT.getValue().equals(billstatus) || BillStatusEnum.PAY.getValue().equals(billstatus) || BillStatusEnum.BEING.getValue().equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u53d1\u8d77\u4ed8\u6b3e\u6d41\u7a0b\uff0c\u65e0\u6cd5\u64a4\u9500\u4ed8\u6b3e\u3002", (String)"AgentPayInfoService_0", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (!BillStatusEnum.SAVE.getValue().equals(billstatus)) continue;
            opBillIds.add(agentBill.getLong("id"));
        }
        if (opBillIds.size() == 0) {
            return SerializationUtils.toJsonString((Object)result);
        }
        DynamicObject[] opBills = BusinessDataServiceHelper.load((Object[])opBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_agentpaybill"));
        ArrayList<DynamicObject> newBills = new ArrayList<DynamicObject>(opBills.length);
        for (DynamicObject opBill : opBills) {
            DynamicObject newBill = (DynamicObject)OrmUtils.clone((Object)opBill, (IDataEntityType)opBill.getDataEntityType(), (boolean)true, (boolean)true);
            newBill.set("reason", (Object)ResManager.loadKDString((String)"\u85aa\u916c\u4ee3\u53d1\u5355\u64a4\u9500", (String)"AgentPayInfoService_1", (String)"fi-cas-business", (Object[])new Object[0]));
            newBill.set("backuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            newBill.set("backdate", (Object)new Date());
            newBill.set("billstatus", (Object)BillStatusEnum.CHARGEBANK.getValue());
            DynamicObjectCollection entrys = newBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_issuccess", (Object)"0");
            }
            String generateNumber = CodeRuleHelper.generateNumber((String)"cas_agentpaybill", (DynamicObject)newBill, null, (String)"");
            if (StringUtils.isEmpty((CharSequence)generateNumber)) {
                generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            }
            newBill.set("billno", (Object)generateNumber);
            newBills.add(newBill);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperateOption create = OperateOption.create();
                create.setVariableValue("byhr", "true");
                create.setVariableValue("ishasright", "true");
                OperateServiceHelper.execOperate((String)"delete", (String)"cas_agentpaybill", (DynamicObject[])opBills, (OperateOption)create);
                SaveServiceHelper.save((DynamicObject[])newBills.toArray(new DynamicObject[newBills.size()]));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw e;
            }
        }
        logger.info("AgentPayInfoService cancelPay result:" + SerializationUtils.toJsonString((Object)result));
        return SerializationUtils.toJsonString((Object)result);
    }

    private DynamicObject[] loadAgentBills(List<String> sourceBillIds) {
        QFilter sBillTypeFilter = new QFilter("sourcebilltype", "=", (Object)"hsas_agencypaybill");
        List sourceBillPks = sourceBillIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        QFilter sBillFilter = new QFilter("entry.sourcebillid", "in", sourceBillPks);
        CharSequence[] selectProps = new String[]{"billstatus", "sourcebillid"};
        DynamicObject[] agentBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)String.join((CharSequence)",", selectProps), (QFilter[])new QFilter[]{sBillTypeFilter, sBillFilter});
        return agentBills;
    }
}

