/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.IBalanceAdjustService;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class BalanceAdjustService
implements IBalanceAdjustService {
    private static final BalanceAdjustService balanceAdjustService = new BalanceAdjustService();

    private BalanceAdjustService() {
    }

    public static BalanceAdjustService getInstance() {
        return balanceAdjustService;
    }

    @Override
    public void getBalanceAdjustColls(List<Long> periods, List<Long> accounts) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.updBalAdjusts(periods, accounts);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void updBalAdjusts(List<Long> periods, List<Long> accounts) {
        for (Long account : accounts) {
            QFilter[] acctfilters = new QFilter[]{new QFilter("id", "=", (Object)account)};
            String selectFields = String.join((CharSequence)",", "currency.fbasedataid.id as currencyid", "company");
            DynamicObjectCollection acctColl = QueryServiceHelper.query((String)"getAcctPlainColl", (String)"bd_accountbanks", (String)selectFields, (QFilter[])acctfilters, null);
            for (DynamicObject acct : acctColl) {
                Long org = acct.getLong("company");
                if (!SystemStatusCtrolHelper.isFinishInit((long)org)) continue;
                for (Long period : periods) {
                    QFilter[] periodFilters = new QFilter[]{new QFilter("id", "=", (Object)period)};
                    DynamicObject periodObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])periodFilters);
                    if (periodObj == null) continue;
                    this.updBalAdjust(org, period, account, acct.getLong("currencyid"));
                }
            }
        }
    }

    @Override
    public void updBalAdjust(Long org, Long period, Long account, Long currency) {
        int processType = 0;
        if (period == null) {
            processType = 1;
        } else {
            DynamicObject periodObj = PeriodHelper.getPeriodById((long)period);
            if (org == null) {
                DynamicObject accountBank = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)account)});
                org = accountBank.getLong("company");
            }
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)org);
            DynamicObject startperiod = initObj.getDynamicObject("startperiod");
            DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
            if (PeriodHelper.before((DynamicObject)periodObj, (DynamicObject)startperiod) || PeriodHelper.after((DynamicObject)periodObj, (DynamicObject)currentperiod)) {
                processType = 2;
                this.delBalAdjust(period, account, currency);
            }
            if ((PeriodHelper.equal((DynamicObject)periodObj, (DynamicObject)startperiod) || PeriodHelper.after((DynamicObject)periodObj, (DynamicObject)startperiod)) && PeriodHelper.before((DynamicObject)periodObj, (DynamicObject)currentperiod)) {
                processType = 3;
            }
            if (PeriodHelper.equal((DynamicObject)periodObj, (DynamicObject)startperiod) && PeriodHelper.equal((DynamicObject)periodObj, (DynamicObject)currentperiod)) {
                processType = 4;
            }
            if (PeriodHelper.after((DynamicObject)periodObj, (DynamicObject)startperiod) && PeriodHelper.equal((DynamicObject)periodObj, (DynamicObject)currentperiod)) {
                processType = 5;
            }
        }
        if (processType == 1 || processType == 3 || processType == 4 || processType == 5) {
            DynamicObject balAdjust = this.getBalanceAdjust(period, account, currency);
            if (balAdjust != null) {
                if (!balAdjust.getString("billstatus").equals("B")) {
                    Long balAdjustId = (Long)balAdjust.getPkValue();
                    this.delBalAdjust(period, account, currency);
                    this.insBalAdjust(balAdjustId, org, period, account, currency);
                }
            } else {
                this.insBalAdjust(null, org, period, account, currency);
            }
        }
    }

    private void delBalAdjust(Long period, Long account, Long currency) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_balanceadjust");
        QFilter bFilters = new QFilter("bankaccount", "=", (Object)account);
        bFilters = bFilters.and(new QFilter("currency", "=", (Object)currency));
        bFilters = period != null ? bFilters.and(new QFilter("period", "=", (Object)period)) : bFilters.and(new QFilter("period", "=", (Object)0));
        QFilter[] filters = new QFilter[]{bFilters};
        DynamicObjectCollection balAdjustColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"id", (QFilter[])filters);
        if (balAdjustColl != null && balAdjustColl.size() > 0) {
            Object[] balAdjustPKs = new Object[balAdjustColl.size()];
            for (int i = 0; i < balAdjustColl.size(); ++i) {
                balAdjustPKs[i] = ((DynamicObject)balAdjustColl.get(i)).get("id");
            }
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])balAdjustPKs);
        }
    }

    private void insBalAdjust(Long balAdjustId, Long orgId, Long periodId, Long accountId, Long currencyId) {
        QFilter[] periodFilters;
        DynamicObject periodObj;
        ICodeRuleService codeRuleService;
        BigDecimal journalbalamt = new BigDecimal("0");
        BigDecimal statmntbalamt = new BigDecimal("0");
        QFilter[] initFilters = new QFilter[]{new QFilter("entrybank.bank_accountbank", "=", (Object)accountId), new QFilter("entrybank.bank_currency", "=", (Object)currencyId)};
        DynamicObjectCollection cashmgtinitColls = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id, entrybank.bank_journalbalance, entrybank.bank_statementbalance, entrybank.bank_accountbank, entrybank.bank_currency", (QFilter[])initFilters, (String)"id");
        if (cashmgtinitColls != null && cashmgtinitColls.size() > 0) {
            for (DynamicObject cashmgtinit : cashmgtinitColls) {
                journalbalamt = cashmgtinit.getBigDecimal("entrybank.bank_journalbalance");
                statmntbalamt = cashmgtinit.getBigDecimal("entrybank.bank_statementbalance");
            }
        }
        if (periodId != null) {
            QFilter[] journalFilters;
            DynamicObject[] journals;
            journalbalamt = new BigDecimal("0");
            QFilter[] journalBalFilters = new QFilter[]{new QFilter("period", "=", (Object)periodId), new QFilter("accountbank", "=", (Object)accountId), new QFilter("currency", "=", (Object)currencyId), new QFilter("type", "=", (Object)"2")};
            DynamicObject[] journalBal = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, monthstart", (QFilter[])journalBalFilters);
            if (journalBal.length > 0) {
                for (int i = 0; i < journalBal.length; ++i) {
                    journalbalamt = journalbalamt.add(journalBal[i].getBigDecimal("monthstart"));
                }
            }
            if ((journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id, accountbank, debitamount, creditamount", (QFilter[])(journalFilters = new QFilter[]{new QFilter("accountbank", "=", (Object)accountId), new QFilter("currency", "=", (Object)currencyId), new QFilter("period", "=", (Object)periodId)}))) != null && journals.length > 0) {
                for (DynamicObject obj : journals) {
                    journalbalamt = journalbalamt.add(obj.getBigDecimal("debitamount")).subtract(obj.getBigDecimal("creditamount"));
                }
            }
            long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
            DynamicObjectCollection periodList = PeriodHelper.getPeriodList((long)periodTypeId);
            ArrayList<Long> periodIDList = new ArrayList<Long>();
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
            DynamicObject startperiod = initObj.getDynamicObject("startperiod");
            DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
            for (DynamicObject periodObj2 : periodList) {
                if (PeriodHelper.before((DynamicObject)periodObj2, (DynamicObject)startperiod) || PeriodHelper.after((DynamicObject)periodObj2, (DynamicObject)currentperiod)) continue;
                periodIDList.add(periodObj2.getLong("id"));
            }
            QFilter[] statmntFilters = new QFilter[]{new QFilter("accountbank", "=", (Object)accountId), new QFilter("currency", "=", (Object)currencyId), new QFilter("period", "in", periodIDList)};
            DynamicObject[] statmnts = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)"id, accountbank, debitamount, creditamount", (QFilter[])statmntFilters);
            if (statmnts != null && statmnts.length > 0) {
                for (DynamicObject obj : statmnts) {
                    statmntbalamt = statmntbalamt.add(obj.getBigDecimal("creditamount")).subtract(obj.getBigDecimal("debitamount"));
                }
            }
        }
        DynamicObject balAdjust = BusinessDataServiceHelper.newDynamicObject((String)"cas_balanceadjust");
        if (balAdjustId != null) {
            balAdjust.set("id", (Object)balAdjustId);
        }
        if ((codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class)) == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        String number = codeRuleService.getNumber("cas_balanceadjust", balAdjust, null);
        balAdjust.set("billno", (Object)number);
        balAdjust.set("org", (Object)orgId);
        balAdjust.set("period", (Object)periodId);
        balAdjust.set("bankaccount", (Object)accountId);
        balAdjust.set("currency", (Object)currencyId);
        balAdjust.set("bizdate", (Object)new Date());
        balAdjust.set("billstatus", (Object)Character.valueOf('A'));
        String userID = RequestContext.get().getUserId();
        balAdjust.set("creator", (Object)Long.valueOf(userID));
        balAdjust.set("createtime", (Object)new Date());
        QFilter[] acctFilters = new QFilter[]{new QFilter("id", "=", (Object)accountId)};
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bankaccountnumber", (QFilter[])acctFilters);
        if (acct != null) {
            balAdjust.set("bankaccountnumber", (Object)"bankaccountnumber");
        }
        QFilter procFilters = new QFilter("accountbank", "=", (Object)accountId);
        procFilters = procFilters.and(new QFilter("currency", "=", (Object)currencyId));
        procFilters = procFilters.and(new QFilter("ischeck", "=", (Object)"0"));
        Date endDate = null;
        if (periodId != null && (periodObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, periodyear, periodnumber, enddate", (QFilter[])(periodFilters = new QFilter[]{new QFilter("id", "=", (Object)periodId)}))) != null) {
            endDate = periodObj.getDate("enddate");
        }
        QFilter jrnlprocFilters = procFilters.copy();
        if (periodId != null) {
            procFilters = procFilters.and(new QFilter("bizDate", "<=", endDate));
            jrnlprocFilters = jrnlprocFilters.and(new QFilter("bookDate", "<=", endDate));
        } else {
            procFilters = procFilters.and(new QFilter("period", "=", (Object)0));
            jrnlprocFilters = jrnlprocFilters.and(new QFilter("period", "=", (Object)0));
        }
        QFilter[] stmtfilters = new QFilter[]{procFilters};
        QFilter[] jrnlfilters = new QFilter[]{jrnlprocFilters};
        DynamicObject balAdjustAfterStmt = this.processData(balAdjust, journalbalamt, "cas_bankstatement", stmtfilters);
        DynamicObject balAdjustAfterJnl = this.processData(balAdjustAfterStmt, statmntbalamt, "cas_bankjournal", jrnlfilters);
        ArrayList<DynamicObject> balAdjustList = new ArrayList<DynamicObject>();
        balAdjustList.add(balAdjustAfterJnl);
        this.saveBalAdjust(balAdjustList);
    }

    private void saveBalAdjust(List<DynamicObject> balAdjustList) {
        if (balAdjustList != null && balAdjustList.size() > 0) {
            DynamicObject[] balAdjustEntities = new DynamicObject[balAdjustList.size()];
            for (int i = 0; i < balAdjustList.size(); ++i) {
                balAdjustEntities[i] = balAdjustList.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])balAdjustEntities);
        }
    }

    private DynamicObject processData(DynamicObject balAdjust, BigDecimal startbalamt, String sourceType, QFilter[] procFilters) {
        BigDecimal adjustamt = new BigDecimal("0");
        BigDecimal creditSum = new BigDecimal("0");
        BigDecimal debitSum = new BigDecimal("0");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)sourceType, (String)"id, accountbank, currency, creditamount, debitamount", (QFilter[])procFilters, (String)"accountbank");
        DynamicObjectCollection balAdjustEntryColl = balAdjust.getDynamicObjectCollection("enter_entry");
        for (DynamicObject obj : colls) {
            DynamicObject balAdjustEntry = new DynamicObject(balAdjust.getDynamicObjectCollection("enter_entry").getDynamicObjectType());
            balAdjustEntry.set("sourcetype", (Object)sourceType);
            balAdjustEntry.set("billid", (Object)obj.getLong("id"));
            creditSum = creditSum.add(obj.getBigDecimal("creditamount"));
            debitSum = debitSum.add(obj.getBigDecimal("debitamount"));
            balAdjustEntryColl.add((Object)balAdjustEntry);
        }
        if (sourceType.equals("cas_bankstatement")) {
            adjustamt = startbalamt.add(creditSum).subtract(debitSum);
            balAdjust.set("journalbalamt", (Object)startbalamt);
            balAdjust.set("bankgotamt", (Object)creditSum);
            balAdjust.set("bankpayedamt", (Object)debitSum);
            balAdjust.set("adjustjournalamt", (Object)adjustamt);
        } else {
            adjustamt = startbalamt.add(debitSum).subtract(creditSum);
            balAdjust.set("statmntbalamt", (Object)startbalamt);
            balAdjust.set("entprgotamt", (Object)debitSum);
            balAdjust.set("entprpayedamt", (Object)creditSum);
            balAdjust.set("adjuststatementamt", (Object)adjustamt);
        }
        return balAdjust;
    }

    @Override
    public DynamicObject getBalanceAdjust(Long period, Long account, Long currency) {
        DynamicObject balAdjust = null;
        QFilter bFilters = new QFilter("bankaccount", "=", (Object)account);
        bFilters = bFilters.and(new QFilter("currency", "=", (Object)currency));
        bFilters = period == null ? bFilters.and(new QFilter("period", "=", (Object)0)) : bFilters.and(new QFilter("period", "=", (Object)period));
        QFilter[] filters = new QFilter[]{bFilters};
        DynamicObject[] balAdjusts = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id, billstatus, adjustjournalamt, adjuststatementamt", (QFilter[])filters);
        if (balAdjusts != null && balAdjusts.length > 0) {
            balAdjust = balAdjusts[0];
        }
        return balAdjust;
    }
}

