/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.service.BalanceDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.business.helper.BalanceCountHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class BalanceCalculateService {
    private static final Log logger = LogFactory.getLog(BalanceCalculateService.class);
    private List<Long> orgList;
    private List<DynamicObject> adjustList = new ArrayList<DynamicObject>();
    private Map<Long, DynamicObject> orgDynamic = new HashMap<Long, DynamicObject>(100);
    private Map<Long, List<String>> errorMsgs = new HashMap<Long, List<String>>(10);

    public BalanceCalculateService() {
    }

    public BalanceCalculateService(List<Long> orgList) {
        this.orgList = orgList;
    }

    public List<DynamicObject> calc() {
        this.doCalc();
        return this.adjustList;
    }

    public void setOrgList(List<Long> orgList) {
        this.orgList = orgList;
    }

    public List<Long> getOrgList() {
        return this.orgList;
    }

    public void setOrgDynamic(Map<Long, DynamicObject> orgDynamic) {
        this.orgDynamic = orgDynamic;
    }

    public Map<Long, DynamicObject> getOrgDynamic() {
        return this.orgDynamic;
    }

    public List<DynamicObject> getAdjustList() {
        return this.adjustList;
    }

    public void setAdjustList(List<DynamicObject> adjustList) {
        this.adjustList = adjustList;
    }

    public Map<Long, List<String>> getErrorMsgs() {
        return this.errorMsgs;
    }

    public void setErrorMsgs(Map<Long, List<String>> errorMsgs) {
        this.errorMsgs = errorMsgs;
    }

    private void doCalc() {
        if (this.orgList == null) {
            throw new IllegalStateException();
        }
        QFilter[] acctFilters = new QFilter[]{new QFilter("createorg", "in", this.orgList), new QFilter("isvirtual", "=", (Object)"0")};
        DynamicObject[] accts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,currency,createorg,company,number, acctstatus, closedate, opendate", (QFilter[])acctFilters);
        Map<Long, List<DynamicObject>> createOrgAcctsMap = Arrays.stream(accts).collect(Collectors.groupingBy(a -> a.getLong("createorg.id")));
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        for (Long orgId : new HashSet<Long>(this.orgList)) {
            Object recPeriod;
            Object recStartInit2;
            Object[] recStartInits;
            DynamicObject finalCheckout = this.orgDynamic.get(orgId);
            List<DynamicObject> accountbanks = createOrgAcctsMap.get(orgId);
            if (EmptyUtil.isEmpty(accountbanks)) continue;
            HashMap orgAccsMap = new HashMap(10);
            HashMap<Long, Long> accOrg = new HashMap<Long, Long>(10);
            HashMap<String, BigDecimal> curMonthStartMap = new HashMap<String, BigDecimal>(10);
            HashSet<DynamicObject> bankAccts = new HashSet<DynamicObject>(accountbanks.size());
            DynamicObject currentPeriod = finalCheckout.getDynamicObject("period");
            for (DynamicObject acctbank : accountbanks) {
                if ("closed".equals(acctbank.getString("acctstatus"))) {
                    Date closeDate = acctbank.getDate("closedate");
                    if (closeDate == null || EmptyUtil.isEmpty((Object)closeDate)) continue;
                    Date periodBeginDate = currentPeriod.getDate("begindate");
                    if (closeDate.getTime() < periodBeginDate.getTime()) continue;
                }
                Date openDate = acctbank.getDate("opendate");
                Date periodEndDate = currentPeriod.getDate("enddate");
                if (openDate.getTime() > periodEndDate.getTime()) continue;
                bankAccts.add(acctbank);
                Long createOrgId = acctbank.getDynamicObject("createorg").getLong("id");
                Long acctId = acctbank.getLong("id");
                Set<Long> acctSet = orgAccsMap.containsKey(createOrgId) ? (Set)orgAccsMap.get(createOrgId) : new HashSet();
                acctSet.add(acctId);
                orgAccsMap.put(createOrgId, acctSet);
                accOrg.put(acctId, createOrgId);
            }
            if (EmptyUtil.isEmpty(bankAccts)) continue;
            HashMap orgAccCurMap = new HashMap(10);
            HashMap accCurAllMap = new HashMap(10);
            HashMap<Long, Long> orgPeriodMap = new HashMap<Long, Long>();
            HashMap<Long, Date> orgPeriodEndDateMap = new HashMap<Long, Date>(10);
            HashMap<Long, Date> recOrgStartPeriodData = new HashMap<Long, Date>(10);
            HashMap<Long, Long> recPeriodIds = new HashMap<Long, Long>(10);
            if (null == orgAccsMap.get(orgId)) continue;
            Set acctIds = (Set)orgAccsMap.get(orgId);
            DynamicObject orgDt = null;
            Set orgSet = AccountBankHelper.getUserOrgsByAccIds((Object[])acctIds.toArray());
            Object[] inits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,isfinishinit,startperiod,currentperiod,entrybank.bank_journalbalance", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgSet)});
            if (EmptyUtil.isNoEmpty((Object[])inits)) {
                for (Object init : inits) {
                    Long orgID = init.getDynamicObject("org").getLong("id");
                    if (orgId.compareTo(orgID) == 0) {
                        orgDt = init.getDynamicObject("org");
                    }
                    if (!init.getBoolean("isfinishinit")) continue;
                    DynamicObject startPeriod = init.getDynamicObject("startperiod");
                    DynamicObject initCurrentPeriod = init.getDynamicObject("currentperiod");
                    if (startPeriod == null || initCurrentPeriod == null) continue;
                    orgPeriodMap.put(orgID, initCurrentPeriod.getLong("id"));
                    orgPeriodEndDateMap.put(orgID, initCurrentPeriod.getDate("enddate"));
                }
            }
            if (EmptyUtil.isNoEmpty((Object[])(recStartInits = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"id, recperiod,org", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgSet)})))) {
                for (Object recStartInit2 : recStartInits) {
                    Long recOrgId = recStartInit2.getDynamicObject("org").getLong("id");
                    recPeriod = recStartInit2.getDynamicObject("recperiod");
                    recOrgStartPeriodData.put(recOrgId, recPeriod.getDate("begindate"));
                    recPeriodIds.put(recOrgId, recPeriod.getLong("id"));
                }
            }
            Long curPeriodId = (Long)orgPeriodMap.get(orgId);
            QFilter[] qFilters = new QFilter[]{new QFilter("accountbank", "in", (Object)acctIds), new QFilter("type", "=", (Object)"2")};
            DataSet journalBalances = QueryServiceHelper.queryDataSet((String)"entity_journalbalance", (String)"cas_journalbalance", (String)"org,accountbank,period,currency,monthstart", (QFilter[])qFilters, (String)"");
            recStartInit2 = null;
            try {
                DataSet groupByDataSet = journalBalances.groupBy(new String[]{"org", "accountbank", "period", "currency"}).sum("monthstart").finish();
                recPeriod = null;
                try {
                    groupByDataSet.forEach(row -> {
                        Long periodId;
                        Long orgID = row.get("org") == null ? Long.valueOf("0") : (Long)row.get("org");
                        Long rowAcctBankId = row.get("accountbank") == null ? Long.valueOf("0") : (Long)row.get("accountbank");
                        Long rowCurrencyId = row.get("currency") == null ? Long.valueOf("0") : (Long)row.get("currency");
                        Long rowPeriodId = row.get("period") == null ? Long.valueOf("0") : (Long)row.get("period");
                        BigDecimal monthStart = row.get("monthstart") == null ? BigDecimal.ZERO : (BigDecimal)row.get("monthstart");
                        Long l = periodId = orgPeriodMap.get(orgID) == null ? Long.valueOf("0") : (Long)orgPeriodMap.get(orgID);
                        if (null != rowPeriodId && null != curPeriodId) {
                            boolean tempBool;
                            boolean bl = tempBool = curPeriodId.compareTo(periodId) >= 0 && rowPeriodId.compareTo(periodId) == 0;
                            if (rowPeriodId.compareTo(curPeriodId) == 0 || tempBool) {
                                curMonthStartMap.put(orgID + "-" + rowAcctBankId + "-" + rowCurrencyId + "-" + rowPeriodId, monthStart);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    recPeriod = throwable;
                    throw throwable;
                }
                finally {
                    if (groupByDataSet != null) {
                        if (recPeriod != null) {
                            try {
                                groupByDataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)recPeriod).addSuppressed(throwable);
                            }
                        } else {
                            groupByDataSet.close();
                        }
                    }
                }
            }
            catch (Throwable groupByDataSet) {
                recStartInit2 = groupByDataSet;
                throw groupByDataSet;
            }
            finally {
                if (journalBalances != null) {
                    if (recStartInit2 != null) {
                        try {
                            journalBalances.close();
                        }
                        catch (Throwable groupByDataSet) {
                            ((Throwable)recStartInit2).addSuppressed(groupByDataSet);
                        }
                    } else {
                        journalBalances.close();
                    }
                }
            }
            Date date = DateUtils.getDataFormat((Date)((Date)orgPeriodEndDateMap.get(orgId)), (boolean)true);
            Date fistDate = DateUtils.getDataFormat((Date)((Date)recOrgStartPeriodData.get(orgId)), (boolean)true);
            QFilter journalFilters = new QFilter("accountbank", "in", (Object)acctIds).and(new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1))).and(new QFilter("period", "!=", (Object)0L));
            try (DataSet bankJournals = QueryServiceHelper.queryDataSet((String)"entity_bankjournal", (String)"cas_bankjournal", (String)"org,accountbank,period,currency,debitamount-creditamount as factamt", (QFilter[])new QFilter[]{journalFilters}, null);
                 DataSet groupByDataSet = bankJournals.groupBy(new String[]{"org", "accountbank", "period", "currency"}).sum("factamt").finish();){
                groupByDataSet.forEach(row -> {
                    Long orgID = row.get("org") == null ? Long.valueOf("0") : (Long)row.get("org");
                    Long rowAcctBankId = row.get("accountbank") == null ? Long.valueOf("0") : (Long)row.get("accountbank");
                    Long rowCurrencyId = row.get("currency") == null ? Long.valueOf("0") : (Long)row.get("currency");
                    Long rowPeriodId = row.get("period") == null ? Long.valueOf("0") : (Long)row.get("period");
                    BigDecimal actAmt = row.get("factamt") == null ? BigDecimal.ZERO : (BigDecimal)row.get("factamt");
                    Long periodId = (Long)orgPeriodMap.get(orgID);
                    if (null != rowPeriodId && null != curPeriodId && (rowPeriodId.compareTo(curPeriodId) == 0 || null != periodId && rowPeriodId.compareTo(periodId) >= 0)) {
                        String orgAccCurPerStr = orgID + "-" + rowAcctBankId + "-" + rowCurrencyId + "-" + rowPeriodId;
                        orgAccCurMap.put(orgAccCurPerStr, actAmt);
                        BigDecimal curMonthStar = (BigDecimal)curMonthStartMap.get(orgAccCurPerStr);
                        if (null == curMonthStar) {
                            curMonthStartMap.put(orgAccCurPerStr, BigDecimal.ZERO);
                        }
                    }
                });
            }
            curMonthStartMap.forEach((orgAccCurStr, monthStart) -> {
                String[] split = orgAccCurStr.split("-");
                String accCurStr = split[1] + "-" + split[2];
                BigDecimal actAmt = (BigDecimal)orgAccCurMap.get(orgAccCurStr);
                actAmt = CasHelper.isEmpty((Object)actAmt) ? BigDecimal.ZERO : actAmt;
                monthStart = monthStart.add(actAmt);
                if (accCurAllMap.containsKey(accCurStr)) {
                    BigDecimal monthStartSum = ((BigDecimal)accCurAllMap.get(accCurStr)).add((BigDecimal)monthStart);
                    accCurAllMap.put(accCurStr, monthStartSum);
                } else {
                    accCurAllMap.put(accCurStr, monthStart);
                }
            });
            HashMap<String, BigDecimal> journalMap = new HashMap(10);
            HashMap<String, BigDecimal> statmMap = new HashMap(10);
            if (useBalanceModel) {
                logger.info("useBalanceModel={}", (Object)useBalanceModel);
                journalMap = this.queryByBalanceModel(BalanceType.JOURNAL, orgId, acctIds, fistDate, date);
                statmMap = this.queryByBalanceModel(BalanceType.STATE, orgId, acctIds, fistDate, date);
            } else {
                for (Map.Entry entry : accCurAllMap.entrySet()) {
                    String[] acKeys = ((String)entry.getKey()).split("-");
                    String newKey = accOrg.get(Long.valueOf(acKeys[0])) + "-" + (String)entry.getKey();
                    journalMap.put(newKey, (BigDecimal)entry.getValue());
                }
                statmMap = this.getStatmMap(acctIds, recPeriodIds, date, fistDate);
            }
            logger.info("getAdjustList(),params: journalMap={}", journalMap);
            logger.info("getAdjustList(),params: statmMap={}", statmMap);
            this.adjustList.addAll(this.getAdjustList(bankAccts.toArray(new DynamicObject[0]), orgDt, orgPeriodEndDateMap, orgPeriodMap, journalMap, statmMap, recOrgStartPeriodData, recPeriodIds));
        }
    }

    private Map<String, BigDecimal> getStatmMap(Set<Long> accountBanks, Map<Long, Long> recPeriodIds, Date date, Date fistDate) {
        HashMap orgAccStamMap = new HashMap(10);
        HashMap<String, BigDecimal> statmMap = new HashMap<String, BigDecimal>(10);
        HashMap<String, BigDecimal> stmMonthStartMap = new HashMap<String, BigDecimal>(10);
        QFilter[] filterStm = new QFilter[]{new QFilter("accountbank", "in", accountBanks), new QFilter("type", "=", (Object)"3")};
        try (DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"entity_journalbalance", (String)"cas_journalbalance", (String)"org,accountbank,period,currency,monthstart", (QFilter[])filterStm, null);
             DataSet groupByDataSet = bankAcctSet.groupBy(new String[]{"org", "accountbank", "period", "currency"}).sum("monthstart").finish();){
            groupByDataSet.forEach(row -> {
                Long orgID = row.get("org") == null ? Long.valueOf("0") : (Long)row.get("org");
                Long rowAcctBankId = row.get("accountbank") == null ? Long.valueOf("0") : (Long)row.get("accountbank");
                Long rowCurrencyId = row.get("currency") == null ? Long.valueOf("0") : (Long)row.get("currency");
                BigDecimal monthStart = row.get("monthstart") == null ? BigDecimal.ZERO : (BigDecimal)row.get("monthstart");
                Long rowPeriodId = row.get("period") == null ? Long.valueOf("0") : (Long)row.get("period");
                Long periodId = (Long)recPeriodIds.get(orgID);
                if (null != rowPeriodId && null != periodId && rowPeriodId.compareTo(periodId) == 0) {
                    stmMonthStartMap.put(orgID + "-" + rowAcctBankId + "-" + rowCurrencyId, monthStart);
                }
            });
        }
        this.calculateInitBalance(recPeriodIds, stmMonthStartMap);
        BalanceCountHelper.ReturnData returnData = this.coaxTransferAccount(accountBanks, date, stmMonthStartMap);
        Map<String, String> relations = returnData.getRelations();
        if (returnData.getMiniStartDate() != null) {
            fistDate = returnData.getMiniStartDate();
        }
        QFilter statmntFilters = new QFilter("accountbank", "in", accountBanks).and(new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1))).and(new QFilter("isbank", "=", (Object)"1").and(new QFilter("period", "!=", (Object)0L)));
        if (null != fistDate) {
            statmntFilters.and(new QFilter("bizdate", ">=", (Object)fistDate));
        }
        try (DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"entity_bankstatement", (String)"cas_bankstatement", (String)"org,accountbank,currency,creditamount-debitamount as factamt", (QFilter[])new QFilter[]{statmntFilters}, null);
             DataSet groupByDataSet = bankAcctSet.groupBy(new String[]{"org", "accountbank", "currency"}).sum("factamt").finish();){
            groupByDataSet.forEach(row -> {
                BigDecimal curMonthStar;
                Long orgID = row.get("org") == null ? Long.valueOf("0") : (Long)row.get("org");
                Long rowAcctBankId = row.get("accountbank") == null ? Long.valueOf("0") : (Long)row.get("accountbank");
                Long rowCurrencyId = row.get("currency") == null ? Long.valueOf("0") : (Long)row.get("currency");
                BigDecimal actAmt = row.get("factamt") == null ? BigDecimal.ZERO : (BigDecimal)row.get("factamt");
                String orgAccCurStr = orgID + "-" + rowAcctBankId + "-" + rowCurrencyId;
                if (orgAccStamMap.containsKey(orgAccCurStr)) {
                    BigDecimal getAmount = (BigDecimal)orgAccStamMap.get(orgAccCurStr);
                    actAmt = actAmt.add(getAmount);
                }
                orgAccStamMap.put(orgAccCurStr, actAmt);
                if (!relations.isEmpty() && relations.containsKey(orgAccCurStr)) {
                    String relate = (String)relations.get(orgAccCurStr);
                    if (orgAccStamMap.containsKey(relate)) {
                        BigDecimal getAmount = (BigDecimal)orgAccStamMap.get(relate);
                        actAmt = actAmt.add(getAmount);
                    }
                    orgAccStamMap.put(relate, actAmt);
                }
                if (null == (curMonthStar = (BigDecimal)stmMonthStartMap.get(orgAccCurStr))) {
                    stmMonthStartMap.put(orgAccCurStr, BigDecimal.ZERO);
                }
            });
        }
        stmMonthStartMap.forEach((orgAccCurStr, monthStart) -> {
            BigDecimal actAmt = (BigDecimal)orgAccStamMap.get(orgAccCurStr);
            actAmt = CasHelper.isEmpty((Object)actAmt) ? BigDecimal.ZERO : actAmt;
            monthStart = monthStart.add(actAmt);
            statmMap.put((String)orgAccCurStr, (BigDecimal)monthStart);
        });
        return statmMap;
    }

    private BalanceCountHelper.ReturnData coaxTransferAccount(Set<Long> accountBanks, Date date, Map<String, BigDecimal> stmMonthStartMap) {
        BalanceCountHelper.ReturnData returnData = BalanceCountHelper.searchOriginBalance(accountBanks, null, date);
        Map<String, String> relations = returnData.getRelations();
        if (relations == null || relations.isEmpty()) {
            return returnData;
        }
        HashMap<String, BigDecimal> addAmount = new HashMap<String, BigDecimal>(relations.size());
        for (Map.Entry<String, BigDecimal> statement : stmMonthStartMap.entrySet()) {
            String strKey = statement.getKey();
            if (!relations.containsKey(strKey)) continue;
            String currencyKey = relations.get(strKey);
            BigDecimal amount = statement.getValue();
            if (!stmMonthStartMap.containsKey(currencyKey)) {
                addAmount.put(currencyKey, amount);
                continue;
            }
            returnData.setMiniStartDate(null);
        }
        if (!addAmount.isEmpty()) {
            stmMonthStartMap.putAll(addAmount);
        }
        return returnData;
    }

    private List<DynamicObject> getAdjustList(DynamicObject[] bankAccts, DynamicObject orgDt, Map<Long, Date> orgPeriodEndDateMap, Map<Long, Long> orgPeriodMap, Map<String, BigDecimal> journalMap, Map<String, BigDecimal> startbalamtMap, Map<Long, Date> recOrgStartPeriodData, Map<Long, Long> recOrgIds) {
        DynamicObject[] checkedResults;
        logger.info("--->> BalanceCalculateService.getAdjustList(),bankAccts.size()={}", (Object)bankAccts.length);
        ArrayList balanceAdjustIdList = new ArrayList(10);
        ArrayList<DynamicObject> balAdjusts = new ArrayList<DynamicObject>(10);
        if (null == orgDt) {
            return balAdjusts;
        }
        Long orgId = orgDt.getLong("id");
        HashMap<Long, String> reasonMap = new HashMap<Long, String>(10);
        QFilter filter = new QFilter("org.id", "=", (Object)orgId).and(new QFilter("bankaccount", "!=", (Object)0)).and("period", "<=", (Object)orgPeriodMap.get(orgId));
        DataSet currentPeriodDs = QueryServiceHelper.queryDataSet((String)"entity_balanceadjust", (String)"cas_balanceadjust", (String)"id,bankaccount,currency", (QFilter[])new QFilter[]{filter}, null).groupBy(new String[]{"bankaccount", "currency"}).max("id").finish();
        currentPeriodDs.forEach(row -> balanceAdjustIdList.add(row.getLong("id")));
        QFilter[] reasonFilters = new QFilter[]{new QFilter("id", "in", balanceAdjustIdList)};
        String reasonSelProp = "enter_entry.billid, enter_entry.enter_reason";
        DynamicObjectCollection reasonColl = QueryServiceHelper.query((String)"cas_balanceadjust", (String)reasonSelProp, (QFilter[])reasonFilters, null);
        for (DynamicObject reason : reasonColl) {
            Long billid = reason.getLong("enter_entry.billid");
            if (!CasHelper.isNotEmpty((Object)billid)) continue;
            reasonMap.put(billid, reason.getString("enter_entry.enter_reason"));
        }
        List accountBanks = Arrays.stream(bankAccts).map(o -> o.getPkValue()).collect(Collectors.toList());
        ArrayList<Long> stateIds = new ArrayList<Long>();
        ArrayList<Long> journalIds = new ArrayList<Long>();
        Date endDate = orgPeriodEndDateMap.get(orgId);
        for (DynamicObject checkedResult : checkedResults = BusinessDataServiceHelper.load((String)"cas_checkedresult", (String)"id,accountbank,entry.bizdate,entry.bizobjectid,entry.bizobject", (QFilter[])new QFilter[]{new QFilter("accountbank", "in", accountBanks)})) {
            Date bizDate;
            DynamicObjectCollection entryCol = checkedResult.getDynamicObjectCollection("entry");
            boolean boolTemp = false;
            boolean boolTempDate = false;
            for (DynamicObject entry : entryCol) {
                bizDate = entry.getDate("bizdate");
                if (bizDate == null) {
                    logger.error("get bank balance that bizDate is null\u3002\u3002\u3002");
                    continue;
                }
                if (bizDate.after(endDate)) {
                    boolTemp = true;
                    continue;
                }
                if (!bizDate.before(endDate)) continue;
                boolTempDate = true;
            }
            if (!boolTemp || !boolTempDate) continue;
            for (DynamicObject entry : entryCol) {
                bizDate = entry.getDate("bizdate");
                if (!bizDate.before(endDate)) continue;
                if ("cas_bankstatement".equals(entry.getString("bizobject"))) {
                    stateIds.add(entry.getLong("bizobjectid"));
                    continue;
                }
                journalIds.add(entry.getLong("bizobjectid"));
            }
        }
        Date beginDate = recOrgStartPeriodData.get(orgId);
        Long recId = recOrgIds.get(orgId);
        QFilter statementFilters = new QFilter("accountbank", "in", accountBanks).and(new QFilter("bizdate", "<=", (Object)endDate)).and(new QFilter("bizdate", ">=", (Object)beginDate)).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("isbank", "=", (Object)"1")).and(new QFilter("isvalid", "=", (Object)"1"));
        DynamicObjectCollection statementCol = QueryServiceHelper.query((String)"cas_bankstatement", (String)"id", (QFilter[])new QFilter[]{statementFilters});
        List statementIdList = statementCol.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        statementIdList.addAll(stateIds);
        if (EmptyUtil.isNoEmpty((Long)recId)) {
            QFilter recFilter = new QFilter("recinitperiod", "=", (Object)recId).and(new QFilter("isvalid", "=", (Object)"1")).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("accountbank", "in", accountBanks));
            statementCol = QueryServiceHelper.query((String)"cas_bankstatement", (String)"id", (QFilter[])new QFilter[]{recFilter});
            List recStatementIdList = statementCol.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            statementIdList.addAll(recStatementIdList);
        }
        QFilter journalColFilters = new QFilter("accountbank", "in", accountBanks).and(new QFilter("bookdate", "<=", (Object)endDate)).and(new QFilter("bookdate", ">=", (Object)beginDate)).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("isvalid", "=", (Object)"1"));
        DynamicObjectCollection journalCol = QueryServiceHelper.query((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{journalColFilters});
        List journalIdList = journalCol.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        journalIdList.addAll(journalIds);
        if (EmptyUtil.isNoEmpty((Long)recId)) {
            QFilter recFilter = new QFilter("recinitperiod", "=", (Object)recId).and(new QFilter("isvalid", "=", (Object)"1")).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("accountbank", "in", accountBanks));
            journalCol = QueryServiceHelper.query((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{recFilter});
            List recJournalIdList = journalCol.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            journalIdList.addAll(recJournalIdList);
        }
        DynamicObject[] statementDt = BusinessDataServiceHelper.load((String)"cas_bankstatement", (String)"id,accountbank,currency,description,settlementtype.name,settlementnumber,bizdate,debitamount,creditamount,ratesdate,bankvouvherno,tradenumber,source,balanceamt", (QFilter[])new QFilter[]{new QFilter("id", "in", statementIdList)}, (String)"accountbank");
        DynamicObject[] journalDt = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,accountbank,currency,sourcebilltype,sourcebillnumber,sourcebillid,,bookdate,bizdate,description,settlementtype.name,settlementnumber,debitamount,creditamount,pddate,avddate,preparationdate,createtime,source,cashier.name,feepayer", (QFilter[])new QFilter[]{new QFilter("id", "in", journalIdList)});
        Set acctBankIdSet = Arrays.stream(bankAccts).map(e -> e.getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> periods = new ArrayList<Long>();
        Long periodId = orgPeriodMap.get(orgId);
        if (periodId != null) {
            periods.add(periodId);
        }
        Date largeDate = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        Date lessDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        DynamicObject[] balanceAdjustS = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"org,bizdate,period,bankaccount,bankaccountnumber,currency", (QFilter[])new QFilter[]{new QFilter("org", "=", orgDt.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("period", "in", periods), new QFilter("bankaccount", "in", acctBankIdSet), new QFilter("bizdate", "<=", (Object)lessDate), new QFilter("bizdate", ">=", (Object)largeDate)});
        DynamicObjectCollection largerDateBalances = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"org,bizdate,bankaccount.number,currency.name", (QFilter[])new QFilter[]{new QFilter("org", "=", orgDt.getPkValue()), new QFilter("bizdate", ">", (Object)lessDate)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)largerDateBalances)) {
            this.addErrorMsgs(orgId, largerDateBalances, endDate);
            return this.adjustList;
        }
        Map result = BalanceAdjustHelper.getBankJournalVoucher((DynamicObject[])journalDt);
        for (DynamicObject bankAcct : bankAccts) {
            DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
            String bankNumber = bankAcct.getString("number");
            Long bankAcctId = bankAcct.getLong("id");
            if (CollectionUtils.isEmpty((Collection)currencys)) continue;
            for (DynamicObject currency : currencys) {
                DynamicObject balAdjustEntry;
                Long currencyIds;
                Long bankAcctIds;
                BigDecimal staAdjustamt = BigDecimal.ZERO;
                BigDecimal journalAdjustamt = BigDecimal.ZERO;
                BigDecimal staCreditSum = BigDecimal.ZERO;
                BigDecimal staDebitSum = BigDecimal.ZERO;
                BigDecimal journalCreditSum = BigDecimal.ZERO;
                BigDecimal journalDebitSum = BigDecimal.ZERO;
                if (currency == null || currency.getDynamicObject("fbasedataid") == null) continue;
                Long currencyId = currency.getDynamicObject("fbasedataid").getLong("id");
                Long period = orgPeriodMap.get(orgId);
                Optional<DynamicObject> billOptional = Arrays.stream(balanceAdjustS).filter(c -> EmptyUtil.isNoEmpty((DynamicObject)c.getDynamicObject("currency"))).filter(bill -> bill.getLong("period.id") == period.longValue() && bill.getLong("bankaccount.id") == bankAcctId.longValue() && bill.getLong("currency.id") == currencyId.longValue()).findFirst();
                if (billOptional.isPresent()) continue;
                DynamicObject balAdjust = BusinessDataServiceHelper.newDynamicObject((String)"cas_balanceadjust");
                BasedataProp orgProp = (BasedataProp)balAdjust.getDynamicObjectType().getProperties().get((Object)"org");
                balAdjust.set("org", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)orgDt.getPkValue(), (DynamicObjectType)((DynamicObjectType)orgProp.getComplexType())));
                balAdjust.set("period_id", period != null ? period : "");
                balAdjust.set("bankaccount_id", bankAcct.getPkValue());
                balAdjust.set("currency_id", (Object)currencyId);
                balAdjust.set("bizdate", (Object)endDate);
                balAdjust.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                String userID = RequestContext.get().getUserId();
                balAdjust.set("creator_id", (Object)Long.valueOf(userID));
                balAdjust.set("createtime", (Object)new Date());
                balAdjust.set("bankaccountnumber", (Object)bankNumber);
                String number = CodeRuleServiceHelper.getNumber((String)"cas_balanceadjust", (DynamicObject)balAdjust, (String)String.valueOf(orgId));
                balAdjust.set("billno", (Object)number);
                for (DynamicObject statement : statementDt) {
                    bankAcctIds = statement.getDynamicObject("accountbank").getLong("id");
                    currencyIds = statement.getDynamicObject("currency").getLong("id");
                    if (bankAcctId.compareTo(bankAcctIds) != 0 || currencyId.compareTo(currencyIds) != 0) continue;
                    balAdjustEntry = balAdjust.getDynamicObjectCollection("enter_entry").addNew();
                    balAdjustEntry.set("sourcetype", (Object)"cas_bankstatement");
                    balAdjustEntry.set("billid", (Object)statement.getLong("id"));
                    balAdjustEntry.set("enter_reason", reasonMap.get(statement.get("id")));
                    balAdjustEntry.set("enter_description", EmptyUtil.isEmpty((Object)statement.get("description")) ? " " : statement.get("description"));
                    balAdjustEntry.set("enter_settletype", EmptyUtil.isEmpty((Object)statement.get("settlementtype.name")) ? " " : statement.get("settlementtype.name"));
                    balAdjustEntry.set("enter_settlenumber", EmptyUtil.isEmpty((Object)statement.get("settlementnumber")) ? " " : statement.get("settlementnumber"));
                    balAdjustEntry.set("enter_bizdate", statement.get("bizdate"));
                    balAdjustEntry.set("enter_debitamount", EmptyUtil.isEmpty((Object)statement.get("debitamount")) ? BigDecimal.ZERO : statement.get("debitamount"));
                    balAdjustEntry.set("enter_creditamount", EmptyUtil.isEmpty((Object)statement.get("creditamount")) ? BigDecimal.ZERO : statement.get("creditamount"));
                    balAdjustEntry.set("ratesdate", statement.get("ratesdate"));
                    balAdjustEntry.set("bankvouvherno", EmptyUtil.isEmpty((Object)statement.get("bankvouvherno")) ? " " : statement.get("bankvouvherno"));
                    balAdjustEntry.set("tradenumber", EmptyUtil.isEmpty((Object)statement.get("tradenumber")) ? " " : statement.get("tradenumber"));
                    balAdjustEntry.set("source", EmptyUtil.isEmpty((Object)statement.get("source")) ? " " : statement.get("source"));
                    balAdjustEntry.set("balanceamt", EmptyUtil.isEmpty((Object)statement.get("balanceamt")) ? BigDecimal.ZERO : statement.get("balanceamt"));
                    staCreditSum = staCreditSum.add(statement.getBigDecimal("creditamount"));
                    staDebitSum = staDebitSum.add(statement.getBigDecimal("debitamount"));
                }
                for (DynamicObject journal : journalDt) {
                    bankAcctIds = journal.getDynamicObject("accountbank").getLong("id");
                    currencyIds = journal.getDynamicObject("currency").getLong("id");
                    if (bankAcctId.compareTo(bankAcctIds) != 0 || currencyId.compareTo(currencyIds) != 0) continue;
                    balAdjustEntry = balAdjust.getDynamicObjectCollection("bank_entry").addNew();
                    balAdjustEntry.set("bank_org", (Object)journal.getDynamicObject("accountbank").getDynamicObject("openorg"));
                    balAdjustEntry.set("banksourcetype", (Object)"cas_bankjournal");
                    balAdjustEntry.set("bankbillid", (Object)journal.getLong("id"));
                    balAdjustEntry.set("bank_reason", reasonMap.get(journal.get("id")));
                    balAdjustEntry.set("bank_bookdate", journal.get("bookdate"));
                    balAdjustEntry.set("bank_bizdate", journal.get("bizdate"));
                    balAdjustEntry.set("bank_description", EmptyUtil.isEmpty((Object)journal.get("description")) ? " " : journal.get("description"));
                    String[] voucherInfo = (String[])result.get(journal.getPkValue());
                    if (voucherInfo != null) {
                        balAdjustEntry.set("bank_vouchertype", (Object)(EmptyUtil.isEmpty((String)voucherInfo[3]) ? " " : voucherInfo[3]));
                        balAdjustEntry.set("bank_vouchernumber", (Object)(EmptyUtil.isEmpty((String)voucherInfo[1]) ? " " : voucherInfo[1]));
                        balAdjustEntry.set("bank_billnumber", (Object)(EmptyUtil.isEmpty((String)voucherInfo[2]) ? " " : voucherInfo[2]));
                    }
                    balAdjustEntry.set("bank_billtype", (Object)SourceBillTypeEnum.getName((String)journal.getString("sourcebilltype")));
                    balAdjustEntry.set("bank_settletype", EmptyUtil.isEmpty((Object)journal.get("settlementtype.name")) ? " " : journal.get("settlementtype.name"));
                    balAdjustEntry.set("bank_settlenumber", EmptyUtil.isEmpty((Object)journal.get("settlementnumber")) ? " " : journal.get("settlementnumber"));
                    balAdjustEntry.set("bank_debitamount", EmptyUtil.isEmpty((Object)journal.get("debitamount")) ? BigDecimal.ZERO : journal.get("debitamount"));
                    balAdjustEntry.set("bank_creditamount", EmptyUtil.isEmpty((Object)journal.get("creditamount")) ? BigDecimal.ZERO : journal.get("creditamount"));
                    balAdjustEntry.set("pddate", journal.get("pddate"));
                    balAdjustEntry.set("avddate", journal.get("avddate"));
                    balAdjustEntry.set("preparationdate", journal.get("preparationdate"));
                    balAdjustEntry.set("sysdate", journal.get("createtime"));
                    balAdjustEntry.set("banksource", EmptyUtil.isEmpty((Object)journal.get("source")) ? " " : journal.get("source"));
                    balAdjustEntry.set("cashier", EmptyUtil.isEmpty((Object)journal.get("cashier.name")) ? " " : journal.get("cashier.name"));
                    balAdjustEntry.set("feepayer", EmptyUtil.isEmpty((Object)journal.get("feepayer")) ? " " : journal.get("feepayer"));
                    if (BalanceAdjustHelper.isHWProperty()) {
                        if (voucherInfo != null) {
                            balAdjustEntry.set("hihn_voucherbatchnum", (Object)(EmptyUtil.isEmpty((String)voucherInfo[4]) ? " " : voucherInfo[4]));
                        } else {
                            balAdjustEntry.set("hihn_voucherbatchnum", (Object)" ");
                        }
                        balAdjustEntry.set("hihn_paynum", EmptyUtil.isEmpty((Object)journal.get("hihn_paynum")) ? " " : journal.get("hihn_paynum"));
                    }
                    journalCreditSum = journalCreditSum.add(journal.getBigDecimal("creditamount"));
                    journalDebitSum = journalDebitSum.add(journal.getBigDecimal("debitamount"));
                }
                BigDecimal journalAmt = journalMap.get(orgId + "-" + bankAcctId + "-" + currencyId);
                journalAmt = null == journalAmt ? BigDecimal.ZERO : journalAmt;
                staAdjustamt = journalAmt.add(staCreditSum).subtract(staDebitSum);
                balAdjust.set("journalbalamt", (Object)journalAmt);
                balAdjust.set("bankgotamt", (Object)staCreditSum);
                balAdjust.set("bankpayedamt", (Object)staDebitSum);
                balAdjust.set("adjustjournalamt", (Object)staAdjustamt);
                BigDecimal startbalamt = startbalamtMap.get(orgId + "-" + bankAcctId + "-" + currencyId);
                startbalamt = null == startbalamt ? BigDecimal.ZERO : startbalamt;
                journalAdjustamt = startbalamt.add(journalDebitSum).subtract(journalCreditSum);
                balAdjust.set("statmntbalamt", (Object)startbalamt);
                balAdjust.set("entprgotamt", (Object)journalDebitSum);
                balAdjust.set("entprpayedamt", (Object)journalCreditSum);
                balAdjust.set("adjuststatementamt", (Object)journalAdjustamt);
                logger.info("====\u65e5\u8bb0\u8d26\u4f59\u989d\uff1a{},\u4f01\u4e1a\u672a\u6536\uff1a{},\u4f01\u4e1a\u672a\u4ed8\uff1a{},\u65e5\u8bb0\u8d26\u8c03\u6574\u540e\u4f59\u989d\u91d1\u989d\uff1a{},====\u5bf9\u8d26\u5355\u4f59\u989d\uff1a{},\u94f6\u884c\u672a\u6536\uff1a{},\u94f6\u884c\u672a\u4ed8\uff1a{},\u5bf9\u8d26\u5355\u8c03\u6574\u540e\u4f59\u989d\u91d1\u989d\uff1a{}", new Object[]{journalAmt, staCreditSum, staDebitSum, staAdjustamt, startbalamt, journalDebitSum, journalCreditSum, journalAdjustamt});
                balAdjusts.add(balAdjust);
            }
        }
        return balAdjusts;
    }

    private void addErrorMsgs(long orgId, DynamicObjectCollection largerDateBalances, Date endDate) {
        String dateStr = DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd");
        ArrayList<String> errorList = new ArrayList<String>(largerDateBalances.size());
        ArrayList<String> exsitBalanceList = new ArrayList<String>(largerDateBalances.size());
        for (DynamicObject balance : largerDateBalances) {
            String accountNumber = balance.getString("bankaccount.number");
            String currencyName = balance.getString("currency.name");
            String key = accountNumber + currencyName;
            if (exsitBalanceList.contains(key)) continue;
            exsitBalanceList.add(key);
            String error = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u751f\u6210\u5931\u8d25\u3002\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728%3$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u5982\u9700\u7ee7\u7eed\uff0c\u8bf7\u5c06%4$s\u4e4b\u540e\u7684\u4f59\u989d\u8c03\u8282\u8868\u5220\u9664\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BalanceCalculateService_0", (String)"fi-cas-business", (Object[])new Object[0]), accountNumber, currencyName, dateStr, dateStr);
            errorList.add(error);
        }
        this.errorMsgs.put(orgId, errorList);
    }

    private void calculateInitBalance(Map<Long, Long> recPeriodIds, Map<String, BigDecimal> stmMonthStartMap) {
        QFilter finishInitFilter = new QFilter("isfinishinit", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "in", recPeriodIds.keySet());
        DynamicObject[] recEdcs = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"id, org, recperiod,startperiod,currentperiod", (QFilter[])new QFilter[]{orgFilter});
        if (recEdcs == null || recEdcs.length == 0) {
            return;
        }
        HashSet<Long> recEdcOrgIds = new HashSet<Long>(recEdcs.length);
        for (DynamicObject recEdc : recEdcs) {
            DynamicObject orgDynamic = recEdc.getDynamicObject("org");
            Long orgId = orgDynamic.getLong("id");
            recEdcOrgIds.add(orgId);
        }
        DynamicObject[] recInits = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id, org, entrybank, entrybank.bank_currency, initperiod, entrybank.bank_accountbank , entrybank.bank_statementbalance", (QFilter[])new QFilter[]{orgFilter, finishInitFilter});
        if (recInits == null || recInits.length == 0) {
            return;
        }
        for (DynamicObject recInit : recInits) {
            DynamicObject initPeriod = recInit.getDynamicObject("initperiod");
            if (initPeriod == null) continue;
            Long initPeriodId = initPeriod.getLong("id");
            DynamicObject org = recInit.getDynamicObject("org");
            if (org == null) continue;
            Long orgId = org.getLong("id");
            if (!recEdcOrgIds.contains(orgId)) {
                logger.warn("=====BalanceCalculateService==the organization didn't init balance of account\u3002");
                continue;
            }
            Long periodId = recPeriodIds.get(orgId);
            if (periodId == null || !initPeriodId.equals(periodId)) continue;
            DynamicObjectCollection entryBank = recInit.getDynamicObjectCollection("entrybank");
            for (DynamicObject bank : entryBank) {
                DynamicObject bankDynamic = bank.getDynamicObject("bank_accountbank");
                if (bankDynamic == null) continue;
                Long bankId = bankDynamic.getLong("id");
                Long currencyId = bank.getDynamicObject("bank_currency").getLong("id");
                String keyStr = orgId + "-" + bankId + "-" + currencyId;
                if (stmMonthStartMap.containsKey(keyStr)) continue;
                BigDecimal monthStart = bank.getBigDecimal("bank_statementbalance");
                stmMonthStartMap.put(keyStr, monthStart);
            }
        }
    }

    private Map<String, BigDecimal> queryByBalanceModel(BalanceType balanceType, long orgId, Set<Long> acctIds, Date startDate, Date endDate) {
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>(10);
        ArrayList<RequestBalanceParameter> parameterList = new ArrayList<RequestBalanceParameter>(10);
        for (Long acctId : acctIds) {
            Set curIds = AccountBankHelper.getCurrencyPks((long)acctId);
            HashSet<Long> tmpAccIds = new HashSet<Long>();
            tmpAccIds.add(acctId);
            for (Long curId : curIds) {
                RequestBalanceParameter parameter = new RequestBalanceParameter();
                parameter.setOrgIds(Collections.singleton(orgId));
                parameter.setEndDate(endDate);
                parameter.setStartDate(startDate);
                parameter.setType(balanceType.getValue());
                parameter.setCurrencyIds(Collections.singleton(curId));
                parameter.setAccountIds(tmpAccIds);
                parameterList.add(parameter);
                String oacKey = StringUtils.joinKeyString((String)"-", (Object[])new Object[]{orgId, acctId, curId});
                balanceMap.put(oacKey, BigDecimal.ZERO);
            }
        }
        try {
            List<ResponseBalances> monthBalances = BalanceDataService.getInstance().getBalances(parameterList, BalanceQueryType.ENDDATE);
            for (ResponseBalances monthBalance : monthBalances) {
                Long accountId = monthBalance.getAccountId();
                Long currencyId = monthBalance.getCurrencyId();
                String oacKey = StringUtils.joinKeyString((String)"-", (Object[])new Object[]{orgId, accountId, currencyId});
                BigDecimal balance = monthBalance.getBalance().getMonthStart();
                balanceMap.put(oacKey, balance);
            }
        }
        catch (Exception e) {
            logger.error("BalanceDataService.getBalances() error:", (Throwable)e);
        }
        return balanceMap;
    }
}

