/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;

public class HisCasInitDataUpService {
    private static final Log logger = LogFactory.getLog(HisCasInitDataUpService.class);

    public String casRecInitDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            this.upCasRecInit();
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
            logger.error((Throwable)e);
        }
        return JSON.toJSONString((Object)recResult);
    }

    public void upCasRecInit() {
        QFilter isfinishinitQf = new QFilter("isfinishinit", "=", (Object)true);
        DynamicObject[] initDatas = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id", (QFilter[])new QFilter[]{isfinishinitQf});
        if (CasHelper.isEmpty((DynamicObject[])initDatas)) {
            return;
        }
        List initDataPks = Arrays.asList(initDatas).stream().map(o -> o.getPkValue()).collect(Collectors.toList());
        initDatas = BusinessDataServiceHelper.load((Object[])initDataPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_cashmgtinit"));
        List orgIds = Arrays.asList(initDatas).stream().filter(o -> o.getDynamicObject("org") != null).map(o -> o.getDynamicObject("org").getPkValue()).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObject[] recEdcDbs = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"id,org", (QFilter[])new QFilter[]{orgFilter});
        Set exisOrgs = Arrays.asList(recEdcDbs).stream().map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        ArrayList<DynamicObject> insertRecEdcs = new ArrayList<DynamicObject>(initDatas.length);
        ArrayList<DynamicObject> insertRecInits = new ArrayList<DynamicObject>(initDatas.length);
        for (DynamicObject initData : initDatas) {
            DynamicObjectCollection entrybank;
            DynamicObject org = initData.getDynamicObject("org");
            if (org == null || exisOrgs.contains(org.getLong("id"))) continue;
            DynamicObject recEdc = BusinessDataServiceHelper.newDynamicObject((String)"cas_rec_edc");
            recEdc.set("org", (Object)org);
            recEdc.set("startperiod", initData.get("startperiod"));
            recEdc.set("currentperiod", initData.get("startperiod"));
            recEdc.set("recperiod", initData.get("startperiod"));
            recEdc.set("creator", initData.get("creator"));
            recEdc.set("createtime", initData.get("createtime"));
            insertRecEdcs.add(recEdc);
            DynamicObject recInit = BusinessDataServiceHelper.newDynamicObject((String)"cas_rec_init");
            recInit.set("org", (Object)org);
            recInit.set("startperiod", initData.get("startperiod"));
            recInit.set("initperiod", initData.get("startperiod"));
            recInit.set("currentperiod", initData.get("startperiod"));
            recInit.set("isfinishinit", initData.get("isfinishinit"));
            recInit.set("standardcurrency", initData.get("standardcurrency"));
            recInit.set("exratetable", initData.get("exratetable"));
            recInit.set("periodtype", initData.get("periodtype"));
            recInit.set("creator", initData.get("creator"));
            recInit.set("createtime", initData.get("createtime"));
            recInit.set("billno", (Object)CodeRuleHelper.generateNumber((String)"cas_rec_init", (DynamicObject)initData, null, null));
            DynamicObjectCollection entrycash = initData.getDynamicObjectCollection("entrycash");
            if (CollectionUtils.isNotEmpty((Collection)entrycash)) {
                DynamicObjectCollection entrys = recInit.getDynamicObjectCollection("entrycash");
                for (DynamicObject row : entrycash) {
                    DynamicObject entry = entrys.addNew();
                    DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
                    for (IDataEntityProperty property : properties) {
                        entry.set(property.getName(), row.get(property.getName()));
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(entrybank = initData.getDynamicObjectCollection("entrybank")))) {
                DynamicObjectCollection entrys = recInit.getDynamicObjectCollection("entrybank");
                for (DynamicObject row : entrybank) {
                    if (!AccountBankHelper.isAuthorityAccount((DynamicObject)row.getDynamicObject("bank_accountbank"), (DynamicObject)org)) continue;
                    DynamicObject entry = entrys.addNew();
                    DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
                    for (IDataEntityProperty property : properties) {
                        entry.set(property.getName(), row.get(property.getName()));
                    }
                }
            }
            insertRecInits.add(recInit);
            this.updateOutDatas(org.getPkValue(), initData.get("startperiod"), "cas_bankstatement");
            this.updateOutDatas(org.getPkValue(), initData.get("startperiod"), "cas_bankjournal");
        }
        if (insertRecEdcs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertRecEdcs.toArray(new DynamicObject[0]));
        }
        if (insertRecInits.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertRecInits.toArray(new DynamicObject[0]));
        }
    }

    private void updateOutDatas(Object orgId, Object initPeriod, String outDataEntity) {
        QFilter oFilter = new QFilter("org", "=", orgId);
        QFilter pFilter = new QFilter("period", "=", (Object)0L);
        DynamicObject[] outDatas = BusinessDataServiceHelper.load((String)outDataEntity, (String)"id,isvalid,recinitperiod", (QFilter[])new QFilter[]{oFilter, pFilter});
        if (outDatas != null && outDatas.length > 0) {
            for (DynamicObject outData : outDatas) {
                outData.set("isvalid", (Object)"1");
                outData.set("recinitperiod", initPeriod);
            }
            SaveServiceHelper.save((DynamicObject[])outDatas);
        }
    }
}

