/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.AgentPayBillPluginHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class HisDataUpService {
    private static String[] sbilltypes = new String[]{"cas_paybill", "cas_paybill_cash", "cas_paybill_synonym"};

    public String payTotalAmtDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            this.payTotalAmtUpdate();
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String exchangeBillRateDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            if (!HisDataUpService.isTestEnv()) {
                this.exchangeBillRateUpdate();
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String payRecsettledLocalAmtDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            if (!HisDataUpService.isTestEnv()) {
                this.paySettledLocalAmtUpdate();
                this.recSettledLocalAmtUpdate();
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String journalEncodeDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            if (!HisDataUpService.isTestEnv()) {
                this.updateJournalEncode();
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String agentBillIsPersonPayDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            if (!HisDataUpService.isTestEnv()) {
                this.agentBillIsPersonPayUpdate();
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    public String payBillIsPersonPayDataUp() {
        RpcResult recResult = new RpcResult();
        try {
            if (!HisDataUpService.isTestEnv()) {
                this.payBillIsPersonPayUpdate();
            }
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    private void agentBillIsPersonPayUpdate() {
        String selects = "id, billno, payeetype, ispersonpay";
        ArrayList<Object[]> bankList = new ArrayList<Object[]>(1000);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)"payBillIsPersonPayUpdate", (String)"cas_agentpaybill", (String)selects, null, null);){
            for (Row row : balanceRawDataSet) {
                boolean ispersonpayDb = row.getBoolean("ispersonpay");
                String payeetype = row.getString("payeetype");
                DynamicObject sourceBill = BusinessDataServiceHelper.newDynamicObject((String)"cas_agentpaybill");
                sourceBill.set("payeetype", (Object)payeetype);
                boolean isPersonPay = AgentPayBillPluginHelper.isPersonPay((DynamicObject)sourceBill);
                if (isPersonPay == ispersonpayDb) continue;
                Object[] upBank = new Object[]{isPersonPay, row.getLong("id")};
                bankList.add(upBank);
                if (bankList.size() < 1000) continue;
                String sql = "update t_cas_agentpaybill_e set fispersonpay = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
                bankList.clear();
            }
            if (bankList.size() > 0) {
                String sql = "update t_cas_agentpaybill_e set fispersonpay = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
            }
        }
    }

    private void payBillIsPersonPayUpdate() {
        String selects = "id, billno, payee, payeetype, payeename, ispersonpay";
        ArrayList<Object[]> bankList = new ArrayList<Object[]>(1000);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)"payBillIsPersonPayUpdate", (String)"cas_paybill", (String)selects, null, null);){
            for (Row row : balanceRawDataSet) {
                boolean ispersonpayDb = row.getBoolean("ispersonpay");
                Long payee = row.getLong("payee");
                String payeetype = row.getString("payeetype");
                String payeename = row.getString("payeename");
                DynamicObject sourceBill = BusinessDataServiceHelper.newDynamicObject((String)"cas_paybill");
                sourceBill.set("payeetype", (Object)payeetype);
                sourceBill.set("payeename", (Object)payeename);
                sourceBill.set("payee", (Object)payee);
                boolean isPersonPay = AgentPayBillPluginHelper.isPersonPay((DynamicObject)sourceBill);
                if (isPersonPay == ispersonpayDb) continue;
                Object[] upBank = new Object[]{isPersonPay, row.getLong("id")};
                bankList.add(upBank);
                if (bankList.size() < 1000) continue;
                String sql = "update t_cas_paymentbill_e set fispersonpay = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
                bankList.clear();
            }
            if (bankList.size() > 0) {
                String sql = "update t_cas_paymentbill_e set fispersonpay = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
            }
        }
    }

    private void updateJournalEncode() {
        ArrayList<Object[]> bankList = new ArrayList<Object[]>(1000);
        String bankUpDataSql = "select fentryid,famount,flocalamount from t_cas_bankjournalentry where famount >0";
        DataSet bankJournalDataSet = DB.queryDataSet((String)"queryBankJournal", (DBRoute)DBRouteConst.cas, (String)bankUpDataSql);
        for (Row row : bankJournalDataSet) {
            BigDecimal e_amount = row.getBigDecimal("famount");
            BigDecimal e_localamount = row.getBigDecimal("flocalamount");
            if (e_amount.compareTo(BigDecimal.ZERO) == 0) continue;
            String encodeAmount = AgentPayBillHelper.encodeAmount((BigDecimal)e_amount);
            String encodeLocalAmount = AgentPayBillHelper.encodeAmount((BigDecimal)e_localamount);
            Object[] upBank = new Object[]{encodeAmount, encodeLocalAmount, row.getLong("fentryid")};
            bankList.add(upBank);
            if (bankList.size() < 1000) continue;
            String sql = "update t_cas_bankjournalentry set famount_enp = ?,flocalamount_enp = ? where fentryid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
            bankList.clear();
        }
        if (bankList.size() > 0) {
            String sql = "update t_cas_bankjournalentry set famount_enp = ?,flocalamount_enp = ? where fentryid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
        }
        ArrayList<Object[]> cashList = new ArrayList<Object[]>(1000);
        String cashUpDataSql = "select fentryid,famount,flocalamount from t_cas_cashjournalentry where famount >0";
        DataSet cashJournalDataSet = DB.queryDataSet((String)"queryCashJournal", (DBRoute)DBRouteConst.cas, (String)cashUpDataSql);
        for (Row row : cashJournalDataSet) {
            BigDecimal e_amount = row.getBigDecimal("famount");
            BigDecimal e_localamount = row.getBigDecimal("flocalamount");
            if (e_amount.compareTo(BigDecimal.ZERO) == 0) continue;
            String encodeAmount = AgentPayBillHelper.encodeAmount((BigDecimal)e_amount);
            String encodeLocalAmount = AgentPayBillHelper.encodeAmount((BigDecimal)e_localamount);
            Object[] upCash = new Object[]{encodeAmount, encodeLocalAmount, row.getLong("fentryid")};
            cashList.add(upCash);
            if (cashList.size() < 1000) continue;
            String sql = "update t_cas_cashjournalentry set famount_enp = ?,flocalamount_enp = ? where fentryid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, cashList);
            cashList.clear();
        }
        if (cashList.size() > 0) {
            String sql = "update t_cas_cashjournalentry set famount_enp = ?,flocalamount_enp = ? where fentryid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, cashList);
        }
    }

    private void paySettledLocalAmtUpdate() {
        String selects = "id,exchangerate,basecurrency, entry.id,entry.e_settledamt, entry.e_unsettledamt, entry.e_unsettledlocalamt, entry.e_settledlocalamt, entry.e_payablelocamt";
        ArrayList<Object[]> payList = new ArrayList<Object[]>(1000);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)"paySettledLocalAmtUpdate", (String)"cas_paybill", (String)selects, null, null);){
            for (Row row : balanceRawDataSet) {
                BigDecimal e_unsettledlocalamt;
                BigDecimal e_settledlocalamt;
                Long entryId = row.getLong("entry.id");
                Long id = row.getLong("id");
                BigDecimal e_settledamt = row.getBigDecimal("entry.e_settledamt") != null ? row.getBigDecimal("entry.e_settledamt") : BigDecimal.ZERO;
                BigDecimal e_unsettledamt = row.getBigDecimal("entry.e_unsettledamt") != null ? row.getBigDecimal("entry.e_unsettledamt") : BigDecimal.ZERO;
                BigDecimal e_payablelocamt = row.getBigDecimal("entry.e_payablelocamt") != null ? row.getBigDecimal("entry.e_payablelocamt") : BigDecimal.ZERO;
                BigDecimal dbSettledlocalamt = row.getBigDecimal("entry.e_settledlocalamt") != null ? row.getBigDecimal("entry.e_settledlocalamt") : BigDecimal.ZERO;
                BigDecimal dbUnsettledlocalamt = row.getBigDecimal("entry.e_unsettledlocalamt") != null ? row.getBigDecimal("entry.e_unsettledlocalamt") : BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(dbUnsettledlocalamt) != 0 || BigDecimal.ZERO.compareTo(dbSettledlocalamt) != 0) continue;
                if (BigDecimal.ZERO.compareTo(e_settledamt) == 0 && BigDecimal.ZERO.compareTo(e_unsettledamt) != 0) {
                    e_settledlocalamt = BigDecimal.ZERO;
                    e_unsettledlocalamt = e_payablelocamt;
                } else if (BigDecimal.ZERO.compareTo(e_unsettledamt) == 0 && BigDecimal.ZERO.compareTo(e_settledamt) != 0) {
                    e_unsettledlocalamt = BigDecimal.ZERO;
                    e_settledlocalamt = e_payablelocamt;
                } else {
                    if (BigDecimal.ZERO.compareTo(e_unsettledamt) == 0 || BigDecimal.ZERO.compareTo(e_settledamt) == 0) continue;
                    QFilter entryIdFilter = new QFilter("entry.billentryid", "=", (Object)entryId);
                    DynamicObject[] settleRec = SettleRecordQueryHelperForCas.getSettleRecords((String)"ap_settlerecord", (String)"entry.billentryid, entry.localsettleamt", (String)"cas_paybill", (Object[])new Object[]{id}, (QFilter)entryIdFilter);
                    if (settleRec != null && settleRec.length > 0) {
                        BigDecimal localSettleAmtSum;
                        e_settledlocalamt = localSettleAmtSum = Arrays.stream(settleRec).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(o -> Objects.equals(entryId, o.get("billentryid"))).map(o -> o.getBigDecimal("localsettleamt")).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        e_unsettledlocalamt = e_payablelocamt.subtract(e_settledlocalamt);
                    } else {
                        e_unsettledlocalamt = e_payablelocamt;
                        e_settledlocalamt = BigDecimal.ZERO;
                    }
                }
                Object[] upPay = new Object[]{e_settledlocalamt, e_unsettledlocalamt, entryId};
                payList.add(upPay);
                if (payList.size() < 1000) continue;
                String sql = "update t_cas_paymentbillentry set fsettledlocalamt = ?,funsettledlocalamt = ? where fentryid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, payList);
                payList.clear();
            }
            if (payList.size() > 0) {
                String sql = "update t_cas_paymentbillentry set fsettledlocalamt = ?,funsettledlocalamt = ? where fentryid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, payList);
                payList.clear();
            }
        }
    }

    private void recSettledLocalAmtUpdate() {
        String selects = "id,exchangerate,basecurrency, entry.id,entry.e_settledamt, entry.e_unsettledamt, entry.e_unsettledlocalamt, entry.e_settledlocalamt, entry.e_receivablelocamt";
        ArrayList<Object[]> payList = new ArrayList<Object[]>(1000);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)"recSettledLocalAmtUpdate", (String)"cas_recbill", (String)selects, null, null);){
            for (Row row : balanceRawDataSet) {
                BigDecimal e_unsettledlocalamt;
                BigDecimal e_settledlocalamt;
                Long entryId = row.getLong("entry.id");
                Long id = row.getLong("id");
                BigDecimal e_settledamt = row.getBigDecimal("entry.e_settledamt") != null ? row.getBigDecimal("entry.e_settledamt") : BigDecimal.ZERO;
                BigDecimal e_unsettledamt = row.getBigDecimal("entry.e_unsettledamt") != null ? row.getBigDecimal("entry.e_unsettledamt") : BigDecimal.ZERO;
                BigDecimal e_receivablelocamt = row.getBigDecimal("entry.e_receivablelocamt") != null ? row.getBigDecimal("entry.e_receivablelocamt") : BigDecimal.ZERO;
                BigDecimal dbSettledlocalamt = row.getBigDecimal("entry.e_settledlocalamt") != null ? row.getBigDecimal("entry.e_settledlocalamt") : BigDecimal.ZERO;
                BigDecimal dbUnsettledlocalamt = row.getBigDecimal("entry.e_unsettledlocalamt") != null ? row.getBigDecimal("entry.e_unsettledlocalamt") : BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(dbUnsettledlocalamt) != 0 || BigDecimal.ZERO.compareTo(dbSettledlocalamt) != 0) continue;
                if (BigDecimal.ZERO.compareTo(e_settledamt) == 0 && BigDecimal.ZERO.compareTo(e_unsettledamt) != 0) {
                    e_settledlocalamt = BigDecimal.ZERO;
                    e_unsettledlocalamt = e_receivablelocamt;
                } else if (BigDecimal.ZERO.compareTo(e_unsettledamt) == 0 && BigDecimal.ZERO.compareTo(e_settledamt) != 0) {
                    e_unsettledlocalamt = BigDecimal.ZERO;
                    e_settledlocalamt = e_receivablelocamt;
                } else {
                    if (BigDecimal.ZERO.compareTo(e_unsettledamt) == 0 || BigDecimal.ZERO.compareTo(e_settledamt) == 0) continue;
                    QFilter entryIdFilter = new QFilter("entry.billentryid", "=", (Object)entryId);
                    DynamicObject[] settleRec = SettleRecordQueryHelperForCas.getSettleRecords((String)"ap_settlerecord", (String)"entry.billentryid, entry.localsettleamt", (String)"cas_paybill", (Object[])new Object[]{id}, (QFilter)entryIdFilter);
                    if (settleRec != null && settleRec.length > 0) {
                        BigDecimal localSettleAmtSum;
                        e_settledlocalamt = localSettleAmtSum = Arrays.stream(settleRec).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(o -> Objects.equals(entryId, o.get("billentryid"))).map(o -> o.getBigDecimal("localsettleamt")).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        e_unsettledlocalamt = e_receivablelocamt.subtract(e_settledlocalamt);
                    } else {
                        e_unsettledlocalamt = e_receivablelocamt;
                        e_settledlocalamt = BigDecimal.ZERO;
                    }
                }
                Object[] upPay = new Object[]{e_settledlocalamt, e_unsettledlocalamt, entryId};
                payList.add(upPay);
                if (payList.size() < 1000) continue;
                String sql = "update t_cas_receivingbillentry set fsettledlocalamt = ?,funsettledlocalamt = ? where fentryid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, payList);
                payList.clear();
            }
            if (payList.size() > 0) {
                String sql = "update t_cas_receivingbillentry set fsettledlocalamt = ?,funsettledlocalamt = ? where fentryid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, payList);
                payList.clear();
            }
        }
    }

    private void exchangeBillRateUpdate() {
        String selects = "id, bizdate, org.id";
        ArrayList<Object[]> bankList = new ArrayList<Object[]>(1000);
        QFilter filter = new QFilter("exratetable", "is null", null).or(new QFilter("exratetable", "=", (Object)0));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)"exchangeBillRateUpdate", (String)"cas_exchangebill", (String)selects, (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : balanceRawDataSet) {
                Long orgId = row.getLong("org.id");
                Long exchangeRateTableId = 0L;
                try {
                    exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exchangeRateTableId.equals(0L)) continue;
                Date bizdate = row.getDate("bizdate");
                Object[] upBank = new Object[]{exchangeRateTableId, bizdate, row.getLong("id")};
                bankList.add(upBank);
                if (bankList.size() < 1000) continue;
                String sql = "update t_cas_exchangebill set fexratetableid = ?,fexratedate = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
                bankList.clear();
            }
            if (bankList.size() > 0) {
                String sql = "update t_cas_exchangebill set fexratetableid = ?,fexratedate = ? where fid = ? ";
                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, bankList);
            }
        }
    }

    private void payTotalAmtUpdate() {
        String selects = "id,dpamt,fee,singlestream,dppayquotation,payeracctbank.id";
        ArrayList<Object[]> payInfoList = new ArrayList<Object[]>(1000);
        HashMap<Long, Object[]> payInfoMap = new HashMap<Long, Object[]>(1000);
        ArrayList<Long> bankJPIds = new ArrayList<Long>(1000);
        ArrayList<Long> cashJPIds = new ArrayList<Long>(1000);
        QFilter filter = new QFilter("totalpayamt", "=", (Object)0);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)"payTotalAmtUpdate", (String)"cas_paybill", (String)selects, (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : balanceRawDataSet) {
                Long payId = row.getLong("id");
                BigDecimal dpamt = row.getBigDecimal("dpamt");
                BigDecimal fee = row.getBigDecimal("fee");
                BigDecimal totalpayamt = dpamt.add(fee);
                Object[] upPay = new Object[]{totalpayamt, payId};
                payInfoList.add(upPay);
                Boolean singlestream = row.getBoolean("singlestream");
                if (!singlestream.booleanValue()) {
                    Long payeracctbankId = row.getLong("payeracctbank.id");
                    if (CasHelper.isEmpty((Object)payeracctbankId)) {
                        cashJPIds.add(payId);
                    } else {
                        bankJPIds.add(payId);
                    }
                    Object[] payInfo = new Object[]{totalpayamt, row.getString("dppayquotation")};
                    payInfoMap.put(payId, payInfo);
                }
                if (payInfoList.size() < 1000) continue;
                this.updateJournalAndPayBill(payInfoList, bankJPIds, cashJPIds, payInfoMap);
            }
            if (payInfoList.size() > 0) {
                this.updateJournalAndPayBill(payInfoList, bankJPIds, cashJPIds, payInfoMap);
            }
        }
    }

    private void updateJournalAndPayBill(List<Object[]> payInfoList, List<Long> bankJPIds, List<Long> cashJPIds, Map<Long, Object[]> payInfoMap) {
        List<Object[]> updateBJournalDatas = this.updateJournalData("cas_bankjournal", bankJPIds, payInfoMap);
        List<Object[]> updateCJournalDatas = this.updateJournalData("cas_cashjournal", cashJPIds, payInfoMap);
        String sql = "update T_CAS_PaymentBill_e set ftotalpayamt = ? where fid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, payInfoList);
        if (updateBJournalDatas.size() > 0) {
            sql = "update t_cas_bankjournal set FCreditAmount = ?,flocalamount = ? where fid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, updateBJournalDatas);
        }
        if (updateCJournalDatas.size() > 0) {
            sql = "update t_cas_cashjournal set FCreditAmount = ?,flocalamount = ? where fid = ? ";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, updateCJournalDatas);
        }
        payInfoList.clear();
        bankJPIds.clear();
        cashJPIds.clear();
        payInfoMap.clear();
    }

    private List<Object[]> updateJournalData(String entityName, List<Long> payInfoIds, Map<Long, Object[]> payInfoMap) {
        DynamicObject[] journalDatas;
        ArrayList<Object[]> upInfoList = new ArrayList<Object[]>(1000);
        if (payInfoIds == null || payInfoIds.size() <= 0) {
            return upInfoList;
        }
        QFilter filter = new QFilter("sourcebilltype", "in", (Object)sbilltypes).and(new QFilter("sourcebillid", "in", payInfoIds)).and(new QFilter("creditamount", "=", (Object)0)).and(new QFilter("debitamount", "=", (Object)0));
        for (DynamicObject journalData : journalDatas = BusinessDataServiceHelper.load((String)entityName, (String)"id,creditamount,localamount,basecurrency,exchangerate,sourcebillid", (QFilter[])new QFilter[]{filter})) {
            long sourcebillid = journalData.getLong("sourcebillid");
            Object[] payInfo = payInfoMap.get(sourcebillid);
            if (payInfo == null) continue;
            BigDecimal totalpayamt = (BigDecimal)payInfo[0];
            String quotation = (String)payInfo[1];
            DynamicObject baseCurrency = journalData.getDynamicObject("basecurrency");
            BigDecimal rate = journalData.getBigDecimal("exchangerate");
            BigDecimal localAmount = BigDecimal.ZERO;
            localAmount = baseCurrency != null ? QuotationHelper.callToCurrency((BigDecimal)totalpayamt, (BigDecimal)rate, (String)quotation, (int)baseCurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency((BigDecimal)totalpayamt, (BigDecimal)rate, (String)quotation, (int)10);
            Object[] upPay = new Object[]{totalpayamt, localAmount, journalData.getLong("id")};
            upInfoList.add(upPay);
        }
        return upInfoList;
    }

    public static boolean isTestEnv() {
        String tenantId = RequestContext.get().getTenantId();
        return "patchfi".equals(tenantId) || "baseline_a".equals(tenantId) || "tenant_devfi_dev".equals(tenantId);
    }
}

