/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.cas.helper.TmcAppCache;

public class JournalPrintHelper {
    private static final String CFG_SUFFIX = "_printsetting";
    private static final Log log = LogFactory.getLog(JournalPrintHelper.class);
    public static IAppCache iAppCache = TmcAppCache.get((String)"cas", (String)"printall", (String)"printnotecache");
    public static final String PAGEID = "pageid";

    public static Object getDefaultTemplateId(String formId) {
        DynamicObject preferenceScheme;
        Object dTemplateId = null;
        Map<String, Object> printSetting = JournalPrintHelper.getPrintSetting(formId);
        if (!printSetting.isEmpty()) {
            dTemplateId = printSetting.get("templateid");
        }
        if (ObjectUtils.isEmpty(dTemplateId) && (preferenceScheme = JournalPrintHelper.getEnableScheme(formId)) != null) {
            dTemplateId = preferenceScheme.get("defaultprinter");
        }
        if (ObjectUtils.isEmpty((Object)dTemplateId)) {
            dTemplateId = JournalPrintHelper.getDefaulttplInManangeTool(formId);
        }
        return dTemplateId;
    }

    private static Map<String, Object> getPrintSetting(String formId) {
        Map<String, Object> myPrintSetting = new HashMap<String, Object>();
        String configKey = formId + CFG_SUFFIX;
        String userId = RequestContext.get().getUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            myPrintSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return myPrintSetting;
    }

    private static DynamicObject getEnableScheme(String formId) {
        Optional firstScheme;
        DynamicObject scheme = null;
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty() && (firstScheme = schemes.values().stream().findFirst()).isPresent()) {
            scheme = (DynamicObject)firstScheme.get();
        }
        return scheme;
    }

    private static String getDefaulttplInManangeTool(String formId) {
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get("printtplid.id");
        }
        return tplId;
    }

    private static String getLeftNoteCacheKey(ReportQueryParam queryParam) {
        FilterItemInfo pageid = queryParam.getFilter().getFilterItem(PAGEID);
        return pageid == null ? null : pageid.getString();
    }

    public static void cacheLeftNodes(List<TreeNode> nodes, ReportQueryParam queryParam) {
        StringBuilder sb = new StringBuilder();
        if (nodes != null) {
            for (TreeNode node : nodes) {
                if (!StringUtils.isNotBlank((CharSequence)node.getParentid())) continue;
                sb.append(node.getId()).append('%');
            }
        }
        log.info("=======cacheLeftNodes:{}===", (Object)sb.toString());
        String pageId = JournalPrintHelper.getLeftNoteCacheKey(queryParam);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            iAppCache.put(pageId, (Object)sb.toString());
        }
    }

    public static void setLeftNoteCacheKey(String pageId, ReportQueryParam queryParam) {
        queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> PAGEID.equals(filterItemInfo.getPropName()));
        queryParam.getFilter().addFilterItem(PAGEID, (Object)pageId);
        iAppCache.put(pageId, (Object)pageId);
    }

    public static String getLeftNodesFromCache(ReportQueryParam queryParam) {
        String pageId = JournalPrintHelper.getLeftNoteCacheKey(queryParam);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            return (String)iAppCache.get(pageId, String.class);
        }
        return null;
    }

    public static void clearLeftNoteCache(String pageId) {
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            iAppCache.remove(pageId);
        }
    }
}

