/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class JournalRptDataService {
    protected static final String REPORT_LIST_AP = "reportlistap";
    private static Log logger = LogFactory.getLog(JournalRptDataService.class);
    private final IReportCache reportCache = ReportCacheManager.getInstance().getCache();
    public static IAppCache iAppCache = TmcAppCache.get((String)"cas", (String)"printall", (String)"printnotecache");

    public Set<String> getJournalRptDataFileUrl(Map<String, Object> params) {
        if (params != null && !params.isEmpty()) {
            String formId = (String)params.get("formid");
            String printLang = (String)params.get("printlang");
            logger.info("JournalRptDataService params:{}", params);
            String rptPageId = this.simulateReportSearch(formId, params);
            Object defaultTemplateId = params.get("templateId");
            if (StringUtils.isEmpty((CharSequence)rptPageId)) {
                String billName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().toString();
                logger.error(String.format("%s\u4e0a\u4f20\u5931\u8d25,\u6253\u5370\u62a5\u8868\u5931\u8d25", billName));
                return new HashSet<String>(1);
            }
            if (EmptyUtil.isEmpty((Object)defaultTemplateId)) {
                String billName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().toString();
                logger.error(String.format("%s\u4e0a\u4f20\u5931\u8d25,\u6253\u5370\u62a5\u8868\u5931\u8d25\uff0c\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u6253\u5370\u6a21\u677f\u3002", billName));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0a\u4f20\u5931\u8d25,\u6253\u5370\u62a5\u8868\u5931\u8d25\u3002\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveRptByDowJonesLogicUnit_2", (String)"fi-cas-business", (Object[])new Object[0]), billName));
            }
            HashSet<String> urlSet = new HashSet<String>(2);
            QFilter qFilter = new QFilter("printtplid", "=", defaultTemplateId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_manageprinttpl", (String)"id,type", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                String type = dynamicObject.getString("type");
                if ("A".equals(type)) {
                    HashMap<String, Object> extParam = new HashMap<String, Object>(2);
                    extParam.put("pageIDForPrint", rptPageId);
                    extParam.put("printAll", true);
                    extParam.put("isBizOp", true);
                    ArrayList<PrintJob> jobs = new ArrayList<PrintJob>();
                    PrintJob job = new PrintJob(rptPageId, formId);
                    job.setTemplateId(defaultTemplateId);
                    job.setDataProvider(null);
                    jobs.add(job);
                    String taskId = PrintServiceHelper.execPrint((String)"", (String)"report", jobs, extParam);
                    PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
                    for (PrtTaskResult.Attach attachDetail : prtResult.getAttach()) {
                        logger.info("urlSet:{}\u3002", (Object)attachDetail.getFilePath());
                        urlSet.add(attachDetail.getFilePath());
                    }
                } else if ("B".equals(type)) {
                    PrintWork work = new PrintWork();
                    work.setPageId(rptPageId);
                    work.setPrintLang(printLang);
                    work.setExpType("1");
                    PrintTask task = new PrintTask();
                    task.setFormId(formId);
                    task.setPageId(rptPageId);
                    task.setPrintType("report");
                    task.setTplId((String)defaultTemplateId);
                    HashMap<String, Object> extParam = new HashMap<String, Object>(2);
                    extParam.put("pageIDForPrint", rptPageId);
                    extParam.put("printAll", true);
                    work.setExtParam(extParam);
                    work.add(task);
                    PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
                    List attachDetails = prtAttach.getAttachDetail();
                    for (PrtAttach.AttachDetail attachDetail : attachDetails) {
                        urlSet.add(attachDetail.getFilePath());
                    }
                }
            }
            logger.info("urlSet:{}\u3002", urlSet);
            return urlSet;
        }
        return new HashSet<String>(2);
    }

    private String simulateReportSearch(String formId, Map<String, Object> params) {
        if (params != null && !params.isEmpty()) {
            FormConfig config = FormMetadataCache.getFormConfig((String)formId);
            ReportView view = null;
            String pageId = null;
            ReportShowParameter report = new ReportShowParameter();
            report.beginInit();
            report.setFormId(formId);
            report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            report.setFormConfig(config);
            report.setCustomParam("bos_reportConcurrencyQueryLimit", (Object)"false");
            report.setCustomParam("bos_reportConcurrencyExportLimit", (Object)"false");
            pageId = report.getPageId();
            String reportJson = FormShowParameter.toJsonString((FormShowParameter)report);
            report.endInit();
            view = (ReportView)report.createView();
            PageCache page = new PageCache(pageId);
            view.addService(IPageCache.class, (Object)page);
            page.put(FormShowParameter.class.getSimpleName(), reportJson);
            view.initialize((FormShowParameter)report);
            IDataModel model = view.getModel();
            model.createNewData();
            this.setQFilter(model, params);
            ReportFilter filter = (ReportFilter)view.getControl("reportfilterap");
            ReportQueryParam reportQueryParam = filter.getReportQueryParam();
            this.reportCache.setReportQueryParam(pageId, reportQueryParam);
            ReportListModel listModel = this.getExportAllReportModel(view, view.getReportList(), pageId);
            if (EmptyUtil.isEmpty((Object)listModel) || listModel.getRowCount() < 1) {
                logger.error("simulateReport\u53c2\u6570formId\uff1a{},params\uff1a{},\u8fd4\u56de\u503cpageid\uff1a{}", new Object[]{formId, params, pageId});
                return "";
            }
            logger.info("simulateReport\u53c2\u6570formId\uff1a{},params\uff1a{},\u8fd4\u56de\u503cpageid\uff1a{}", new Object[]{formId, params, pageId});
            return pageId;
        }
        return "";
    }

    private void setQFilter(IDataModel model, Map<String, Object> params) {
        if (params != null) {
            Map allFields = model.getDataEntityType().getAllFields();
            List orgIds = (List)params.get("org");
            this.setMulBaseDataProp(model, "org", orgIds);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String propertyKey = entry.getKey();
                if (!model.getDataEntity().containsProperty(propertyKey)) continue;
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(propertyKey);
                if ("org".equals(propertyKey)) continue;
                if (property instanceof MulBasedataProp) {
                    String key = entry.getKey();
                    ArrayList<Object> pkIds = new ArrayList(2);
                    pkIds = (List)entry.getValue();
                    this.setMulBaseDataProp(model, key, pkIds);
                    continue;
                }
                model.setValue(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setMulBaseDataProp(IDataModel model, String key, List<Object> pkIds) {
        DynamicObjectCollection collection = (DynamicObjectCollection)model.getValue(key);
        collection.clear();
        Map objs = new HashMap(2);
        if ("currency".equals(key)) {
            objs = BusinessDataReader.loadFromCache((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
        } else if ("org".equals(key) || "openorg".equals(key)) {
            objs = BusinessDataReader.loadFromCache((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
        } else if ("accountbank".equals(key)) {
            objs = BusinessDataReader.loadFromCache((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        } else if ("accountcash".equals(key)) {
            objs = BusinessDataReader.loadFromCache((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_accountcash"));
        }
        if (!objs.isEmpty()) {
            DynamicCollectionProperty orgProperty = (DynamicCollectionProperty)model.getProperty(key);
            for (DynamicObject obj : objs.values()) {
                DynamicObject newObj = new DynamicObject(orgProperty.getDynamicCollectionItemPropertyType());
                newObj.set("fbasedataId", (Object)obj);
                newObj.set("fbasedataId_id", obj.getPkValue());
                collection.add((Object)newObj);
            }
            model.setValue(key, (Object)collection);
        }
    }

    private ReportListModel getExportAllReportModel(ReportView view, ReportList reportList1, String pageId) {
        ReportQueryParam queryParam = reportList1.getReportModel().getReportQueryParam();
        ReportList list = (ReportList)view.getControl(REPORT_LIST_AP);
        String acctIds = this.buildNodeIdStr(queryParam, view.getEntityId());
        if (StringUtils.isBlank((CharSequence)acctIds)) {
            return new ReportListModel();
        }
        this.reportCache.setReportQueryParam(pageId, queryParam);
        ReportListModel reportModel = (ReportListModel)list.getReportModel();
        reportModel.setPageId(pageId);
        list.setAsynQuery(true);
        logger.info("getExportAllReportModel acctIds : {}", (Object)acctIds);
        list.submitTask(queryParam, (Object)acctIds);
        return reportModel;
    }

    public String buildNodeIdStr(ReportQueryParam queryParam, String formId) {
        StringBuilder sb = new StringBuilder();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgColl = null;
        orgColl = filterInfo.getDynamicObjectCollection("org");
        String queryorgtype = filterInfo.getString("queryorgtype");
        if ("cas_bankjournalformrpt".equalsIgnoreCase(formId) && !"org".equals(queryorgtype)) {
            orgColl = filterInfo.getDynamicObjectCollection("openorg");
        }
        DynamicObjectCollection currencyColl = filterInfo.getDynamicObjectCollection("currency");
        boolean isContainClosed = filterInfo.getBoolean("iscontainclosed");
        DynamicObjectCollection acctPlainColl = this.getAcctPlainColl(orgColl, isContainClosed, formId, queryorgtype, filterInfo);
        for (int j = 0; j < acctPlainColl.size(); ++j) {
            DynamicObject acct = (DynamicObject)acctPlainColl.get(j);
            if (currencyColl != null) {
                if (!this.isContains(currencyColl, acct.getLong("currencyid"))) continue;
                sb.append(acct.getString("currencyid")).append('-').append(acct.getString("id")).append('-').append(acct.getString("orgid")).append('-').append(acct.getString("acctname")).append('%');
                continue;
            }
            sb.append(acct.getString("currencyid")).append('-').append(acct.getString("id")).append('-').append(acct.getString("orgid")).append('-').append(acct.getString("acctname")).append('%');
        }
        return sb.toString();
    }

    public DynamicObjectCollection getAcctPlainColl(DynamicObjectCollection orgColl, boolean isContainClosed, String formId, String queryOrgType, FilterInfo filterInfo) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (isContainClosed) {
            Date beginDate = null;
            int type = filterInfo.getInt("datetype");
            if (type == 1) {
                DynamicObject beginPeriodDo = filterInfo.getDynamicObject("beginperiod");
                if (beginPeriodDo != null) {
                    beginDate = beginPeriodDo.getDate("begindate");
                }
            } else {
                beginDate = filterInfo.getDate("begindate");
            }
            QFilter qFilter = QFilter.of((String)"(closedate = null or closedate >= ?)", (Object[])new Object[]{DateUtils.getDataFormat((Date)beginDate, (boolean)true)});
            filters.add(qFilter);
        }
        String entity = "";
        String selectFields = "";
        if ("cas_cashjournalformrpt".equalsIgnoreCase(formId)) {
            if (!isContainClosed) {
                filters.add(new QFilter("closestatus", "!=", (Object)"1"));
            }
            entity = "cas_accountcash";
            selectFields = this.getCashSelectFields();
            filters.add(new QFilter("org", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)orgColl)));
        } else {
            if (!isContainClosed) {
                filters.add(new QFilter("acctstatus", "!=", (Object)"closed"));
            }
            if ("org".equals(queryOrgType)) {
                ArrayList<QFilter> listQ = new ArrayList<QFilter>(1);
                if (orgColl != null) {
                    listQ.add(AccountBankHelper.getAccountBankFilterByOrg((Collection)OrgHelper.getIdList((DynamicObjectCollection)orgColl)));
                    filters.addAll(listQ);
                }
                filters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
            } else if ("openorg".equals(queryOrgType) && orgColl != null) {
                filters.add(new QFilter("openorg", "in", (Object)OrgHelper.getIdList((DynamicObjectCollection)orgColl)));
            }
            entity = "bd_accountbanks";
            selectFields = this.getBankSelectFields();
        }
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
    }

    public String getCashSelectFields() {
        String selectFields = "id,name as acctname,number as acctnumber,org.id as orgid,org.name as orgname,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname";
        return selectFields;
    }

    public String getBankSelectFields() {
        String selectFields = "id,name as acctname,number as acctnumber,company.id as orgid,company.name as orgname,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname";
        return selectFields;
    }

    protected boolean isContains(DynamicObjectCollection coll, long id) {
        boolean flag = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject object = (DynamicObject)coll.get(i);
            if (object.getLong("id") != id) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

