/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class LetterCreditService {
    private static final Log logger = LogFactory.getLog(LetterCreditService.class);
    private static final List<String> REQ_PARAM_LIST = Stream.of("payBillId", "creditNo", "settletNumber", "orgId", "bankId", "currencyId", "amount", "benefiterType", "beneficiaryName").collect(Collectors.toList());

    public OperationResult chgPayBillStatus(Map<String, Object> param) {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        String operation = (String)param.get("operation");
        try {
            List payBillInfoList = (List)param.get("payBillInfoList");
            if (CollectionUtils.isEmpty((Collection)payBillInfoList)) {
                return result;
            }
            switch (operation) {
                case "save": 
                case "submit": {
                    this.saveSettletNumber(payBillInfoList, result);
                    break;
                }
                case "delete": {
                    Set<String> settletNumberSet = payBillInfoList.stream().map(i -> (String)i.get("settletNumber")).collect(Collectors.toSet());
                    this.clearSettletNumber(settletNumberSet, result);
                    break;
                }
                case "unauditValidate": {
                    this.lcOpExecPayBillOp(payBillInfoList, result, "validcancelpay");
                    break;
                }
                case "unaudit": {
                    this.lcOpExecPayBillOp(payBillInfoList, result, "cancelpay");
                    break;
                }
                default: {
                    String msg = String.format(ResManager.loadKDString((String)"%s \u975e\u6cd5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LcCallBillService_0", (String)"fi-cas-business", (Object[])new Object[0]), operation);
                    result.setSuccess(false);
                    result.setMessage(msg);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(operation + " error", (Throwable)e);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private void saveSettletNumber(List<Map<String, Object>> payBillInfoList, OperationResult result) {
        ArrayList<String> errorMsgList = new ArrayList<String>(10);
        ArrayList<DynamicObject> updateObjList = new ArrayList<DynamicObject>(10);
        Set payBillIdSet = payBillInfoList.stream().map(i -> (Long)i.get("payBillId")).collect(Collectors.toSet());
        DynamicObject[] payBillArr = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,settletnumber,org,payerbank,dpcurrency,actpayamt,payeetype,payeename", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIdSet)});
        Map<Long, List<DynamicObject>> idToPayBillMap = Arrays.stream(payBillArr).collect(Collectors.groupingBy(b -> b.getLong("id")));
        for (int i2 = 0; i2 < payBillInfoList.size(); ++i2) {
            Map<String, Object> info = payBillInfoList.get(i2);
            List<String> emptyParamList = this.checkReqParamNotEmpty(info, REQ_PARAM_LIST);
            if (emptyParamList.isEmpty()) {
                Long payBillId = (Long)info.get("payBillId");
                List<DynamicObject> dbData = idToPayBillMap.get(payBillId);
                if (dbData != null) {
                    DynamicObject dbPayBill = dbData.get(0);
                    String errorMsg = this.checkPayBillInfo(info, dbPayBill);
                    if (StringUtils.isBlank((CharSequence)errorMsg)) {
                        String settletNumber = (String)info.get("settletNumber");
                        dbPayBill.set("settletnumber", (Object)settletNumber);
                        updateObjList.add(dbPayBill);
                        continue;
                    }
                    errorMsgList.add(errorMsg);
                    continue;
                }
                String errorMsg = String.format(ResManager.loadKDString((String)"id\u4e3a\u201d%s\u201c\u7684\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\u3002", (String)"LcCallBillService_1", (String)"fi-cas-business", (Object[])new Object[0]), payBillId);
                errorMsgList.add(errorMsg);
                continue;
            }
            String msg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e2d\u4e0b\u6807\u4e3a%1$s\u7684\u4fe1\u606f\u5b57\u6bb5%2$s\u4e3a\u7a7a\u3002", (String)"LcCallBillService_2", (String)"fi-cas-business", (Object[])new Object[0]);
            String errorMsg = String.format(msg, i2, emptyParamList);
            errorMsgList.add(errorMsg);
        }
        if (!errorMsgList.isEmpty()) {
            String errorMsg = String.join((CharSequence)"\r\n", errorMsgList);
            result.setSuccess(false);
            result.setMessage(errorMsg);
        } else {
            SaveServiceHelper.update((DynamicObject[])updateObjList.toArray(new DynamicObject[0]));
        }
    }

    private void clearSettletNumber(Set<String> payBillIdSet, OperationResult result) {
        QFilter qFilter = new QFilter("settletnumber", "in", payBillIdSet).and("settletype.settlementtype", "=", (Object)SettleMentTypeEnum.CREDITOPEN.getValue());
        DynamicObject[] payBillArr = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,billstatus,settletnumber", (QFilter[])new QFilter[]{qFilter});
        if (payBillArr.length == 0) {
            return;
        }
        for (DynamicObject dbPayBill : payBillArr) {
            dbPayBill.set("settletnumber", (Object)"");
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject[])payBillArr);
                Set payedIdSet = Arrays.stream(payBillArr).filter(p -> "D".equals(p.getString("billstatus"))).map(p -> p.getLong("id")).collect(Collectors.toSet());
                if (!payedIdSet.isEmpty()) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("isStrict", "false");
                    OperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (Object[])payedIdSet.toArray(), (OperateOption)operateOption);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            logger.error("clearSettletNumber fail", (Throwable)e);
        }
    }

    private void lcOpExecPayBillOp(List<Map<String, Object>> payBillInfoList, OperationResult result, String payBillOp) {
        List successPkIds = result.getSuccessPkIds();
        Map creditNoToLcBillIdMap = payBillInfoList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)((String)p.get("settletNumber"))) && !EmptyUtil.isEmpty((Long)((Long)p.get("lcBillId")))).collect(Collectors.groupingBy(p -> (String)p.get("settletNumber"), Collectors.mapping(p -> (Long)p.get("lcBillId"), Collectors.toList())));
        if (creditNoToLcBillIdMap.isEmpty()) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"LcCallBillService_13", (String)"fi-cas-business", (Object[])new Object[0]));
            return;
        }
        successPkIds.addAll(creditNoToLcBillIdMap.values());
        Set<String> settletnumberSet = creditNoToLcBillIdMap.keySet();
        QFilter filter = new QFilter("settletnumber", "in", settletnumberSet).and("billstatus", "=", (Object)"D");
        DynamicObjectCollection dbPayBillColl = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno,billstatus,settletnumber", (QFilter[])new QFilter[]{filter});
        if (dbPayBillColl.isEmpty()) {
            return;
        }
        List validateErrors = result.getValidateResult().getValidateErrors();
        try {
            Map payBillIdToCreditNoMap = dbPayBillColl.stream().collect(Collectors.groupingBy(p -> p.getLong("id"), Collectors.mapping(p -> p.getString("settletnumber"), Collectors.toList())));
            Set<Long> payedIdSet = payBillIdToCreditNoMap.keySet();
            OperateOption operateOption = OperateOption.create();
            if ("cancelpay".equals(payBillOp)) {
                operateOption.setVariableValue("isStrict", "false");
                operateOption.setVariableValue("ishasright", "true");
            }
            OperationResult cancelPayResult = OperationServiceHelper.executeOperate((String)payBillOp, (String)"cas_paybill", (Object[])payedIdSet.toArray(), (OperateOption)operateOption);
            List allErrorOrValidateInfo = cancelPayResult.getAllErrorOrValidateInfo();
            for (IOperateInfo validateInfo : allErrorOrValidateInfo) {
                ValidateResult validateResult = new ValidateResult();
                OperateErrorInfo info = new OperateErrorInfo();
                info.setMessage(validateInfo.getMessage());
                Long payBillId = (Long)validateInfo.getPkValue();
                String creditNo = (String)payBillIdToCreditNoMap.get(payBillId).get(0);
                Long lcBillId = (Long)creditNoToLcBillIdMap.get(creditNo).get(0);
                successPkIds.remove(lcBillId);
                info.setPkValue((Object)lcBillId);
                info.setErrorLevel(ErrorLevel.Error.name());
                validateResult.addErrorInfo(info);
                validateErrors.add(validateResult);
            }
            if (validateErrors.size() > 0) {
                result.setSuccess(false);
                result.setMessage(this.getErrorMsg(payBillOp));
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(this.getErrorMsg(payBillOp));
        }
    }

    private String getErrorMsg(String payBillOp) {
        String msg = "";
        if ("validcancelpay".equals(payBillOp)) {
            msg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u53d6\u6d88\u4ed8\u6b3e\u6821\u9a8c\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"LcCallBillService_11", (String)"fi-cas-business", (Object[])new Object[0]);
        } else if ("cancelpay".equals(payBillOp)) {
            msg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"LcCallBillService_12", (String)"fi-cas-business", (Object[])new Object[0]);
        }
        return msg;
    }

    private List<String> checkReqParamNotEmpty(Map<String, Object> payBillInfo, List<String> fields) {
        ArrayList<String> emptyParamList = new ArrayList<String>(10);
        for (String param : fields) {
            Object obj = payBillInfo.get(param);
            if (!EmptyUtil.isEmpty((Object)obj)) continue;
            emptyParamList.add(param);
        }
        return emptyParamList;
    }

    private String checkPayBillInfo(Map<String, Object> reqInfo, DynamicObject dbData) {
        Long orgId = (Long)reqInfo.get("orgId");
        Long bankId = (Long)reqInfo.get("bankId");
        Long currencyId = (Long)reqInfo.get("currencyId");
        BigDecimal amount = (BigDecimal)reqInfo.get("amount");
        String benefiterType = (String)reqInfo.get("benefiterType");
        String beneficiaryName = (String)reqInfo.get("beneficiaryName");
        Long dbOrgId = dbData.getDynamicObject("org").getLong("id");
        Long dbBankId = dbData.getDynamicObject("payerbank").getLong("id");
        Long dbCurrencyId = dbData.getDynamicObject("dpcurrency").getLong("id");
        BigDecimal dbAmount = dbData.getBigDecimal("actpayamt");
        String dbPayeeType = dbData.getString("payeetype");
        String dbPayeeName = dbData.getString("payeename");
        String errorMsg = null;
        StringBuilder sb = new StringBuilder();
        if (!orgId.equals(dbOrgId)) {
            sb.append(ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba\u4e0e\u4ed8\u6b3e\u4eba\u4e0d\u4e00\u6837\u3002", (String)"LcCallBillService_3", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!bankId.equals(dbBankId)) {
            sb.append(ResManager.loadKDString((String)"\u5f00\u8bc1\u94f6\u884c\u4e0e\u4ed8\u6b3e\u94f6\u884c\u4e0d\u4e00\u6837\u3002", (String)"LcCallBillService_4", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!currencyId.equals(dbCurrencyId)) {
            sb.append(ResManager.loadKDString((String)"\u5f00\u8bc1\u5e01\u79cd\u4e0e\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u4e00\u6837\u3002", (String)"LcCallBillService_5", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (amount.compareTo(dbAmount) < 0) {
            sb.append(ResManager.loadKDString((String)"\u5f00\u8bc1\u91d1\u989d\u5c0f\u4e8e\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"LcCallBillService_6", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!"fbd_other".equals(benefiterType) && !benefiterType.equals(dbPayeeType)) {
            sb.append(ResManager.loadKDString((String)"\u53d7\u76ca\u4eba\u7c7b\u578b\u4e0e\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u4e00\u6837\u3002", (String)"LcCallBillService_7", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!beneficiaryName.equals(dbPayeeName)) {
            sb.append(ResManager.loadKDString((String)"\u53d7\u76ca\u4eba\u4e0e\u6536\u6b3e\u4eba\u4e0d\u4e00\u6837\u3002", (String)"LcCallBillService_8", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            String creditNo = (String)reqInfo.get("creditNo");
            String billNo = dbData.getString("billno");
            errorMsg = String.format(ResManager.loadKDString((String)"\u5f00\u8bc1\u5904\u7406\u5355\u201c%1$s\u201c\u4e0e\u4ed8\u6b3e\u5355\u201c%2$s\u201c,%3$s", (String)"LcCallBillService_9", (String)"fi-cas-business", (Object[])new Object[0]), creditNo, billNo, sb.toString());
        }
        return errorMsg;
    }

    public static void writeBackLetterCredit(String lcOperate, List<DynamicObject> payBillList) {
        Map<Long, String> idToMsgMap;
        try (TXHandle tx = TX.requiresNew();){
            try {
                idToMsgMap = LetterCreditService.callLetterCreditService(lcOperate, payBillList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("writeBackLetterCredit error:", (Throwable)e);
                throw e;
            }
        }
        if (idToMsgMap != null && !idToMsgMap.isEmpty()) {
            Map<Long, String> idToBillNoMap = payBillList.stream().collect(Collectors.toMap(p -> p.getLong("id"), p -> p.getString("billno")));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Long, String> idMsg : idToMsgMap.entrySet()) {
                Long id = idMsg.getKey();
                String msg = idMsg.getValue();
                sb.append(idToBillNoMap.get(id)).append(msg).append("\r\n");
            }
            throw new KDBizException(sb.toString());
        }
    }

    public static Map<Long, String> callLetterCreditService(String lcOperate, List<DynamicObject> dynObjList) {
        if (EmptyUtil.isEmpty(dynObjList)) {
            return null;
        }
        ArrayList reqParamList = new ArrayList(16);
        for (DynamicObject dataEntity : dynObjList) {
            DynamicObject payerBank;
            HashMap<String, Object> reqParam = new HashMap<String, Object>(16);
            reqParam.put("operate", lcOperate);
            reqParam.put("targetpk", dataEntity.getPkValue());
            reqParam.put("targetbillno", dataEntity.getString("billno"));
            reqParam.put("settletnumber", dataEntity.getString("settletnumber"));
            DynamicObject dpcurrency = dataEntity.getDynamicObject("dpcurrency");
            if (dpcurrency != null) {
                reqParam.put("currencypk", dpcurrency.getPkValue());
            }
            reqParam.put("amount", dataEntity.getBigDecimal("actpayamt"));
            reqParam.put("bizdate", dataEntity.getDate("bizdate"));
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org != null) {
                reqParam.put("payerid", org.getPkValue());
            }
            if ((payerBank = dataEntity.getDynamicObject("payerbank")) != null) {
                reqParam.put("paybankid", payerBank.getPkValue());
            }
            String payeeType = dataEntity.getString("payeetype");
            List<String> payeeTypeList = Arrays.asList("bos_user", "other");
            if (payeeTypeList.contains(payeeType)) {
                payeeType = "fbd_other";
            }
            reqParam.put("payeetype", payeeType);
            reqParam.put("payee", dataEntity.getString("payeename"));
            reqParamList.add(reqParam);
        }
        HashMap<Long, String> idToMsgMap = null;
        try {
            Object obj = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"lc", (String)"letterCreditOpenService", (String)"execute", (Object[])new Object[]{reqParamList});
            if (EmptyUtil.isEmpty((Object)obj)) {
                return idToMsgMap;
            }
            if (obj instanceof OperationResult) {
                OperationResult operationResult = (OperationResult)obj;
                if (!operationResult.isSuccess()) {
                    String errorMsg = operationResult.getMessage();
                    if (!lcOperate.endsWith("Validate") && EmptyUtil.isNoEmpty((String)errorMsg)) {
                        String kdeMsg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4fe1\u7528\u8bc1[%1$s]\u64cd\u4f5c\u5f02\u5e38\uff0c%2$s", (String)"LcCallBillService_14", (String)"fi-cas-business", (Object[])new Object[0]), lcOperate, errorMsg);
                        throw new KDBizException(kdeMsg);
                    }
                }
                idToMsgMap = new HashMap<Long, String>(16);
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo validateInfo : allErrorOrValidateInfo) {
                    idToMsgMap.put((Long)validateInfo.getPkValue(), validateInfo.getMessage());
                }
            }
        }
        catch (KDBizException kde) {
            throw kde;
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3010tranceid\uff1a%2$s\u3011\u3002", (String)"LcCallBillService_10", (String)"fi-cas-business", (Object[])new Object[0]), e.getMessage(), RequestContext.get().getTraceId());
            throw new KDBizException(msg);
        }
        return idToMsgMap;
    }
}

