/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.service.bean.ReleaseInfo;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.message.MessageTemplateEnum;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.result.PayApplyStatusResult;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.FiCacheHelper;

public class PaySynPayApplyService {
    private static final Log logger = LogFactory.getLog(PaySynPayApplyService.class);

    public void synPayInfo(Object params) {
        String operate;
        List disposeData = (List)params;
        HashMap<Long, ReleaseInfo> entryReleaseInfo = new HashMap<Long, ReleaseInfo>(16);
        Object[] sourcePks = (Long[])disposeData.parallelStream().map(d -> (Long)d.get("sourcepk")).distinct().toArray(Long[]::new);
        DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((Object[])sourcePks, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"));
        Map<Long, DynamicObject> dataMap = Arrays.stream(payApplyBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        ArrayList<DynamicObject> saveOrSubmitDataList = new ArrayList<DynamicObject>(10);
        HashSet<Long> delPayApplyBillIds = new HashSet<Long>(16);
        for (Map applyMap : disposeData) {
            operate = applyMap.get("operate").toString();
            if (WriteBackOperateEnum.SAVE.getValue().equals(operate) || WriteBackOperateEnum.SUBMIT.getValue().equals(operate)) {
                DynamicObject payBillData = (DynamicObject)applyMap.get("info");
                saveOrSubmitDataList.add(payBillData);
            }
            this.analyseInfo(applyMap, entryReleaseInfo);
            delPayApplyBillIds.addAll(this.getDelPayApplyBillIds(applyMap));
        }
        this.saveOrSubmitSyn(saveOrSubmitDataList, entryReleaseInfo, delPayApplyBillIds);
        this.modifyPayBillNo(disposeData, dataMap);
        for (Map applyMap : disposeData) {
            operate = applyMap.get("operate").toString();
            if (WriteBackOperateEnum.SAVE.getValue().equals(operate) || WriteBackOperateEnum.SUBMIT.getValue().equals(operate)) continue;
            Boolean isSuccess = (Boolean)applyMap.get("issuccess");
            boolean isPay = StringUtils.equals((CharSequence)WriteBackOperateEnum.PAY.getValue(), (CharSequence)operate);
            Long sourcePk = (Long)applyMap.get("sourcepk");
            Long sourceEntryPk = (Long)applyMap.get("sourceentrypk");
            Long targetPk = (Long)applyMap.get("targetpk");
            StringBuilder pkInfo = new StringBuilder();
            pkInfo.append("sourcepk:").append(sourcePk);
            pkInfo.append("sourceentrypk:").append(sourceEntryPk);
            pkInfo.append("targetpk:").append(targetPk);
            pkInfo.append("operate:").append(operate);
            String pkInfoStr = pkInfo.toString();
            logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u540c\u6b65\u4ed8\u6b3e\u5355\u4fe1\u606f\uff0c%s", (Object)pkInfoStr);
            if (isPay && !isSuccess.booleanValue()) {
                logger.info("\u5df2\u652f\u4ed8\u4f46\u652f\u4ed8\u672a\u6210\u529f\uff0c%s", (Object)pkInfoStr);
                return;
            }
            DynamicObject payApplyData = dataMap.get(sourcePk);
            if (payApplyData != null) {
                BigDecimal amount;
                DynamicObjectCollection payInfoEntry = payApplyData.getDynamicObjectCollection("cas_payinfo");
                Optional<DynamicObject> currPayInfoOptional = payInfoEntry.stream().filter(e -> e.get("id").equals(sourceEntryPk)).findFirst();
                if (!currPayInfoOptional.isPresent()) {
                    logger.info(String.format("\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u4e0d\u5b58\u5728\uff0c%s", pkInfoStr));
                    return;
                }
                DynamicObject currPayInfo = currPayInfoOptional.get();
                if (!this.idemPotencyValidate(operate, currPayInfo)) {
                    logger.info(String.format("\u4ed8\u6b3e\u7533\u8bf7\u5355\u540c\u6b65\u4ed8\u6b3e\u5355\u91cd\u590d\u6267\u884c\uff0c%s", pkInfoStr));
                    continue;
                }
                BigDecimal payAmount = BigDecimal.ZERO;
                DynamicObjectCollection payedEntry = payApplyData.getDynamicObjectCollection("cas_payapplypaidentry");
                payAmount = amount = (BigDecimal)applyMap.get("amount");
                if (isPay) {
                    DynamicObject addNew = payedEntry.addNew();
                    addNew.set("e_paymentid", (Object)targetPk);
                    addNew.set("e_payedamount", (Object)payAmount);
                    addNew.set("e_applyid", (Object)sourceEntryPk);
                    addNew.set("e_wbtime", (Object)new Date());
                } else {
                    boolean ispayed = payedEntry.removeIf(dy -> dy.getLong("e_paymentid") == targetPk.longValue() && dy.getLong("e_applyid") == sourceEntryPk.longValue());
                    payAmount = ispayed ? payAmount.negate() : BigDecimal.ZERO;
                    if (StringUtils.equals((CharSequence)WriteBackOperateEnum.DELETE.getValue(), (CharSequence)operate)) {
                        payAmount = BigDecimal.ZERO;
                    } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CHARGEBACK.getValue(), (CharSequence)operate) && !ispayed) {
                        payAmount = BigDecimal.ZERO;
                    }
                }
                BigDecimal paidamount = currPayInfo.getBigDecimal("entry_paidamount");
                if (BigDecimal.ZERO.compareTo(paidamount.abs()) > 0) {
                    currPayInfo.set("entry_paidamount", (Object)payAmount);
                } else {
                    currPayInfo.set("entry_paidamount", (Object)paidamount.add(payAmount));
                }
                Object applyEntryId = currPayInfo.get("entry_applyid");
                DynamicObjectCollection payApplyEntry = payApplyData.getDynamicObjectCollection("cas_payapplyentry");
                DynamicObject currApplyInfo = null;
                Optional<DynamicObject> currPayApplyInfoOptional = payApplyEntry.stream().filter(e -> e.get("e_splitid").equals(applyEntryId)).findFirst();
                if (!currPayApplyInfoOptional.isPresent()) {
                    logger.info(String.format("\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u4e0d\u5b58\u5728\uff0c%s", pkInfoStr));
                } else {
                    currApplyInfo = currPayApplyInfoOptional.get();
                    paidamount = currApplyInfo.getBigDecimal("e_paidamount");
                    if (BigDecimal.ZERO.compareTo(paidamount.abs()) > 0) {
                        currApplyInfo.set("e_paidamount", (Object)payAmount);
                    } else {
                        currApplyInfo.set("e_paidamount", (Object)paidamount.add(payAmount));
                    }
                }
                String oldReason = currPayInfo.getString("entry_statusexplain");
                if (StringUtils.equals((CharSequence)WriteBackOperateEnum.PAY.getValue(), (CharSequence)operate)) {
                    currPayInfo.set("entry_remainrfamount", currPayInfo.get("entry_paidamount"));
                    BigDecimal payeeAmount = currPayInfo.getBigDecimal("entry_payeeamount").abs();
                    BigDecimal payedAmount = currPayInfo.getBigDecimal("entry_paidamount").abs();
                    if (payedAmount.compareTo(payeeAmount) < 0) {
                        currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
                    } else {
                        currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYMENTSUCCESS.getValue());
                        this.cacheHeadPayStatus(String.valueOf(sourcePk), String.valueOf(sourceEntryPk));
                    }
                    currPayInfo.set("entry_paydate", applyMap.get("paydate"));
                    Boolean isCommitBe = (Boolean)applyMap.get("iscommitbe");
                    if (isCommitBe.booleanValue()) {
                        currPayInfo.set("entry_statusexplain", applyMap.get("bankreturnmsg"));
                    }
                    currPayInfo.set("entry_settletnumber", applyMap.get("settletnumber"));
                    Set draftBills = (Set)applyMap.get("draftBills");
                    if (draftBills != null) {
                        DynamicObjectCollection draftColl = MultiBaseDataHelper.generateEntryMultiPropValue((DynamicObject)payApplyData, (String)"entry_draftbill", (DynamicObject[])draftBills.toArray(new DynamicObject[0]));
                        currPayInfo.set("entry_draftbill", (Object)draftColl);
                        DynamicObjectCollection draftInfoEntries = payApplyData.getDynamicObjectCollection("cas_draftinfo");
                        Set applyDraftIdSet = draftInfoEntries.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getPkValue()).collect(Collectors.toSet());
                        draftBills.forEach(draftBill -> {
                            if (!applyDraftIdSet.contains(draftBill.getPkValue())) {
                                DraftHelper.addCasDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject)draftBill);
                            }
                        });
                    }
                } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELPAY.getValue(), (CharSequence)operate)) {
                    currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
                    currPayInfo.set("entry_paydate", null);
                    Boolean clearDraft = (Boolean)applyMap.get("clearDraft");
                    if (clearDraft != null && clearDraft.booleanValue()) {
                        DynamicObjectCollection draftBillColl = currPayInfo.getDynamicObjectCollection("entry_draftbill");
                        DynamicObjectCollection draftInfoEntries = payApplyData.getDynamicObjectCollection("cas_draftinfo");
                        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBillColl) && EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfoEntries)) {
                            Set draftBillIdSet = draftBillColl.stream().map(draft -> draft.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                            draftInfoEntries.removeIf(draftInfo -> draftBillIdSet.contains(draftInfo.getDynamicObject("draftbillinfo").getPkValue()));
                        }
                        currPayInfo.set("entry_settletnumber", null);
                        currPayInfo.set("entry_draftbill", null);
                    }
                    this.deleteHeadPayStatusCache(String.valueOf(sourcePk));
                } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CHARGEBACK.getValue(), (CharSequence)operate)) {
                    boolean isPartPayment = payApplyData.getBoolean("ispartpayment");
                    if (!isPartPayment) {
                        this.copyNewPayInfoData(payInfoEntry, currPayInfo, currApplyInfo);
                        currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.CLANCEL.getValue());
                        currPayInfo.set("entry_statusexplain", applyMap.get("reason"));
                        currPayInfo.set("entry_paydate", null);
                        this.deleteHeadPayStatusCache(String.valueOf(sourcePk));
                    } else {
                        String newReason = String.format(ResManager.loadKDString((String)"\u9000\u5355\u91d1\u989d\uff1a%1$s\uff0c\u9000\u5355\u539f\u56e0\uff1a%2$s\u3002", (String)"PaySynPayApplyService_5", (String)"fi-cas-business", (Object[])new Object[0]), amount, applyMap.get("reason"));
                        String reason = String.join((CharSequence)"\n", newReason, oldReason);
                        if (reason.length() > 1024) {
                            reason = reason.substring(0, 1024);
                        }
                        currPayInfo.set("entry_statusexplain", (Object)reason);
                        currPayInfo.set("entry_paydate", null);
                        if (entryReleaseInfo.size() > 0) {
                            this.changeEntryStatus(dataMap, entryReleaseInfo, false);
                        } else {
                            this.changeStatus(payApplyData, currPayInfo);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.DELETE.getValue(), (CharSequence)operate)) {
                    boolean isDoSch = currPayInfo.getBoolean("entry_isdosche");
                    if (isDoSch) {
                        currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYSCHEFUND.getValue());
                    } else {
                        currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
                    }
                    this.setBillNo(applyMap, currPayInfo);
                    this.changeEntryStatus(dataMap, entryReleaseInfo, false);
                    Object paymentselectedbill = applyMap.get("paymentselectedbill");
                    if (null != paymentselectedbill && "Y".equalsIgnoreCase(String.valueOf(paymentselectedbill))) {
                        Set draftBills;
                        DynamicObjectCollection dynamicObjectCollection = currPayInfo.getDynamicObjectCollection("entry_draftbill");
                        dynamicObjectCollection.clear();
                        currPayInfo.set("entry_settletnumber", (Object)"");
                        DynamicObjectCollection cas_draftInfos = payApplyData.getDynamicObjectCollection("cas_draftinfo");
                        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftInfos) && cas_draftInfos.size() > 0 && (draftBills = (Set)applyMap.get("draftBills")) != null) {
                            Set payDraftIdSet = draftBills.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                            cas_draftInfos.removeIf(e -> null != e.getDynamicObject("draftbillinfo") && payDraftIdSet.contains(e.getDynamicObject("draftbillinfo").getLong("id")));
                        }
                    }
                }
                this.setHeadStatus(payApplyData);
                try {
                    this.msgNotice(payApplyData, operate);
                }
                catch (Exception e2) {
                    logger.error("\u6d88\u606f\u901a\u77e5\u5931\u8d25", (Throwable)e2);
                }
                logger.info(String.format("\u53cd\u5199\u4ed8\u6b3e\u7533\u8bf7\u5355\u7ed3\u675f\uff0c%s", pkInfoStr));
                continue;
            }
            logger.info(String.format("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c%s", pkInfoStr));
        }
        this.changePartPay(dataMap);
        Collection<DynamicObject> applyBillCol = dataMap.values();
        if (applyBillCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])applyBillCol.toArray(new DynamicObject[0]));
        }
    }

    private void modifyPayBillNo(List<Map<String, Object>> disposeData, Map<Long, DynamicObject> dataMap) {
        ArrayList<DynamicObject> applyBillCol = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> applyMap : disposeData) {
            DynamicObject currPayInfo;
            DynamicObjectCollection payInfoEntry;
            Optional<DynamicObject> currPayInfoOptional;
            Boolean isPartPayment;
            Long sourcePk = (Long)applyMap.get("sourcepk");
            Long sourceEntryPk = (Long)applyMap.get("sourceentrypk");
            String operate = applyMap.get("operate").toString();
            DynamicObject payApplyData = dataMap.get(sourcePk);
            if (payApplyData == null || !(isPartPayment = Boolean.valueOf(payApplyData.getBoolean("ispartpayment"))).booleanValue() || !(currPayInfoOptional = (payInfoEntry = payApplyData.getDynamicObjectCollection("cas_payinfo")).stream().filter(e -> e.get("id").equals(sourceEntryPk)).findFirst()).isPresent() || this.idemPotencyValidate(operate, currPayInfo = currPayInfoOptional.get()) || !StringUtils.equals((CharSequence)WriteBackOperateEnum.DELETE.getValue(), (CharSequence)operate)) continue;
            this.setBillNo(applyMap, currPayInfo);
            applyBillCol.add(payApplyData);
        }
        if (applyBillCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])applyBillCol.toArray(new DynamicObject[0]));
        }
    }

    private void changePartPay(Map<Long, DynamicObject> dataMap) {
        for (DynamicObject payApplyData : dataMap.values()) {
            Boolean isPartPayment = payApplyData.getBoolean("ispartpayment");
            if (!isPartPayment.booleanValue()) continue;
            DynamicObjectCollection payInfoEntry = payApplyData.getDynamicObjectCollection("cas_payinfo");
            boolean isPartPay = false;
            HashSet<String> status = new HashSet<String>(16);
            HashSet<String> paidStatus = new HashSet<String>(16);
            boolean existReject = false;
            boolean isPayInfoAllPaid = PayApplyBillHelper.isPayInfoAllPaid(payInfoEntry);
            for (DynamicObject payInfo : payInfoEntry) {
                boolean isValid;
                BigDecimal entryPaid = payInfo.getBigDecimal("entry_paidamount");
                String entryPayStatus = payInfo.getString("entry_paystatus");
                if (PayStatusEnum.PAYMENTSUCCESS.getValue().equals(entryPayStatus) || isPayInfoAllPaid) {
                    entryPayStatus = PayApplyPayStatusEnum.SUCCESS.getValue();
                } else if (PayStatusEnum.NOTPAYING.getValue().equals(entryPayStatus)) {
                    entryPayStatus = PayApplyPayStatusEnum.NOTPAYING.getValue();
                }
                if (BigDecimal.ZERO.compareTo(entryPaid) != 0) {
                    isPartPay = true;
                }
                if (!(isValid = payInfo.getBoolean("entry_invalid"))) {
                    paidStatus.add(entryPayStatus);
                } else {
                    existReject = true;
                }
                status.add(entryPayStatus);
            }
            PaymentPayHelper.setPartPay((DynamicObject)payApplyData, status, (boolean)isPartPay, (boolean)existReject);
            PaymentPayHelper.setPaidStatus((DynamicObject)payApplyData, paidStatus);
        }
    }

    private void changeEntryStatus(Map<Long, DynamicObject> dataMap, Map<Long, ReleaseInfo> entryReleaseInfo, boolean isSaveOrSubmit) {
        for (DynamicObject payApplyData : dataMap.values()) {
            Boolean isPartPayment = payApplyData.getBoolean("ispartpayment");
            if (!isPartPayment.booleanValue() && !isSaveOrSubmit) continue;
            DynamicObjectCollection payInfoEntry = payApplyData.getDynamicObjectCollection("cas_payinfo");
            for (DynamicObject payInfo : payInfoEntry) {
                this.changeEntry(entryReleaseInfo, payInfo);
            }
        }
    }

    private void changeStatus(DynamicObject payApplyData, DynamicObject currPayInfo) {
        boolean isPartPayment = payApplyData.getBoolean("ispartpayment");
        if (!isPartPayment) {
            return;
        }
        BigDecimal lockAmount = currPayInfo.getBigDecimal("entry_lockedamount");
        if (BigDecimal.ZERO.compareTo(lockAmount) == 0) {
            currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
        } else {
            currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
        }
        String sourcePk = payApplyData.getString("id");
        this.deleteHeadPayStatusCache(sourcePk);
    }

    private void changeEntry(Map<Long, ReleaseInfo> entryReleaseInfo, DynamicObject payInfo) {
        String payScheOpType;
        if (entryReleaseInfo == null || entryReleaseInfo.size() <= 0) {
            return;
        }
        BigDecimal lockedAmount = payInfo.getBigDecimal("entry_lockedamount");
        BigDecimal payAmount = payInfo.getBigDecimal("entry_payeeamount");
        ReleaseInfo releaseInfo = entryReleaseInfo.get(payInfo.getLong("id"));
        if (releaseInfo == null) {
            return;
        }
        if (Boolean.parseBoolean(releaseInfo.getIsPayScheBack()) && StringUtils.isNotBlank((CharSequence)releaseInfo.getBackReason()) && (!StringUtils.isNotEmpty((CharSequence)(payScheOpType = releaseInfo.getPayScheOPType())) || !"delete".equals(payScheOpType))) {
            String newReason = String.format(ResManager.loadKDString((String)"\u9000\u5355\u91d1\u989d\uff1a%1$s\uff0c\u9000\u5355\u539f\u56e0\uff1a%2$s\u3002", (String)"PaySynPayApplyService_5", (String)"fi-cas-business", (Object[])new Object[0]), releaseInfo.getReleaseAmount(), releaseInfo.getBackReason());
            String explain = String.join((CharSequence)"\n", newReason, payInfo.getString("entry_statusexplain"));
            payInfo.set("entry_statusexplain", (Object)StringUtils.substring((String)explain, (int)0, (int)1024));
        }
        if (payAmount.compareTo(releaseInfo.getReleaseAmount()) == 0 || BigDecimal.ZERO.compareTo(lockedAmount) == 0) {
            payInfo.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
            if ("delete".equals(releaseInfo.getPayScheOPType())) {
                payInfo.set("entry_paybillno", (Object)"");
            }
            return;
        }
        if (lockedAmount.compareTo(releaseInfo.getReleaseAmount()) != 0) {
            payInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
            return;
        }
        payInfo.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
        if ("delete".equals(releaseInfo.getPayScheOPType())) {
            payInfo.set("entry_paybillno", (Object)"");
        } else if (BigDecimal.ZERO.compareTo(lockedAmount) != 0) {
            payInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
        }
        String sourcePk = ((DynamicObject)payInfo.getParent()).getString("id");
        this.deleteHeadPayStatusCache(sourcePk);
    }

    private void setBillNo(Map<String, Object> applyMap, DynamicObject currPayInfo) {
        String backBillNo = (String)applyMap.get("targetbillno");
        String currBillNo = currPayInfo.getString("entry_paybillno");
        String[] currBillNos = currBillNo.split(",");
        StringBuilder sb = new StringBuilder();
        for (String billNo : currBillNos) {
            if (billNo.equals(backBillNo)) continue;
            sb.append(billNo).append(",");
        }
        String newBillNo = "";
        if (sb.length() > 0) {
            newBillNo = sb.substring(0, sb.lastIndexOf(","));
        }
        currPayInfo.set("entry_paybillno", (Object)newBillNo);
    }

    private void setHeadStatus(DynamicObject payApplyData) {
        PayApplyStatusResult headStatus = PayApplyBillHelper.getHeadStatus(payApplyData.getDynamicObjectCollection("cas_payinfo"));
        PayApplyPayStatusEnum payHeadStatus = headStatus.getPayStatus();
        payApplyData.set("paidstatus", (Object)payHeadStatus.getValue());
        payApplyData.set("backbillflag", (Object)(headStatus.getBackBillFlag() != false ? "1" : "0"));
        payApplyData.set("partpaysche", (Object)(headStatus.getPartPaySchFlag() != false ? "1" : "0"));
        payApplyData.set("partpay", (Object)(headStatus.getPartPayFlag() != false ? "1" : "0"));
    }

    private void copyNewPayInfoData(DynamicObjectCollection payInfoEntry, DynamicObject oldData, DynamicObject applyInfo) {
        block8: {
            DynamicObject newEntryData = payInfoEntry.addNew();
            try {
                Set entryPropertyS = EntityPropertyHelper.getEntryPropertys((String)"cas_payapplybill", (String)"cas_payinfo");
                for (String entryProperty : entryPropertyS) {
                    newEntryData.set(entryProperty, oldData.get(entryProperty));
                }
                newEntryData.set("id", null);
                newEntryData.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
                newEntryData.set("entry_paydate", null);
                newEntryData.set("entry_paybillno", null);
                newEntryData.set("entry_payeraccbank", null);
                newEntryData.set("entry_payerbank", null);
                newEntryData.set("entry_balance", null);
                newEntryData.set("entry_paymentchannel", null);
                newEntryData.set("entry_paidamount", (Object)BigDecimal.ZERO);
                newEntryData.set("entry_isdiffcur", (Object)Boolean.FALSE);
                newEntryData.set("entry_paycurrency", null);
                newEntryData.set("entry_exratetable", null);
                newEntryData.set("entry_exratedate", null);
                newEntryData.set("entry_exchangerate", null);
                newEntryData.set("entry_payamount", null);
                DynamicObjectCollection olddraftbill = oldData.getDynamicObjectCollection("entry_draftbill");
                if (olddraftbill != null && olddraftbill.size() > 0) {
                    newEntryData.set("entry_settlementtype", oldData.get("entry_settlementtype"));
                    newEntryData.getDataEntityType().getName();
                    DynamicObjectCollection draftbill = olddraftbill;
                    try {
                        draftbill = this.generateMultiPropValue(oldData, oldData.getDynamicObjectType(), "entry_draftbill", (DynamicObject[])olddraftbill.stream().map(item -> item.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new));
                    }
                    catch (Exception e) {
                        logger.info(e.getMessage());
                    }
                    newEntryData.set("entry_draftbill", (Object)draftbill);
                    newEntryData.set("entry_settletnumber", oldData.get("entry_settletnumber"));
                    newEntryData.set("entry_draftamttotal", oldData.get("entry_draftamttotal"));
                    oldData.set("entry_draftbill", null);
                    break block8;
                }
                if (applyInfo != null) {
                    newEntryData.set("entry_settlementtype", applyInfo.get("e_settlementtype"));
                } else {
                    newEntryData.set("entry_settlementtype", null);
                }
            }
            catch (Exception e) {
                logger.error("\u590d\u5236\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u5931\u8d25", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private DynamicObjectCollection generateMultiPropValue(DynamicObject entity, DynamicObjectType entityType, String propName, DynamicObject ... objs) {
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(propName);
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (DynamicObject obj : objs) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)obj);
            newObj.set("fbasedataid_id", obj.getPkValue());
            collection.add((Object)newObj);
        }
        return collection;
    }

    private void msgNotice(DynamicObject payApplyData, String operate) {
        Object payStatus = payApplyData.get("paidstatus");
        ArrayList<Long> recIdList = new ArrayList<Long>(1);
        recIdList.add((Long)payApplyData.getDynamicObject("creator").getPkValue());
        try (TXHandle tx = TX.requiresNew();){
            MessageInfo message;
            if (PayApplyPayStatusEnum.SUCCESS.getValue().equals(payStatus)) {
                logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e\u6210\u529f-\u6d88\u606f\u63a8\u9001");
                message = new MessageInfo();
                message.setTemplateNumber(MessageTemplateEnum.CAS_PAYAPPLY_PAYSUCCESS.getValue());
                message.setUserIds(recIdList);
                message.setType("message");
                message.setEntityNumber("cas_payapplybill");
                message.setBizDataId((Long)payApplyData.getPkValue());
                message.setNotifyType(MessageCenterServiceHelper.getChannelsOfMsgType((String)"message"));
                message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + "cas_payapplybill" + "&pkId=" + payApplyData.getPkValue());
                message.setMessageTag((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7", (String)"PaySynPayApplyService_0", (String)"fi-cas-business", (Object[])new Object[0])));
                MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            }
            if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CHARGEBACK.getValue(), (CharSequence)operate)) {
                logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e\u5355\u9000\u5355-\u6d88\u606f\u63a8\u9001");
                message = new MessageInfo();
                message.setTemplateNumber(MessageTemplateEnum.CAS_PAYAPPLY_BACKBILL.getValue());
                message.setUserIds(recIdList);
                message.setType("message");
                message.setEntityNumber("cas_payapplybill");
                message.setBizDataId((Long)payApplyData.getPkValue());
                message.setNotifyType(MessageCenterServiceHelper.getChannelsOfMsgType((String)"message"));
                message.setMessageTag((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7", (String)"PaySynPayApplyService_0", (String)"fi-cas-business", (Object[])new Object[0])));
                message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + "cas_payapplybill" + "&pkId=" + payApplyData.getPkValue());
                MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            }
        }
    }

    private void saveOrSubmitSyn(List<DynamicObject> payBillDataList, Map<Long, ReleaseInfo> entryReleaseInfo, Set<Long> delPayApplyBillIds) {
        List ids = payBillDataList.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection payBillDetails = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.e_sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Set sourceIdSet = payBillDetails.stream().map(s -> s.getLong("entry.e_sourcebillid")).collect(Collectors.toSet());
        if (sourceIdSet.size() == 0) {
            sourceIdSet = payBillDataList.stream().filter(o -> o != null).map(o -> o.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(o -> o.getLong("e_sourcebillid")).collect(Collectors.toSet());
        }
        if (delPayApplyBillIds.size() > 0) {
            sourceIdSet.addAll(delPayApplyBillIds);
        }
        if (sourceIdSet.size() == 0) {
            return;
        }
        DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((Object[])sourceIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"));
        Map<Long, DynamicObject> dataMap = Arrays.stream(payApplyBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        Map<Long, DynamicObject> payApplyEntryMap = Arrays.stream(payApplyBills).map(o -> o.getDynamicObjectCollection("cas_payinfo")).flatMap(Collection::stream).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (DynamicObject payBillData : payBillDataList) {
            for (DynamicObject entry : payBillData.getDynamicObjectCollection("entry")) {
                String newPayBillNo;
                long sourceEntryId = entry.getLong("e_sourcebillentryid");
                DynamicObject currPayInfo = payApplyEntryMap.get(sourceEntryId);
                if (currPayInfo == null) continue;
                if (PayStatusEnum.CLANCEL.getValue().equals(currPayInfo.getString("entry_paystatus"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9000\u5355\u72b6\u6001\u5355\u636e\u4e0d\u5141\u8bb8\u518d\u6b21\u8fdb\u884c\u4fdd\u5b58\u6216\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"PaySynPayApplyService_4", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                String payBillNo = currPayInfo.getString("entry_paybillno");
                String billno = newPayBillNo = payBillData.getString("billno");
                if (StringUtils.isNotEmpty((CharSequence)payBillNo)) {
                    String[] billNo = payBillNo.split(",");
                    HashSet<String> billNoSet = new HashSet<String>(billNo.length);
                    for (String number : billNo) {
                        billNoSet.add(number);
                    }
                    billno = !billNoSet.contains(newPayBillNo) ? String.join((CharSequence)",", newPayBillNo, payBillNo) : payBillNo;
                }
                currPayInfo.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
                currPayInfo.set("entry_paybillno", (Object)billno);
            }
        }
        this.changeEntryStatus(dataMap, entryReleaseInfo, true);
        this.changePartPay(dataMap);
        this.changeDeleteRow(payBillDataList, payApplyEntryMap);
        for (DynamicObject payApplyBill : payApplyBills) {
            this.setHeadStatus(payApplyBill);
        }
        SaveServiceHelper.save((DynamicObject[])payApplyBills);
    }

    private void changeDeleteRow(List<DynamicObject> payBillDataList, Map<Long, DynamicObject> payApplyEntryMap) {
        if (EmptyUtil.isEmpty(payBillDataList) || EmptyUtil.isEmpty(payApplyEntryMap) || payBillDataList.size() != 1) {
            return;
        }
        HashMap<Long, Long> payBillEntry = new HashMap<Long, Long>(4);
        DynamicObject payBill = payBillDataList.get(0);
        Long payId = payBill.getLong("id");
        if (payId == null || payId == 0L) {
            return;
        }
        boolean isWaitSche = payBill.getBoolean("iswaitsche");
        if (isWaitSche) {
            return;
        }
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        HashSet<Long> payBillEntryIds = new HashSet<Long>(entrys.size());
        for (DynamicObject entry : entrys) {
            Long entryId = (Long)entry.getPkValue();
            Long e_sourcebillentryid = entry.getLong("e_sourcebillentryid");
            payBillEntry.put(entryId, e_sourcebillentryid);
            payBillEntryIds.add(entryId);
        }
        boolean exist = true;
        DynamicObject payBillInDb = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payId)});
        if (!payBillEntryIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "=", (Object)payId).and(new QFilter("entry", "in", payBillEntryIds));
            exist = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{qFilter});
        }
        if (EmptyUtil.isEmpty((DynamicObject)payBillInDb) || !exist) {
            return;
        }
        DynamicObjectCollection dbEntrys = payBillInDb.getDynamicObjectCollection("entry");
        for (DynamicObject dbEntry : dbEntrys) {
            Long e_sourcebillentryid;
            DynamicObject payApplyEntry;
            Long entryid = (Long)dbEntry.getPkValue();
            if (payBillEntry.get(entryid) != null || (payApplyEntry = payApplyEntryMap.get(e_sourcebillentryid = Long.valueOf(dbEntry.getLong("e_sourcebillentryid")))) == null) continue;
            payApplyEntry.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
            payApplyEntry.set("entry_paybillno", (Object)"");
        }
    }

    private boolean idemPotencyValidate(String operate, DynamicObject payInfoEntry) {
        Boolean result = Boolean.TRUE;
        String payStatus = payInfoEntry.getString("entry_paystatus");
        if (StringUtils.equals((CharSequence)WriteBackOperateEnum.PAY.getValue(), (CharSequence)operate) && PayStatusEnum.PAYMENTSUCCESS.getValue().equals(payStatus)) {
            result = Boolean.FALSE;
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CHARGEBACK.getValue(), (CharSequence)operate) && PayStatusEnum.CLANCEL.getValue().equals(payStatus)) {
            result = Boolean.FALSE;
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.DELETE.getValue(), (CharSequence)operate)) {
            boolean isDoSch = payInfoEntry.getBoolean("entry_isdosche");
            if (isDoSch) {
                if (PayStatusEnum.PAYSCHEFUND.getValue().equals(payStatus)) {
                    result = Boolean.FALSE;
                }
            } else if (PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    private void analyseInfo(Map<String, Object> applyMap, Map<Long, ReleaseInfo> entryReleaseInfo) {
        if (!applyMap.containsKey("isPayScheBack")) {
            return;
        }
        String isPayScheBck = (String)applyMap.get("isPayScheBack");
        if (!"true".equals(isPayScheBck)) {
            return;
        }
        String payScheReleaseStr = (String)applyMap.get("payScheRelease");
        if (kd.fi.cas.util.StringUtils.isEmpty((String)payScheReleaseStr)) {
            return;
        }
        String payScheOPType = (String)applyMap.get("payScheOPType");
        Map payScheRelease = (Map)JSONObject.parseObject((String)payScheReleaseStr, Map.class);
        for (Map.Entry payRelease : payScheRelease.entrySet()) {
            Long mapKey = (Long)payRelease.getKey();
            BigDecimal mapValue = (BigDecimal)payRelease.getValue();
            ReleaseInfo releaseInfo = new ReleaseInfo(isPayScheBck, mapValue, payScheOPType);
            String backReason = (String)applyMap.get("backReason");
            if (StringUtils.isNotBlank((CharSequence)backReason)) {
                releaseInfo.setBackReason(backReason);
            }
            entryReleaseInfo.put(mapKey, releaseInfo);
        }
    }

    private Set<Long> getDelPayApplyBillIds(Map<String, Object> applyMap) {
        HashSet<Long> result = new HashSet<Long>(4);
        if (!applyMap.containsKey("isPayScheBack")) {
            return result;
        }
        if (!applyMap.containsKey("delPayApplyBillIds")) {
            return result;
        }
        String payApplyBillIdsStr = (String)applyMap.get("delPayApplyBillIds");
        if (kd.fi.cas.util.StringUtils.isEmpty((String)payApplyBillIdsStr)) {
            return result;
        }
        return (Set)JSONObject.parseObject((String)payApplyBillIdsStr, Set.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheHeadPayStatus(String sourcePayApplyPk, String sourceEntryPk) {
        String lockKey = PayApplyBillHelper.getLockKey(sourcePayApplyPk);
        DLock dLock = DLock.create((String)lockKey);
        dLock.lock();
        try {
            String successStatusCache = (String)FiCacheHelper.getSessionlessCacheInstance().get(lockKey);
            JSONObject jsonObject = EmptyUtil.isEmpty((String)successStatusCache) ? new JSONObject() : JSONObject.parseObject((String)successStatusCache);
            jsonObject.put(String.valueOf(sourceEntryPk), (Object)PayStatusEnum.PAYMENTSUCCESS.getValue());
            FiCacheHelper.getSessionlessCacheInstance().put(lockKey, (Object)jsonObject.toString(), 600);
        }
        finally {
            dLock.unlock();
        }
    }

    private void deleteHeadPayStatusCache(String sourcePayApplyPk) {
        String lockKey = PayApplyBillHelper.getLockKey(sourcePayApplyPk);
        String successStatusCache = (String)FiCacheHelper.getSessionlessCacheInstance().get(lockKey);
        if (EmptyUtil.isNoEmpty((String)successStatusCache)) {
            FiCacheHelper.getSessionlessCacheInstance().remove(lockKey);
        }
    }
}

