/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.dao.RpcResult;
import kd.fi.cas.enums.RpcResultStatusCode;

public class RecChgDataUpgrade {
    private static final Log LOGGER = LogFactory.getLog(RecChgDataUpgrade.class);

    public String upgrade() {
        DynamicObject[] recChgBills;
        RpcResult result = new RpcResult();
        QFilter qChgType = new QFilter("chgtype", "=", (Object)"recchg");
        QFilter qConfirm = new QFilter("iscashconfirm", "=", (Object)Character.valueOf('0'));
        QFilter qStatus = new QFilter("billstatus", "in", Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')));
        for (DynamicObject recChgBill : recChgBills = BusinessDataServiceHelper.load((String)"cas_paychgbill", (String)"id,entrys,entrys.afterrecerbank,entrys.afterrecprovince,entrys.afterreccity,entrys.afterrecbanknumber", (QFilter[])new QFilter[]{qChgType, qConfirm, qStatus})) {
            DynamicObjectCollection entries = recChgBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                DynamicObject afterRecBank = entry.getDynamicObject("afterrecerbank");
                if (afterRecBank == null) continue;
                entry.set("afterrecprovince", afterRecBank.get("provincetxt"));
                entry.set("afterreccity", afterRecBank.get("citytxt"));
                entry.set("afterrecbanknumber", afterRecBank.get("union_number"));
            }
        }
        try (TXHandle h = TX.requiresNew((String)"RecChgDataUpgrade.upgrade");){
            try {
                SaveServiceHelper.save((DynamicObject[])recChgBills);
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

