/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.UrlServiceForEreceipt;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.util.EmptyUtil;

public class ViewReceiptService {
    private static Log logger = LogFactory.getLog(ViewReceiptService.class);

    public void openReceiptById(IFormView view, Object[] pks) {
        DynamicObject[] receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,bustype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        if (receipts == null || receipts.length == 0) {
            return;
        }
        this.showReceipt(view, receipts);
    }

    public void viewReceipt(IFormView view, String entityName, Object billId) {
        DynamicObject[] receipts = new DynamicObject[]{};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityName, (String)"bankcheckflag,bankcheckentity.ebankcheckflag");
        Set<Long> botpRtansDetails = HandLinkBillHelper.getBotpRtansDetails((Long)billId, entityName);
        if (botpRtansDetails != null && botpRtansDetails.size() > 0) {
            List<String> receiptNoByDetails = HandLinkBillHelper.getReceiptNoByDetails(obj, entityName);
            receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,bustype,bankcheckflag,receiptno,fileserverurl,tcpurl,uploadfilename,username,password", (QFilter[])new QFilter[]{new QFilter("receiptno", "in", receiptNoByDetails), new QFilter("fileserverurl", "!=", (Object)" "), QFilter.isNotNull((String)"fileserverurl")});
        } else {
            ArrayList<String> bankCheckList = new ArrayList<String>(10);
            DynamicObjectCollection bankCheckEntity = obj.getDynamicObjectCollection("bankcheckentity");
            for (DynamicObject entry : bankCheckEntity) {
                String eBankCheckFlag = entry.getString("ebankcheckflag");
                if (EmptyUtil.isEmpty((String)eBankCheckFlag)) continue;
                bankCheckList.add(eBankCheckFlag);
            }
            receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,bustype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password", (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", (Object)bankCheckList.toArray()), new QFilter("fileserverurl", "!=", (Object)" "), QFilter.isNotNull((String)"fileserverurl")});
        }
        if (receipts.length > 0) {
            this.showReceipt(view, receipts);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55\u3002", (String)"ViewReceiptService_0", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private String getTemplateForm(DynamicObject receipt) {
        DynamicObject bank = receipt.getDynamicObject("bank");
        String bustype = receipt.getString("bustype");
        if (bank == null) {
            return null;
        }
        QFilter filter = new QFilter("finorg", "=", bank.getPkValue());
        DynamicObject parentBank = bank.getDynamicObject("parent");
        if (parentBank != null) {
            filter.or("finorg", "=", parentBank.getPkValue());
        }
        DynamicObject[] settemps = BusinessDataServiceHelper.load((String)"cas_settemp", (String)"id,finorg,template,isdefault,remark", (QFilter[])filter.toArray());
        String templateFormId = null;
        if (settemps.length == 1) {
            templateFormId = settemps[0].getString("template.number");
        } else if (settemps.length > 1) {
            for (DynamicObject settemp : settemps) {
                String remark = settemp.getString("remark");
                if (StringUtils.isBlank((CharSequence)remark) || StringUtils.isBlank((CharSequence)bustype) || !bustype.equals(remark)) continue;
                templateFormId = settemp.getString("template.number");
                break;
            }
            if (templateFormId == null) {
                for (DynamicObject settemp : settemps) {
                    boolean isDefault = settemp.getBoolean("isdefault");
                    if (!isDefault) continue;
                    templateFormId = settemp.getString("template.number");
                    break;
                }
            }
        }
        return templateFormId;
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }

    private void showReceipt(IFormView view, DynamicObject[] receipts) {
        String pdfUrl = null;
        Object[] pks = new Object[receipts.length];
        for (int i = 0; i < receipts.length; ++i) {
            pks[i] = receipts[i].getPkValue();
        }
        if (receipts[0].getBoolean("fileflag")) {
            DynamicObject receipt = receipts[0];
            String uploadfilename = receipt.getString("uploadfilename");
            logger.info("\u8bbe\u7f6etcpUrl:{},fileserverurl:{},username:{},uploadfilename:{} ", new Object[]{receipt.getString("tcpurl"), receipt.getString("fileserverurl"), receipt.getString("username"), uploadfilename});
            if (uploadfilename.endsWith("pdf")) {
                pdfUrl = UrlServiceForEreceipt.getEreceiptFullUrl((String)uploadfilename);
                logger.info("PDF\u6587\u4ef6\u7c7b\u578b\u56de\u5355\u751f\u6210\u7684url\uff1a" + pdfUrl);
                this.openForm(view, pdfUrl);
            } else {
                pdfUrl = UrlService.getImageFullUrl((String)uploadfilename);
                logger.info("\u5176\u4ed6\u6587\u4ef6\u7c7b\u578b\u56de\u5355\u751f\u6210\u7684url\uff1a" + pdfUrl);
                String[] urls = new String[]{pdfUrl};
                view.showPictureView(urls, 1);
                this.openForm(view, pdfUrl);
            }
        } else {
            String templateFormId = this.getTemplateForm(receipts[0]);
            if (templateFormId == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u6682\u65e0\u6307\u5b9a\u7684\u5957\u6253\u6a21\u677f\u3002", (String)"ViewReceiptService_1", (String)"fi-cas-business", (Object[])new Object[0]));
            } else {
                pdfUrl = PrintServiceHelper.createPdfUrl((String)view.getPageId(), (String)"bei_elecreceipt", (String)templateFormId, (Object[])pks);
            }
            this.openForm(view, pdfUrl);
        }
    }

    private void openForm(IFormView view, String pdfUrl) {
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.openUrl(pdfUrl);
        } else {
            FormShowParameter parm = this.buildParameter(pdfUrl);
            parm.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ViewReceiptService_2", (String)"fi-cas-business", (Object[])new Object[0]));
            view.getParentView().showForm(parm);
            view.sendFormAction(view.getParentView());
        }
    }
}

