/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service.loanser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.paysche.bean.RpcStatus;
import kd.fi.cas.business.service.bean.loanser.PushInfo;
import kd.fi.cas.business.service.bean.loanser.PushOperate;
import kd.fi.cas.business.service.bean.loanser.PushResult;
import kd.fi.cas.enums.CasEntityEnum;
import kd.fi.cas.helper.CasBotpHelper;

public class PushTargetBillService {
    private List<DynamicObject> saveTargetPayBills;
    private List<DynamicObject> saveTargetRecBills;
    private Map<DynamicObject, DynamicObject> relationPayMap;
    private Map<DynamicObject, DynamicObject> relationRecMap;
    private Map<Object, List<String>> errorInfoMap;
    private static Log logger = LogFactory.getLog(PushTargetBillService.class);

    public String push(String reqStr) {
        logger.info("PushTargetBillService push req:" + reqStr);
        PushResult result = new PushResult(RpcStatus.SUCCESS);
        PushInfo pushInfo = (PushInfo)SerializationUtils.fromJsonString((String)reqStr, PushInfo.class);
        List<Object> sourceBillIds = pushInfo.getBillIds();
        if (sourceBillIds == null || sourceBillIds.size() <= 0) {
            return SerializationUtils.toJsonString((Object)result);
        }
        this.saveTargetPayBills = new ArrayList<DynamicObject>(sourceBillIds.size());
        this.saveTargetRecBills = new ArrayList<DynamicObject>(sourceBillIds.size());
        this.relationPayMap = new HashMap<DynamicObject, DynamicObject>(sourceBillIds.size());
        this.relationRecMap = new HashMap<DynamicObject, DynamicObject>(sourceBillIds.size());
        this.errorInfoMap = new HashMap<Object, List<String>>(sourceBillIds.size());
        PushOperate operate = pushInfo.getOperate();
        for (Object sourceBillId : sourceBillIds) {
            if (PushOperate.loan == operate) {
                this.pushAndSave("cfm_loanbill", CasEntityEnum.RECBILL.getValue(), sourceBillId, "company");
                this.pushAndSave("cim_invest_loanbill", CasEntityEnum.PAYBILL.getValue(), sourceBillId, "loanorg");
                continue;
            }
            if (PushOperate.repay == operate) {
                this.pushAndSave("cfm_repaymentbill", CasEntityEnum.PAYBILL.getValue(), sourceBillId, "company");
                this.pushAndSave("cim_invest_repaybill", CasEntityEnum.RECBILL.getValue(), sourceBillId, "loanorg");
                continue;
            }
            if (PushOperate.interest != operate) continue;
            this.pushAndSave("cfm_interestbill", CasEntityEnum.PAYBILL.getValue(), sourceBillId, "company");
            this.pushAndSave("cim_invest_interestbill", CasEntityEnum.RECBILL.getValue(), sourceBillId, "loanorg");
        }
        try (TXHandle tx = TX.requiresNew();){
            if (this.saveTargetPayBills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])this.saveTargetPayBills.toArray(new DynamicObject[0]));
                for (Map.Entry<DynamicObject, DynamicObject> entry : this.relationPayMap.entrySet()) {
                    CasBotpHelper.saveRelation((DynamicObject)entry.getKey(), (DynamicObject)entry.getValue());
                }
            }
            if (this.saveTargetRecBills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])this.saveTargetRecBills.toArray(new DynamicObject[0]));
                for (Map.Entry<DynamicObject, DynamicObject> entry : this.relationRecMap.entrySet()) {
                    CasBotpHelper.saveRelation((DynamicObject)entry.getKey(), (DynamicObject)entry.getValue());
                }
            }
        }
        result.setErrorInfoMap(this.errorInfoMap);
        String resultStr = SerializationUtils.toJsonString((Object)result);
        logger.info("PushTargetBillService push resp:" + resultStr);
        return resultStr;
    }

    private void pushAndSave(String sourceEntityName, String targetEntityName, Object sourcePk, String mainOrgFieldName) {
        try {
            boolean isPush = QueryServiceHelper.exists((String)sourceEntityName, (QFilter[])new QFilter[]{new QFilter("id", "=", sourcePk), new QFilter(mainOrgFieldName, "!=", (Object)0L)});
            if (!isPush) {
                return;
            }
            DynamicObject sourceBill = BusinessDataServiceHelper.newDynamicObject((String)sourceEntityName);
            sourceBill.set("id", sourcePk);
            DynamicObject[] targetBills = CasBotpHelper.push((DynamicObject)sourceBill, (String)targetEntityName);
            if (targetBills == null || targetBills.length == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51fa\u7eb3\u4e0b\u63a8%s\u5931\u8d25\u3002", (String)"PushTargetBillService_0", (String)"fi-cas-business", (Object[])new Object[0]), CasEntityEnum.getName((String)targetEntityName)));
            }
            if (targetBills.length > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u51fa\u7eb3%s\u6570\u91cf\u5927\u4e8e1\uff0c\u8bf7\u68c0\u67e5BOTP\u914d\u7f6e\u3002", (String)"PushTargetBillService_1", (String)"fi-cas-business", (Object[])new Object[0]), CasEntityEnum.getName((String)targetEntityName)));
            }
            if (CasEntityEnum.PAYBILL.getValue().equals(targetEntityName)) {
                this.saveTargetPayBills.add(targetBills[0]);
                this.relationPayMap.put(sourceBill, targetBills[0]);
            } else {
                this.saveTargetRecBills.add(targetBills[0]);
                this.relationRecMap.put(sourceBill, targetBills[0]);
            }
        }
        catch (Exception e) {
            List<String> errorInfos = this.errorInfoMap.get(sourcePk);
            if (errorInfos == null) {
                errorInfos = new ArrayList<String>(2);
            }
            errorInfos.add(e.getMessage());
            this.errorInfoMap.put(sourcePk, errorInfos);
        }
    }
}

