/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service.oplog.recoplog.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.service.oplog.RecOpInfoLogBean;
import kd.fi.cas.business.service.oplog.RecSettlteLogBean;
import kd.fi.cas.business.service.oplog.recoplog.AbstractRecBillOpLog;
import kd.fi.cas.business.service.oplog.recoplog.IRecBillOpLog;
import kd.fi.cas.helper.EntityPropertyHelper;

public class RecOplogBySettleOpImpl
extends AbstractRecBillOpLog
implements IRecBillOpLog<List<RecSettlteLogBean>> {
    @Override
    public void doRecOpLog(List<RecSettlteLogBean> entryDataList) {
        ArrayList<RecOpInfoLogBean> recOpInfoLogBeanList = new ArrayList<RecOpInfoLogBean>(entryDataList.size());
        List recIdList = entryDataList.stream().map(RecSettlteLogBean::getRecId).collect(Collectors.toList());
        List recEntryIdList = entryDataList.stream().map(RecSettlteLogBean::getRecEntryId).collect(Collectors.toList());
        Map<Long, BigDecimal> entryIdBizAmtMap = entryDataList.stream().collect(Collectors.toMap(RecSettlteLogBean::getRecEntryId, RecSettlteLogBean::getBizAmt));
        Set fullEntryPropertys = EntityPropertyHelper.getFullEntryPropertys((String)"cas_recbill", (String)"entry");
        fullEntryPropertys.addAll(Arrays.asList("id", "entry", "org"));
        DynamicObjectCollection recBillEntrys = QueryServiceHelper.query((String)"cas_recbill", (String)String.join((CharSequence)",", fullEntryPropertys), (QFilter[])new QFilter[]{new QFilter("id", "in", recIdList).and(new QFilter("entry", "in", recEntryIdList))});
        for (DynamicObject recBillEntry : recBillEntrys) {
            long entry = recBillEntry.getLong("entry");
            BigDecimal bizAmt = entryIdBizAmtMap.get(entry);
            String opType = "settle";
            if (bizAmt.compareTo(BigDecimal.ZERO) < 0) {
                opType = "unsettle";
            }
            recOpInfoLogBeanList.add(RecOpInfoLogBean.fromPlainDynamic2Bean(recBillEntry, opType, bizAmt.abs()));
        }
        this.recordRecOpLog(recOpInfoLogBeanList, false);
    }
}

