/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.statement.IBankStatementCheck;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.TmcBusinessBaseHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class BankStatementCheck
implements IBankStatementCheck {
    private static final Log logger = LogFactory.getLog(BankStatementCheck.class);
    public static final DBRoute BASE = new DBRoute("base");
    private static final String STRING_SPLIT_KEY = "_";
    private static final String LOCK_KEY = "Lock_BankStatementCheck";

    public static BankStatementCheck getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void syncBankAccount2StatementByLog() throws Exception {
        boolean locked = MutexServiceHelper.request((String)LOCK_KEY, (String)"fi-cas-business", (String)"bankstatementcheck");
        if (!locked) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8d26\u6237\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u52a0\u9501\u5931\u8d25\u3002 \u9501\uff1a{}", (Object)LOCK_KEY);
            return;
        }
        try {
            DynamicObject[] accBankLogs = BusinessDataServiceHelper.load((String)"am_acctbank_log", (String)"id, org, acctbank, currency", (QFilter[])new QFilter[]{new QFilter("isdeal", "=", (Object)"0")});
            if (accBankLogs.length == 0) {
                return;
            }
            HashMap<String, Set<Long>> acctLogIds = new HashMap<String, Set<Long>>(accBankLogs.length);
            HashSet<Long> orgIds = new HashSet<Long>(accBankLogs.length);
            for (DynamicObject accBankLog : accBankLogs) {
                Long orgId = accBankLog.getDynamicObject("org").getLong("id");
                Long acctBankId = accBankLog.getLong("acctbank");
                Long currencyId = accBankLog.getDynamicObject("currency").getLong("id");
                String latKey = StringUtils.joinKeyString((String)STRING_SPLIT_KEY, (Object[])new Object[]{orgId, acctBankId, currencyId});
                HashSet<Long> logIds = (HashSet<Long>)acctLogIds.get(latKey);
                if (logIds == null) {
                    logIds = new HashSet<Long>(16);
                    acctLogIds.put(latKey, logIds);
                }
                logIds.add(accBankLog.getLong("id"));
                orgIds.add(orgId);
            }
            this.doExecute(orgIds, acctLogIds);
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        finally {
            boolean releaseLock = MutexServiceHelper.release((String)LOCK_KEY, (String)"fi-cas-business", (String)"bankstatementcheck");
            if (!releaseLock) {
                logger.error("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8d26\u6237\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u91ca\u653e\u9501\u5931\u8d25\u3002 \u9501\uff1a{}", (Object)LOCK_KEY);
            }
        }
    }

    @Override
    public void syncBankAccount2Statement(Set<Long> orgIds, Map<String, Set<Long>> acctLogIds) throws Exception {
        boolean locked = MutexServiceHelper.request((String)LOCK_KEY, (String)"fi-cas-business", (String)"bankstatementcheck");
        if (!locked) {
            logger.error("\u5904\u7406\u8d26\u6237\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u52a0\u9501\u5931\u8d25\u3002 \u9501\uff1a{}", (Object)LOCK_KEY);
            throw new KDBizException(ResManager.loadKDString((String)"\u5904\u7406\u8d26\u6237\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u52a0\u9501\u5931\u8d25\u3002", (String)"BankStatementCheck_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        try {
            this.doExecute(orgIds, acctLogIds);
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        finally {
            boolean releaseLock = MutexServiceHelper.release((String)LOCK_KEY, (String)"fi-cas-business", (String)"bankstatementcheck");
            if (!releaseLock) {
                logger.error("\u5904\u7406\u8d26\u6237\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u91ca\u653e\u9501\u5931\u8d25\u3002 \u9501\uff1a{}", (Object)LOCK_KEY);
            }
        }
    }

    private void doExecute(Set<Long> orgIds, Map<String, Set<Long>> acctLogIds) throws Exception {
        ArrayList<DynamicObject> accBanksArray = new ArrayList<DynamicObject>(orgIds.size());
        try {
            for (Long id : orgIds) {
                QFilter filter = AccountBankHelper.getAccountBankFilterByOrg((Long)id);
                DynamicObjectCollection acctPlainColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id as acctbank,company as org,currency.fbasedataid.id as currency, bank.bank_cate.id as bankcgsetting", (QFilter[])new QFilter[]{filter});
                if (acctPlainColl.size() == 0) continue;
                for (DynamicObject dynamicObject : acctPlainColl) {
                    dynamicObject.set("org", (Object)id);
                }
                accBanksArray.addAll((Collection<DynamicObject>)acctPlainColl);
            }
            this.execute(accBanksArray, acctLogIds);
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
    }

    private void execute(List<DynamicObject> accBanksArray, Map<String, Set<Long>> acctLogIds) throws Exception {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        List<DynamicObject> accBankList = accBanksArray;
        if (accBankList.size() == 0) {
            return;
        }
        for (DynamicObject accBank : accBankList) {
            Long orgId = accBank.getLong("org");
            orgIds.add(orgId);
        }
        Map<String, DynamicObject> accountBankMap = this.getBankAccounts(accBankList);
        Map<String, DynamicObject> bankVccCheckMap = this.getVcCheckBank(orgIds);
        this.compareData(accBankList, accountBankMap, bankVccCheckMap, acctLogIds);
    }

    private Map<String, DynamicObject> getBankAccounts(List<DynamicObject> accountBanks) throws Exception {
        HashMap<String, DynamicObject> accountBankMap = new HashMap<String, DynamicObject>(accountBanks.size());
        for (DynamicObject accountBank : accountBanks) {
            Long orgId = accountBank.getLong("org");
            Long accountId = accountBank.getLong("acctbank");
            Long currencyId = accountBank.getLong("currency");
            logger.info("\u83b7\u53d6\u6709\u6743\u9650\u7684\u94f6\u884c\u8d26\u6237\u4fe1\u606f(getBankAccounts), orgId:{}, accountId:{}, currencyId:{}", new Object[]{orgId, accountId, currencyId});
            String latKey = StringUtils.joinKeyString((String)STRING_SPLIT_KEY, (Object[])new Object[]{orgId, accountId, currencyId});
            accountBankMap.put(latKey, accountBank);
        }
        return accountBankMap;
    }

    private Map<String, DynamicObject> getVcCheckBank(Set<Long> orgIds) throws Exception {
        DynamicObjectCollection bankVccChecks = this.getBankVccCheck(orgIds);
        HashMap<String, DynamicObject> bankVccCheckMap = new HashMap<String, DynamicObject>(bankVccChecks.size());
        for (DynamicObject bankVccCheck : bankVccChecks) {
            Long orgId = bankVccCheck.getLong("org");
            Long accountId = bankVccCheck.getLong("accountbank");
            Long currencyId = bankVccCheck.getLong("currency");
            String latKey = StringUtils.joinKeyString((String)STRING_SPLIT_KEY, (Object[])new Object[]{orgId, accountId, currencyId});
            bankVccCheckMap.put(latKey, bankVccCheck);
        }
        return bankVccCheckMap;
    }

    private void compareData(List<DynamicObject> accBankList, Map<String, DynamicObject> accountBankMap, Map<String, DynamicObject> bankVccCheckMap, Map<String, Set<Long>> acctLogIds) throws Exception {
        ArrayList<Long> updateLogs = new ArrayList<Long>(accBankList.size());
        ArrayList<BankCheckDto> saveBankCheck = new ArrayList<BankCheckDto>(64);
        ArrayList<BankCheckDto> updateBankCheck = new ArrayList<BankCheckDto>(64);
        ArrayList<BankCheckDto> deleteBankCheck = new ArrayList<BankCheckDto>(64);
        for (DynamicObject dynamicObject : accBankList) {
            BankCheckDto bankCheckDto;
            DynamicObject bankVccCheck;
            DynamicObject acctBank;
            Set<Long> ids;
            Long orgId = dynamicObject.getLong("org");
            Long accId = dynamicObject.getLong("acctBank");
            Long currencyId = dynamicObject.getLong("currency");
            String latKey = StringUtils.joinKeyString((String)STRING_SPLIT_KEY, (Object[])new Object[]{orgId, accId, currencyId});
            if (acctLogIds != null && acctLogIds.size() > 0 && (ids = acctLogIds.get(latKey)) != null && ids.size() > 0) {
                updateLogs.addAll(ids);
            }
            if ((acctBank = accountBankMap.get(latKey)) == null) {
                bankVccCheck = bankVccCheckMap.remove(latKey);
                if (bankVccCheck == null) continue;
                deleteBankCheck.add(new BankCheckDto(bankVccCheck.getLong("id")));
                continue;
            }
            bankVccCheck = bankVccCheckMap.remove(latKey);
            Long accountbankId = acctBank.getLong("acctBank");
            Long bankcgsetting = acctBank.getLong("bankcgsetting");
            if (bankVccCheck == null || EmptyUtil.isEmpty((DynamicObject)bankVccCheck)) {
                bankCheckDto = new BankCheckDto(orgId, accountbankId, currencyId, bankcgsetting);
                saveBankCheck.add(bankCheckDto);
                continue;
            }
            bankCheckDto = new BankCheckDto(bankVccCheck.getLong("id"), bankcgsetting);
            updateBankCheck.add(bankCheckDto);
        }
        if (bankVccCheckMap.size() > 0) {
            for (Map.Entry entry : bankVccCheckMap.entrySet()) {
                String keyStr = (String)entry.getKey();
                DynamicObject value = (DynamicObject)entry.getValue();
                BankCheckDto bankCheckDto = new BankCheckDto(value.getLong("id"));
                deleteBankCheck.add(bankCheckDto);
                Set<Object> ids = new HashSet();
                if (acctLogIds != null) {
                    ids = acctLogIds.get(keyStr);
                }
                if (ids == null || ids.size() <= 0) continue;
                updateLogs.addAll(ids);
            }
        }
        this.dealData(saveBankCheck, updateBankCheck, deleteBankCheck, updateLogs);
    }

    private void saveData(List<BankCheckDto> saveBankChecks) {
        if (saveBankChecks.size() == 0) {
            return;
        }
        ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
        String sql = "INSERT INTO t_cas_bankvccheck (fid, forgid, faccountbankid,fcurrencyid,fbankcgsetting) VALUES(?, ?, ?, ?, ?)";
        long[] ids = DBServiceHelper.genLongIds((String)"t_cas_bankvccheck", (int)saveBankChecks.size());
        int i = 0;
        for (BankCheckDto bankCheckDto : saveBankChecks) {
            batchParam.add(new Object[]{ids[i], bankCheckDto.getOrgId(), bankCheckDto.getAccountId(), bankCheckDto.getCurrencyId(), bankCheckDto.getBankCateId()});
            ++i;
        }
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private void updateData(List<BankCheckDto> updateBankChecks) {
        if (updateBankChecks.size() == 0) {
            return;
        }
        ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
        String sql = "UPDATE t_cas_bankvccheck SET fbankcgsetting = ? WHERE FID = ?";
        for (BankCheckDto bankCheckDto : updateBankChecks) {
            batchParam.add(new Object[]{bankCheckDto.getBankCateId(), bankCheckDto.getId()});
        }
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private void deleteData(List<BankCheckDto> deleteBankChecks) {
        if (deleteBankChecks.size() == 0) {
            return;
        }
        ArrayList<Object[]> batchParam = new ArrayList<Object[]>(16);
        String sql = "DELETE FROM t_cas_bankvccheck WHERE FID = ?";
        for (BankCheckDto bankCheckDto : deleteBankChecks) {
            batchParam.add(new Object[]{bankCheckDto.getId()});
        }
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, batchParam);
    }

    private void dealData(List<BankCheckDto> saveBankCheck, List<BankCheckDto> updateBankCheck, List<BankCheckDto> deleteBankCheck, final List<Long> updateLogs) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!saveBankCheck.isEmpty()) {
                    this.saveData(saveBankCheck);
                }
                if (!updateBankCheck.isEmpty()) {
                    this.updateData(updateBankCheck);
                }
                if (!deleteBankCheck.isEmpty()) {
                    this.deleteData(deleteBankCheck);
                }
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onCommitted() {
                        if (!updateLogs.isEmpty()) {
                            try (TXHandle txh = TX.requiresNew();){
                                try {
                                    String sql = "UPDATE t_am_acctbank_log  SET fisdeal = 1  WHERE fid IN(" + TmcBusinessBaseHelper.idListToString((List)updateLogs) + ")";
                                    DB.execute((DBRoute)BASE, (String)sql);
                                }
                                catch (Exception e) {
                                    txh.markRollback();
                                    throw e;
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u540c\u6b65\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
        }
    }

    private DynamicObjectCollection getBankVccCheck(Set<Long> orgIds) {
        QFilter filter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection bankChecks = QueryServiceHelper.query((String)"cas_bankvccheck", (String)"id,org, accountbank,currency", (QFilter[])new QFilter[]{filter});
        return bankChecks;
    }

    static class BankCheckDto {
        private Long id;
        private Long orgId;
        private Long accountId;
        private Long currencyId;
        private Long bankCateId;

        public BankCheckDto(Long orgId, Long accountId, Long currencyId, Long bankCateId) {
            this.orgId = orgId;
            this.accountId = accountId;
            this.currencyId = currencyId;
            this.bankCateId = bankCateId;
        }

        public BankCheckDto(Long id) {
            this.id = id;
        }

        public BankCheckDto(Long id, Long bankCateId) {
            this.id = id;
            this.bankCateId = bankCateId;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public Long getAccountId() {
            return this.accountId;
        }

        public void setAccountId(Long accountId) {
            this.accountId = accountId;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public Long getBankCateId() {
            return this.bankCateId;
        }

        public void setBankCateId(Long bankCateId) {
            this.bankCateId = bankCateId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }

    static class Singleton {
        private static final BankStatementCheck INSTANCE = new BankStatementCheck();

        Singleton() {
        }
    }
}

