/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.statement;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.TmcBusinessBaseHelper;
import kd.fi.cas.util.StringUtils;

public class BankStatementCheckUpgrade
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BankStatementCheckUpgrade.class);
    private static final int MAX_NUMBER = 2000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle ignore = TX.notSupported();){
            result.setLog("kd.fi.cas.business.statement.BankStatementCheckUpgrade");
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u5355\u5386\u53f2\u6570\u636e\u5904\u7406\u3002", (String)"BankStatementCheckUpgrade_1", (String)"fi-cas-business", (Object[])new Object[0]));
            BankStatementCheckUpgrade.updateStatement();
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u5355\u5386\u53f2\u6570\u636e\u5904\u7406\u5b8c\u6bd5\u3002", (String)"BankStatementCheckUpgrade_2", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.warn((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStatement() throws Exception {
        try (TXHandle tx = TX.requiresNew();){
            try {
                logger.info("\u5f00\u59cb\u5904\u7406\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u91cd\u590d\u6570\u636e");
                String sqlBankStatement = "SELECT fid, forgid, faccountbankid, fcurrencyid FROM t_cas_bankvccheck";
                DataSet queryBankvcCheck = DB.queryDataSet((String)"query_bankvcCheck", (DBRoute)DBRouteConst.cas, (String)sqlBankStatement);
                HashSet<String> uniqueKey = new HashSet<String>(64);
                HashSet<Long> removeIds = new HashSet<Long>(64);
                try {
                    for (Object next : queryBankvcCheck) {
                        long id = next.getLong("fid");
                        long orgId = next.getLong("forgid");
                        long accountId = next.getLong("faccountbankid");
                        long currencyId = next.getLong("fcurrencyid");
                        String unique = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgId, accountId, currencyId});
                        if (uniqueKey.add(unique)) continue;
                        removeIds.add(id);
                    }
                }
                finally {
                    queryBankvcCheck.close();
                }
                if (removeIds.size() > 0) {
                    HashSet<Long> doData = new HashSet<Long>(removeIds.size());
                    for (Long removeId : removeIds) {
                        if (doData.size() < 2000) {
                            doData.add(removeId);
                            continue;
                        }
                        doData.add(removeId);
                        String deleteSql = "delete from t_cas_bankvccheck WHERE fid IN(" + TmcBusinessBaseHelper.idListToString(new ArrayList(doData)) + ")";
                        DB.execute((DBRoute)DBRouteConst.cas, (String)deleteSql);
                        tx.commit();
                        doData.clear();
                    }
                    if (doData.size() > 0) {
                        String deleteSql = "delete from t_cas_bankvccheck WHERE fid IN(" + TmcBusinessBaseHelper.idListToString(new ArrayList(doData)) + ")";
                        DB.execute((DBRoute)DBRouteConst.cas, (String)deleteSql);
                        tx.commit();
                    }
                }
                logger.info("\u5904\u7406\u94f6\u884c\u5b58\u6b3e\u5bf9\u8d26\u91cd\u590d\u6570\u636e\u5b8c\u6210");
            }
            catch (Exception e) {
                logger.error("\u5347\u7ea7\u65f6\uff0c\u5904\u7406\u94f6\u884c\u5b58\u6b3e\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
                tx.markRollback();
                throw e;
            }
        }
    }
}

